/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.pahimar.ee3.init.ModItems;
import com.pahimar.ee3.item.ItemEE;
import com.pahimar.ee3.reference.Names;
import com.pahimar.ee3.reference.Textures;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class ItemAlchemicalDust
extends ItemEE {
    public ItemAlchemicalDust() {
        this.setMaxStackSize(64);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("alchemicalDust");
    }

    public static List<ItemStack> getAlchemicalDusts() {
        ArrayList<ItemStack> alchemicalDustStacks = new ArrayList<ItemStack>();
        for (int meta = 0; meta < Names.Items.ALCHEMICAL_DUST_SUBTYPES.length; ++meta) {
            alchemicalDustStacks.add(new ItemStack((Item)ModItems.alchemicalDust, 1, meta));
        }
        return alchemicalDustStacks;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack itemStack, int renderPass) {
        if (itemStack.getItemDamage() == 0) {
            return Integer.parseInt("A0A0A0", 16);
        }
        if (itemStack.getItemDamage() == 1) {
            return Integer.parseInt("45CC39", 16);
        }
        if (itemStack.getItemDamage() == 2) {
            return Integer.parseInt("35A6DE", 16);
        }
        if (itemStack.getItemDamage() == 3) {
            return Integer.parseInt("FF4545", 16);
        }
        return Integer.parseInt("ffffff", 16);
    }

    @Override
    public String getUnlocalizedName() {
        return String.format("item.%s%s", Textures.RESOURCE_PREFIX, "alchemicalDust");
    }

    @Override
    public String getUnlocalizedName(ItemStack itemStack) {
        return String.format("item.%s%s.%s", Textures.RESOURCE_PREFIX, "alchemicalDust", Names.Items.ALCHEMICAL_DUST_SUBTYPES[MathHelper.clamp_int((int)itemStack.getItemDamage(), (int)0, (int)(Names.Items.ALCHEMICAL_DUST_SUBTYPES.length - 1))]);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta < Names.Items.ALCHEMICAL_DUST_SUBTYPES.length; ++meta) {
            list.add(new ItemStack((Item)this, 1, meta));
        }
    }
}

