/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item.crafting;

import com.pahimar.ee3.exchange.WrappedStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class RecipeAludel {
    private ItemStack recipeOutput;
    private WrappedStack inputStack;
    private ItemStack dustStack;

    public RecipeAludel(ItemStack recipeOutput, ItemStack inputStack, ItemStack dustStack) {
        this.recipeOutput = recipeOutput.copy();
        this.inputStack = WrappedStack.wrap(inputStack);
        this.dustStack = dustStack.copy();
    }

    public boolean matches(ItemStack inputStack, ItemStack dustStack) {
        return this.matches(WrappedStack.wrap(inputStack), dustStack);
    }

    public boolean matches(WrappedStack inputStack, ItemStack dustStack) {
        return RecipeAludel.compareStacks(this.inputStack, inputStack) && RecipeAludel.compareItemStacks(this.dustStack, dustStack);
    }

    private static boolean compareStacks(WrappedStack wrappedStack1, WrappedStack wrappedStack2) {
        if (wrappedStack1 != null && wrappedStack1.getWrappedObject() != null && wrappedStack2 != null && wrappedStack2.getWrappedObject() != null && wrappedStack1.getWrappedObject() instanceof ItemStack && wrappedStack2.getWrappedObject() instanceof ItemStack) {
            ItemStack itemStack1 = (ItemStack)wrappedStack1.getWrappedObject();
            itemStack1.stackSize = wrappedStack1.getStackSize();
            ItemStack itemStack2 = (ItemStack)wrappedStack2.getWrappedObject();
            itemStack2.stackSize = wrappedStack2.getStackSize();
            return RecipeAludel.compareItemStacks(itemStack1, itemStack2);
        }
        return false;
    }

    private static boolean compareItemStacks(ItemStack itemStack1, ItemStack itemStack2) {
        if (itemStack1 != null && itemStack2 != null) {
            itemStack1.getItem();
            int n = Item.getIdFromItem((Item)itemStack1.getItem());
            itemStack2.getItem();
            if (n == Item.getIdFromItem((Item)itemStack2.getItem()) && (itemStack1.getItemDamage() == itemStack2.getItemDamage() || itemStack1.getItemDamage() == Short.MAX_VALUE || itemStack2.getItemDamage() == Short.MAX_VALUE) && (itemStack1.hasTagCompound() && itemStack2.hasTagCompound() ? itemStack1.getTagCompound().hashCode() == itemStack2.getTagCompound().hashCode() : !itemStack1.hasTagCompound() && !itemStack2.hasTagCompound())) {
                return itemStack2.stackSize >= itemStack1.stackSize;
            }
        }
        return false;
    }

    public ItemStack getRecipeOutput() {
        return this.recipeOutput;
    }

    public WrappedStack[] getRecipeInputs() {
        return new WrappedStack[]{this.inputStack, WrappedStack.wrap(this.dustStack)};
    }

    public List<WrappedStack> getRecipeInputsAsWrappedStacks() {
        ArrayList<WrappedStack> recipeInputs = new ArrayList<WrappedStack>();
        recipeInputs.add(WrappedStack.wrap(this.inputStack));
        recipeInputs.add(WrappedStack.wrap(this.dustStack));
        return recipeInputs;
    }

    public boolean equals(Object object) {
        if (object instanceof RecipeAludel) {
            return this.matches((RecipeAludel)object);
        }
        return false;
    }

    public boolean matches(RecipeAludel recipeAludel) {
        return RecipeAludel.compareItemStacks(this.recipeOutput, recipeAludel.recipeOutput) && this.matches(recipeAludel.inputStack, recipeAludel.dustStack);
    }

    public String toString() {
        return String.format("Output: %s, Input: %s, Dust: %s", this.recipeOutput, this.inputStack, this.dustStack);
    }
}

