/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item.crafting;

import com.pahimar.ee3.item.ItemAlchemicalBag;
import java.util.ArrayList;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;

public class RecipesAlchemicalBagDyes
implements IRecipe {
    public boolean matches(InventoryCrafting inventoryCrafting, World world) {
        ItemStack itemStack = null;
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (int i = 0; i < inventoryCrafting.getSizeInventory(); ++i) {
            ItemStack currentStack = inventoryCrafting.getStackInSlot(i);
            if (currentStack == null) continue;
            if (currentStack.getItem() instanceof ItemAlchemicalBag) {
                if (itemStack != null) {
                    return false;
                }
                itemStack = currentStack;
                continue;
            }
            if (currentStack.getItem() != Items.dye) {
                return false;
            }
            arrayList.add(currentStack);
        }
        return itemStack != null && !arrayList.isEmpty();
    }

    public ItemStack getCraftingResult(InventoryCrafting inventoryCrafting) {
        int newColor;
        float green;
        float red;
        int currentColor;
        int k;
        ItemStack itemStack = null;
        ItemAlchemicalBag itemAlchemicalBag = null;
        int[] colorChannels = new int[3];
        int i = 0;
        int j = 0;
        for (k = 0; k < inventoryCrafting.getSizeInventory(); ++k) {
            ItemStack currentStack = inventoryCrafting.getStackInSlot(k);
            if (currentStack == null) continue;
            if (currentStack.getItem() instanceof ItemAlchemicalBag) {
                itemAlchemicalBag = (ItemAlchemicalBag)currentStack.getItem();
                if (itemStack != null) {
                    return null;
                }
                itemStack = currentStack.copy();
                itemStack.stackSize = 1;
                if (!itemAlchemicalBag.hasColor(currentStack)) continue;
                currentColor = itemAlchemicalBag.getColor(itemStack);
                red = (float)(currentColor >> 16 & 0xFF) / 255.0f;
                green = (float)(currentColor >> 8 & 0xFF) / 255.0f;
                float blue = (float)(currentColor & 0xFF) / 255.0f;
                i = (int)((float)i + Math.max(red, Math.max(green, blue)) * 255.0f);
                colorChannels[0] = (int)((float)colorChannels[0] + red * 255.0f);
                colorChannels[1] = (int)((float)colorChannels[1] + green * 255.0f);
                colorChannels[2] = (int)((float)colorChannels[2] + blue * 255.0f);
                ++j;
                continue;
            }
            if (currentStack.getItem() != Items.dye) {
                return null;
            }
            float[] dyeColorChannels = EntitySheep.fleeceColorTable[BlockColored.func_150032_b((int)currentStack.getItemDamage())];
            int j1 = (int)(dyeColorChannels[0] * 255.0f);
            int k1 = (int)(dyeColorChannels[1] * 255.0f);
            newColor = (int)(dyeColorChannels[2] * 255.0f);
            i += Math.max(j1, Math.max(k1, newColor));
            colorChannels[0] = colorChannels[0] + j1;
            colorChannels[1] = colorChannels[1] + k1;
            colorChannels[2] = colorChannels[2] + newColor;
            ++j;
        }
        if (itemAlchemicalBag == null) {
            return null;
        }
        k = colorChannels[0] / j;
        int l1 = colorChannels[1] / j;
        currentColor = colorChannels[2] / j;
        red = (float)i / (float)j;
        green = Math.max(k, Math.max(l1, currentColor));
        k = (int)((float)k * red / green);
        l1 = (int)((float)l1 * red / green);
        currentColor = (int)((float)currentColor * red / green);
        newColor = (k << 8) + l1;
        newColor = (newColor << 8) + currentColor;
        itemAlchemicalBag.setColor(itemStack, newColor);
        return itemStack;
    }

    public int getRecipeSize() {
        return 10;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }
}

