/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.pahimar.ee3.tileentity.TileEntityDummyArray;
import com.pahimar.ee3.tileentity.TileEntityEE;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.tileentity.TileEntity;

public class MessageTileEntityDummy
implements IMessage,
IMessageHandler<MessageTileEntityDummy, IMessage> {
    public int x;
    public int y;
    public int z;
    public byte orientation;
    public byte state;
    public String customName;
    public UUID ownerUUID;
    public int trueXCoord;
    public int trueYCoord;
    public int trueZCoord;

    public MessageTileEntityDummy() {
    }

    public MessageTileEntityDummy(TileEntityDummyArray tileEntityDummyArray) {
        this.x = tileEntityDummyArray.xCoord;
        this.y = tileEntityDummyArray.yCoord;
        this.z = tileEntityDummyArray.zCoord;
        this.orientation = (byte)tileEntityDummyArray.getOrientation().ordinal();
        this.state = (byte)tileEntityDummyArray.getState();
        this.customName = tileEntityDummyArray.getCustomName();
        this.ownerUUID = tileEntityDummyArray.getOwnerUUID();
        this.trueXCoord = tileEntityDummyArray.getTrueXCoord();
        this.trueYCoord = tileEntityDummyArray.getTrueYCoord();
        this.trueZCoord = tileEntityDummyArray.getTrueZCoord();
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.orientation = buf.readByte();
        this.state = buf.readByte();
        int customNameLength = buf.readInt();
        this.customName = new String(buf.readBytes(customNameLength).array());
        this.ownerUUID = buf.readBoolean() ? new UUID(buf.readLong(), buf.readLong()) : null;
        this.trueXCoord = buf.readInt();
        this.trueYCoord = buf.readInt();
        this.trueZCoord = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.orientation);
        buf.writeByte((int)this.state);
        buf.writeInt(this.customName.length());
        buf.writeBytes(this.customName.getBytes());
        if (this.ownerUUID != null) {
            buf.writeBoolean(true);
            buf.writeLong(this.ownerUUID.getMostSignificantBits());
            buf.writeLong(this.ownerUUID.getLeastSignificantBits());
        } else {
            buf.writeBoolean(false);
        }
        buf.writeInt(this.trueXCoord);
        buf.writeInt(this.trueYCoord);
        buf.writeInt(this.trueZCoord);
    }

    public IMessage onMessage(MessageTileEntityDummy message, MessageContext ctx) {
        TileEntity tileEntity = FMLClientHandler.instance().getClient().theWorld.getTileEntity(message.x, message.y, message.z);
        if (tileEntity instanceof TileEntityEE) {
            ((TileEntityEE)tileEntity).setOrientation(message.orientation);
            ((TileEntityEE)tileEntity).setState(message.state);
            ((TileEntityEE)tileEntity).setCustomName(message.customName);
            ((TileEntityEE)tileEntity).setOwnerUUID(message.ownerUUID);
            if (tileEntity instanceof TileEntityDummyArray) {
                ((TileEntityDummyArray)tileEntity).setTrueCoords(message.trueXCoord, message.trueYCoord, message.trueZCoord);
            }
        }
        return null;
    }
}

