/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.reference;

import com.pahimar.ee3.exchange.EnergyValueRegistry;
import java.util.Comparator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class Comparators {
    public static Comparator<String> stringComparator = new Comparator<String>(){

        @Override
        public int compare(String string1, String string2) {
            return string1.compareToIgnoreCase(string2);
        }
    };
    public static Comparator<ItemStack> idComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            if (itemStack1 != null && itemStack2 != null) {
                if (Item.getIdFromItem((Item)itemStack1.getItem()) - Item.getIdFromItem((Item)itemStack2.getItem()) == 0) {
                    if (itemStack1.getItem() == itemStack2.getItem()) {
                        if (itemStack1.getItemDamage() == itemStack2.getItemDamage() || itemStack1.getItemDamage() == Short.MAX_VALUE || itemStack2.getItemDamage() == Short.MAX_VALUE) {
                            if (itemStack1.hasTagCompound() && itemStack2.hasTagCompound()) {
                                if (ItemStack.areItemStackTagsEqual((ItemStack)itemStack1, (ItemStack)itemStack2)) {
                                    return itemStack1.stackSize - itemStack2.stackSize;
                                }
                                return itemStack1.getTagCompound().hashCode() - itemStack2.getTagCompound().hashCode();
                            }
                            if (!itemStack1.hasTagCompound() && itemStack2.hasTagCompound()) {
                                return -1;
                            }
                            if (itemStack1.hasTagCompound() && !itemStack2.hasTagCompound()) {
                                return 1;
                            }
                            return itemStack1.stackSize - itemStack2.stackSize;
                        }
                        return itemStack1.getItemDamage() - itemStack2.getItemDamage();
                    }
                    return itemStack1.getItem().getUnlocalizedName(itemStack1).compareToIgnoreCase(itemStack2.getItem().getUnlocalizedName(itemStack2));
                }
                return Item.getIdFromItem((Item)itemStack1.getItem()) - Item.getIdFromItem((Item)itemStack2.getItem());
            }
            if (itemStack1 != null) {
                return -1;
            }
            if (itemStack2 != null) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator<ItemStack> reverseIdComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            return idComparator.compare(itemStack1, itemStack2) * -1;
        }
    };
    public static Comparator<ItemStack> displayNameComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            if (itemStack1 != null && itemStack2 != null) {
                if (itemStack1.getDisplayName().equalsIgnoreCase(itemStack2.getDisplayName())) {
                    return idComparator.compare(itemStack1, itemStack2);
                }
                return itemStack1.getDisplayName().compareToIgnoreCase(itemStack2.getDisplayName());
            }
            if (itemStack1 != null) {
                return -1;
            }
            if (itemStack2 != null) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator<ItemStack> reverseDisplayNameComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            return displayNameComparator.compare(itemStack1, itemStack2) * -1;
        }
    };
    public static Comparator<ItemStack> energyValueItemStackComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            if (itemStack1 != null && itemStack2 != null) {
                if (EnergyValueRegistry.getInstance().hasEnergyValue(itemStack1) && EnergyValueRegistry.getInstance().hasEnergyValue(itemStack2)) {
                    return Float.compare(EnergyValueRegistry.getInstance().getEnergyValue(itemStack1).getValue(), EnergyValueRegistry.getInstance().getEnergyValue(itemStack2).getValue());
                }
                return idComparator.compare(itemStack1, itemStack2);
            }
            if (itemStack1 != null) {
                return -1;
            }
            if (itemStack2 != null) {
                return 1;
            }
            return 0;
        }
    };
    public static Comparator<ItemStack> reverseEnergyValueComparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            return energyValueItemStackComparator.compare(itemStack1, itemStack2) * -1;
        }
    };
}

