/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.api.array.AlchemyArray;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileEntityAlchemyArray;
import com.pahimar.ee3.tileentity.TileEntityDummyArray;
import com.pahimar.ee3.tileentity.TileEntityEE;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAlchemyArray
extends TileEntityEE
implements ISidedInventory {
    private AlchemyArray alchemyArray = null;
    private ForgeDirection rotation = ForgeDirection.UNKNOWN;
    private int size = 0;
    private int tickCount;

    public AlchemyArray getAlchemyArray() {
        return this.alchemyArray;
    }

    public void setAlchemyArray(AlchemyArray alchemyArray) {
        this.setAlchemyArray(alchemyArray, 1);
    }

    public void setAlchemyArray(AlchemyArray alchemyArray, int size) {
        this.alchemyArray = alchemyArray;
        this.size = size;
    }

    public ForgeDirection getRotation() {
        return this.rotation;
    }

    public void setRotation(ForgeDirection rotation) {
        this.rotation = rotation;
    }

    public void setRotation(int rotation, int facing) {
        if (this.orientation == ForgeDirection.UP) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.NORTH;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.EAST;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.SOUTH;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.WEST;
            }
        } else if (this.orientation == ForgeDirection.DOWN) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.NORTH;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.EAST;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.SOUTH;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.WEST;
            }
        } else if (this.orientation == ForgeDirection.NORTH) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.UP;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.EAST;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.DOWN;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.WEST;
            }
        } else if (this.orientation == ForgeDirection.SOUTH) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.DOWN;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.EAST;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.UP;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.WEST;
            }
        } else if (this.orientation == ForgeDirection.EAST) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.NORTH;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.UP;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.SOUTH;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.DOWN;
            }
        } else if (this.orientation == ForgeDirection.WEST) {
            if ((rotation + facing) % 4 == 0) {
                this.rotation = ForgeDirection.NORTH;
            } else if ((rotation + facing) % 4 == 1) {
                this.rotation = ForgeDirection.DOWN;
            } else if ((rotation + facing) % 4 == 2) {
                this.rotation = ForgeDirection.SOUTH;
            } else if ((rotation + facing) % 4 == 3) {
                this.rotation = ForgeDirection.UP;
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.orientation == ForgeDirection.UP || this.orientation == ForgeDirection.DOWN) {
            return AxisAlignedBB.getBoundingBox((double)(this.xCoord - this.size), (double)(this.yCoord - 1), (double)(this.zCoord - this.size), (double)(this.xCoord + this.size), (double)(this.yCoord + 1), (double)(this.zCoord + this.size));
        }
        if (this.orientation == ForgeDirection.NORTH || this.orientation == ForgeDirection.SOUTH) {
            return AxisAlignedBB.getBoundingBox((double)(this.xCoord - this.size), (double)(this.yCoord - this.size), (double)(this.zCoord - 1), (double)(this.xCoord + this.size), (double)(this.yCoord + this.size), (double)(this.zCoord + 1));
        }
        if (this.orientation == ForgeDirection.EAST || this.orientation == ForgeDirection.WEST) {
            return AxisAlignedBB.getBoundingBox((double)(this.xCoord - 1), (double)(this.yCoord - this.size), (double)(this.zCoord - this.size), (double)(this.xCoord + 1), (double)(this.yCoord + this.size), (double)(this.zCoord + this.size));
        }
        return super.getRenderBoundingBox();
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this.worldObj.isRemote) {
            ++this.tickCount;
            if (this.tickCount % 100 == 0 && !this.areDummyBlocksValid()) {
                this.invalidate();
                this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
            }
            this.onUpdate(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.tickCount);
        }
    }

    public int getLightLevel() {
        if (this.alchemyArray != null) {
            return this.alchemyArray.getLightLevel();
        }
        return 0;
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        this.onBlockPlacedBy(world, x, y, z, this.xCoord, this.yCoord, this.zCoord, entityLiving, itemStack);
    }

    public void onBlockPlacedBy(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityLivingBase entityLiving, ItemStack itemStack) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayPlacedBy(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entityLiving, itemStack);
        }
    }

    public void onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        this.onBlockActivated(world, x, y, z, this.xCoord, this.yCoord, this.zCoord, entityPlayer, sideHit, hitX, hitY, hitZ);
    }

    public void onBlockActivated(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer, int sideHit, float hitX, float hitY, float hitZ) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayActivated(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entityPlayer, sideHit, hitX, hitY, hitZ);
        }
    }

    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer entityPlayer) {
        this.onBlockClicked(world, x, y, z, this.xCoord, this.yCoord, this.zCoord, entityPlayer);
    }

    public void onBlockClicked(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, EntityPlayer entityPlayer) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayClicked(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entityPlayer);
        }
    }

    public void onBlockDestroyedByExplosion(World world, int x, int y, int z, Explosion explosion) {
        this.onBlockDestroyedByExplosion(world, x, y, z, this.xCoord, this.yCoord, this.zCoord, explosion);
    }

    public void onBlockDestroyedByExplosion(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Explosion explosion) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayDestroyedByExplosion(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, explosion);
        }
    }

    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, int metaData) {
        this.onBlockDestroyedByPlayer(world, x, y, z, this.xCoord, this.yCoord, this.zCoord, metaData);
    }

    public void onBlockDestroyedByPlayer(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, int metaData) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayDestroyedByPlayer(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, metaData);
        }
    }

    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        this.onEntityCollidedWithBlock(world, x, y, z, this.xCoord, this.yCoord, this.zCoord, entity);
    }

    public void onEntityCollidedWithBlock(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Entity entity) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onEntityCollidedWithArray(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entity);
        }
    }

    public void onFallenUpon(World world, int x, int y, int z, Entity entity, float fallDistance) {
        this.onFallenUpon(world, x, y, z, this.xCoord, this.yCoord, this.zCoord, entity, fallDistance);
    }

    public void onFallenUpon(World world, int eventX, int eventY, int eventZ, int arrayX, int arrayY, int arrayZ, Entity entity, float fallDistance) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onArrayFallenUpon(world, eventX, eventY, eventZ, arrayX, arrayY, arrayZ, entity, fallDistance);
        }
    }

    public void onUpdate(World world, int x, int y, int z, int tickCount) {
        if (this.alchemyArray != null) {
            this.alchemyArray.onUpdate(world, x, y, z, tickCount);
        }
    }

    @Override
    public Packet getDescriptionPacket() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityAlchemyArray(this));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.rotation = ForgeDirection.getOrientation((int)nbtTagCompound.getInteger("rotation"));
        this.size = nbtTagCompound.getInteger("size");
        NBTTagCompound alchemyArrayTagCompound = nbtTagCompound.getCompoundTag("alchemyArray");
        if (!alchemyArrayTagCompound.hasNoTags()) {
            this.alchemyArray = AlchemyArray.readArrayFromNBT(alchemyArrayTagCompound);
            try {
                Class<?> clazz = Class.forName(this.alchemyArray.getClassName(), true, Loader.instance().getModClassLoader());
                this.alchemyArray = (AlchemyArray)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                this.alchemyArray.readFromNBT(alchemyArrayTagCompound);
            }
            catch (Exception e) {
                this.invalidate();
                if (this.worldObj != null) {
                    this.worldObj.setBlockToAir(this.xCoord, this.yCoord, this.zCoord);
                }
            }
        } else {
            this.invalidate();
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        nbtTagCompound.setInteger("rotation", this.rotation.ordinal());
        nbtTagCompound.setInteger("size", this.size);
        NBTTagCompound alchemyArrayTagCompound = new NBTTagCompound();
        if (this.alchemyArray != null) {
            this.alchemyArray.writeToNBT(alchemyArrayTagCompound);
        }
        nbtTagCompound.setTag("alchemyArray", (NBTBase)alchemyArrayTagCompound);
    }

    private boolean areDummyBlocksValid() {
        boolean validDummyBlocks;
        block7: {
            int coordOffset;
            block8: {
                block6: {
                    validDummyBlocks = true;
                    coordOffset = this.size / 2;
                    if (this.orientation != ForgeDirection.UP && this.orientation != ForgeDirection.DOWN) break block6;
                    for (int i = this.xCoord - coordOffset; i <= this.xCoord + coordOffset; ++i) {
                        for (int j = this.zCoord - coordOffset; j <= this.zCoord + coordOffset; ++j) {
                            if (i == this.xCoord && j == this.zCoord || this.isValidDummyBlock(i, this.yCoord, j)) continue;
                            validDummyBlocks = false;
                        }
                    }
                    break block7;
                }
                if (this.orientation != ForgeDirection.NORTH && this.orientation != ForgeDirection.SOUTH) break block8;
                for (int i = this.xCoord - coordOffset; i <= this.xCoord + coordOffset; ++i) {
                    for (int j = this.yCoord - coordOffset; j <= this.yCoord + coordOffset; ++j) {
                        if (i == this.xCoord && j == this.yCoord || this.isValidDummyBlock(i, j, this.zCoord)) continue;
                        validDummyBlocks = false;
                    }
                }
                break block7;
            }
            if (this.orientation != ForgeDirection.EAST && this.orientation != ForgeDirection.WEST) break block7;
            for (int i = this.yCoord - coordOffset; i <= this.yCoord + coordOffset; ++i) {
                for (int j = this.zCoord - coordOffset; j <= this.zCoord + coordOffset; ++j) {
                    if (i == this.yCoord && j == this.zCoord || this.isValidDummyBlock(this.xCoord, i, j)) continue;
                    validDummyBlocks = false;
                }
            }
        }
        return validDummyBlocks;
    }

    private boolean isValidDummyBlock(int x, int y, int z) {
        if (!this.worldObj.isRemote && this.worldObj.getTileEntity(x, y, z) instanceof TileEntityDummyArray) {
            TileEntityDummyArray tileEntityDummyArray = (TileEntityDummyArray)this.worldObj.getTileEntity(x, y, z);
            return tileEntityDummyArray.getOrientation() == this.orientation && tileEntityDummyArray.getTrueXCoord() == this.xCoord && tileEntityDummyArray.getTrueYCoord() == this.yCoord && tileEntityDummyArray.getTrueZCoord() == this.zCoord;
        }
        return false;
    }

    public int getSizeInventory() {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).getSizeInventory();
        }
        return 0;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).getStackInSlot(slotIndex);
        }
        return null;
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).decrStackSize(slotIndex, decrementAmount);
        }
        return null;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).getStackInSlotOnClosing(slotIndex);
        }
        return null;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        if (this.alchemyArray instanceof IInventory) {
            ((IInventory)this.alchemyArray).setInventorySlotContents(slotIndex, itemStack);
        }
    }

    public String getInventoryName() {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).getInventoryName();
        }
        return null;
    }

    public boolean hasCustomInventoryName() {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).hasCustomInventoryName();
        }
        return false;
    }

    public int getInventoryStackLimit() {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).getInventoryStackLimit();
        }
        return 0;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).isUseableByPlayer(entityplayer);
        }
        return false;
    }

    public void openInventory() {
        if (this.alchemyArray instanceof IInventory) {
            ((IInventory)this.alchemyArray).openInventory();
        }
    }

    public void closeInventory() {
        if (this.alchemyArray instanceof IInventory) {
            ((IInventory)this.alchemyArray).closeInventory();
        }
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        if (this.alchemyArray instanceof IInventory) {
            return ((IInventory)this.alchemyArray).isItemValidForSlot(slotIndex, itemStack);
        }
        return false;
    }

    public int[] getAccessibleSlotsFromSide(int slotIndex) {
        return new int[0];
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }
}

