/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.item.ItemAlchemicalDust;
import com.pahimar.ee3.item.crafting.RecipeAludel;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileEntityAludel;
import com.pahimar.ee3.recipe.AludelRecipeManager;
import com.pahimar.ee3.tileentity.TileEntityEE;
import com.pahimar.ee3.tileentity.TileEntityGlassBell;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAludel
extends TileEntityEE
implements ISidedInventory {
    public static final int INVENTORY_SIZE = 4;
    public static final int FUEL_INVENTORY_INDEX = 0;
    public static final int INPUT_INVENTORY_INDEX = 1;
    public static final int DUST_INVENTORY_INDEX = 2;
    public static final int OUTPUT_INVENTORY_INDEX = 3;
    public int deviceCookTime;
    public int fuelBurnTime;
    public int itemCookTime;
    public ItemStack outputItemStack;
    public boolean hasGlassBell = false;
    private ItemStack[] inventory = new ItemStack[4];

    public int[] getAccessibleSlotsFromSide(int side) {
        int[] nArray;
        if (side == ForgeDirection.DOWN.ordinal()) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = 3;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 3;
        }
        return nArray;
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        if (this.worldObj.getTileEntity(this.xCoord, this.yCoord + 1, this.zCoord) instanceof TileEntityGlassBell) {
            return this.isItemValidForSlot(slotIndex, itemStack);
        }
        return false;
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        return slotIndex == 3;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            byte slotIndex = tagCompound.getByte("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
        this.deviceCookTime = nbtTagCompound.getInteger("deviceCookTime");
        this.fuelBurnTime = nbtTagCompound.getInteger("fuelBurnTime");
        this.itemCookTime = nbtTagCompound.getInteger("itemCookTime");
        this.hasGlassBell = nbtTagCompound.getBoolean("hasGlassBell");
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            this.setInventorySlotContents(slotIndex, null);
        }
        return itemStack;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
            itemStack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:aludel";
    }

    public boolean hasCustomInventoryName() {
        return this.hasCustomName();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer var1) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        switch (slotIndex) {
            case 0: {
                return TileEntityFurnace.isItemFuel((ItemStack)itemStack);
            }
            case 1: {
                return true;
            }
            case 2: {
                return itemStack.getItem() instanceof ItemAlchemicalDust;
            }
        }
        return false;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("Items", (NBTBase)tagList);
        nbtTagCompound.setInteger("deviceCookTime", this.deviceCookTime);
        nbtTagCompound.setInteger("fuelBurnTime", this.fuelBurnTime);
        nbtTagCompound.setInteger("itemCookTime", this.itemCookTime);
        nbtTagCompound.setBoolean("hasGlassBell", this.hasGlassBell);
    }

    @Override
    public Packet getDescriptionPacket() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityAludel(this, this.inventory[3]));
    }

    public void updateEntity() {
        boolean isBurning = this.deviceCookTime > 0;
        boolean sendUpdate = false;
        if (this.deviceCookTime > 0) {
            --this.deviceCookTime;
        }
        if (!this.worldObj.isRemote) {
            if (this.deviceCookTime == 0 && this.canInfuse()) {
                this.fuelBurnTime = this.deviceCookTime = TileEntityFurnace.getItemBurnTime((ItemStack)this.inventory[0]);
                if (this.deviceCookTime > 0) {
                    sendUpdate = true;
                    if (this.inventory[0] != null) {
                        --this.inventory[0].stackSize;
                        if (this.inventory[0].stackSize == 0) {
                            this.inventory[0] = this.inventory[0].getItem().getContainerItem(this.inventory[0]);
                        }
                    }
                }
            }
            if (this.deviceCookTime > 0 && this.canInfuse()) {
                ++this.itemCookTime;
                if (this.itemCookTime == 200) {
                    this.itemCookTime = 0;
                    this.infuseItem();
                    sendUpdate = true;
                }
            } else {
                this.itemCookTime = 0;
            }
            if (isBurning != this.deviceCookTime > 0) {
                sendUpdate = true;
            }
        }
        if (sendUpdate) {
            this.markDirty();
            this.state = this.deviceCookTime > 0 ? (byte)1 : 0;
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, (int)this.state);
            PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTileEntityAludel(this, this.inventory[3]), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 128.0));
            this.worldObj.notifyBlockChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        }
    }

    public void markDirty() {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageTileEntityAludel(this, this.inventory[3]), new NetworkRegistry.TargetPoint(this.worldObj.provider.dimensionId, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, 128.0));
        this.worldObj.func_147451_t(this.xCoord, this.yCoord, this.zCoord);
        if (this.hasGlassBell) {
            this.worldObj.func_147451_t(this.xCoord, this.yCoord + 1, this.zCoord);
        }
    }

    private boolean canInfuse() {
        if (!this.hasGlassBell || this.inventory[1] == null || this.inventory[2] == null) {
            return false;
        }
        ItemStack infusedItemStack = AludelRecipeManager.getInstance().getResult(this.inventory[1], this.inventory[2]);
        if (infusedItemStack == null) {
            return false;
        }
        if (this.inventory[3] == null) {
            return true;
        }
        boolean outputEquals = this.inventory[3].isItemEqual(infusedItemStack);
        int mergedOutputStackSize = this.inventory[3].stackSize + infusedItemStack.stackSize;
        if (outputEquals) {
            return mergedOutputStackSize <= this.getInventoryStackLimit() && mergedOutputStackSize <= infusedItemStack.getMaxStackSize();
        }
        return false;
    }

    public void infuseItem() {
        if (this.canInfuse()) {
            RecipeAludel recipe = AludelRecipeManager.getInstance().getRecipe(this.inventory[1], this.inventory[2]);
            if (this.inventory[3] == null) {
                this.inventory[3] = recipe.getRecipeOutput().copy();
            } else if (this.inventory[3].isItemEqual(recipe.getRecipeOutput())) {
                this.inventory[3].stackSize += recipe.getRecipeOutput().stackSize;
            }
            this.decrStackSize(1, recipe.getRecipeInputs()[0].getStackSize());
            this.decrStackSize(2, recipe.getRecipeInputs()[1].getStackSize());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.itemCookTime * scale / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.fuelBurnTime > 0) {
            return this.deviceCookTime * scale / this.fuelBurnTime;
        }
        return 0;
    }
}

