/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileCalcinator;
import com.pahimar.ee3.tileentity.TileEntityEE;
import com.pahimar.ee3.util.CalcinationHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCalcinator
extends TileEntityEE
implements ISidedInventory {
    public static final int INVENTORY_SIZE = 4;
    public static final int FUEL_INVENTORY_INDEX = 0;
    public static final int INPUT_INVENTORY_INDEX = 1;
    public static final int OUTPUT_LEFT_INVENTORY_INDEX = 2;
    public static final int OUTPUT_RIGHT_INVENTORY_INDEX = 3;
    private static final int DEFAULT_ITEM_SUCK_COOL_DOWN = 20;
    public int deviceCookTime;
    public int fuelBurnTime;
    public int itemCookTime;
    public byte leftStackSize;
    public byte leftStackMeta;
    public byte rightStackSize;
    public byte rightStackMeta;
    public int itemSuckCoolDown = 0;
    private ItemStack[] inventory = new ItemStack[4];

    public static boolean suckInItems(TileEntityCalcinator tileEntityCalcinator) {
        EntityItem entityitem = TileEntityHopper.func_145897_a((World)tileEntityCalcinator.getWorldObj(), (double)tileEntityCalcinator.xCoord, (double)((double)tileEntityCalcinator.yCoord + 1.0), (double)tileEntityCalcinator.zCoord);
        return entityitem != null && TileEntityHopper.func_145898_a((IInventory)tileEntityCalcinator, (EntityItem)entityitem);
    }

    public int[] getAccessibleSlotsFromSide(int side) {
        int[] nArray;
        if (side == ForgeDirection.DOWN.ordinal()) {
            int[] nArray2 = new int[3];
            nArray2[0] = 0;
            nArray2[1] = 2;
            nArray = nArray2;
            nArray2[2] = 3;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 1;
            nArray3[1] = 2;
            nArray = nArray3;
            nArray3[2] = 3;
        }
        return nArray;
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        return this.isItemValidForSlot(slotIndex, itemStack);
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        return slotIndex == 2 || slotIndex == 3;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            byte slotIndex = tagCompound.getByte("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
        this.deviceCookTime = nbtTagCompound.getInteger("deviceCookTime");
        this.fuelBurnTime = nbtTagCompound.getInteger("fuelBurnTime");
        this.itemCookTime = nbtTagCompound.getInteger("itemCookTime");
        this.itemSuckCoolDown = nbtTagCompound.getInteger("itemSuckCoolDown");
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        this.sendDustPileData();
        return this.inventory[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            this.setInventorySlotContents(slotIndex, null);
        }
        return itemStack;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
            itemStack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:calcinator";
    }

    public boolean hasCustomInventoryName() {
        return this.hasCustomName();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return false;
    }

    private void sendDustPileData() {
        if (this.getBlockType() != null) {
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 2, this.getLeftStackSize());
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 3, this.getLeftStackMeta());
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 4, this.getRightStackSize());
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 5, this.getRightStackMeta());
        }
    }

    private int getLeftStackSize() {
        if (this.inventory[2] != null) {
            return this.inventory[2].stackSize;
        }
        return 0;
    }

    private int getLeftStackMeta() {
        if (this.inventory[2] != null) {
            return this.inventory[2].getItemDamage();
        }
        return 0;
    }

    private int getRightStackSize() {
        if (this.inventory[3] != null) {
            return this.inventory[3].stackSize;
        }
        return 0;
    }

    private int getRightStackMeta() {
        if (this.inventory[3] != null) {
            return this.inventory[3].getItemDamage();
        }
        return 0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("Items", (NBTBase)tagList);
        nbtTagCompound.setInteger("deviceCookTime", this.deviceCookTime);
        nbtTagCompound.setInteger("fuelBurnTime", this.fuelBurnTime);
        nbtTagCompound.setInteger("itemCookTime", this.itemCookTime);
        nbtTagCompound.setInteger("itemSuckCoolDown", this.itemSuckCoolDown);
    }

    @Override
    public Packet getDescriptionPacket() {
        this.sendDustPileData();
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileCalcinator(this));
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int scale) {
        return this.itemCookTime * scale / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int scale) {
        if (this.fuelBurnTime > 0) {
            return this.deviceCookTime * scale / this.fuelBurnTime;
        }
        return 0;
    }

    public void updateEntity() {
        boolean isBurning = this.deviceCookTime > 0;
        boolean sendUpdate = false;
        if (this.deviceCookTime > 0) {
            --this.deviceCookTime;
        }
        if (!this.worldObj.isRemote) {
            if (this.deviceCookTime == 0 && this.canCalcinate()) {
                this.fuelBurnTime = this.deviceCookTime = TileEntityFurnace.getItemBurnTime((ItemStack)this.inventory[0]);
                if (this.deviceCookTime > 0) {
                    sendUpdate = true;
                    if (this.inventory[0] != null) {
                        --this.inventory[0].stackSize;
                        if (this.inventory[0].stackSize == 0) {
                            this.inventory[0] = this.inventory[0].getItem().getContainerItem(this.inventory[0]);
                        }
                    }
                }
            }
            if (this.deviceCookTime > 0 && this.canCalcinate()) {
                ++this.itemCookTime;
                if (this.itemCookTime == 200) {
                    this.itemCookTime = 0;
                    this.calcinateItem();
                    sendUpdate = true;
                }
            } else {
                this.itemCookTime = 0;
            }
            if (isBurning != this.deviceCookTime > 0) {
                sendUpdate = true;
            }
            if (this.itemSuckCoolDown > 0) {
                --this.itemSuckCoolDown;
            } else {
                if (TileEntityCalcinator.suckInItems(this)) {
                    this.markDirty();
                }
                this.itemSuckCoolDown = 20;
            }
        }
        if (sendUpdate) {
            this.markDirty();
            this.state = this.deviceCookTime > 0 ? (byte)1 : 0;
            this.worldObj.addBlockEvent(this.xCoord, this.yCoord, this.zCoord, this.getBlockType(), 1, (int)this.state);
            this.sendDustPileData();
            this.worldObj.notifyBlockChange(this.xCoord, this.yCoord, this.zCoord, this.getBlockType());
        }
    }

    public boolean receiveClientEvent(int eventId, int eventData) {
        if (eventId == 1) {
            this.state = (byte)eventData;
            this.worldObj.func_147451_t(this.xCoord, this.yCoord, this.zCoord);
            return true;
        }
        if (eventId == 2) {
            this.leftStackSize = (byte)eventData;
            return true;
        }
        if (eventId == 3) {
            this.leftStackMeta = (byte)eventData;
            return true;
        }
        if (eventId == 4) {
            this.rightStackSize = (byte)eventData;
            return true;
        }
        if (eventId == 5) {
            this.rightStackMeta = (byte)eventData;
            return true;
        }
        return super.receiveClientEvent(eventId, eventData);
    }

    private boolean canCalcinate() {
        if (this.inventory[1] == null) {
            return false;
        }
        ItemStack alchemicalDustStack = CalcinationHelper.getCalcinationResult(this.inventory[1]);
        if (alchemicalDustStack == null) {
            return false;
        }
        if (this.inventory[2] == null || this.inventory[3] == null) {
            return true;
        }
        boolean leftEquals = this.inventory[2].isItemEqual(alchemicalDustStack);
        int leftResult = this.inventory[2].stackSize + alchemicalDustStack.stackSize;
        boolean rightEquals = this.inventory[3].isItemEqual(alchemicalDustStack);
        int rightResult = this.inventory[3].stackSize + alchemicalDustStack.stackSize;
        if (!leftEquals && !rightEquals) {
            return false;
        }
        if (leftEquals && !rightEquals) {
            return leftResult <= this.getInventoryStackLimit() && leftResult <= alchemicalDustStack.getMaxStackSize();
        }
        if (!leftEquals) {
            return rightResult <= this.getInventoryStackLimit() && rightResult <= alchemicalDustStack.getMaxStackSize();
        }
        return leftResult <= this.getInventoryStackLimit() && leftResult <= alchemicalDustStack.getMaxStackSize() || rightResult <= this.getInventoryStackLimit() && rightResult <= alchemicalDustStack.getMaxStackSize();
    }

    public void calcinateItem() {
        if (this.canCalcinate()) {
            ItemStack alchemicalDustStack = CalcinationHelper.getCalcinationResult(this.inventory[1]);
            this.addItemStackToOutput(alchemicalDustStack.copy());
            --this.inventory[1].stackSize;
            if (this.inventory[1].stackSize <= 0) {
                this.inventory[1] = null;
            }
        }
    }

    private void addItemStackToOutput(ItemStack alchemicalDustStack) {
        int addedSize;
        int maxStackSize = Math.min(this.getInventoryStackLimit(), alchemicalDustStack.getMaxStackSize());
        if (this.inventory[2] == null) {
            this.inventory[2] = alchemicalDustStack;
            return;
        }
        if (this.inventory[2].isItemEqual(alchemicalDustStack) && this.inventory[2].stackSize < maxStackSize) {
            addedSize = Math.min(alchemicalDustStack.stackSize, maxStackSize - this.inventory[2].stackSize);
            alchemicalDustStack.stackSize -= addedSize;
            this.inventory[2].stackSize += addedSize;
            if (alchemicalDustStack.stackSize == 0) {
                return;
            }
        }
        if (this.inventory[3] == null) {
            this.inventory[3] = alchemicalDustStack;
            return;
        }
        if (this.inventory[3].isItemEqual(alchemicalDustStack) && this.inventory[3].stackSize < maxStackSize) {
            addedSize = Math.min(alchemicalDustStack.stackSize, maxStackSize - this.inventory[3].stackSize);
            alchemicalDustStack.stackSize -= addedSize;
            this.inventory[3].stackSize += addedSize;
        }
    }
}

