/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.knowledge.TransmutationKnowledgeRegistry;
import com.pahimar.ee3.tileentity.TileEntityEE;
import com.pahimar.ee3.util.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityResearchStation
extends TileEntityEE
implements IInventory {
    public static final int INVENTORY_SIZE = 2;
    public static final int ITEM_SLOT_INVENTORY_INDEX = 0;
    public static final int TOME_SLOT_INVENTORY_INDEX = 1;
    public int itemLearnTime;
    public boolean isItemKnown;
    private ItemStack[] inventory = new ItemStack[2];

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            this.setInventorySlotContents(slotIndex, null);
        }
        return itemStack;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
            itemStack.stackSize = this.getInventoryStackLimit();
        }
    }

    public String getInventoryName() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:researchStation";
    }

    public boolean hasCustomInventoryName() {
        return this.hasCustomName();
    }

    public int getInventoryStackLimit() {
        return 1;
    }

    public boolean isUseableByPlayer(EntityPlayer entityplayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        return slotIndex == 0 && AbilityRegistry.getInstance().isLearnable(itemStack);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("Items", (NBTBase)tagList);
        nbtTagCompound.setInteger("itemLearnTime", this.itemLearnTime);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        NBTTagList tagList = nbtTagCompound.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            byte slotIndex = tagCompound.getByte("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
        this.itemLearnTime = nbtTagCompound.getInteger("itemLearnTime");
    }

    @SideOnly(value=Side.CLIENT)
    public int getLearnProgressScaled(int scale) {
        return this.itemLearnTime * scale / 200;
    }

    public void updateEntity() {
        if (!this.worldObj.isRemote) {
            if (this.canLearnItemStack()) {
                ++this.itemLearnTime;
                if (this.itemLearnTime == 200) {
                    this.itemLearnTime = 0;
                    this.learnItemStack();
                }
            } else {
                this.itemLearnTime = 0;
            }
            this.isItemKnown = this.isItemStackKnown();
        }
    }

    private boolean canLearnItemStack() {
        ItemStack alchemicalTome = this.inventory[1];
        UUID playerUUID = ItemHelper.getOwnerUUID(alchemicalTome);
        if (alchemicalTome != null && playerUUID != null) {
            return TransmutationKnowledgeRegistry.getInstance().canPlayerLearn(playerUUID, this.inventory[0]);
        }
        return false;
    }

    private boolean isItemStackKnown() {
        ItemStack alchemicalTome = this.inventory[1];
        UUID playerUUID = ItemHelper.getOwnerUUID(alchemicalTome);
        if (alchemicalTome != null && playerUUID != null) {
            return TransmutationKnowledgeRegistry.getInstance().doesPlayerKnow(playerUUID, this.inventory[0]);
        }
        return false;
    }

    private void learnItemStack() {
        if (this.canLearnItemStack()) {
            TransmutationKnowledgeRegistry.getInstance().teachPlayer(ItemHelper.getOwnerUUID(this.inventory[1]), this.inventory[0]);
            --this.inventory[0].stackSize;
            if (this.inventory[0].stackSize <= 0) {
                this.inventory[0] = null;
            }
        }
    }
}

