/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.tileentity;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.block.BlockAshInfusedStoneSlab;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.item.ItemAlchemicalTome;
import com.pahimar.ee3.item.ItemMiniumStone;
import com.pahimar.ee3.item.ItemPhilosophersStone;
import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.network.PacketHandler;
import com.pahimar.ee3.network.message.MessageTileEntityTransmutationTablet;
import com.pahimar.ee3.tileentity.TileEntityEE;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTransmutationTablet
extends TileEntityEE
implements ISidedInventory {
    public static final int INVENTORY_SIZE = 10;
    public static final int ITEM_INPUT_1 = 0;
    public static final int ITEM_INPUT_2 = 1;
    public static final int ITEM_INPUT_3 = 2;
    public static final int ITEM_INPUT_4 = 3;
    public static final int ITEM_INPUT_5 = 4;
    public static final int ITEM_INPUT_6 = 5;
    public static final int ITEM_INPUT_7 = 6;
    public static final int ITEM_INPUT_8 = 7;
    public static final int STONE_INDEX = 8;
    public static final int ALCHEMICAL_TOME_INDEX = 9;
    private EnergyValue storedEnergyValue;
    private EnergyValue availableEnergyValue;
    private ForgeDirection rotation = ForgeDirection.UNKNOWN;
    private ItemStack[] inventory;

    public TileEntityTransmutationTablet() {
        this.availableEnergyValue = new EnergyValue(0.0f);
        this.storedEnergyValue = new EnergyValue(0.0f);
        this.inventory = new ItemStack[10];
    }

    public EnergyValue getAvailableEnergyValue() {
        return this.availableEnergyValue;
    }

    public EnergyValue getStoredEnergyValue() {
        return this.storedEnergyValue;
    }

    public void consumeInventoryForEnergyValue(ItemStack outputItemStack) {
        EnergyValue outputEnergyValue = EnergyValueRegistryProxy.getEnergyValue(outputItemStack);
        if (this.storedEnergyValue.compareTo(outputEnergyValue) >= 0) {
            this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() - outputEnergyValue.getValue());
        } else {
            while (this.storedEnergyValue.compareTo(outputEnergyValue) < 0 && this.availableEnergyValue.compareTo(outputEnergyValue) >= 0) {
                for (int i = 0; i < 8; ++i) {
                    ItemStack stackInSlot = this.getStackInSlot(i);
                    if (stackInSlot == null || !EnergyValueRegistryProxy.hasEnergyValue(stackInSlot)) continue;
                    this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() + EnergyValueRegistryProxy.getEnergyValue(stackInSlot).getValue());
                    this.decrStackSize(i, 1);
                }
            }
            if (this.storedEnergyValue.getValue() >= outputEnergyValue.getValue()) {
                this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() - outputEnergyValue.getValue());
            }
        }
        this.updateEnergyValueFromInventory();
    }

    public void updateEnergyValueFromInventory() {
        float newEnergyValue = this.storedEnergyValue.getValue();
        for (int i = 0; i <= 8; ++i) {
            if (this.inventory[i] == null || !EnergyValueRegistryProxy.hasEnergyValue(this.inventory[i])) continue;
            newEnergyValue += EnergyValueRegistryProxy.getEnergyValueForStack(this.inventory[i]).getValue();
        }
        this.availableEnergyValue = new EnergyValue(newEnergyValue);
    }

    public ForgeDirection getRotation() {
        return this.rotation;
    }

    public void setRotation(ForgeDirection rotation) {
        this.rotation = rotation;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.getBoundingBox((double)((double)this.xCoord - 1.5), (double)(this.yCoord - 1), (double)((double)this.zCoord - 1.5), (double)((double)this.xCoord + 1.5), (double)(this.yCoord + 1), (double)((double)this.zCoord + 1.5));
    }

    public boolean isStructureValid() {
        return this.worldObj.getBlock(this.xCoord - 1, this.yCoord, this.zCoord - 1) instanceof BlockAshInfusedStoneSlab && this.worldObj.getBlockMetadata(this.xCoord - 1, this.yCoord, this.zCoord - 1) == 1 && this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord - 1) instanceof BlockAshInfusedStoneSlab && this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord - 1) == 2 && this.worldObj.getBlock(this.xCoord + 1, this.yCoord, this.zCoord - 1) instanceof BlockAshInfusedStoneSlab && this.worldObj.getBlockMetadata(this.xCoord + 1, this.yCoord, this.zCoord - 1) == 3 && this.worldObj.getBlock(this.xCoord - 1, this.yCoord, this.zCoord) instanceof BlockAshInfusedStoneSlab && this.worldObj.getBlockMetadata(this.xCoord - 1, this.yCoord, this.zCoord) == 4 && this.worldObj.getBlock(this.xCoord + 1, this.yCoord, this.zCoord) instanceof BlockAshInfusedStoneSlab && this.worldObj.getBlockMetadata(this.xCoord + 1, this.yCoord, this.zCoord) == 5 && this.worldObj.getBlock(this.xCoord - 1, this.yCoord, this.zCoord + 1) instanceof BlockAshInfusedStoneSlab && this.worldObj.getBlockMetadata(this.xCoord - 1, this.yCoord, this.zCoord + 1) == 6 && this.worldObj.getBlock(this.xCoord, this.yCoord, this.zCoord + 1) instanceof BlockAshInfusedStoneSlab && this.worldObj.getBlockMetadata(this.xCoord, this.yCoord, this.zCoord + 1) == 7 && this.worldObj.getBlock(this.xCoord + 1, this.yCoord, this.zCoord + 1) instanceof BlockAshInfusedStoneSlab && this.worldObj.getBlockMetadata(this.xCoord + 1, this.yCoord, this.zCoord + 1) == 8;
    }

    public void updateEntity() {
        super.updateEntity();
        this.updateEnergyValueFromInventory();
    }

    @Override
    public Packet getDescriptionPacket() {
        return PacketHandler.INSTANCE.getPacketFrom((IMessage)new MessageTileEntityTransmutationTablet(this));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.rotation = ForgeDirection.getOrientation((int)nbtTagCompound.getInteger("rotation"));
        NBTTagList tagList = nbtTagCompound.getTagList("Items", 10);
        this.inventory = new ItemStack[this.getSizeInventory()];
        for (int i = 0; i < tagList.tagCount(); ++i) {
            NBTTagCompound tagCompound = tagList.getCompoundTagAt(i);
            byte slotIndex = tagCompound.getByte("Slot");
            if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
            this.inventory[slotIndex] = ItemStack.loadItemStackFromNBT((NBTTagCompound)tagCompound);
        }
        NBTTagCompound energyValueTagCompound = nbtTagCompound.getCompoundTag("storedEnergyValue");
        this.storedEnergyValue = !energyValueTagCompound.hasNoTags() ? EnergyValue.loadEnergyValueFromNBT(energyValueTagCompound) : new EnergyValue(0.0f);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        super.writeToNBT(nbtTagCompound);
        nbtTagCompound.setInteger("rotation", this.rotation.ordinal());
        NBTTagList tagList = new NBTTagList();
        for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
            if (this.inventory[currentIndex] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.setByte("Slot", (byte)currentIndex);
            this.inventory[currentIndex].writeToNBT(tagCompound);
            tagList.appendTag((NBTBase)tagCompound);
        }
        nbtTagCompound.setTag("Items", (NBTBase)tagList);
        NBTTagCompound energyValueTagCompound = new NBTTagCompound();
        if (this.storedEnergyValue != null) {
            this.storedEnergyValue.writeToNBT(energyValueTagCompound);
        }
        nbtTagCompound.setTag("storedEnergyValue", (NBTBase)energyValueTagCompound);
    }

    public int getSizeInventory() {
        return this.inventory.length;
    }

    public ItemStack getStackInSlot(int slotIndex) {
        return this.inventory[slotIndex];
    }

    public ItemStack decrStackSize(int slotIndex, int decrementAmount) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            if (itemStack.stackSize <= decrementAmount) {
                this.setInventorySlotContents(slotIndex, null);
            } else {
                itemStack = itemStack.splitStack(decrementAmount);
                if (itemStack.stackSize == 0) {
                    this.setInventorySlotContents(slotIndex, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack getStackInSlotOnClosing(int slotIndex) {
        ItemStack itemStack = this.getStackInSlot(slotIndex);
        if (itemStack != null) {
            this.setInventorySlotContents(slotIndex, null);
        }
        return itemStack;
    }

    public void setInventorySlotContents(int slotIndex, ItemStack itemStack) {
        if (slotIndex < this.getSizeInventory()) {
            this.inventory[slotIndex] = itemStack;
            if (itemStack != null && itemStack.stackSize > this.getInventoryStackLimit()) {
                itemStack.stackSize = this.getInventoryStackLimit();
            }
            this.updateEnergyValueFromInventory();
        }
    }

    public String getInventoryName() {
        return this.hasCustomName() ? this.getCustomName() : "container.ee3:transmutationTablet";
    }

    public boolean hasCustomInventoryName() {
        return this.hasCustomName();
    }

    public int getInventoryStackLimit() {
        return 64;
    }

    public boolean isUseableByPlayer(EntityPlayer entityPlayer) {
        return true;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isItemValidForSlot(int slotIndex, ItemStack itemStack) {
        if (slotIndex < 8 && EnergyValueRegistry.getInstance().hasEnergyValue(itemStack) && AbilityRegistry.getInstance().isRecoverable(itemStack)) {
            return true;
        }
        if (slotIndex == 8 && (itemStack.getItem() instanceof ItemMiniumStone || itemStack.getItem() instanceof ItemPhilosophersStone)) {
            return true;
        }
        return slotIndex == 9 && itemStack.getItem() instanceof ItemAlchemicalTome;
    }

    public int[] getAccessibleSlotsFromSide(int slotIndex) {
        return new int[0];
    }

    public boolean canInsertItem(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }

    public boolean canExtractItem(int slotIndex, ItemStack itemStack, int side) {
        return false;
    }
}

