/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.reference.Comparators;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class FilterUtils {
    public static Set<ItemStack> filterForItemBlock(Set<ItemStack> unfilteredItemStackSet) {
        return FilterUtils.filterForItemBlock(unfilteredItemStackSet, Comparators.idComparator);
    }

    public static Set<ItemStack> filterForItemBlock(Set<ItemStack> unfilteredItemStackSet, Comparator comparator) {
        TreeSet<ItemStack> itemBlockOnlySet = new TreeSet<ItemStack>(comparator);
        for (ItemStack itemStack : unfilteredItemStackSet) {
            if (!(itemStack.getItem() instanceof ItemBlock)) continue;
            itemBlockOnlySet.add(itemStack);
        }
        return itemBlockOnlySet;
    }

    public static Set<ItemStack> filterByNameStartsWith(Set<ItemStack> unfilteredItemStackSet, String filterString) {
        return FilterUtils.filterByNameStartsWith(unfilteredItemStackSet, filterString, Comparators.idComparator);
    }

    public static Set<ItemStack> filterByNameStartsWith(Set<ItemStack> unfilteredItemStackSet, String filterString, Comparator comparator) {
        TreeSet<ItemStack> nameSortedSet = new TreeSet<ItemStack>(comparator);
        for (ItemStack itemStack : unfilteredItemStackSet) {
            String itemDisplayName = itemStack.getDisplayName().toLowerCase();
            if (filterString != null) {
                if (!itemDisplayName.startsWith(filterString.toLowerCase())) continue;
                nameSortedSet.add(itemStack);
                continue;
            }
            nameSortedSet.add(itemStack);
        }
        return nameSortedSet;
    }

    public static Set<ItemStack> filterByNameContains(Collection<ItemStack> unfilteredCollection, String filterString) {
        HashSet<ItemStack> nameSortedSet = new HashSet<ItemStack>();
        for (ItemStack itemStack : unfilteredCollection) {
            String itemDisplayName = itemStack.getDisplayName().toLowerCase();
            if (filterString != null) {
                if (!itemDisplayName.contains(filterString.toLowerCase())) continue;
                nameSortedSet.add(itemStack);
                continue;
            }
            nameSortedSet.add(itemStack);
        }
        return nameSortedSet;
    }

    public static Set<ItemStack> filterByNameContains(Collection<ItemStack> unfilteredCollection, String filterString, Comparator comparator) {
        TreeSet<ItemStack> nameSortedSet = new TreeSet<ItemStack>(comparator);
        for (ItemStack itemStack : unfilteredCollection) {
            String itemDisplayName = itemStack.getDisplayName().toLowerCase();
            if (filterString != null) {
                if (!itemDisplayName.contains(filterString.toLowerCase())) continue;
                nameSortedSet.add(itemStack);
                continue;
            }
            nameSortedSet.add(itemStack);
        }
        return nameSortedSet;
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> unfilteredCollection, EnergyValue energyValue) {
        return FilterUtils.filterByEnergyValue(unfilteredCollection, energyValue.getValue());
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> unfilteredCollection, EnergyValue energyValue, Comparator<ItemStack> comparator) {
        return FilterUtils.filterByEnergyValue(unfilteredCollection, energyValue.getValue(), comparator);
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> unfilteredCollection, float energyValue) {
        HashSet<ItemStack> sortedSet = new HashSet<ItemStack>();
        for (ItemStack itemStack : unfilteredCollection) {
            if (!(energyValue > 0.0f) || !EnergyValueRegistryProxy.hasEnergyValue(itemStack) || !(EnergyValueRegistryProxy.getEnergyValue(itemStack).getValue() <= energyValue)) continue;
            sortedSet.add(itemStack);
        }
        return sortedSet;
    }

    public static Set<ItemStack> filterByEnergyValue(Collection<ItemStack> unfilteredCollection, float energyValue, Comparator<ItemStack> comparator) {
        TreeSet<ItemStack> sortedSet = new TreeSet<ItemStack>(comparator);
        for (ItemStack itemStack : unfilteredCollection) {
            if (!(energyValue > 0.0f) || !EnergyValueRegistryProxy.hasEnergyValue(itemStack) || !(EnergyValueRegistryProxy.getEnergyValue(itemStack).getValue() <= energyValue)) continue;
            sortedSet.add(itemStack);
        }
        return sortedSet;
    }
}

