/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.NBTHelper;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemHelper {
    public static ItemStack cloneItemStack(ItemStack itemStack, int stackSize) {
        ItemStack clonedItemStack = itemStack.copy();
        clonedItemStack.stackSize = stackSize;
        return clonedItemStack;
    }

    public static boolean equals(ItemStack first, ItemStack second) {
        return Comparators.idComparator.compare(first, second) == 0;
    }

    public static boolean equalsIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return itemStack1 != null && itemStack2 != null && Item.getIdFromItem((Item)itemStack1.getItem()) - Item.getIdFromItem((Item)itemStack2.getItem()) == 0 && itemStack1.getItem() == itemStack2.getItem() && itemStack1.getItemDamage() == itemStack2.getItemDamage() && (itemStack1.hasTagCompound() && itemStack2.hasTagCompound() ? ItemStack.areItemStackTagsEqual((ItemStack)itemStack1, (ItemStack)itemStack2) : !itemStack1.hasTagCompound() && !itemStack2.hasTagCompound());
    }

    public static int compare(ItemStack itemStack1, ItemStack itemStack2) {
        return Comparators.idComparator.compare(itemStack1, itemStack2);
    }

    public static String toString(ItemStack itemStack) {
        if (itemStack != null) {
            if (itemStack.hasTagCompound()) {
                return String.format("%sxitemStack[%s@%s:%s]", itemStack.stackSize, itemStack.getUnlocalizedName(), itemStack.getItemDamage(), itemStack.getTagCompound());
            }
            return String.format("%sxitemStack[%s@%s]", itemStack.stackSize, itemStack.getUnlocalizedName(), itemStack.getItemDamage());
        }
        return "null";
    }

    public static boolean hasOwner(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "ownerUUIDMostSig") && NBTHelper.hasTag(itemStack, "ownerUUIDLeastSig") || NBTHelper.hasTag(itemStack, "owner");
    }

    public static boolean hasOwnerUUID(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "ownerUUIDMostSig") && NBTHelper.hasTag(itemStack, "ownerUUIDLeastSig");
    }

    public static boolean hasOwnerName(ItemStack itemStack) {
        return NBTHelper.hasTag(itemStack, "owner");
    }

    public static String getOwnerName(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "owner")) {
            return NBTHelper.getString(itemStack, "owner");
        }
        return null;
    }

    public static UUID getOwnerUUID(ItemStack itemStack) {
        if (NBTHelper.hasTag(itemStack, "ownerUUIDMostSig") && NBTHelper.hasTag(itemStack, "ownerUUIDLeastSig")) {
            return new UUID(NBTHelper.getLong(itemStack, "ownerUUIDMostSig"), NBTHelper.getLong(itemStack, "ownerUUIDLeastSig"));
        }
        return null;
    }

    public static void setOwner(ItemStack itemStack, EntityPlayer entityPlayer) {
        ItemHelper.setOwnerName(itemStack, entityPlayer);
        ItemHelper.setOwnerUUID(itemStack, entityPlayer);
    }

    public static void setOwnerUUID(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTHelper.setLong(itemStack, "ownerUUIDMostSig", entityPlayer.getUniqueID().getMostSignificantBits());
        NBTHelper.setLong(itemStack, "ownerUUIDLeastSig", entityPlayer.getUniqueID().getLeastSignificantBits());
    }

    public static void setOwnerName(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTHelper.setString(itemStack, "owner", entityPlayer.getDisplayName());
    }
}

