/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.repackage.cofh.lib.gui;

import com.pahimar.repackage.cofh.lib.audio.SoundBase;
import com.pahimar.repackage.cofh.lib.gui.TabTracker;
import com.pahimar.repackage.cofh.lib.gui.element.ElementBase;
import com.pahimar.repackage.cofh.lib.gui.element.TabBase;
import com.pahimar.repackage.cofh.lib.gui.slot.SlotFalseCopy;
import com.pahimar.repackage.cofh.lib.render.RenderHelper;
import com.pahimar.repackage.cofh.lib.util.helpers.StringHelper;
import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase
extends GuiContainer {
    public static final SoundHandler guiSoundManager = FMLClientHandler.instance().getClient().getSoundHandler();
    protected boolean drawTitle = true;
    protected boolean drawInventory = true;
    protected int mouseX = 0;
    protected int mouseY = 0;
    protected int lastIndex = -1;
    protected String name;
    protected ResourceLocation texture;
    public ArrayList<TabBase> tabs = new ArrayList();
    protected ArrayList<ElementBase> elements = new ArrayList();
    protected List<String> tooltip = new LinkedList<String>();
    protected boolean tooltips = true;

    public static void playSound(String name, float volume, float pitch) {
        guiSoundManager.playSound((ISound)new SoundBase(name, volume, pitch));
    }

    public GuiBase(Container container) {
        super(container);
    }

    public GuiBase(Container container, ResourceLocation texture) {
        super(container);
        this.texture = texture;
    }

    public void initGui() {
        super.initGui();
        this.tabs.clear();
        this.elements.clear();
    }

    public void drawScreen(int x, int y, float partialTick) {
        this.updateElementInformation();
        super.drawScreen(x, y, partialTick);
        if (this.tooltips && this.mc.thePlayer.inventory.getItemStack() == null) {
            this.addTooltips(this.tooltip);
            this.drawTooltip(this.tooltip);
        }
        this.mouseX = x - this.guiLeft;
        this.mouseY = y - this.guiTop;
        this.updateElements();
    }

    protected void drawGuiContainerForegroundLayer(int x, int y) {
        if (this.drawTitle) {
            this.fontRendererObj.drawString(StringHelper.localize(this.name), this.getCenteredOffset(StringHelper.localize(this.name)), 6, 0x404040);
        }
        if (this.drawInventory) {
            this.fontRendererObj.drawString(StatCollector.translateToLocal((String)"container.inventory"), 8, this.ySize - 96 + 3, 0x404040);
        }
        this.drawElements(0.0f, true);
        this.drawTabs(0.0f, true);
    }

    protected void drawGuiContainerBackgroundLayer(float partialTick, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture);
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.mouseX = x - this.guiLeft;
        this.mouseY = y - this.guiTop;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        this.drawElements(partialTick, false);
        this.drawTabs(partialTick, false);
        GL11.glPopMatrix();
    }

    protected void keyTyped(char characterTyped, int keyPressed) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.onKeyTyped(characterTyped, keyPressed)) continue;
            return;
        }
        super.keyTyped(characterTyped, keyPressed);
    }

    public void handleMouseInput() {
        int x = Mouse.getEventX() * this.width / this.mc.displayWidth;
        int y = this.height - Mouse.getEventY() * this.height / this.mc.displayHeight - 1;
        this.mouseX = x - this.guiLeft;
        this.mouseY = y - this.guiTop;
        int wheelMovement = Mouse.getEventDWheel();
        if (wheelMovement != 0) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(this.mouseX, this.mouseY) || !c.onMouseWheel(this.mouseX, this.mouseY, wheelMovement)) continue;
                return;
            }
            TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
            if (tab != null && tab.onMouseWheel(this.mouseX, this.mouseY, wheelMovement)) {
                return;
            }
        }
        super.handleMouseInput();
    }

    protected void mouseClicked(int mX, int mY, int mouseButton) {
        int tMx;
        mX -= this.guiLeft;
        mY -= this.guiTop;
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled() || !c.intersectsWith(mX, mY) || !c.onMousePressed(mX, mY, mouseButton)) continue;
            return;
        }
        TabBase tab = this.getTabAtPosition(mX, mY);
        if (tab != null && !tab.onMousePressed(tMx = mX, mY, mouseButton)) {
            int i2 = this.tabs.size();
            while (i2-- > 0) {
                TabBase other = this.tabs.get(i2);
                if (other == tab || !other.open || other.side != tab.side) continue;
                other.toggleOpen();
            }
            tab.toggleOpen();
            return;
        }
        mX += this.guiLeft;
        mY += this.guiTop;
        if (tab != null) {
            switch (tab.side) {
                case 0: {
                    this.guiLeft -= tab.currentWidth;
                    break;
                }
                case 1: {
                    this.xSize += tab.currentWidth;
                }
            }
        }
        super.mouseClicked(mX, mY, mouseButton);
        if (tab != null) {
            switch (tab.side) {
                case 0: {
                    this.guiLeft += tab.currentWidth;
                    break;
                }
                case 1: {
                    this.xSize -= tab.currentWidth;
                }
            }
        }
    }

    protected void mouseMovedOrUp(int mX, int mY, int mouseButton) {
        mX -= this.guiLeft;
        mY -= this.guiTop;
        if (mouseButton >= 0 && mouseButton <= 2) {
            int i = this.elements.size();
            while (i-- > 0) {
                ElementBase c = this.elements.get(i);
                if (!c.isVisible() || !c.isEnabled()) continue;
                c.onMouseReleased(mX, mY);
            }
        }
        super.mouseMovedOrUp(mX += this.guiLeft, mY += this.guiTop, mouseButton);
    }

    protected void mouseClickMove(int mX, int mY, int lastClick, long timeSinceClick) {
        Slot slot = this.getSlotAtPosition(mX, mY);
        ItemStack itemstack = this.mc.thePlayer.inventory.getItemStack();
        if (this.field_147007_t && slot != null && itemstack != null && slot instanceof SlotFalseCopy) {
            if (this.lastIndex != slot.slotNumber) {
                this.lastIndex = slot.slotNumber;
                this.handleMouseClick(slot, slot.slotNumber, 0, 0);
            }
        } else {
            this.lastIndex = -1;
            super.mouseClickMove(mX, mY, lastClick, timeSinceClick);
        }
    }

    public Slot getSlotAtPosition(int xCoord, int yCoord) {
        for (int k = 0; k < this.inventorySlots.inventorySlots.size(); ++k) {
            Slot slot = (Slot)this.inventorySlots.inventorySlots.get(k);
            if (!this.isMouseOverSlot(slot, xCoord, yCoord)) continue;
            return slot;
        }
        return null;
    }

    public boolean isMouseOverSlot(Slot theSlot, int xCoord, int yCoord) {
        return this.func_146978_c(theSlot.xDisplayPosition, theSlot.yDisplayPosition, 16, 16, xCoord, yCoord);
    }

    protected void drawElements(float partialTick, boolean foreground) {
        if (foreground) {
            for (int i = 0; i < this.elements.size(); ++i) {
                ElementBase element = this.elements.get(i);
                if (!element.isVisible()) continue;
                element.drawForeground(this.mouseX, this.mouseY);
            }
        } else {
            for (int i = 0; i < this.elements.size(); ++i) {
                ElementBase element = this.elements.get(i);
                if (!element.isVisible()) continue;
                element.drawBackground(this.mouseX, this.mouseY, partialTick);
            }
        }
    }

    protected void drawTabs(float partialTick, boolean foreground) {
        if (foreground) {
            return;
        }
        int yPosRight = 4;
        int yPosLeft = 4;
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabBase tab = this.tabs.get(i);
            tab.update();
            if (!tab.isVisible()) continue;
            if (tab.side == 0) {
                tab.draw(0, yPosLeft);
                yPosLeft += tab.currentHeight;
                continue;
            }
            tab.draw(this.xSize, yPosRight);
            yPosRight += tab.currentHeight;
        }
    }

    public List<String> handleTooltip(int mousex, int mousey, List<String> tooltip) {
        if (this.mc.thePlayer.inventory.getItemStack() == null) {
            this.addTooltips(tooltip);
        }
        return tooltip;
    }

    public void addTooltips(List<String> tooltip) {
        ElementBase element;
        TabBase tab = this.getTabAtPosition(this.mouseX, this.mouseY);
        if (tab != null) {
            tab.addTooltip(tooltip);
        }
        if ((element = this.getElementAtPosition(this.mouseX, this.mouseY)) != null) {
            element.addTooltip(tooltip);
        }
    }

    public ElementBase addElement(ElementBase element) {
        this.elements.add(element);
        return element;
    }

    public TabBase addTab(TabBase tab) {
        int yOffset = 4;
        for (int i = 0; i < this.tabs.size(); ++i) {
            if (this.tabs.get((int)i).side != tab.side || !this.tabs.get(i).isVisible()) continue;
            yOffset += this.tabs.get((int)i).currentHeight;
        }
        tab.setPosition(tab.side == 0 ? 0 : this.xSize, yOffset);
        this.tabs.add(tab);
        if (TabTracker.getOpenedLeftTab() != null && tab.getClass().equals(TabTracker.getOpenedLeftTab())) {
            tab.setFullyOpen();
        } else if (TabTracker.getOpenedRightTab() != null && tab.getClass().equals(TabTracker.getOpenedRightTab())) {
            tab.setFullyOpen();
        }
        return tab;
    }

    protected ElementBase getElementAtPosition(int mX, int mY) {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase element = this.elements.get(i);
            if (!element.intersectsWith(mX, mY)) continue;
            return element;
        }
        return null;
    }

    protected TabBase getTabAtPosition(int mX, int mY) {
        TabBase tab;
        int i;
        int xShift = 0;
        int yShift = 4;
        for (i = 0; i < this.tabs.size(); ++i) {
            tab = this.tabs.get(i);
            if (!tab.isVisible() || tab.side == 1) continue;
            tab.setCurrentShift(xShift, yShift);
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        xShift = this.xSize;
        yShift = 4;
        for (i = 0; i < this.tabs.size(); ++i) {
            tab = this.tabs.get(i);
            if (!tab.isVisible() || tab.side == 0) continue;
            tab.setCurrentShift(xShift, yShift);
            if (tab.intersectsWith(mX, mY, xShift, yShift)) {
                return tab;
            }
            yShift += tab.currentHeight;
        }
        return null;
    }

    protected final void updateElements() {
        int i = this.elements.size();
        while (i-- > 0) {
            ElementBase c = this.elements.get(i);
            if (!c.isVisible() || !c.isEnabled()) continue;
            c.update(this.mouseX, this.mouseY);
        }
    }

    protected void updateElementInformation() {
    }

    public void handleElementButtonClick(String buttonName, int mouseButton) {
    }

    public void bindTexture(ResourceLocation texture) {
        this.mc.renderEngine.bindTexture(texture);
    }

    public IIcon getIcon(String name) {
        return null;
    }

    public void drawButton(IIcon icon, int x, int y, int spriteSheet, int mode) {
        this.drawIcon(icon, x, y, spriteSheet);
    }

    public void drawButton(String iconName, int x, int y, int spriteSheet, int mode) {
        this.drawButton(this.getIcon(iconName), x, y, spriteSheet, mode);
    }

    public void drawFluid(int x, int y, FluidStack fluid, int width, int height) {
        if (fluid == null || fluid.getFluid() == null) {
            return;
        }
        RenderHelper.setBlockTextureSheet();
        RenderHelper.setColor3ub(fluid.getFluid().getColor(fluid));
        this.drawTiledTexture(x, y, fluid.getFluid().getIcon(fluid), width, height);
    }

    public void drawTiledTexture(int x, int y, IIcon icon, int width, int height) {
        int i = 0;
        int j = 0;
        int drawHeight = 0;
        int drawWidth = 0;
        for (i = 0; i < width; i += 16) {
            for (j = 0; j < height; j += 16) {
                drawWidth = Math.min(width - i, 16);
                drawHeight = Math.min(height - j, 16);
                this.drawScaledTexturedModelRectFromIcon(x + i, y + j, icon, drawWidth, drawHeight);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawIcon(IIcon icon, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModelRectFromIcon(x, y, icon, 16, 16);
    }

    public void drawColorIcon(IIcon icon, int x, int y, int spriteSheet) {
        if (spriteSheet == 0) {
            RenderHelper.setBlockTextureSheet();
        } else {
            RenderHelper.setItemTextureSheet();
        }
        this.drawTexturedModelRectFromIcon(x, y, icon, 16, 16);
    }

    public void drawIcon(String iconName, int x, int y, int spriteSheet) {
        this.drawIcon(this.getIcon(iconName), x, y, spriteSheet);
    }

    public void drawSizedModalRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.startDrawingQuads();
        tessellator.addVertex((double)x1, (double)y2, (double)this.zLevel);
        tessellator.addVertex((double)x2, (double)y2, (double)this.zLevel);
        tessellator.addVertex((double)x2, (double)y1, (double)this.zLevel);
        tessellator.addVertex((double)x1, (double)y1, (double)this.zLevel);
        tessellator.draw();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    public void drawSizedRect(int x1, int y1, int x2, int y2, int color) {
        int temp;
        if (x1 < x2) {
            temp = x1;
            x1 = x2;
            x2 = temp;
        }
        if (y1 < y2) {
            temp = y1;
            y1 = y2;
            y2 = temp;
        }
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.instance;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        tessellator.startDrawingQuads();
        tessellator.addVertex((double)x1, (double)y2, (double)this.zLevel);
        tessellator.addVertex((double)x2, (double)y2, (double)this.zLevel);
        tessellator.addVertex((double)x2, (double)y1, (double)this.zLevel);
        tessellator.addVertex((double)x1, (double)y1, (double)this.zLevel);
        tessellator.draw();
        GL11.glEnable((int)3553);
    }

    public void drawSizedTexturedModalRect(int x, int y, int u, int v, int width, int height, float texW, float texH) {
        float texU = 1.0f / texW;
        float texV = 1.0f / texH;
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)(x + 0), (double)(y + height), (double)this.zLevel, (double)((float)(u + 0) * texU), (double)((float)(v + height) * texV));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), (double)this.zLevel, (double)((float)(u + width) * texU), (double)((float)(v + height) * texV));
        tessellator.addVertexWithUV((double)(x + width), (double)(y + 0), (double)this.zLevel, (double)((float)(u + width) * texU), (double)((float)(v + 0) * texV));
        tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)this.zLevel, (double)((float)(u + 0) * texU), (double)((float)(v + 0) * texV));
        tessellator.draw();
    }

    public void drawScaledTexturedModelRectFromIcon(int x, int y, IIcon icon, int width, int height) {
        if (icon == null) {
            return;
        }
        double minU = icon.getMinU();
        double maxU = icon.getMaxU();
        double minV = icon.getMinV();
        double maxV = icon.getMaxV();
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)(x + 0), (double)(y + height), (double)this.zLevel, minU, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.addVertexWithUV((double)(x + width), (double)(y + height), (double)this.zLevel, minU + (maxU - minU) * (double)width / 16.0, minV + (maxV - minV) * (double)height / 16.0);
        tessellator.addVertexWithUV((double)(x + width), (double)(y + 0), (double)this.zLevel, minU + (maxU - minU) * (double)width / 16.0, minV);
        tessellator.addVertexWithUV((double)(x + 0), (double)(y + 0), (double)this.zLevel, minU, minV);
        tessellator.draw();
    }

    public void drawTooltip(List<String> list) {
        this.drawTooltipHoveringText(list, this.mouseX + this.guiLeft, this.mouseY + this.guiTop, this.fontRendererObj);
        this.tooltip.clear();
    }

    protected void drawTooltipHoveringText(List list, int x, int y, FontRenderer font) {
        if (list == null || list.isEmpty()) {
            return;
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        int k = 0;
        for (String s : list) {
            int l = font.getStringWidth(s);
            if (l <= k) continue;
            k = l;
        }
        int i1 = x + 12;
        int j1 = y - 12;
        int k1 = 8;
        if (list.size() > 1) {
            k1 += 2 + (list.size() - 1) * 10;
        }
        if (i1 + k > this.width) {
            i1 -= 28 + k;
        }
        if (j1 + k1 + 6 > this.height) {
            j1 = this.height - k1 - 6;
        }
        this.zLevel = 300.0f;
        GuiBase.itemRender.zLevel = 300.0f;
        int l1 = -267386864;
        this.drawGradientRect(i1 - 3, j1 - 4, i1 + k + 3, j1 - 3, l1, l1);
        this.drawGradientRect(i1 - 3, j1 + k1 + 3, i1 + k + 3, j1 + k1 + 4, l1, l1);
        this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 + k1 + 3, l1, l1);
        this.drawGradientRect(i1 - 4, j1 - 3, i1 - 3, j1 + k1 + 3, l1, l1);
        this.drawGradientRect(i1 + k + 3, j1 - 3, i1 + k + 4, j1 + k1 + 3, l1, l1);
        int i2 = 0x505000FF;
        int j2 = (i2 & 0xFEFEFE) >> 1 | i2 & 0xFF000000;
        this.drawGradientRect(i1 - 3, j1 - 3 + 1, i1 - 3 + 1, j1 + k1 + 3 - 1, i2, j2);
        this.drawGradientRect(i1 + k + 2, j1 - 3 + 1, i1 + k + 3, j1 + k1 + 3 - 1, i2, j2);
        this.drawGradientRect(i1 - 3, j1 - 3, i1 + k + 3, j1 - 3 + 1, i2, i2);
        this.drawGradientRect(i1 - 3, j1 + k1 + 2, i1 + k + 3, j1 + k1 + 3, j2, j2);
        for (int k2 = 0; k2 < list.size(); ++k2) {
            String s1 = (String)list.get(k2);
            font.drawStringWithShadow(s1, i1, j1, -1);
            if (k2 == 0) {
                j1 += 2;
            }
            j1 += 10;
        }
        this.zLevel = 0.0f;
        GuiBase.itemRender.zLevel = 0.0f;
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
    }

    public void mouseClicked(int mouseButton) {
        super.mouseClicked(this.guiLeft + this.mouseX, this.guiTop + this.mouseY, mouseButton);
    }

    public FontRenderer getFontRenderer() {
        return this.fontRendererObj;
    }

    protected int getCenteredOffset(String string) {
        return this.getCenteredOffset(string, this.xSize);
    }

    protected int getCenteredOffset(String string, int xWidth) {
        return (xWidth - this.fontRendererObj.getStringWidth(string)) / 2;
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public int getMouseX() {
        return this.mouseX;
    }

    public int getMouseY() {
        return this.mouseY;
    }

    public void overlayRecipe() {
    }
}

