/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.client.handler;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.api.knowledge.TransmutationKnowledgeRegistryProxy;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.inventory.ContainerAlchemicalTome;
import com.pahimar.ee3.inventory.ContainerResearchStation;
import com.pahimar.ee3.inventory.ContainerTransmutationTablet;
import com.pahimar.ee3.util.IOwnable;
import com.pahimar.ee3.util.ItemHelper;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class ItemTooltipEventHandler {
    private static DecimalFormat energyValueDecimalFormat = new DecimalFormat("###,###,###,###,###.###");

    @SubscribeEvent
    public void handleItemTooltipEvent(ItemTooltipEvent event) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) || event.entityPlayer != null && (event.entityPlayer.field_71070_bA instanceof ContainerAlchemicalTome || event.entityPlayer.field_71070_bA instanceof ContainerTransmutationTablet)) {
            WrappedStack wrappedItemStack = WrappedStack.wrap(event.itemStack);
            EnergyValue energyValue = EnergyValueRegistryProxy.getEnergyValue(wrappedItemStack);
            if (energyValue != null) {
                if (wrappedItemStack.getStackSize() > 1) {
                    event.toolTip.add(String.format("Exchange Energy (Item): %s", energyValueDecimalFormat.format(energyValue.getValue())));
                    event.toolTip.add(String.format("Exchange Energy (Stack of %s): %s", event.itemStack.field_77994_a, energyValueDecimalFormat.format((float)wrappedItemStack.getStackSize() * energyValue.getValue())));
                } else {
                    FluidStack fluidStack;
                    event.toolTip.add(String.format("Exchange Energy: %s", energyValueDecimalFormat.format((float)wrappedItemStack.getStackSize() * energyValue.getValue())));
                    if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)event.itemStack) != null && EnergyValueRegistryProxy.getEnergyValueForStack(fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)event.itemStack)) != null) {
                        EnergyValue fluidStackEnergyValue = EnergyValueRegistryProxy.getEnergyValueForStack(fluidStack);
                        event.toolTip.add(String.format(" - Exchange Energy (%s): %s", fluidStack.getLocalizedName(), energyValueDecimalFormat.format(fluidStackEnergyValue.getValue())));
                        event.toolTip.add(String.format(" - Exchange Energy (Container): %s", energyValueDecimalFormat.format(energyValue.getValue() - fluidStackEnergyValue.getValue())));
                    }
                }
            } else {
                event.toolTip.add("No Exchange Energy value");
            }
        }
        if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && event.entityPlayer != null && event.entityPlayer.field_71070_bA instanceof ContainerResearchStation && TransmutationKnowledgeRegistryProxy.doesPlayerKnow(event.entityPlayer, event.itemStack)) {
            event.toolTip.add("You know how to transmute this");
        }
        if (event.itemStack.func_77973_b() instanceof IOwnable) {
            UUID playerUUID = ItemHelper.getOwnerUUID(event.itemStack);
            if (playerUUID != null && UsernameCache.containsUUID((UUID)playerUUID)) {
                event.toolTip.add(StatCollector.func_74837_a((String)"tooltip.ee3:belongsTo", (Object[])new Object[]{UsernameCache.getLastKnownUsername((UUID)playerUUID)}));
            } else if (ItemHelper.hasOwnerName(event.itemStack)) {
                event.toolTip.add(StatCollector.func_74837_a((String)"tooltip.ee3:belongsTo", (Object[])new Object[]{ItemHelper.getOwnerName(event.itemStack)}));
            } else if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                event.toolTip.add(StatCollector.func_74838_a((String)"tooltip.ee3:belongsToNoOne"));
            }
        }
    }
}

