/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.LogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class CachedOreDictionary {
    private static CachedOreDictionary cachedOreDictionary = null;
    private ImmutableMap<Integer, String> idToNameMap;
    private ImmutableMap<String, List<ItemStack>> oreNameToItemStackMap;
    private ImmutableMultimap<WrappedStack, String> itemStackToOreNameMap;

    private CachedOreDictionary() {
        TreeMap<Integer, String> idToOreNameMap = new TreeMap<Integer, String>();
        TreeMap<String, ArrayList> nameToStackMap = new TreeMap<String, ArrayList>(Comparators.stringComparator);
        TreeMultimap stackToNameMultiMap = TreeMultimap.create(WrappedStack.comparator, Comparators.stringComparator);
        for (String oreName : OreDictionary.getOreNames()) {
            idToOreNameMap.put(OreDictionary.getOreID((String)oreName), oreName);
            ArrayList oreNameItemStacks = OreDictionary.getOres((String)oreName);
            nameToStackMap.put(oreName, oreNameItemStacks);
            for (ItemStack itemStack : oreNameItemStacks) {
                stackToNameMultiMap.put((Object)WrappedStack.wrap(itemStack), (Object)oreName);
            }
        }
        this.idToNameMap = ImmutableMap.copyOf(idToOreNameMap);
        this.oreNameToItemStackMap = ImmutableMap.copyOf(nameToStackMap);
        this.itemStackToOreNameMap = ImmutableMultimap.copyOf((Multimap)stackToNameMultiMap);
    }

    public static CachedOreDictionary getInstance() {
        if (cachedOreDictionary == null) {
            cachedOreDictionary = new CachedOreDictionary();
        }
        return cachedOreDictionary;
    }

    public Set<String> getOreNames() {
        return this.oreNameToItemStackMap.keySet();
    }

    public List<ItemStack> getItemStacksForOreName(String oreName) {
        if (this.oreNameToItemStackMap.containsKey((Object)oreName)) {
            return (List)this.oreNameToItemStackMap.get((Object)oreName);
        }
        return new ArrayList<ItemStack>();
    }

    public List<String> getOreNamesForItemStack(ItemStack itemStack) {
        ArrayList<String> oreNameList = new ArrayList<String>();
        WrappedStack wrappedStack = WrappedStack.wrap(itemStack);
        if (this.itemStackToOreNameMap.containsKey((Object)wrappedStack)) {
            for (String oreName : this.itemStackToOreNameMap.get((Object)wrappedStack)) {
                oreNameList.add(oreName);
            }
        } else {
            for (WrappedStack wrappedStack1 : this.itemStackToOreNameMap.keySet()) {
            }
        }
        return oreNameList;
    }

    public void dumpCachedOreDictionaryToLog() {
        for (String oreName : CachedOreDictionary.getInstance().getOreNames()) {
            LogHelper.info(String.format("OreName: %s, ItemStacks: %s", oreName, CachedOreDictionary.getInstance().getItemStacksForOreName(oreName)));
        }
    }
}

