/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.exchange;

import com.google.common.collect.ImmutableSortedMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.api.exchange.IEnergyValueProvider;
import com.pahimar.ee3.exchange.CachedOreDictionary;
import com.pahimar.ee3.exchange.EnergyValueStackMapping;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.recipe.RecipeRegistry;
import com.pahimar.ee3.reference.Reference;
import com.pahimar.ee3.reference.Settings;
import com.pahimar.ee3.util.EnergyValueHelper;
import com.pahimar.ee3.util.LoaderHelper;
import com.pahimar.ee3.util.LogHelper;
import com.pahimar.ee3.util.SerializationHelper;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class EnergyValueRegistry
implements JsonSerializer<EnergyValueRegistry>,
JsonDeserializer<EnergyValueRegistry> {
    private static final Gson jsonSerializer = new GsonBuilder().registerTypeAdapter(EnergyValueRegistry.class, (Object)new EnergyValueRegistry()).registerTypeAdapter(EnergyValueStackMapping.class, (Object)new EnergyValueStackMapping()).create();
    private static final Gson prettyJsonSerializer = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(EnergyValueRegistry.class, (Object)new EnergyValueRegistry()).registerTypeAdapter(EnergyValueStackMapping.class, (Object)new EnergyValueStackMapping()).create();
    private boolean shouldRegenNextRestart = false;
    private static EnergyValueRegistry energyValueRegistry = null;
    private static Map<WrappedStack, EnergyValue> preAssignedMappings;
    private static Map<WrappedStack, EnergyValue> postAssignedMappings;
    private ImmutableSortedMap<WrappedStack, EnergyValue> stackMappings;
    private ImmutableSortedMap<EnergyValue, List<WrappedStack>> valueMappings;

    private EnergyValueRegistry() {
    }

    public static EnergyValueRegistry getInstance() {
        if (energyValueRegistry == null) {
            energyValueRegistry = new EnergyValueRegistry();
        }
        return energyValueRegistry;
    }

    public void addPreAssignedEnergyValue(Object object, float energyValue) {
        this.addPreAssignedEnergyValue(object, new EnergyValue(energyValue));
    }

    public void addPreAssignedEnergyValue(Object object, EnergyValue energyValue) {
        WrappedStack wrappedStack;
        if (preAssignedMappings == null) {
            preAssignedMappings = new TreeMap<WrappedStack, EnergyValue>();
        }
        if (WrappedStack.canBeWrapped(object) && energyValue != null && Float.compare(energyValue.getValue(), 0.0f) > 0 && (wrappedStack = WrappedStack.wrap(object)).getStackSize() > 0) {
            WrappedStack factoredWrappedStack = WrappedStack.wrap(wrappedStack, 1);
            EnergyValue factoredEnergyValue = EnergyValueHelper.factorEnergyValue(energyValue, wrappedStack.getStackSize());
            if (preAssignedMappings.containsKey(factoredWrappedStack)) {
                if (factoredEnergyValue.compareTo(preAssignedMappings.get(factoredWrappedStack)) < 0) {
                    LogHelper.trace(String.format("EnergyValueRegistry[%s]: Mod with ID '%s' added a pre-assignment energy value of %s for object %s", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), energyValue, wrappedStack));
                    preAssignedMappings.put(factoredWrappedStack, factoredEnergyValue);
                }
            } else {
                LogHelper.trace(String.format("EnergyValueRegistry[%s]: Mod with ID '%s' added a pre-assignment energy value of %s for object %s", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), energyValue, wrappedStack));
                preAssignedMappings.put(factoredWrappedStack, factoredEnergyValue);
            }
        }
    }

    public void addPostAssignedExactEnergyValue(Object object, float energyValue) {
        this.addPostAssignedExactEnergyValue(object, new EnergyValue(energyValue));
    }

    public void addPostAssignedExactEnergyValue(Object object, EnergyValue energyValue) {
        WrappedStack wrappedStack;
        if (postAssignedMappings == null) {
            postAssignedMappings = new TreeMap<WrappedStack, EnergyValue>();
        }
        if (WrappedStack.canBeWrapped(object) && energyValue != null && Float.compare(energyValue.getValue(), 0.0f) > 0 && (wrappedStack = WrappedStack.wrap(object)).getStackSize() > 0) {
            WrappedStack factoredWrappedStack = WrappedStack.wrap(wrappedStack, 1);
            EnergyValue factoredEnergyValue = EnergyValueHelper.factorEnergyValue(energyValue, wrappedStack.getStackSize());
            LogHelper.trace(String.format("EnergyValueRegistry[%s]: Mod with ID '%s' added a post-assignment energy value of %s for object %s", LoaderHelper.getLoaderState(), Loader.instance().activeModContainer().getModId(), energyValue, wrappedStack));
            postAssignedMappings.put(factoredWrappedStack, factoredEnergyValue);
        }
    }

    public boolean hasEnergyValue(Object object) {
        return this.hasEnergyValue(object, false);
    }

    public boolean hasEnergyValue(Object object, boolean strict) {
        return this.getEnergyValue(object, strict) != null;
    }

    public EnergyValue getEnergyValue(Object object) {
        return this.getEnergyValueFromMap((Map<WrappedStack, EnergyValue>)EnergyValueRegistry.energyValueRegistry.stackMappings, object, false);
    }

    public EnergyValue getEnergyValue(Object object, boolean strict) {
        return this.getEnergyValueFromMap((Map<WrappedStack, EnergyValue>)EnergyValueRegistry.energyValueRegistry.stackMappings, object, strict);
    }

    public EnergyValue getEnergyValueForStack(Object object) {
        return this.getEnergyValueForStack(object, false);
    }

    public EnergyValue getEnergyValueForStack(Object object, boolean strict) {
        WrappedStack wrappedObject = WrappedStack.wrap(object);
        if (wrappedObject != null && this.getEnergyValue(object, strict) != null) {
            return new EnergyValue(this.getEnergyValue(object, strict).getValue() * (float)wrappedObject.getStackSize());
        }
        return null;
    }

    public EnergyValue getEnergyValueFromMap(Map<WrappedStack, EnergyValue> stackEnergyValueMap, Object object) {
        return this.getEnergyValueFromMap(stackEnergyValueMap, object, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public EnergyValue getEnergyValueFromMap(Map<WrappedStack, EnergyValue> stackEnergyValueMap, Object object, boolean strict) {
        if (!WrappedStack.canBeWrapped(object)) return null;
        WrappedStack wrappedStackObject = WrappedStack.wrap(object);
        WrappedStack unitWrappedStackObject = WrappedStack.wrap(object);
        unitWrappedStackObject.setStackSize(1);
        Object wrappedObject = wrappedStackObject.getWrappedObject();
        if (wrappedObject instanceof ItemStack && ((ItemStack)wrappedObject).func_77973_b() instanceof IEnergyValueProvider && !strict) {
            ItemStack itemStack = (ItemStack)wrappedObject;
            IEnergyValueProvider iEnergyValueProvider = (IEnergyValueProvider)itemStack.func_77973_b();
            EnergyValue energyValue = iEnergyValueProvider.getEnergyValue(itemStack);
            if (energyValue == null || !(energyValue.getValue() > 0.0f)) return null;
            return energyValue;
        }
        if (stackEnergyValueMap == null) return null;
        if (stackEnergyValueMap.containsKey(unitWrappedStackObject)) {
            return stackEnergyValueMap.get(unitWrappedStackObject);
        }
        if (strict) return null;
        if (wrappedObject instanceof ItemStack) {
            EnergyValue lowestValue = null;
            ItemStack wrappedItemStack = (ItemStack)wrappedObject;
            if (OreDictionary.getOreIDs((ItemStack)wrappedItemStack).length >= 1) {
                EnergyValue energyValue = null;
                boolean allHaveSameValueFlag = true;
                for (int oreID : OreDictionary.getOreIDs((ItemStack)wrappedItemStack)) {
                    String oreName = OreDictionary.getOreName((int)oreID);
                    if (!oreName.equals("Unknown")) {
                        WrappedStack oreStack = WrappedStack.wrap(new OreStack(oreName));
                        if (oreStack != null && stackEnergyValueMap.containsKey(oreStack)) {
                            if (energyValue == null) {
                                energyValue = stackEnergyValueMap.get(oreStack);
                                continue;
                            }
                            if (energyValue.equals(stackEnergyValueMap.get(oreStack))) continue;
                            allHaveSameValueFlag = false;
                            continue;
                        }
                        allHaveSameValueFlag = false;
                        continue;
                    }
                    allHaveSameValueFlag = false;
                }
                if (energyValue == null || !allHaveSameValueFlag) return null;
                return energyValue;
            }
            for (WrappedStack valuedStack : stackEnergyValueMap.keySet()) {
                EnergyValue stackValue;
                ItemStack valuedItemStack;
                if (!(valuedStack.getWrappedObject() instanceof ItemStack) || Item.func_150891_b((Item)(valuedItemStack = (ItemStack)valuedStack.getWrappedObject()).func_77973_b()) != Item.func_150891_b((Item)wrappedItemStack.func_77973_b())) continue;
                if (valuedItemStack.func_77960_j() == Short.MAX_VALUE || wrappedItemStack.func_77960_j() == Short.MAX_VALUE) {
                    stackValue = stackEnergyValueMap.get(valuedStack);
                    if (stackValue.compareTo(lowestValue) >= 0) continue;
                    lowestValue = stackValue;
                    continue;
                }
                if (!wrappedItemStack.func_77973_b().func_77645_m() || !wrappedItemStack.func_77951_h() || (stackValue = new EnergyValue(stackEnergyValueMap.get(valuedStack).getValue() * (1.0f - (float)wrappedItemStack.func_77960_j() * 1.0f / (float)wrappedItemStack.func_77958_k()))).compareTo(lowestValue) >= 0) continue;
                lowestValue = stackValue;
            }
            return lowestValue;
        }
        if (!(wrappedObject instanceof OreStack)) return null;
        OreStack oreStack = (OreStack)wrappedObject;
        if (CachedOreDictionary.getInstance().getItemStacksForOreName(oreStack.oreName).size() < 1) return null;
        EnergyValue energyValue = null;
        boolean allHaveSameValueFlag = true;
        for (ItemStack itemStack : CachedOreDictionary.getInstance().getItemStacksForOreName(oreStack.oreName)) {
            WrappedStack wrappedItemStack = WrappedStack.wrap(itemStack);
            if (wrappedItemStack != null && stackEnergyValueMap.containsKey(wrappedItemStack)) {
                if (energyValue == null) {
                    energyValue = stackEnergyValueMap.get(wrappedItemStack);
                    continue;
                }
                if (energyValue.equals(stackEnergyValueMap.get(wrappedItemStack))) continue;
                allHaveSameValueFlag = false;
                continue;
            }
            allHaveSameValueFlag = false;
        }
        if (energyValue == null || !allHaveSameValueFlag) return null;
        return energyValue;
    }

    protected final void init() {
        if (!this.loadEnergyValueRegistryFromFile()) {
            this.runDynamicEnergyValueResolution();
        }
        AbilityRegistry.getInstance().discoverAllLearnableItemStacks();
        this.shouldRegenNextRestart = false;
    }

    private void runDynamicEnergyValueResolution() {
        TreeMap<WrappedStack, EnergyValue> stackValueMap = new TreeMap<WrappedStack, EnergyValue>();
        stackValueMap.putAll(preAssignedMappings);
        Map<WrappedStack, EnergyValue> preAssignedValueMap = SerializationHelper.readEnergyValueStackMapFromJsonFile("pre-assigned-energy-values.json");
        for (WrappedStack wrappedStack : preAssignedValueMap.keySet()) {
            if (preAssignedValueMap.get(wrappedStack) == null) continue;
            stackValueMap.put(wrappedStack, preAssignedValueMap.get(wrappedStack));
        }
        ImmutableSortedMap.Builder stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
        stackMappingsBuilder.putAll(stackValueMap);
        this.stackMappings = stackMappingsBuilder.build();
        Map<Object, Object> computedStackValues = new TreeMap();
        int passNumber = 0;
        long computationStartTime = System.currentTimeMillis();
        int computedValueCount = 0;
        int totalComputedValueCount = 0;
        LogHelper.info("Beginning dynamic value computation");
        boolean isFirstPass = true;
        while ((isFirstPass || computedValueCount > 0) && passNumber < 16) {
            if (isFirstPass) {
                isFirstPass = false;
            }
            computedValueCount = 0;
            long passStartTime = System.currentTimeMillis();
            ++passNumber;
            computedStackValues = this.computeStackMappings(stackValueMap);
            for (WrappedStack wrappedStack : computedStackValues.keySet()) {
                EnergyValue factoredExchangeEnergyValue = null;
                WrappedStack factoredKeyStack = null;
                if (wrappedStack != null && wrappedStack.getWrappedObject() != null && wrappedStack.getStackSize() > 0 && computedStackValues.get(wrappedStack) != null && Float.compare(((EnergyValue)computedStackValues.get(wrappedStack)).getValue(), 0.0f) > 0) {
                    factoredExchangeEnergyValue = EnergyValueHelper.factorEnergyValue((EnergyValue)computedStackValues.get(wrappedStack), wrappedStack.getStackSize());
                    factoredKeyStack = WrappedStack.wrap(wrappedStack, 1);
                }
                if (factoredExchangeEnergyValue == null) continue;
                if (stackValueMap.containsKey(factoredKeyStack)) {
                    if (factoredExchangeEnergyValue.compareTo(stackValueMap.get(factoredKeyStack)) != -1) continue;
                    stackValueMap.put(factoredKeyStack, factoredExchangeEnergyValue);
                    continue;
                }
                stackValueMap.put(factoredKeyStack, factoredExchangeEnergyValue);
                ++computedValueCount;
                ++totalComputedValueCount;
            }
            LogHelper.info(String.format("Pass %s: Computed %s values for objects in %s ms", passNumber, computedValueCount, System.currentTimeMillis() - passStartTime));
        }
        LogHelper.info(String.format("Finished dynamic value computation (computed %s values for objects in %s ms)", totalComputedValueCount, System.currentTimeMillis() - computationStartTime));
        if (postAssignedMappings != null) {
            for (WrappedStack wrappedStack : postAssignedMappings.keySet()) {
                if (postAssignedMappings.get(wrappedStack) == null) continue;
                stackValueMap.put(wrappedStack, postAssignedMappings.get(wrappedStack));
            }
        } else {
            postAssignedMappings = new TreeMap<WrappedStack, EnergyValue>();
        }
        Map<WrappedStack, EnergyValue> postAssignedValueMap = SerializationHelper.readEnergyValueStackMapFromJsonFile("post-assigned-energy-values.json");
        for (WrappedStack wrappedStack : postAssignedValueMap.keySet()) {
            if (postAssignedValueMap.get(wrappedStack) == null) continue;
            stackValueMap.put(wrappedStack, postAssignedValueMap.get(wrappedStack));
        }
        stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
        stackMappingsBuilder.putAll(stackValueMap);
        this.stackMappings = stackMappingsBuilder.build();
        this.generateValueStackMappings();
        LogHelper.info("Saving energy values to disk");
        this.save();
    }

    private void generateValueStackMappings() {
        TreeMap<EnergyValue, ArrayList<WrappedStack>> tempValueMappings = new TreeMap<EnergyValue, ArrayList<WrappedStack>>();
        for (WrappedStack stack : this.stackMappings.keySet()) {
            EnergyValue value;
            if (stack == null || (value = (EnergyValue)this.stackMappings.get((Object)stack)) == null) continue;
            if (tempValueMappings.containsKey(value)) {
                if (((List)tempValueMappings.get(value)).contains(stack)) continue;
                ((List)tempValueMappings.get(value)).add(stack);
                continue;
            }
            tempValueMappings.put(value, new ArrayList<WrappedStack>(Arrays.asList(stack)));
        }
        this.valueMappings = ImmutableSortedMap.copyOf(tempValueMappings);
    }

    private Map<WrappedStack, EnergyValue> computeStackMappings(Map<WrappedStack, EnergyValue> stackValueMappings) {
        TreeMap<WrappedStack, EnergyValue> computedStackMap = new TreeMap<WrappedStack, EnergyValue>();
        for (WrappedStack recipeOutput : RecipeRegistry.getInstance().getRecipeMappings().keySet()) {
            if (this.hasEnergyValue(recipeOutput.getWrappedObject(), false) || computedStackMap.containsKey(recipeOutput)) continue;
            EnergyValue lowestValue = null;
            for (List recipeInputs : RecipeRegistry.getInstance().getRecipeMappings().get((Object)recipeOutput)) {
                EnergyValue computedValue = EnergyValueHelper.computeEnergyValueFromRecipe(stackValueMappings, recipeOutput, recipeInputs);
                if (computedValue == null || computedValue.compareTo(lowestValue) >= 0) continue;
                lowestValue = computedValue;
            }
            if (lowestValue == null || !(lowestValue.getValue() > 0.0f)) continue;
            computedStackMap.put(WrappedStack.wrap(recipeOutput.getWrappedObject()), lowestValue);
        }
        return computedStackMap;
    }

    public List getStacksInRange(int start, int finish) {
        return this.getStacksInRange(new EnergyValue(start), new EnergyValue(finish));
    }

    public List getStacksInRange(float start, float finish) {
        return this.getStacksInRange(new EnergyValue(start), new EnergyValue(finish));
    }

    public List getStacksInRange(EnergyValue start, EnergyValue finish) {
        ArrayList<Object> stacksInRange = new ArrayList<Object>();
        if (this.valueMappings != null) {
            ImmutableSortedMap tailMap = EnergyValueRegistry.energyValueRegistry.valueMappings.tailMap((Object)start);
            ImmutableSortedMap headMap = EnergyValueRegistry.energyValueRegistry.valueMappings.headMap((Object)finish);
            if (!tailMap.isEmpty() && !headMap.isEmpty()) {
                ImmutableSortedMap biggerMap;
                ImmutableSortedMap smallerMap;
                if (tailMap.size() <= headMap.size()) {
                    smallerMap = tailMap;
                    biggerMap = headMap;
                } else {
                    smallerMap = headMap;
                    biggerMap = tailMap;
                }
                for (EnergyValue value : smallerMap.keySet()) {
                    if (!biggerMap.containsKey(value)) continue;
                    for (WrappedStack wrappedStack : (List)EnergyValueRegistry.energyValueRegistry.valueMappings.get((Object)value)) {
                        if (wrappedStack.getWrappedObject() instanceof ItemStack || wrappedStack.getWrappedObject() instanceof FluidStack) {
                            stacksInRange.add(wrappedStack.getWrappedObject());
                            continue;
                        }
                        if (!(wrappedStack.getWrappedObject() instanceof OreStack)) continue;
                        for (ItemStack itemStack : OreDictionary.getOres((String)((OreStack)wrappedStack.getWrappedObject()).oreName)) {
                            stacksInRange.add(itemStack);
                        }
                    }
                }
            }
        }
        return stacksInRange;
    }

    public void loadFromMap(Map<WrappedStack, EnergyValue> stackValueMap) {
        if (stackValueMap != null) {
            ImmutableSortedMap.Builder stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
            stackMappingsBuilder.putAll(stackValueMap);
            this.stackMappings = stackMappingsBuilder.build();
            this.generateValueStackMappings();
        }
    }

    public void setEnergyValue(WrappedStack wrappedStack, EnergyValue energyValue) {
        if (wrappedStack != null && energyValue != null && Float.compare(energyValue.getValue(), 0.0f) > 0) {
            TreeMap<WrappedStack, EnergyValue> stackValueMap = new TreeMap<WrappedStack, EnergyValue>();
            stackValueMap.putAll((Map<WrappedStack, EnergyValue>)this.stackMappings);
            stackValueMap.put(wrappedStack, energyValue);
            ImmutableSortedMap.Builder stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
            stackMappingsBuilder.putAll(stackValueMap);
            this.stackMappings = stackMappingsBuilder.build();
            TreeMap<EnergyValue, ArrayList<WrappedStack>> tempValueMappings = new TreeMap<EnergyValue, ArrayList<WrappedStack>>();
            for (WrappedStack stack : this.stackMappings.keySet()) {
                EnergyValue value;
                if (stack == null || (value = (EnergyValue)this.stackMappings.get((Object)stack)) == null) continue;
                if (tempValueMappings.containsKey(value)) {
                    if (((List)tempValueMappings.get(value)).contains(stack)) continue;
                    ((List)tempValueMappings.get(value)).add(stack);
                    continue;
                }
                tempValueMappings.put(value, new ArrayList<WrappedStack>(Arrays.asList(stack)));
            }
            this.valueMappings = ImmutableSortedMap.copyOf(tempValueMappings);
        }
    }

    public boolean getShouldRegenNextRestart() {
        return this.shouldRegenNextRestart;
    }

    public void setShouldRegenNextRestart(boolean shouldRegenNextRestart) {
        this.shouldRegenNextRestart = shouldRegenNextRestart;
    }

    public ImmutableSortedMap<WrappedStack, EnergyValue> getStackValueMap() {
        return this.stackMappings;
    }

    public ImmutableSortedMap<EnergyValue, List<WrappedStack>> getValueStackMap() {
        return this.valueMappings;
    }

    public void save() {
        File energyValuesDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues");
        energyValuesDataDirectory.mkdirs();
        if (this.shouldRegenNextRestart) {
            File staticEnergyValuesJsonFile = new File(energyValuesDataDirectory, "energy-values.json.gz");
            File md5EnergyValuesJsonFile = new File(energyValuesDataDirectory, SerializationHelper.getModListMD5() + ".json");
            if (staticEnergyValuesJsonFile.exists()) {
                staticEnergyValuesJsonFile.delete();
            }
            if (md5EnergyValuesJsonFile.exists()) {
                md5EnergyValuesJsonFile.delete();
            }
            this.shouldRegenNextRestart = false;
        } else {
            SerializationHelper.compressEnergyValueStackMapToFile(new File(energyValuesDataDirectory, "energy-values.json.gz"), EnergyValueRegistry.energyValueRegistry.stackMappings);
            SerializationHelper.compressEnergyValueStackMapToFile(new File(energyValuesDataDirectory, SerializationHelper.getModListMD5() + ".json.gz"), EnergyValueRegistry.energyValueRegistry.stackMappings);
        }
    }

    public boolean loadEnergyValueRegistryFromFile() {
        File energyValuesDataDirectory = new File(FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_().func_72860_G().func_75765_b(), "data" + File.separator + Reference.LOWERCASE_MOD_ID + File.separator + "energyvalues");
        energyValuesDataDirectory.mkdirs();
        File staticEnergyValuesFile = new File(energyValuesDataDirectory, "energy-values.json.gz");
        File md5EnergyValuesFile = new File(energyValuesDataDirectory, SerializationHelper.getModListMD5() + ".json.gz");
        Map<WrappedStack, EnergyValue> stackValueMap = null;
        if (!Settings.DynamicEnergyValueGeneration.regenerateEnergyValuesWhen.equalsIgnoreCase("Always")) {
            if (Settings.DynamicEnergyValueGeneration.regenerateEnergyValuesWhen.equalsIgnoreCase("When Mods Change")) {
                if (md5EnergyValuesFile.exists()) {
                    LogHelper.info("Attempting to load energy values from file: " + md5EnergyValuesFile.getAbsolutePath());
                    stackValueMap = SerializationHelper.decompressEnergyValueStackMapFromFile(md5EnergyValuesFile);
                }
            } else if (Settings.DynamicEnergyValueGeneration.regenerateEnergyValuesWhen.equalsIgnoreCase("Never")) {
                if (staticEnergyValuesFile.exists()) {
                    LogHelper.info("Attempting to load energy values from file: " + staticEnergyValuesFile.getAbsolutePath());
                    stackValueMap = SerializationHelper.decompressEnergyValueStackMapFromFile(staticEnergyValuesFile);
                } else if (md5EnergyValuesFile.exists()) {
                    LogHelper.info("Attempting to load energy values from file: " + md5EnergyValuesFile.getAbsolutePath());
                    stackValueMap = SerializationHelper.decompressEnergyValueStackMapFromFile(md5EnergyValuesFile);
                }
            }
            if (stackValueMap != null) {
                this.loadFromMap(stackValueMap);
                LogHelper.info("Successfully loaded energy values from file");
                return true;
            }
            LogHelper.info("No energy value file to load values from, generating new values");
            return false;
        }
        return false;
    }

    public String toJson() {
        return prettyJsonSerializer.toJson((Object)this);
    }

    public EnergyValueRegistry deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonArray()) {
            JsonArray jsonArray = (JsonArray)json;
            TreeMap<WrappedStack, EnergyValue> stackValueMap = new TreeMap<WrappedStack, EnergyValue>();
            for (JsonElement jsonElement : jsonArray) {
                EnergyValueStackMapping energyValueStackMapping = new EnergyValueStackMapping().deserialize(jsonElement, typeOfT, context);
                if (energyValueStackMapping == null) continue;
                stackValueMap.put(energyValueStackMapping.wrappedStack, energyValueStackMapping.energyValue);
            }
            ImmutableSortedMap.Builder stackMappingsBuilder = ImmutableSortedMap.naturalOrder();
            stackMappingsBuilder.putAll(stackValueMap);
            this.stackMappings = stackMappingsBuilder.build();
            this.generateValueStackMappings();
        }
        return null;
    }

    public JsonElement serialize(EnergyValueRegistry energyValueRegistry, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray jsonEnergyValueRegistry = new JsonArray();
        for (WrappedStack wrappedStack : energyValueRegistry.stackMappings.keySet()) {
            jsonEnergyValueRegistry.add(EnergyValueStackMapping.jsonSerializer.toJsonTree((Object)new EnergyValueStackMapping(wrappedStack, (EnergyValue)energyValueRegistry.stackMappings.get((Object)wrappedStack))));
        }
        return jsonEnergyValueRegistry;
    }

    public void dumpEnergyValueRegistryToLog() {
        this.dumpEnergyValueRegistryToLog(EnergyValueRegistryProxy.Phase.ALL);
    }

    public void dumpEnergyValueRegistryToLog(EnergyValueRegistryProxy.Phase phase) {
        LogHelper.info(String.format("BEGIN DUMPING %s ENERGY VALUE MAPPINGS", new Object[]{phase}));
        if (phase == EnergyValueRegistryProxy.Phase.PRE_ASSIGNMENT) {
            for (WrappedStack wrappedStack : preAssignedMappings.keySet()) {
                LogHelper.info(String.format("- Object: %s, Value: %s", wrappedStack, EnergyValueRegistry.getInstance().getStackValueMap().get((Object)wrappedStack)));
            }
        } else if (phase == EnergyValueRegistryProxy.Phase.POST_ASSIGNMENT) {
            if (postAssignedMappings != null) {
                for (WrappedStack wrappedStack : postAssignedMappings.keySet()) {
                    LogHelper.info(String.format("- Object: %s, Value: %s", wrappedStack, EnergyValueRegistry.getInstance().getStackValueMap().get((Object)wrappedStack)));
                }
            }
        } else if (phase == EnergyValueRegistryProxy.Phase.ALL) {
            for (WrappedStack wrappedStack : EnergyValueRegistry.getInstance().getStackValueMap().keySet()) {
                LogHelper.info(String.format("- Object: %s, Value: %s", wrappedStack, EnergyValueRegistry.getInstance().getStackValueMap().get((Object)wrappedStack)));
            }
        }
        LogHelper.info(String.format("END DUMPING %s ENERGY VALUE MAPPINGS", new Object[]{phase}));
    }
}

