/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.item;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.pahimar.ee3.item.ItemToolModalEE;
import com.pahimar.ee3.reference.Key;
import com.pahimar.ee3.reference.Material;
import com.pahimar.ee3.reference.ToolMode;
import com.pahimar.ee3.util.CommonSoundHelper;
import com.pahimar.ee3.util.IChargeable;
import com.pahimar.ee3.util.IKeyBound;
import com.pahimar.ee3.util.NBTHelper;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class ItemDarkMatterShovel
extends ItemToolModalEE
implements IKeyBound,
IChargeable {
    private static final Set blocksEffectiveAgainst = Sets.newHashSet((Object[])new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh});

    public ItemDarkMatterShovel() {
        super(1.0f, Material.Tools.DARK_MATTER, blocksEffectiveAgainst);
        this.func_77655_b("shovelDarkMatter");
    }

    public boolean func_150897_b(Block block) {
        return block == Blocks.field_150431_aC || block == Blocks.field_150433_aE;
    }

    public Set<String> getToolClasses(ItemStack itemStack) {
        return ImmutableSet.of((Object)"shovel");
    }

    @Override
    public short getMaxChargeLevel() {
        return 3;
    }

    @Override
    public short getChargeLevel(ItemStack itemStack) {
        return NBTHelper.getShort(itemStack, "chargeLevel");
    }

    @Override
    public void setChargeLevel(ItemStack itemStack, short chargeLevel) {
        if (chargeLevel <= this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", chargeLevel);
        }
    }

    @Override
    public void increaseChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") < this.getMaxChargeLevel()) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(NBTHelper.getShort(itemStack, "chargeLevel") + 1));
        }
    }

    @Override
    public void decreaseChargeLevel(ItemStack itemStack) {
        if (NBTHelper.getShort(itemStack, "chargeLevel") > 0) {
            NBTHelper.setShort(itemStack, "chargeLevel", (short)(NBTHelper.getShort(itemStack, "chargeLevel") - 1));
        }
    }

    @Override
    public void doKeyBindingAction(EntityPlayer entityPlayer, ItemStack itemStack, Key key) {
        if (key == Key.CHARGE) {
            if (!entityPlayer.func_70093_af()) {
                if (this.getChargeLevel(itemStack) == this.getMaxChargeLevel()) {
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
                } else {
                    this.increaseChargeLevel(itemStack);
                    CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeUp", 0.5f, 0.5f + 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel()));
                }
            } else if (this.getChargeLevel(itemStack) == 0) {
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "fail", 1.5f, 1.5f);
            } else {
                this.decreaseChargeLevel(itemStack);
                CommonSoundHelper.playSoundAtPlayer(entityPlayer, "chargeDown", 0.5f, 1.0f - (0.5f - 0.5f * ((float)this.getChargeLevel(itemStack) * 1.0f / (float)this.getMaxChargeLevel())));
            }
        } else if (key == Key.EXTRA) {
            CommonSoundHelper.playSoundAtPlayer(entityPlayer, "tock", 0.5f, 1.5f);
            this.changeToolMode(itemStack);
        }
    }

    @Override
    public List<ToolMode> getAvailableToolModes() {
        return Arrays.asList(ToolMode.STANDARD);
    }
}

