/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.knowledge;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.pahimar.ee3.exchange.JsonItemStack;
import com.pahimar.ee3.knowledge.AbilityRegistry;
import com.pahimar.ee3.reference.Comparators;
import com.pahimar.ee3.util.FilterUtils;
import com.pahimar.ee3.util.INBTTaggable;
import com.pahimar.ee3.util.ItemHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TransmutationKnowledge
implements INBTTaggable,
JsonSerializer<TransmutationKnowledge>,
JsonDeserializer<TransmutationKnowledge> {
    private static final Gson jsonSerializer = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(TransmutationKnowledge.class, (Object)new TransmutationKnowledge()).create();
    private boolean canTransmuteEverything;
    private Set<ItemStack> knownTransmutations;
    private boolean hasBeenModified = false;

    public TransmutationKnowledge() {
        this(new TreeSet<ItemStack>(Comparators.idComparator));
    }

    public TransmutationKnowledge(Collection<ItemStack> knownTransmutations) {
        this(knownTransmutations, false);
    }

    public TransmutationKnowledge(Collection<ItemStack> knownTransmutations, boolean canTransmuteEverything) {
        this.canTransmuteEverything = canTransmuteEverything;
        this.knownTransmutations = new TreeSet<ItemStack>(Comparators.idComparator);
        this.knownTransmutations.addAll(knownTransmutations);
        this.hasBeenModified = false;
    }

    public TransmutationKnowledge(ItemStack ... knownTransmutations) {
        this(Arrays.asList(knownTransmutations));
    }

    public TransmutationKnowledge(NBTTagCompound nbtTagCompound) {
        this.canTransmuteEverything = false;
        this.knownTransmutations = new TreeSet<ItemStack>(Comparators.idComparator);
        this.readFromNBT(nbtTagCompound);
        this.hasBeenModified = false;
    }

    public boolean isKnown(ItemStack itemStack) {
        if (this.canTransmuteEverything) {
            return true;
        }
        ItemStack unitItemStack = itemStack.func_77946_l();
        unitItemStack.field_77994_a = 1;
        return this.knownTransmutations.contains(unitItemStack);
    }

    public boolean canTransmuteEverything() {
        return this.canTransmuteEverything;
    }

    public void setCanTransmuteEverything(boolean canTransmuteEverything) {
        this.canTransmuteEverything = canTransmuteEverything;
        this.hasBeenModified = true;
    }

    public Set<ItemStack> getKnownTransmutations() {
        if (this.canTransmuteEverything) {
            return AbilityRegistry.getInstance().getAllLearnableItemStacks();
        }
        return this.knownTransmutations;
    }

    public boolean learnTransmutation(ItemStack itemStack) {
        ItemStack unitItemStack = itemStack.func_77946_l();
        unitItemStack.field_77994_a = 1;
        if (!this.knownTransmutations.contains(unitItemStack)) {
            this.hasBeenModified = true;
            return this.knownTransmutations.add(unitItemStack);
        }
        return false;
    }

    public boolean forgetTransmutation(ItemStack itemStack) {
        ItemStack unitItemStack = itemStack.func_77946_l();
        unitItemStack.field_77994_a = 1;
        if (this.knownTransmutations.contains(unitItemStack)) {
            this.hasBeenModified = true;
            return this.knownTransmutations.remove(unitItemStack);
        }
        return false;
    }

    public void forgetAllTransmutations() {
        this.knownTransmutations.clear();
        this.canTransmuteEverything = false;
        this.hasBeenModified = true;
    }

    public boolean hasBeenModified() {
        return this.hasBeenModified;
    }

    public Set<ItemStack> filterByNameStartsWith(String filterString) {
        return FilterUtils.filterByNameStartsWith(this.getKnownTransmutations(), filterString);
    }

    public Set<ItemStack> filterByNameContains(String filterString) {
        return FilterUtils.filterByNameContains(this.getKnownTransmutations(), filterString);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("transmutationKnowledge")) {
            if (nbtTagCompound.func_74764_b("transmutationKnowledge")) {
                NBTTagList tagList = nbtTagCompound.func_150295_c("transmutationKnowledge", 10);
                this.knownTransmutations = new TreeSet<ItemStack>(Comparators.idComparator);
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tagCompound = tagList.func_150305_b(i);
                    ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
                    this.knownTransmutations.add(itemStack);
                }
            } else {
                this.knownTransmutations = new TreeSet<ItemStack>(Comparators.idComparator);
            }
            this.canTransmuteEverything = nbtTagCompound.func_74764_b("CAN_TRANSMUTE_ANYTHING") ? nbtTagCompound.func_74767_n("CAN_TRANSMUTE_ANYTHING") : false;
        } else {
            this.knownTransmutations = new TreeSet<ItemStack>(Comparators.idComparator);
            this.canTransmuteEverything = false;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList tagList = new NBTTagList();
        for (ItemStack itemStack : this.knownTransmutations) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            itemStack.func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        nbtTagCompound.func_74782_a("transmutationKnowledge", (NBTBase)tagList);
        nbtTagCompound.func_74757_a("CAN_TRANSMUTE_ANYTHING", this.canTransmuteEverything);
    }

    @Override
    public String getTagLabel() {
        return "TransmutationKnowledge";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (ItemStack itemStack : this.knownTransmutations) {
            stringBuilder.append(String.format("%s, ", ItemHelper.toString(itemStack)));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static TransmutationKnowledge createFromJson(String jsonTransmutationKnowledge) throws JsonParseException {
        try {
            return (TransmutationKnowledge)jsonSerializer.fromJson(jsonTransmutationKnowledge, TransmutationKnowledge.class);
        }
        catch (JsonSyntaxException exception) {
            exception.printStackTrace();
        }
        catch (JsonParseException exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public String toJson() {
        return jsonSerializer.toJson((Object)this);
    }

    public TransmutationKnowledge deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonObject()) {
            JsonObject jsonObject = (JsonObject)json;
            TreeSet<ItemStack> itemStacks = new TreeSet<ItemStack>(Comparators.idComparator);
            boolean canTransmuteEverything = jsonObject.has("canTransmuteEverything") && jsonObject.get("canTransmuteEverything").isJsonPrimitive() ? jsonObject.get("canTransmuteEverything").getAsBoolean() : false;
            if (jsonObject.has("knownTransmutations") && jsonObject.get("knownTransmutations").isJsonArray()) {
                JsonArray jsonArray = (JsonArray)jsonObject.get("knownTransmutations");
                for (JsonElement jsonElement : jsonArray) {
                    if (!jsonElement.isJsonObject()) continue;
                    try {
                        JsonItemStack jsonItemStack = (JsonItemStack)JsonItemStack.jsonSerializer.fromJson(jsonElement, JsonItemStack.class);
                        ItemStack itemStack = null;
                        Item item = (Item)Item.field_150901_e.func_82594_a(jsonItemStack.itemName);
                        if (item != null) {
                            itemStack = new ItemStack(item, 1, jsonItemStack.itemDamage);
                            if (jsonItemStack.itemNBTTagCompound != null) {
                                itemStack.field_77990_d = jsonItemStack.itemNBTTagCompound;
                            }
                        }
                        if (itemStack == null) continue;
                        itemStacks.add(itemStack);
                    }
                    catch (JsonParseException e) {}
                }
            }
            return new TransmutationKnowledge(itemStacks, canTransmuteEverything);
        }
        return null;
    }

    public JsonElement serialize(TransmutationKnowledge transmutationKnowledge, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonTransmutationKnowledge = new JsonObject();
        jsonTransmutationKnowledge.addProperty("canTransmuteEverything", Boolean.valueOf(transmutationKnowledge.canTransmuteEverything()));
        JsonArray knownTransmutations = new JsonArray();
        for (ItemStack itemStack : transmutationKnowledge.getKnownTransmutations()) {
            knownTransmutations.add(JsonItemStack.jsonSerializer.toJsonTree((Object)new JsonItemStack(itemStack)));
        }
        jsonTransmutationKnowledge.add("knownTransmutations", (JsonElement)knownTransmutations);
        return jsonTransmutationKnowledge;
    }

    public static void writeToFile(File file, TransmutationKnowledge transmutationKnowledge) {
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(file));
            jsonWriter.setIndent("    ");
            jsonSerializer.toJson((Object)transmutationKnowledge, TransmutationKnowledge.class, jsonWriter);
            jsonWriter.close();
            transmutationKnowledge.hasBeenModified = false;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static TransmutationKnowledge readFromFile(File file) {
        try {
            JsonReader jsonReader = new JsonReader((Reader)new FileReader(file));
            TransmutationKnowledge transmutationKnowledge = (TransmutationKnowledge)jsonSerializer.fromJson(jsonReader, TransmutationKnowledge.class);
            jsonReader.close();
            return transmutationKnowledge;
        }
        catch (FileNotFoundException ignored) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

