/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.network.message;

import com.google.gson.stream.JsonReader;
import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.EnergyValueStackMapping;
import com.pahimar.ee3.exchange.WrappedStack;
import com.pahimar.ee3.util.CompressionHelper;
import com.pahimar.ee3.util.LogHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.TreeMap;

public class MessageSyncEnergyValues
implements IMessage,
IMessageHandler<MessageSyncEnergyValues, IMessage> {
    public String jsonEnergyValueRegistry;

    public MessageSyncEnergyValues() {
    }

    public MessageSyncEnergyValues(EnergyValueRegistry energyValueRegistry) {
        this.jsonEnergyValueRegistry = energyValueRegistry.toJson();
    }

    public void fromBytes(ByteBuf buf) {
        byte[] compressedBytes = null;
        int readableBytes = buf.readInt();
        if (readableBytes > 0) {
            compressedBytes = buf.readBytes(readableBytes).array();
        }
        if (compressedBytes != null) {
            this.jsonEnergyValueRegistry = CompressionHelper.decompressStringFromByteArray(compressedBytes);
        }
    }

    public void toBytes(ByteBuf buf) {
        byte[] compressedBytes = null;
        if (this.jsonEnergyValueRegistry != null) {
            compressedBytes = CompressionHelper.compressStringToByteArray(this.jsonEnergyValueRegistry);
        }
        if (compressedBytes != null) {
            buf.writeInt(compressedBytes.length);
            buf.writeBytes(compressedBytes);
        } else {
            buf.writeInt(0);
        }
    }

    public IMessage onMessage(MessageSyncEnergyValues message, MessageContext ctx) {
        if (message.jsonEnergyValueRegistry != null) {
            TreeMap<WrappedStack, EnergyValue> energyValueStackMap = new TreeMap<WrappedStack, EnergyValue>();
            try {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(message.jsonEnergyValueRegistry));
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    EnergyValueStackMapping energyValueStackMapping = (EnergyValueStackMapping)EnergyValueStackMapping.jsonSerializer.fromJson(jsonReader, EnergyValueStackMapping.class);
                    if (energyValueStackMapping == null) continue;
                    energyValueStackMap.put(energyValueStackMapping.wrappedStack, energyValueStackMapping.energyValue);
                }
                jsonReader.endArray();
                jsonReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            EnergyValueRegistry.getInstance().loadFromMap(energyValueStackMap);
            LogHelper.info("Client successfully received EnergyValues from server");
        } else {
            LogHelper.info("Client failed to receive EnergyValues from server - falling back to local EnergyValues");
        }
        return null;
    }
}

