/*
 * Decompiled with CFR 0.152.
 */
package com.pahimar.ee3.util;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.exchange.EnergyValueRegistry;
import com.pahimar.ee3.exchange.OreStack;
import com.pahimar.ee3.exchange.WrappedStack;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.oredict.OreDictionary;

public class EnergyValueHelper {
    public static EnergyValue computeEnergyValueFromRecipe(Map<WrappedStack, EnergyValue> stackValueMappings, WrappedStack outputStack, List<WrappedStack> inputStacks) {
        float computedValue = 0.0f;
        for (WrappedStack wrappedStack : inputStacks) {
            EnergyValue wrappedStackValue;
            int stackSize = -1;
            if (wrappedStack.getWrappedObject() instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)wrappedStack.getWrappedObject();
                if (FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack) != null) {
                    if (itemStack.func_77973_b().getContainerItem(itemStack) != null) {
                        stackSize = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack).amount * wrappedStack.getStackSize();
                        wrappedStackValue = EnergyValueRegistry.getInstance().getEnergyValueFromMap(stackValueMappings, FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack));
                    } else {
                        wrappedStackValue = EnergyValueRegistry.getInstance().getEnergyValueFromMap(stackValueMappings, wrappedStack);
                    }
                } else if (itemStack.func_77973_b().getContainerItem(itemStack) != null) {
                    ItemStack containerItemStack = itemStack.func_77973_b().getContainerItem(itemStack);
                    if (EnergyValueRegistry.getInstance().hasEnergyValue(itemStack) && EnergyValueRegistry.getInstance().hasEnergyValue(containerItemStack)) {
                        float itemStackValue = EnergyValueRegistry.getInstance().getEnergyValueFromMap(stackValueMappings, itemStack).getValue();
                        float containerStackValue = EnergyValueRegistry.getInstance().getEnergyValueFromMap(stackValueMappings, containerItemStack).getValue();
                        wrappedStackValue = new EnergyValue(itemStackValue - containerStackValue);
                    } else {
                        wrappedStackValue = new EnergyValue(0.0f);
                    }
                } else {
                    wrappedStackValue = !itemStack.func_77973_b().func_77630_h(itemStack) ? new EnergyValue(0.0f) : (OreDictionary.getOreIDs((ItemStack)itemStack).length > 0 ? EnergyValueRegistry.getInstance().getEnergyValueFromMap(stackValueMappings, wrappedStack, true) : EnergyValueRegistry.getInstance().getEnergyValueFromMap(stackValueMappings, wrappedStack));
                }
            } else if (wrappedStack.getWrappedObject() instanceof OreStack) {
                OreStack oreStack = (OreStack)wrappedStack.getWrappedObject();
                wrappedStackValue = EnergyValueRegistry.getInstance().getEnergyValueFromMap(stackValueMappings, wrappedStack);
                for (ItemStack itemStack : OreDictionary.getOres((String)oreStack.oreName)) {
                    if (itemStack.func_77973_b().func_77630_h(itemStack)) continue;
                    wrappedStackValue = new EnergyValue(0.0f);
                }
            } else {
                wrappedStackValue = EnergyValueRegistry.getInstance().getEnergyValueFromMap(stackValueMappings, wrappedStack);
            }
            if (wrappedStackValue != null) {
                if (stackSize == -1) {
                    stackSize = wrappedStack.getStackSize();
                }
                computedValue += wrappedStackValue.getValue() * (float)stackSize;
                continue;
            }
            return null;
        }
        return EnergyValueHelper.factorEnergyValue(new EnergyValue(computedValue), outputStack.getStackSize());
    }

    public static EnergyValue factorEnergyValue(EnergyValue energyValue, int factor) {
        return EnergyValueHelper.factorEnergyValue(energyValue, (float)factor);
    }

    public static EnergyValue factorEnergyValue(EnergyValue energyValue, float factor) {
        if (Float.compare(factor, 0.0f) != 0 && energyValue != null) {
            return new EnergyValue(new BigDecimal(energyValue.getValue() * 1.0f / factor).setScale(3, 6).floatValue());
        }
        return null;
    }
}

