/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs.consumers;

import cofh.api.energy.IEnergyReceiver;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Pollution;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class NodeEnergyReceiver
extends ConsumerNode {
    int mRestRF = 0;

    public NodeEnergyReceiver(int aNodeValue, IEnergyReceiver aTileEntity, byte aSide, ArrayList<ConsumerNode> aConsumers) {
        super(aNodeValue, (TileEntity)aTileEntity, aSide, aConsumers);
    }

    @Override
    public int injectEnergy(int aVoltage, int aMaxAmps) {
        ForgeDirection tDirection = ForgeDirection.getOrientation((int)this.mSide);
        int rfOut = GT_Utility.safeInt(aVoltage * GregTech_API.mEUtoRF / 100);
        int ampsUsed = 0;
        if (this.mRestRF < rfOut) {
            this.mRestRF += rfOut;
            ampsUsed = 1;
        }
        if (((IEnergyReceiver)this.mTileEntity).receiveEnergy(tDirection, this.mRestRF, true) > 0) {
            int consumed = ((IEnergyReceiver)this.mTileEntity).receiveEnergy(tDirection, this.mRestRF, false);
            this.mRestRF -= consumed;
            return ampsUsed;
        }
        if (GregTech_API.mRFExplosions && GregTech_API.sMachineExplosions && (long)((IEnergyReceiver)this.mTileEntity).getMaxEnergyStored(tDirection) < (long)rfOut * 600L) {
            this.explode(rfOut);
        }
        return 0;
    }

    private void explode(int aRfOut) {
        if ((long)aRfOut > 32L * (long)GregTech_API.mEUtoRF / 100L) {
            int aExplosionPower = aRfOut;
            float tStrength = (long)aExplosionPower < GT_Values.V[0] ? 1.0f : ((long)aExplosionPower < GT_Values.V[1] ? 2.0f : ((long)aExplosionPower < GT_Values.V[2] ? 3.0f : ((long)aExplosionPower < GT_Values.V[3] ? 4.0f : ((long)aExplosionPower < GT_Values.V[4] ? 5.0f : ((long)aExplosionPower < GT_Values.V[4] * 2L ? 6.0f : ((long)aExplosionPower < GT_Values.V[5] ? 7.0f : ((long)aExplosionPower < GT_Values.V[6] ? 8.0f : ((long)aExplosionPower < GT_Values.V[7] ? 9.0f : ((long)aExplosionPower < GT_Values.V[8] ? 10.0f : ((long)aExplosionPower < GT_Values.V[8] * 2L ? 11.0f : ((long)aExplosionPower < GT_Values.V[9] ? 12.0f : ((long)aExplosionPower < GT_Values.V[10] ? 13.0f : ((long)aExplosionPower < GT_Values.V[11] ? 14.0f : ((long)aExplosionPower < GT_Values.V[12] ? 15.0f : ((long)aExplosionPower < GT_Values.V[12] * 2L ? 16.0f : ((long)aExplosionPower < GT_Values.V[13] ? 17.0f : ((long)aExplosionPower < GT_Values.V[14] ? 18.0f : ((long)aExplosionPower < GT_Values.V[15] ? 19.0f : 20.0f))))))))))))))))));
            int tX = this.mTileEntity.field_145851_c;
            int tY = this.mTileEntity.field_145848_d;
            int tZ = this.mTileEntity.field_145849_e;
            World tWorld = this.mTileEntity.func_145831_w();
            GT_Utility.sendSoundToPlayers(tWorld, GregTech_API.sSoundList.get(209), 1.0f, -1.0f, tX, tY, tZ);
            tWorld.func_147449_b(tX, tY, tZ, Blocks.field_150350_a);
            if (GregTech_API.sMachineExplosions && GT_Mod.gregtechproxy.mPollution) {
                GT_Pollution.addPollution(tWorld.func_72938_d(tX, tZ), 100000);
            }
            new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setStrength(tStrength).setSmoking(true).setPosition((double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5).setWorld(tWorld).run();
        }
    }
}

