/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IPipeRenderedTileEntity;
import gregtech.api.interfaces.tileentity.ITexturedTileEntity;
import gregtech.common.blocks.GT_Block_Machines;
import gregtech.common.blocks.GT_Block_Ores_Abstract;
import gregtech.common.blocks.GT_TileEntity_Ores;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GT_Renderer_Block
implements ISimpleBlockRenderingHandler {
    public static final float blockMin = 0.0f;
    public static final float blockMax = 1.0f;
    private static final float coverThickness = 0.125f;
    private static final float coverInnerMin = 0.125f;
    private static final float coverInnerMax = 0.875f;
    public static GT_Renderer_Block INSTANCE;
    public final int mRenderID = RenderingRegistry.getNextAvailableRenderId();

    public GT_Renderer_Block() {
        INSTANCE = this;
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)this);
    }

    public static boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IPipeRenderedTileEntity) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, new ITexture[][]{((IPipeRenderedTileEntity)tTileEntity).getTextureCovered((byte)ForgeDirection.DOWN.ordinal()), ((IPipeRenderedTileEntity)tTileEntity).getTextureCovered((byte)ForgeDirection.UP.ordinal()), ((IPipeRenderedTileEntity)tTileEntity).getTextureCovered((byte)ForgeDirection.NORTH.ordinal()), ((IPipeRenderedTileEntity)tTileEntity).getTextureCovered((byte)ForgeDirection.SOUTH.ordinal()), ((IPipeRenderedTileEntity)tTileEntity).getTextureCovered((byte)ForgeDirection.WEST.ordinal()), ((IPipeRenderedTileEntity)tTileEntity).getTextureCovered((byte)ForgeDirection.EAST.ordinal())});
        }
        if (tTileEntity instanceof ITexturedTileEntity) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer, new ITexture[][]{((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)ForgeDirection.DOWN.ordinal()), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)ForgeDirection.UP.ordinal()), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)ForgeDirection.NORTH.ordinal()), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)ForgeDirection.SOUTH.ordinal()), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)ForgeDirection.WEST.ordinal()), ((ITexturedTileEntity)tTileEntity).getTexture(aBlock, (byte)ForgeDirection.EAST.ordinal())});
        }
        return false;
    }

    public static boolean renderStandardBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, RenderBlocks aRenderer, ITexture[][] aTextures) {
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.DOWN.ordinal()], true);
        GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.UP.ordinal()], true);
        GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.NORTH.ordinal()], true);
        GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.SOUTH.ordinal()], true);
        GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.WEST.ordinal()], true);
        GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, aTextures[ForgeDirection.EAST.ordinal()], true);
        return true;
    }

    public static boolean renderPipeBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, IPipeRenderedTileEntity aTileEntity, RenderBlocks aRenderer) {
        byte aConnections = aTileEntity.getConnections();
        if ((aConnections & 0xC0) != 0) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        float thickness = aTileEntity.getThickNess();
        if (thickness >= 0.99f) {
            return GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer);
        }
        float pipeMin = (1.0f - thickness) / 2.0f;
        float pipeMax = 1.0f - pipeMin;
        boolean[] tIsCovered = new boolean[ForgeDirection.VALID_DIRECTIONS.length];
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            tIsCovered[i] = aTileEntity.getCoverIDAtSide((byte)i) != 0;
        }
        ITexture[][] tIcons = new ITexture[ForgeDirection.VALID_DIRECTIONS.length][];
        ITexture[][] tCovers = new ITexture[ForgeDirection.VALID_DIRECTIONS.length][];
        for (int i = 0; i < ForgeDirection.VALID_DIRECTIONS.length; ++i) {
            tCovers[i] = aTileEntity.getTexture(aBlock, (byte)i);
            tIcons[i] = aTileEntity.getTextureUncovered((byte)i);
        }
        switch (aConnections) {
            case 0: {
                aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                break;
            }
            case 48: {
                aBlock.func_149676_a(0.0f, pipeMin, pipeMin, 1.0f, pipeMax, pipeMax);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                break;
            }
            case 3: {
                aBlock.func_149676_a(pipeMin, 0.0f, pipeMin, pipeMax, 1.0f, pipeMax);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                break;
            }
            case 12: {
                aBlock.func_149676_a(pipeMin, pipeMin, 0.0f, pipeMax, pipeMax, 1.0f);
                aRenderer.func_147775_a(aBlock);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
                break;
            }
            default: {
                if ((aConnections & 0x10) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(0.0f, pipeMin, pipeMin, pipeMin, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                    GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                    GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                    GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                    GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
                }
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                if ((aConnections & 0x20) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMax, pipeMin, pipeMin, 1.0f, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                    GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                    GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                    GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                    GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
                }
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                if ((aConnections & 1) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMin, 0.0f, pipeMin, pipeMax, pipeMin, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                    GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                    GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
                    GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                    GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                }
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                if ((aConnections & 2) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMin, pipeMax, pipeMin, pipeMax, 1.0f, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                    GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                    GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
                    GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                    GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                }
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                if ((aConnections & 4) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMin, pipeMin, 0.0f, pipeMax, pipeMax, pipeMin);
                    aRenderer.func_147775_a(aBlock);
                    GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                    GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                    GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                    GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                }
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.NORTH.ordinal()], false);
                if ((aConnections & 8) == 0) {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMin, pipeMax, pipeMax, pipeMax);
                    aRenderer.func_147775_a(aBlock);
                } else {
                    aBlock.func_149676_a(pipeMin, pipeMin, pipeMax, pipeMax, pipeMax, 1.0f);
                    aRenderer.func_147775_a(aBlock);
                    GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.DOWN.ordinal()], false);
                    GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.UP.ordinal()], false);
                    GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.WEST.ordinal()], false);
                    GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.EAST.ordinal()], false);
                }
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tIcons[ForgeDirection.SOUTH.ordinal()], false);
            }
        }
        if (tIsCovered[ForgeDirection.DOWN.ordinal()]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[ForgeDirection.NORTH.ordinal()]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.SOUTH.ordinal()]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.WEST.ordinal()]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.EAST.ordinal()]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
            }
            GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
            if ((aConnections & 1) != 0) {
                aRenderer.func_147782_a(0.0, 0.0, 0.0, 1.0, 0.0, (double)pipeMin);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
                aRenderer.func_147782_a(0.0, 0.0, (double)pipeMax, 1.0, 0.0, 1.0);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
                aRenderer.func_147782_a(0.0, 0.0, (double)pipeMin, (double)pipeMin, 0.0, (double)pipeMax);
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
                aRenderer.func_147782_a((double)pipeMax, 0.0, (double)pipeMin, 1.0, 0.0, (double)pipeMax);
            }
            GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.DOWN.ordinal()], false);
        }
        if (tIsCovered[ForgeDirection.UP.ordinal()]) {
            aBlock.func_149676_a(0.0f, 0.875f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[ForgeDirection.NORTH.ordinal()]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.SOUTH.ordinal()]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.WEST.ordinal()]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.EAST.ordinal()]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
            }
            GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
            if ((aConnections & 2) != 0) {
                aRenderer.func_147782_a(0.0, 1.0, 0.0, 1.0, 1.0, (double)pipeMin);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
                aRenderer.func_147782_a(0.0, 1.0, (double)pipeMax, 1.0, 1.0, 1.0);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
                aRenderer.func_147782_a(0.0, 1.0, (double)pipeMin, (double)pipeMin, 1.0, (double)pipeMax);
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
                aRenderer.func_147782_a((double)pipeMax, 1.0, (double)pipeMin, 1.0, 1.0, (double)pipeMax);
            }
            GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.UP.ordinal()], false);
        }
        if (tIsCovered[ForgeDirection.NORTH.ordinal()]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.125f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[ForgeDirection.DOWN.ordinal()]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.UP.ordinal()]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.WEST.ordinal()]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.EAST.ordinal()]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
            }
            GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
            if ((aConnections & 4) != 0) {
                aRenderer.func_147782_a(0.0, 0.0, 0.0, 1.0, (double)pipeMin, 0.0);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
                aRenderer.func_147782_a(0.0, (double)pipeMax, 0.0, 1.0, 1.0, 0.0);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
                aRenderer.func_147782_a(0.0, (double)pipeMin, 0.0, (double)pipeMin, (double)pipeMax, 0.0);
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
                aRenderer.func_147782_a((double)pipeMax, (double)pipeMin, 0.0, 1.0, (double)pipeMax, 0.0);
            }
            GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.NORTH.ordinal()], false);
        }
        if (tIsCovered[ForgeDirection.SOUTH.ordinal()]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.875f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[ForgeDirection.DOWN.ordinal()]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.UP.ordinal()]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.WEST.ordinal()]) {
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.EAST.ordinal()]) {
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
            }
            GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
            if ((aConnections & 8) != 0) {
                aRenderer.func_147782_a(0.0, 0.0, 1.0, 1.0, (double)pipeMin, 1.0);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
                aRenderer.func_147782_a(0.0, (double)pipeMax, 1.0, 1.0, 1.0, 1.0);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
                aRenderer.func_147782_a(0.0, (double)pipeMin, 1.0, (double)pipeMin, (double)pipeMax, 1.0);
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
                aRenderer.func_147782_a((double)pipeMax, (double)pipeMin, 1.0, 1.0, (double)pipeMax, 1.0);
            }
            GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.SOUTH.ordinal()], false);
        }
        if (tIsCovered[ForgeDirection.WEST.ordinal()]) {
            aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 0.125f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[ForgeDirection.DOWN.ordinal()]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.UP.ordinal()]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.NORTH.ordinal()]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.SOUTH.ordinal()]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
            }
            GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
            if ((aConnections & 0x10) != 0) {
                aRenderer.func_147782_a(0.0, 0.0, 0.0, 0.0, (double)pipeMin, 1.0);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
                aRenderer.func_147782_a(0.0, (double)pipeMax, 0.0, 0.0, 1.0, 1.0);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
                aRenderer.func_147782_a(0.0, (double)pipeMin, 0.0, 0.0, (double)pipeMax, (double)pipeMin);
                GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
                aRenderer.func_147782_a(0.0, (double)pipeMin, (double)pipeMax, 0.0, (double)pipeMax, 1.0);
            }
            GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.WEST.ordinal()], false);
        }
        if (tIsCovered[ForgeDirection.EAST.ordinal()]) {
            aBlock.func_149676_a(0.875f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            aRenderer.func_147775_a(aBlock);
            if (!tIsCovered[ForgeDirection.DOWN.ordinal()]) {
                GT_Renderer_Block.renderNegativeYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.UP.ordinal()]) {
                GT_Renderer_Block.renderPositiveYFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.NORTH.ordinal()]) {
                GT_Renderer_Block.renderNegativeZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
            }
            if (!tIsCovered[ForgeDirection.SOUTH.ordinal()]) {
                GT_Renderer_Block.renderPositiveZFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
            }
            GT_Renderer_Block.renderNegativeXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
            if ((aConnections & 0x20) != 0) {
                aRenderer.func_147782_a(1.0, 0.0, 0.0, 1.0, (double)pipeMin, 1.0);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
                aRenderer.func_147782_a(1.0, (double)pipeMax, 0.0, 1.0, 1.0, 1.0);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
                aRenderer.func_147782_a(1.0, (double)pipeMin, 0.0, 1.0, (double)pipeMax, (double)pipeMin);
                GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
                aRenderer.func_147782_a(1.0, (double)pipeMin, (double)pipeMax, 1.0, (double)pipeMax, 1.0);
            }
            GT_Renderer_Block.renderPositiveXFacing(aWorld, aRenderer, aBlock, aX, aY, aZ, tCovers[ForgeDirection.EAST.ordinal()], false);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        return true;
    }

    public void renderInventoryBlock(Block aBlock, int aMeta, int aModelID, RenderBlocks aRenderer) {
        aRenderer.field_147863_w = false;
        aRenderer.field_147844_c = true;
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (aBlock instanceof GT_Block_Ores_Abstract) {
            GT_TileEntity_Ores tTileEntity = new GT_TileEntity_Ores();
            tTileEntity.mMetaData = (short)aMeta;
            aBlock.func_149683_g();
            aRenderer.func_147775_a(aBlock);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            GT_Renderer_Block.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)ForgeDirection.DOWN.ordinal()), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            GT_Renderer_Block.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)ForgeDirection.UP.ordinal()), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            GT_Renderer_Block.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)ForgeDirection.NORTH.ordinal()), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            GT_Renderer_Block.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)ForgeDirection.SOUTH.ordinal()), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)ForgeDirection.WEST.ordinal()), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, tTileEntity.getTexture(aBlock, (byte)ForgeDirection.EAST.ordinal()), true);
            Tessellator.field_78398_a.func_78381_a();
        } else if (aMeta > 0 && aMeta < GregTech_API.METATILEENTITIES.length && aBlock instanceof GT_Block_Machines && GregTech_API.METATILEENTITIES[aMeta] != null && !GregTech_API.METATILEENTITIES[aMeta].renderInInventory(aBlock, aMeta, aRenderer)) {
            GT_Renderer_Block.renderNormalInventoryMetaTileEntity(aBlock, aMeta, aRenderer);
        }
        aBlock.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        aRenderer.func_147775_a(aBlock);
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        aRenderer.field_147844_c = false;
    }

    private static void renderNormalInventoryMetaTileEntity(Block aBlock, int aMeta, RenderBlocks aRenderer) {
        if (aMeta <= 0 || aMeta >= GregTech_API.METATILEENTITIES.length) {
            return;
        }
        IMetaTileEntity tMetaTileEntity = GregTech_API.METATILEENTITIES[aMeta];
        if (tMetaTileEntity == null) {
            return;
        }
        aBlock.func_149683_g();
        aRenderer.func_147775_a(aBlock);
        IGregTechTileEntity iGregTechTileEntity = tMetaTileEntity.getBaseMetaTileEntity();
        if (iGregTechTileEntity instanceof IPipeRenderedTileEntity) {
            float tThickness = ((IPipeRenderedTileEntity)((Object)iGregTechTileEntity)).getThickNess();
            float pipeMin = (1.0f - tThickness) / 2.0f;
            float pipeMax = 1.0f - pipeMin;
            aBlock.func_149676_a(0.0f, pipeMin, pipeMin, 1.0f, pipeMax, pipeMax);
            aRenderer.func_147775_a(aBlock);
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            GT_Renderer_Block.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.DOWN.ordinal(), (byte)48, (byte)-1, false, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            GT_Renderer_Block.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.UP.ordinal(), (byte)48, (byte)-1, false, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            GT_Renderer_Block.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.NORTH.ordinal(), (byte)48, (byte)-1, false, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            GT_Renderer_Block.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.SOUTH.ordinal(), (byte)48, (byte)-1, false, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.WEST.ordinal(), (byte)48, (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.EAST.ordinal(), (byte)48, (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
        } else {
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
            GT_Renderer_Block.renderNegativeYFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.DOWN.ordinal(), (byte)ForgeDirection.WEST.ordinal(), (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
            GT_Renderer_Block.renderPositiveYFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.UP.ordinal(), (byte)ForgeDirection.WEST.ordinal(), (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
            GT_Renderer_Block.renderNegativeZFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.NORTH.ordinal(), (byte)ForgeDirection.WEST.ordinal(), (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
            GT_Renderer_Block.renderPositiveZFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.SOUTH.ordinal(), (byte)ForgeDirection.WEST.ordinal(), (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderNegativeXFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.WEST.ordinal(), (byte)ForgeDirection.WEST.ordinal(), (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
            Tessellator.field_78398_a.func_78382_b();
            Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
            GT_Renderer_Block.renderPositiveXFacing(null, aRenderer, aBlock, 0, 0, 0, tMetaTileEntity.getTexture(iGregTechTileEntity, (byte)ForgeDirection.EAST.ordinal(), (byte)ForgeDirection.WEST.ordinal(), (byte)-1, true, false), true);
            Tessellator.field_78398_a.func_78381_a();
        }
    }

    public static void renderNegativeYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY - 1, aZ, 0)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY - 1 : aY, aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderYNeg(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderPositiveYFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY + 1, aZ, 1)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aFullBlock ? aY + 1 : aY, aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderYPos(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderNegativeZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY, aZ - 1, 2)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ - 1 : aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderZNeg(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderPositiveZFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX, aY, aZ + 1, 3)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aX, aY, aFullBlock ? aZ + 1 : aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderZPos(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderNegativeXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX - 1, aY, aZ, 4)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX - 1 : aX, aY, aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderXNeg(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public static void renderPositiveXFacing(IBlockAccess aWorld, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, ITexture[] aIcon, boolean aFullBlock) {
        if (aWorld != null) {
            if (aFullBlock && !aBlock.func_149646_a(aWorld, aX + 1, aY, aZ, 5)) {
                return;
            }
            Tessellator.field_78398_a.func_78380_c(aBlock.func_149677_c(aWorld, aFullBlock ? aX + 1 : aX, aY, aZ));
        }
        if (aIcon == null) {
            return;
        }
        for (ITexture iTexture : aIcon) {
            if (iTexture == null) continue;
            iTexture.renderXPos(aRenderer, aBlock, aX, aY, aZ);
        }
    }

    public boolean renderWorldBlock(IBlockAccess aWorld, int aX, int aY, int aZ, Block aBlock, int aModelID, RenderBlocks aRenderer) {
        IMetaTileEntity metaTileEntity;
        aRenderer.field_147863_w = Minecraft.func_71379_u() && GT_Mod.gregtechproxy.mRenderTileAmbientOcclusion;
        aRenderer.field_147844_c = false;
        TileEntity tileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof IGregTechTileEntity && (metaTileEntity = ((IGregTechTileEntity)tileEntity).getMetaTileEntity()) != null && metaTileEntity.renderInWorld(aWorld, aX, aY, aZ, aBlock, aRenderer)) {
            aRenderer.field_147863_w = false;
            return true;
        }
        if (tileEntity instanceof IPipeRenderedTileEntity && GT_Renderer_Block.renderPipeBlock(aWorld, aX, aY, aZ, aBlock, (IPipeRenderedTileEntity)tileEntity, aRenderer)) {
            aRenderer.field_147863_w = false;
            return true;
        }
        if (GT_Renderer_Block.renderStandardBlock(aWorld, aX, aY, aZ, aBlock, aRenderer)) {
            aRenderer.field_147863_w = false;
            return true;
        }
        return false;
    }

    public boolean shouldRender3DInInventory(int aModel) {
        return true;
    }

    public int getRenderId() {
        return this.mRenderID;
    }
}

