/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.widgets.GT_GuiIcon;
import gregtech.api.interfaces.IGuiScreen;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GT_GuiFakeItemButton
implements IGuiScreen.IGuiElement {
    private final GT_GuiIcon bgIcon;
    private ItemStack item;
    private IGuiScreen gui;
    private int x0;
    private int y0;
    private int xPosition;
    private int yPosition;
    private int width;
    private int height;

    public GT_GuiFakeItemButton(IGuiScreen gui, int x, int y, GT_GuiIcon bgIcon) {
        this.gui = gui;
        this.x0 = x;
        this.y0 = y;
        this.bgIcon = bgIcon;
        this.item = null;
        this.width = 18;
        this.height = 18;
        gui.addElement(this);
    }

    public GT_GuiFakeItemButton setItem(ItemStack i) {
        this.item = i;
        return this;
    }

    public ItemStack getItem() {
        return this.item;
    }

    @Override
    public void onInit() {
        this.xPosition = this.x0 + this.gui.getGuiLeft();
        this.yPosition = this.y0 + this.gui.getGuiTop();
    }

    @Override
    public void draw(int mouseX, int mouseY, float parTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.bgIcon != null) {
            GT_GuiIcon.render(this.bgIcon, this.xPosition - 1, this.yPosition - 1, 18.0, 18.0, 0.0, true);
        }
        if (this.item != null) {
            this.gui.getItemRenderer().renderItemAndEffectIntoGUI(this.gui.getFontRenderer(), Minecraft.getMinecraft().getTextureManager(), this.item, this.xPosition, this.yPosition);
        }
        GL11.glPopAttrib();
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x0, this.y0, this.width, this.height);
    }
}

