/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.graphs.Node;
import gregtech.api.graphs.paths.NodePath;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IPipeRenderedTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.MetaPipeEntity;
import gregtech.api.net.GT_Packet_TileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import gregtech.common.covers.GT_Cover_Fluidfilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class BaseMetaPipeEntity
extends BaseTileEntity
implements IGregTechTileEntity,
IPipeRenderedTileEntity {
    private final GT_CoverBehavior[] mCoverBehaviors = new GT_CoverBehavior[]{GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior};
    public byte mConnections = 0;
    protected MetaPipeEntity mMetaTileEntity;
    private byte[] mSidedRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    private int[] mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
    private int[] mCoverData = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] mTimeStatistics = new int[GregTech_API.TICKS_FOR_LAG_AVERAGING];
    private boolean mInventoryChanged = false;
    private boolean mWorkUpdate = false;
    private boolean mWorks = true;
    private boolean mNeedsUpdate = true;
    private boolean mNeedsBlockUpdate = true;
    private boolean mSendClientData = false;
    private final boolean mCheckConnections = false;
    private byte mColor = 0;
    private byte oColor = 0;
    private byte mStrongRedstone = 0;
    private byte oStrongRedstone = 0;
    private byte oRedstoneData = (byte)63;
    private byte oTextureData = 0;
    private byte oUpdateData = 0;
    private byte mLagWarningCount = 0;
    private int oX = 0;
    private int oY = 0;
    private int oZ = 0;
    private int mTimeStatisticsIndex = 0;
    private short mID = 0;
    private long mTickTimer = 0L;
    protected Node node;
    protected NodePath nodePath;

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public NodePath getNodePath() {
        return this.nodePath;
    }

    public void setNodePath(NodePath nodePath) {
        this.nodePath = nodePath;
    }

    @Override
    public void writeToNBT(NBTTagCompound aNBT) {
        try {
            super.writeToNBT(aNBT);
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        try {
            aNBT.setInteger("mID", (int)this.mID);
            aNBT.setIntArray("mCoverData", this.mCoverData);
            aNBT.setIntArray("mCoverSides", this.mCoverSides);
            aNBT.setByteArray("mRedstoneSided", this.mSidedRedstone);
            aNBT.setByte("mConnections", this.mConnections);
            aNBT.setByte("mColor", this.mColor);
            aNBT.setByte("mStrongRedstone", this.mStrongRedstone);
            aNBT.setBoolean("mWorks", !this.mWorks);
            for (int i = 0; i < this.mCoverData.length; ++i) {
                int fluidId;
                Fluid fluid;
                if (!(GregTech_API.getCoverBehavior(this.mCoverSides[i]) instanceof GT_Cover_Fluidfilter) || (fluid = FluidRegistry.getFluid((int)(fluidId = this.mCoverData[i] >>> 3))) == null) continue;
                String fluidName = FluidRegistry.getFluidName((Fluid)fluid);
                aNBT.setString(String.format("fluidFilter%d", i), fluidName);
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        try {
            if (this.hasValidMetaTileEntity()) {
                NBTTagList tItemList = new NBTTagList();
                for (int i = 0; i < this.mMetaTileEntity.getRealInventory().length; ++i) {
                    ItemStack tStack = this.mMetaTileEntity.getRealInventory()[i];
                    if (tStack == null) continue;
                    NBTTagCompound tTag = new NBTTagCompound();
                    tTag.setInteger("IntSlot", i);
                    tStack.writeToNBT(tTag);
                    tItemList.appendTag((NBTBase)tTag);
                }
                aNBT.setTag("Inventory", (NBTBase)tItemList);
                try {
                    this.mMetaTileEntity.saveNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
                    e.printStackTrace(GT_Log.err);
                }
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound aNBT) {
        super.readFromNBT(aNBT);
        this.setInitialValuesAsNBT(aNBT, (short)0);
    }

    @Override
    public void setInitialValuesAsNBT(NBTTagCompound aNBT, short aID) {
        byte i;
        if (aNBT == null) {
            if (aID > 0) {
                this.mID = aID;
            } else {
                short s = this.mID = this.mID > 0 ? this.mID : (short)0;
            }
            if (this.mID != 0) {
                this.createNewMetatileEntity(this.mID);
            }
        } else {
            this.mID = aID <= 0 ? (short)aNBT.getInteger("mID") : aID;
            this.mCoverSides = aNBT.getIntArray("mCoverSides");
            this.mCoverData = aNBT.getIntArray("mCoverData");
            this.mSidedRedstone = aNBT.getByteArray("mRedstoneSided");
            this.mConnections = aNBT.getByte("mConnections");
            this.mColor = aNBT.getByte("mColor");
            this.mStrongRedstone = aNBT.getByte("mStrongRedstone");
            boolean bl = this.mWorks = !aNBT.getBoolean("mWorks");
            if (this.mCoverData.length != 6) {
                this.mCoverData = new int[]{0, 0, 0, 0, 0, 0};
            }
            if (this.mCoverSides.length != 6) {
                this.mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
            }
            if (this.mSidedRedstone.length != 6) {
                this.mSidedRedstone = new byte[]{0, 0, 0, 0, 0, 0};
            }
            for (i = 0; i < 6; i = (byte)((byte)(i + 1))) {
                String filterKey;
                this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
                if (!(this.mCoverBehaviors[i] instanceof GT_Cover_Fluidfilter) || !aNBT.hasKey(filterKey = String.format("fluidFilter%d", i))) continue;
                this.mCoverData[i] = this.mCoverData[i] & 7 | FluidRegistry.getFluidID((String)aNBT.getString(filterKey)) << 3;
            }
            if (this.mID != 0 && this.createNewMetatileEntity(this.mID)) {
                NBTTagList tItemList = aNBT.getTagList("Inventory", 10);
                for (int i2 = 0; i2 < tItemList.tagCount(); ++i2) {
                    NBTTagCompound tTag = tItemList.getCompoundTagAt(i2);
                    int tSlot = tTag.getInteger("IntSlot");
                    if (tSlot < 0 || tSlot >= this.mMetaTileEntity.getRealInventory().length) continue;
                    this.mMetaTileEntity.getRealInventory()[tSlot] = GT_Utility.loadItem(tTag);
                }
                try {
                    this.mMetaTileEntity.loadNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Log.err.println("Encountered Exception while loading MetaTileEntity, the Server should've crashed now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
                    e.printStackTrace(GT_Log.err);
                }
            }
        }
        if (this.mCoverData.length != 6) {
            this.mCoverData = new int[]{0, 0, 0, 0, 0, 0};
        }
        if (this.mCoverSides.length != 6) {
            this.mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
        }
        if (this.mSidedRedstone.length != 6) {
            this.mSidedRedstone = new byte[]{0, 0, 0, 0, 0, 0};
        }
        for (i = 0; i < 6; i = (byte)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
        }
    }

    private boolean createNewMetatileEntity(short aID) {
        if (aID > 0 && aID < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[aID] != null) {
            if (this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.setBaseMetaTileEntity(null);
            }
            GregTech_API.METATILEENTITIES[aID].newMetaEntity(this).setBaseMetaTileEntity(this);
            this.mTickTimer = 0L;
            this.mID = aID;
            return true;
        }
        GT_Log.err.println("MetaID " + aID + " not loadable => locking TileEntity!");
        return false;
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.hasValidMetaTileEntity()) {
            if (this.mMetaTileEntity == null) {
                return;
            }
            this.mMetaTileEntity.setBaseMetaTileEntity(this);
        }
        long tTime = System.nanoTime();
        int tCode = 0;
        try {
            tCode = 0;
            while (this.hasValidMetaTileEntity() && tCode >= 0) {
                switch (tCode) {
                    case 0: {
                        byte i;
                        ++tCode;
                        if (this.mTickTimer++ == 0L) {
                            this.oX = this.xCoord;
                            this.oY = this.yCoord;
                            this.oZ = this.zCoord;
                            if (this.isServerSide()) {
                                for (i = 0; i < 6; i = (byte)(i + 1)) {
                                    if (this.getCoverIDAtSide(i) == 0 || this.mMetaTileEntity.allowCoverOnSide(i, new GT_ItemStack(this.getCoverIDAtSide(i)))) continue;
                                    this.dropCover(i, i, true);
                                }
                            }
                            this.worldObj.markTileEntityChunkModified(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
                            this.mMetaTileEntity.onFirstTick(this);
                            if (!this.hasValidMetaTileEntity()) {
                                return;
                            }
                        }
                    }
                    case 1: {
                        ++tCode;
                        if (this.isClientSide()) {
                            if (this.mColor != this.oColor) {
                                this.oColor = this.mColor;
                                this.mMetaTileEntity.onColorChangeClient(this.oColor);
                                this.issueTextureUpdate();
                            }
                            if (this.mNeedsUpdate) {
                                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                                this.mNeedsUpdate = false;
                            }
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        byte i;
                        if (this.isServerSide() && this.mTickTimer > 10L) {
                            for (i = (byte)(tCode - 2); i < 6; i = (byte)(i + 1)) {
                                if (this.getCoverIDAtSide(i) == 0) continue;
                                ++tCode;
                                GT_CoverBehavior tCover = this.getCoverBehaviorAtSide(i);
                                int tCoverTickRate = tCover.getTickRate(i, this.getCoverIDAtSide(i), this.mCoverData[i], this);
                                if (tCoverTickRate <= 0 || this.mTickTimer % (long)tCoverTickRate != 0L) continue;
                                byte tRedstone = tCover.isRedstoneSensitive(i, this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer) ? this.getInputRedstoneSignal(i) : (byte)0;
                                this.mCoverData[i] = tCover.doCoverThings(i, tRedstone, this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer);
                                if (this.hasValidMetaTileEntity()) continue;
                                return;
                            }
                            byte oldConnections = this.mConnections;
                            this.mConnections = (byte)(this.mMetaTileEntity.mConnections | this.mConnections & 0xFFFFFFC0);
                            if ((this.mConnections & 0xC0) == 64 && this.getRandomNumber(1000) == 0) {
                                this.mConnections = (byte)(this.mConnections & 0xFFFFFFBF | 0x80);
                            }
                            if (this.mTickTimer > 12L && oldConnections != this.mConnections) {
                                GregTech_API.causeCableUpdate(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
                            }
                        }
                    }
                    case 8: {
                        tCode = 9;
                        this.mMetaTileEntity.onPreTick(this, this.mTickTimer);
                        if (!this.hasValidMetaTileEntity()) {
                            return;
                        }
                    }
                    case 9: {
                        byte i;
                        ++tCode;
                        if (this.isServerSide()) {
                            if (this.mTickTimer == 10L) {
                                for (i = 0; i < 6; i = (byte)(i + 1)) {
                                    this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
                                }
                                this.issueBlockUpdate();
                                this.joinEnet();
                            }
                            if (this.xCoord != this.oX || this.yCoord != this.oY || this.zCoord != this.oZ) {
                                this.oX = this.xCoord;
                                this.oY = this.yCoord;
                                this.oZ = this.zCoord;
                                this.issueClientUpdate();
                                this.clearTileEntityBuffer();
                            }
                        }
                    }
                    case 10: {
                        ++tCode;
                        this.mMetaTileEntity.onPostTick(this, this.mTickTimer);
                        if (!this.hasValidMetaTileEntity()) {
                            return;
                        }
                    }
                    case 11: {
                        ++tCode;
                        if (!this.isServerSide()) break;
                        if (this.mTickTimer % 10L == 0L && this.mSendClientData) {
                            this.oTextureData = this.mConnections;
                            this.oUpdateData = this.hasValidMetaTileEntity() ? this.mMetaTileEntity.getUpdateData() : (byte)0;
                            this.oRedstoneData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0));
                            this.oColor = this.mColor;
                            GT_Values.NW.sendPacketToAllPlayersInRange(this.worldObj, new GT_Packet_TileEntity(this.xCoord, (short)this.yCoord, this.zCoord, this.mID, this.mCoverSides[0], this.mCoverSides[1], this.mCoverSides[2], this.mCoverSides[3], this.mCoverSides[4], this.mCoverSides[5], this.oTextureData, this.oUpdateData, this.oRedstoneData, this.oColor), this.xCoord, this.zCoord);
                            this.mSendClientData = false;
                        }
                        if (this.mTickTimer > 10L) {
                            byte tData;
                            if (this.mConnections != this.oTextureData) {
                                this.oTextureData = this.mConnections;
                                this.sendBlockEvent((byte)0, this.oTextureData);
                            }
                            if ((tData = this.mMetaTileEntity.getUpdateData()) != this.oUpdateData) {
                                this.oUpdateData = tData;
                                this.sendBlockEvent((byte)1, this.oUpdateData);
                            }
                            if (this.mColor != this.oColor) {
                                this.oColor = this.mColor;
                                this.sendBlockEvent((byte)2, this.oColor);
                            }
                            if ((tData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0))) != this.oRedstoneData) {
                                this.oRedstoneData = tData;
                                this.sendBlockEvent((byte)3, this.oRedstoneData);
                            }
                        }
                        if (!this.mNeedsBlockUpdate) break;
                        this.updateNeighbours(this.mStrongRedstone, this.oStrongRedstone);
                        this.oStrongRedstone = this.mStrongRedstone;
                        this.mNeedsBlockUpdate = false;
                    }
                }
                tCode = -1;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (this.isServerSide() && this.hasValidMetaTileEntity()) {
            tTime = System.nanoTime() - tTime;
            if (this.mTimeStatistics.length > 0) {
                this.mTimeStatisticsIndex = (this.mTimeStatisticsIndex + 1) % this.mTimeStatistics.length;
                this.mTimeStatistics[this.mTimeStatisticsIndex] = (int)tTime;
            }
            if (tTime > 0L && tTime > (long)(GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING * 1000000) && this.mTickTimer > 1000L && this.getMetaTileEntity().doTickProfilingMessageDuringThisTick()) {
                byte by = this.mLagWarningCount;
                this.mLagWarningCount = (byte)(by + 1);
                if (by < 10) {
                    GT_Mod.GT_FML_LOGGER.warn("WARNING: Possible Lag Source at [" + this.xCoord + "," + this.yCoord + "," + this.zCoord + "] in Dimension " + this.worldObj.provider.dimensionId + " with " + tTime + " ns caused by an instance of " + this.getMetaTileEntity().getClass());
                }
            }
        }
        this.mInventoryChanged = false;
        this.mWorkUpdate = false;
    }

    public Packet getDescriptionPacket() {
        this.issueClientUpdate();
        return null;
    }

    public final void receiveMetaTileEntityData(short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aTextureData, byte aUpdateData, byte aRedstoneData, byte aColorData) {
        this.issueTextureUpdate();
        if (aID > 0 && this.mID != aID) {
            this.mID = aID;
            this.createNewMetatileEntity(this.mID);
        }
        this.mCoverSides[0] = aCover0;
        this.mCoverSides[1] = aCover1;
        this.mCoverSides[2] = aCover2;
        this.mCoverSides[3] = aCover3;
        this.mCoverSides[4] = aCover4;
        this.mCoverSides[5] = aCover5;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
        }
        this.receiveClientEvent(0, aTextureData);
        this.receiveClientEvent(1, aUpdateData);
        this.receiveClientEvent(2, aColorData);
        this.receiveClientEvent(3, aRedstoneData);
    }

    public boolean receiveClientEvent(int aEventID, int aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (this.hasValidMetaTileEntity()) {
            try {
                this.mMetaTileEntity.receiveClientEvent((byte)aEventID, (byte)aValue);
            }
            catch (Throwable e) {
                GT_Log.err.println("Encountered Exception while receiving Data from the Server, the Client should've been crashed by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
                e.printStackTrace(GT_Log.err);
            }
        }
        if (this.isClientSide()) {
            this.issueTextureUpdate();
            switch (aEventID) {
                case 0: {
                    this.mConnections = (byte)aValue;
                    break;
                }
                case 1: {
                    if (!this.hasValidMetaTileEntity()) break;
                    this.mMetaTileEntity.onValueUpdate((byte)aValue);
                    break;
                }
                case 2: {
                    if (aValue > 16 || aValue < 0) {
                        aValue = 0;
                    }
                    this.mColor = (byte)aValue;
                    break;
                }
                case 3: {
                    this.mSidedRedstone[0] = (byte)((aValue & 1) == 1 ? 15 : 0);
                    this.mSidedRedstone[1] = (byte)((aValue & 2) == 2 ? 15 : 0);
                    this.mSidedRedstone[2] = (byte)((aValue & 4) == 4 ? 15 : 0);
                    this.mSidedRedstone[3] = (byte)((aValue & 8) == 8 ? 15 : 0);
                    this.mSidedRedstone[4] = (byte)((aValue & 0x10) == 16 ? 15 : 0);
                    this.mSidedRedstone[5] = (byte)((aValue & 0x20) == 32 ? 15 : 0);
                    break;
                }
                case 4: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.doSound((byte)aValue, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                    break;
                }
                case 5: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.startSoundLoop((byte)aValue, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                    break;
                }
                case 6: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.stopSoundLoop((byte)aValue, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                }
            }
        }
        return true;
    }

    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aLogLevel) {
        ArrayList<String> tList = new ArrayList<String>();
        if (aLogLevel > 2) {
            tList.add("Meta-ID: " + EnumChatFormatting.BLUE + this.mID + EnumChatFormatting.RESET + (this.hasValidMetaTileEntity() ? EnumChatFormatting.GREEN + " valid" + EnumChatFormatting.RESET : EnumChatFormatting.RED + " invalid" + EnumChatFormatting.RESET) + (this.mMetaTileEntity == null ? EnumChatFormatting.RED + " MetaTileEntity == null!" + EnumChatFormatting.RESET : " "));
        }
        if (aLogLevel > 1) {
            if (this.mTimeStatistics.length > 0) {
                double tAverageTime = 0.0;
                double tWorstTime = 0.0;
                for (int tTime : this.mTimeStatistics) {
                    tAverageTime += (double)tTime;
                    if (!((double)tTime > tWorstTime)) continue;
                    tWorstTime = tTime;
                }
                tList.add("Average CPU-load of ~" + tAverageTime / (double)this.mTimeStatistics.length + "ns since " + this.mTimeStatistics.length + " ticks with worst time of " + tWorstTime + "ns.");
            }
            if (this.mLagWarningCount > 0) {
                tList.add("Caused " + (this.mLagWarningCount >= 10 ? "more than 10" : Byte.valueOf(this.mLagWarningCount)) + " Lag Spike Warnings (anything taking longer than " + GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING + "ms) on the Server.");
            }
            tList.add("Is" + (this.mMetaTileEntity.isAccessAllowed(aPlayer) ? " " : EnumChatFormatting.RED + " not " + EnumChatFormatting.RESET) + "accessible for you");
        }
        if (this.joinedIc2Enet) {
            tList.add("Joined IC2 ENet");
        }
        return this.mMetaTileEntity.getSpecialDebugInfo(this, aPlayer, aLogLevel, tList);
    }

    @Override
    public void issueTextureUpdate() {
        this.mNeedsUpdate = true;
    }

    @Override
    public void issueBlockUpdate() {
        this.mNeedsBlockUpdate = true;
    }

    @Override
    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        this.issueClientUpdate();
    }

    @Override
    public void receiveCoverData(byte coverSide, int coverID, int coverData) {
        if (coverSide >= 0 && coverSide < 6 && this.mCoverSides[coverSide] == coverID) {
            this.setCoverDataAtSide(coverSide, coverData);
        }
    }

    @Override
    public byte getStrongestRedstone() {
        return (byte)Math.max(this.getInternalInputRedstoneSignal((byte)0), Math.max(this.getInternalInputRedstoneSignal((byte)1), Math.max(this.getInternalInputRedstoneSignal((byte)2), Math.max(this.getInternalInputRedstoneSignal((byte)3), Math.max(this.getInternalInputRedstoneSignal((byte)4), this.getInternalInputRedstoneSignal((byte)5))))));
    }

    @Override
    public boolean getRedstone() {
        return this.getRedstone((byte)0) || this.getRedstone((byte)1) || this.getRedstone((byte)2) || this.getRedstone((byte)3) || this.getRedstone((byte)4) || this.getRedstone((byte)5);
    }

    @Override
    public boolean getRedstone(byte aSide) {
        return this.getInternalInputRedstoneSignal(aSide) > 0;
    }

    public ITexture getCoverTexture(byte aSide) {
        if (this.getCoverIDAtSide(aSide) == 0) {
            return null;
        }
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return Textures.BlockIcons.HIDDEN_TEXTURE[0];
        }
        return GregTech_API.sCovers.get(new GT_ItemStack(this.getCoverIDAtSide(aSide)));
    }

    @Override
    public boolean isGivingInformation() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isGivingInformation();
        }
        return false;
    }

    @Override
    public boolean isValidFacing(byte aSide) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isFacingValid(aSide);
        }
        return false;
    }

    @Override
    public byte getBackFacing() {
        return GT_Utility.getOppositeSide(this.getFrontFacing());
    }

    @Override
    public byte getFrontFacing() {
        return 6;
    }

    @Override
    public void setFrontFacing(byte aFacing) {
        this.doEnetUpdate();
    }

    public int getSizeInventory() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getSizeInventory();
        }
        return 0;
    }

    public ItemStack getStackInSlot(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getStackInSlot(aIndex);
        }
        return null;
    }

    public void setInventorySlotContents(int aIndex, ItemStack aStack) {
        this.mInventoryChanged = true;
        if (this.canAccessData()) {
            this.mMetaTileEntity.setInventorySlotContents(aIndex, this.worldObj.isRemote ? aStack : GT_OreDictUnificator.setStack(true, aStack));
        }
    }

    public String getInventoryName() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getInventoryName();
        }
        if (GregTech_API.METATILEENTITIES[this.mID] != null) {
            return GregTech_API.METATILEENTITIES[this.mID].getInventoryName();
        }
        return "";
    }

    public int getInventoryStackLimit() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getInventoryStackLimit();
        }
        return 64;
    }

    public void openInventory() {
    }

    public void closeInventory() {
    }

    public boolean isUseableByPlayer(EntityPlayer aPlayer) {
        return this.hasValidMetaTileEntity() && this.mTickTimer > 40L && this.getTileEntityOffset(0, 0, 0) == this && aPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) < 64.0 && this.mMetaTileEntity.isAccessAllowed(aPlayer);
    }

    @Override
    public void validate() {
        super.validate();
        this.mTickTimer = 0L;
    }

    @Override
    public void invalidate() {
        this.tileEntityInvalid = false;
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.onRemoval();
            this.mMetaTileEntity.setBaseMetaTileEntity(null);
        }
        this.leaveEnet();
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    @Override
    public void onMachineBlockUpdate() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onMachineBlockUpdate();
        }
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return this.canAccessData() && this.mMetaTileEntity.isMachineBlockUpdateRecursive();
    }

    @Override
    public int getProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.getProgresstime() : 0;
    }

    @Override
    public int getMaxProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.maxProgresstime() : 0;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.canAccessData() && this.mMetaTileEntity.increaseProgress(aProgressAmountInTicks) != aProgressAmountInTicks;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public void enableWorking() {
        if (!this.mWorks) {
            this.mWorkUpdate = true;
        }
        this.mWorks = true;
    }

    @Override
    public void disableWorking() {
        this.mWorks = false;
    }

    @Override
    public boolean isAllowedToWork() {
        return this.mWorks;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.mWorkUpdate;
    }

    @Override
    public byte getWorkDataValue() {
        return 0;
    }

    @Override
    public void setWorkDataValue(byte aValue) {
    }

    @Override
    public int getMetaTileID() {
        return this.mID;
    }

    @Override
    public int setMetaTileID(short aID) {
        this.mID = aID;
        return this.mID;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void setActive(boolean aActive) {
    }

    @Override
    public long getTimer() {
        return this.mTickTimer;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        return false;
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    @Override
    public boolean inputEnergyFrom(byte aSide) {
        return false;
    }

    @Override
    public boolean inputEnergyFrom(byte aSide, boolean waitForActive) {
        return false;
    }

    @Override
    public boolean outputsEnergyTo(byte aSide) {
        return false;
    }

    @Override
    public boolean outputsEnergyTo(byte aSide, boolean waitForActive) {
        return false;
    }

    @Override
    public long getOutputAmperage() {
        return 0L;
    }

    @Override
    public long getOutputVoltage() {
        return 0L;
    }

    @Override
    public long getInputAmperage() {
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        return 0L;
    }

    @Override
    public boolean increaseStoredSteam(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return false;
    }

    @Override
    public String[] getDescription() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getDescription();
        }
        return new String[0];
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isValidSlot(aIndex);
        }
        return false;
    }

    @Override
    public long getUniversalEnergyStored() {
        return Math.max(this.getStoredEU(), this.getStoredSteam());
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return Math.max(this.getEUCapacity(), this.getSteamCapacity());
    }

    @Override
    public long getStoredEU() {
        return 0L;
    }

    @Override
    public long getEUCapacity() {
        return 0L;
    }

    @Override
    public long getStoredSteam() {
        return 0L;
    }

    @Override
    public long getSteamCapacity() {
        return 0L;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide) {
        ITexture rIcon = this.getCoverTexture(aSide);
        if (rIcon != null) {
            return new ITexture[]{rIcon};
        }
        return this.getTextureUncovered(aSide);
    }

    @Override
    public ITexture[] getTextureCovered(byte aSide) {
        ITexture coverTexture = this.getCoverTexture(aSide);
        ITexture[] textureUncovered = this.getTextureUncovered(aSide);
        if (coverTexture != null) {
            ITexture[] textureCovered = Arrays.copyOf(textureUncovered, textureUncovered.length + 1);
            textureCovered[textureUncovered.length] = coverTexture;
            return textureCovered;
        }
        return textureUncovered;
    }

    @Override
    public ITexture[] getTextureUncovered(byte aSide) {
        if ((this.mConnections & 0x40) != 0) {
            return Textures.BlockIcons.FRESHFOAM;
        }
        if ((this.mConnections & 0x80) != 0) {
            return Textures.BlockIcons.HARDENEDFOAMS[this.mColor];
        }
        if ((this.mConnections & 0xC0) != 0) {
            return Textures.BlockIcons.ERROR_RENDERING;
        }
        byte tConnections = this.mConnections;
        if (tConnections == 16 || tConnections == 32) {
            tConnections = 48;
        } else if (tConnections == 1 || tConnections == 2) {
            tConnections = 3;
        } else if (tConnections == 4 || tConnections == 8) {
            tConnections = 12;
        }
        if (this.hasValidMetaTileEntity()) {
            return this.mMetaTileEntity.getTexture(this, aSide, tConnections, (byte)(this.mColor - 1), tConnections == 0 || (tConnections & 1 << aSide) != 0, this.getOutputRedstoneSignal(aSide) > 0);
        }
        return Textures.BlockIcons.ERROR_RENDERING;
    }

    protected boolean hasValidMetaTileEntity() {
        return this.mMetaTileEntity != null && this.mMetaTileEntity.getBaseMetaTileEntity() == this;
    }

    protected boolean canAccessData() {
        return this.hasValidMetaTileEntity() && !this.isDead;
    }

    @Override
    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onExplosion();
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    @Override
    public ArrayList<ItemStack> getDrops() {
        ItemStack rStack = new ItemStack(GregTech_API.sBlockMachines, 1, (int)this.mID);
        NBTTagCompound tNBT = new NBTTagCompound();
        if (this.mStrongRedstone > 0) {
            tNBT.setByte("mStrongRedstone", this.mStrongRedstone);
        }
        for (int i = 0; i < this.mCoverSides.length; i = (int)((byte)(i + 1))) {
            if (this.mCoverSides[i] == 0) continue;
            tNBT.setIntArray("mCoverData", this.mCoverData);
            tNBT.setIntArray("mCoverSides", this.mCoverSides);
            break;
        }
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.setItemNBT(tNBT);
        }
        if (!tNBT.hasNoTags()) {
            rStack.setTagCompound(tNBT);
        }
        return new ArrayList<ItemStack>(Arrays.asList(rStack));
    }

    @Override
    public boolean onRightclick(EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (this.isClientSide()) {
            if (aPlayer.isSneaking()) {
                byte tSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                return this.getCoverBehaviorAtSide(tSide).hasCoverGUI();
            }
            if (this.getCoverBehaviorAtSide(aSide).onCoverRightclickClient(aSide, this, aPlayer, aX, aY, aZ)) {
                return true;
            }
        }
        if (this.isServerSide()) {
            ItemStack tCurrentItem = aPlayer.inventory.getCurrentItem();
            if (tCurrentItem != null) {
                if (this.getColorization() >= 0 && GT_Utility.areStacksEqual(new ItemStack(Items.water_bucket, 1), tCurrentItem)) {
                    tCurrentItem.func_150996_a(Items.bucket);
                    this.setColorization((byte)-1);
                    return true;
                }
                byte tSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList)) {
                    if (this.mMetaTileEntity.onWrenchRightClick(aSide, tSide, aPlayer, aX, aY, aZ)) {
                        GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList)) {
                    if (this.getCoverIDAtSide(aSide) == 0 && this.getCoverIDAtSide(tSide) != 0) {
                        if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 200, (EntityLivingBase)aPlayer)) {
                            this.setCoverDataAtSide(tSide, this.getCoverBehaviorAtSide(tSide).onCoverScrewdriverclick(tSide, this.getCoverIDAtSide(tSide), this.getCoverDataAtSide(tSide), this, aPlayer, 0.5f, 0.5f, 0.5f));
                            this.mMetaTileEntity.onScrewdriverRightClick(tSide, aPlayer, aX, aY, aZ);
                            GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        }
                    } else if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        this.setCoverDataAtSide(aSide, this.getCoverBehaviorAtSide(aSide).onCoverScrewdriverclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer, aX, aY, aZ));
                        this.mMetaTileEntity.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sHardHammerList)) {
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        if (this.mWorks) {
                            this.disableWorking();
                        } else {
                            this.enableWorking();
                        }
                        GT_Utility.sendChatToPlayer(aPlayer, this.trans("090", "Machine Processing: ") + (this.isAllowedToWork() ? this.trans("088", "Enabled") : this.trans("087", "Disabled")));
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(101), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList)) {
                    if (this.mMetaTileEntity.onWireCutterRightClick(aSide, tSide, aPlayer, aX, aY, aZ)) {
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    }
                    this.doEnetUpdate();
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList)) {
                    if (this.mMetaTileEntity.onSolderingToolRightClick(aSide, tSide, aPlayer, aX, aY, aZ)) {
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(103), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    } else if (GT_ModHandler.useSolderingIron(tCurrentItem, (EntityLivingBase)aPlayer)) {
                        this.mStrongRedstone = (byte)(this.mStrongRedstone ^ 1 << tSide);
                        GT_Utility.sendChatToPlayer(aPlayer, this.trans("091", "Redstone Output at Side ") + tSide + this.trans("092", " set to: ") + ((this.mStrongRedstone & 1 << tSide) != 0 ? this.trans("093", "Strong") : this.trans("094", "Weak")));
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(103), 3.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        this.issueBlockUpdate();
                    }
                    this.doEnetUpdate();
                    return true;
                }
                byte coverSide = aSide;
                if (this.getCoverIDAtSide(aSide) == 0) {
                    coverSide = tSide;
                }
                if (this.getCoverIDAtSide(coverSide) == 0) {
                    if (GregTech_API.sCovers.containsKey(new GT_ItemStack(tCurrentItem))) {
                        if (GregTech_API.getCoverBehavior(tCurrentItem).isCoverPlaceable(coverSide, new GT_ItemStack(tCurrentItem), this) && this.mMetaTileEntity.allowCoverOnSide(coverSide, new GT_ItemStack(tCurrentItem))) {
                            this.setCoverItemAtSide(coverSide, tCurrentItem);
                            if (!aPlayer.capabilities.isCreativeMode) {
                                --tCurrentItem.stackSize;
                            }
                            GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        }
                        return true;
                    }
                } else if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCrowbarList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(0), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        this.dropCover(coverSide, aSide, false);
                    }
                    return true;
                }
            } else if (aPlayer.isSneaking()) {
                aSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                return this.getCoverIDAtSide(aSide) > 0 && this.getCoverBehaviorAtSide(aSide).onCoverShiftRightclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer);
            }
            if (this.getCoverBehaviorAtSide(aSide).onCoverRightclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer, aX, aY, aZ)) {
                return true;
            }
        }
        if (!this.getCoverBehaviorAtSide(aSide).isGUIClickable(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
            return false;
        }
        try {
            if (!aPlayer.isSneaking() && this.hasValidMetaTileEntity()) {
                return this.mMetaTileEntity.onRightclick(this, aPlayer, aSide, aX, aY, aZ);
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered Exception while rightclicking TileEntity, the Game should've crashed now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        return false;
    }

    @Override
    public void onLeftclick(EntityPlayer aPlayer) {
        try {
            if (aPlayer != null && this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.onLeftclick(this, aPlayer);
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered Exception while leftclicking TileEntity, the Game should've crashed now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
    }

    @Override
    public boolean isDigitalChest() {
        return false;
    }

    @Override
    public ItemStack[] getStoredItemData() {
        return null;
    }

    @Override
    public void setItemCount(int aCount) {
    }

    @Override
    public int getMaxItemCount() {
        return 0;
    }

    public boolean isItemValidForSlot(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mMetaTileEntity.isItemValidForSlot(aIndex, aStack);
    }

    public int[] getAccessibleSlotsFromSide(int aSide) {
        if (this.canAccessData() && (this.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), -1, this) || this.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), -1, this))) {
            return this.mMetaTileEntity.getAccessibleSlotsFromSide(aSide);
        }
        return new int[0];
    }

    public boolean canInsertItem(int aIndex, ItemStack aStack, int aSide) {
        return this.canAccessData() && this.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), aIndex, this) && this.mMetaTileEntity.canInsertItem(aIndex, aStack, aSide);
    }

    public boolean canExtractItem(int aIndex, ItemStack aStack, int aSide) {
        return this.canAccessData() && this.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), aIndex, this) && this.mMetaTileEntity.canExtractItem(aIndex, aStack, aSide);
    }

    @Override
    public boolean isUpgradable() {
        return false;
    }

    @Override
    public byte getInternalInputRedstoneSignal(byte aSide) {
        return (byte)(this.getCoverBehaviorAtSide(aSide).getRedstoneInput(aSide, this.getInputRedstoneSignal(aSide), this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(byte aSide) {
        return (byte)(this.worldObj.getIndirectPowerLevelTo(this.getOffsetX(aSide, 1), (int)this.getOffsetY(aSide, 1), this.getOffsetZ(aSide, 1), (int)aSide) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(byte aSide) {
        return (byte)(this.getCoverBehaviorAtSide(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this) || this.getCoverBehaviorAtSide(aSide).letsRedstoneGoOut(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this) ? this.mSidedRedstone[aSide] & 0xF : 0);
    }

    @Override
    public void setInternalOutputRedstoneSignal(byte aSide, byte aStrength) {
        if (!this.getCoverBehaviorAtSide(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
            this.setOutputRedstoneSignal(aSide, aStrength);
        }
    }

    @Override
    public void setOutputRedstoneSignal(byte aSide, byte aStrength) {
        aStrength = (byte)Math.min(Math.max(0, aStrength), 15);
        if (aSide >= 0 && aSide < 6 && this.mSidedRedstone[aSide] != aStrength) {
            this.mSidedRedstone[aSide] = aStrength;
            this.issueBlockUpdate();
        }
    }

    @Override
    public boolean isSteamEngineUpgradable() {
        return this.isUpgradable() && !this.hasSteamEngineUpgrade() && this.getSteamCapacity() > 0L;
    }

    @Override
    public boolean addSteamEngineUpgrade() {
        if (this.isSteamEngineUpgradable()) {
            this.issueBlockUpdate();
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSteamEngineUpgrade() {
        return false;
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
    }

    @Override
    public int getErrorDisplayID() {
        return 0;
    }

    @Override
    public void setErrorDisplayID(int aErrorID) {
    }

    @Override
    public IMetaTileEntity getMetaTileEntity() {
        return this.hasValidMetaTileEntity() ? this.mMetaTileEntity : null;
    }

    @Override
    public void setMetaTileEntity(IMetaTileEntity aMetaTileEntity) {
        this.mMetaTileEntity = (MetaPipeEntity)aMetaTileEntity;
    }

    @Override
    public GT_CoverBehavior getCoverBehaviorAtSide(byte aSide) {
        return aSide >= 0 && aSide < this.mCoverBehaviors.length ? this.mCoverBehaviors[aSide] : GregTech_API.sNoBehavior;
    }

    @Override
    public void setCoverIDAtSide(byte aSide, int aID) {
        if (aSide >= 0 && aSide < 6) {
            this.mCoverSides[aSide] = aID;
            this.mCoverData[aSide] = 0;
            this.mCoverBehaviors[aSide] = GregTech_API.getCoverBehavior(aID);
            this.issueCoverUpdate(aSide);
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setCoverItemAtSide(byte aSide, ItemStack aCover) {
        GregTech_API.getCoverBehavior(aCover).placeCover(aSide, aCover, this);
    }

    @Override
    public int getCoverIDAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverSides[aSide];
        }
        return 0;
    }

    @Override
    public ItemStack getCoverItemAtSide(byte aSide) {
        return GT_Utility.intToStack(this.getCoverIDAtSide(aSide));
    }

    @Override
    public boolean canPlaceCoverIDAtSide(byte aSide, int aID) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public boolean canPlaceCoverItemAtSide(byte aSide, ItemStack aCover) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public void setCoverDataAtSide(byte aSide, int aData) {
        if (aSide >= 0 && aSide < 6) {
            this.mCoverData[aSide] = aData;
        }
    }

    @Override
    public int getCoverDataAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverData[aSide];
        }
        return 0;
    }

    @Override
    public void setLightValue(byte aLightValue) {
    }

    @Override
    public long getAverageElectricInput() {
        return 0L;
    }

    @Override
    public long getAverageElectricOutput() {
        return 0L;
    }

    @Override
    public boolean dropCover(byte aSide, byte aDroppedSide, boolean aForced) {
        if (this.getCoverBehaviorAtSide(aSide).onCoverRemoval(aSide, this.getCoverIDAtSide(aSide), this.mCoverData[aSide], this, aForced) || aForced) {
            ItemStack tStack = this.getCoverBehaviorAtSide(aSide).getDrop(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this);
            if (tStack != null) {
                tStack.setTagCompound(null);
                EntityItem tEntity = new EntityItem(this.worldObj, (double)this.getOffsetX(aDroppedSide, 1) + 0.5, (double)this.getOffsetY(aDroppedSide, 1) + 0.5, (double)this.getOffsetZ(aDroppedSide, 1) + 0.5, tStack);
                tEntity.motionX = 0.0;
                tEntity.motionY = 0.0;
                tEntity.motionZ = 0.0;
                this.worldObj.spawnEntityInWorld((Entity)tEntity);
            }
            this.setCoverIDAtSide(aSide, 0);
            this.setOutputRedstoneSignal(aSide, (byte)0);
            return true;
        }
        return false;
    }

    @Override
    public String getOwnerName() {
        return "Player";
    }

    @Override
    public String setOwnerName(String aName) {
        return "Player";
    }

    @Override
    public UUID getOwnerUuid() {
        return GT_Utility.defaultUuid;
    }

    @Override
    public void setOwnerUuid(UUID uuid) {
    }

    @Override
    public byte getComparatorValue(byte aSide) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(aSide) : (byte)0;
    }

    @Override
    public byte getStrongOutputRedstoneSignal(byte aSide) {
        return aSide >= 0 && aSide < 6 && (this.mStrongRedstone & 1 << aSide) != 0 ? (byte)(this.mSidedRedstone[aSide] & 0xF) : (byte)0;
    }

    @Override
    public void setStrongOutputRedstoneSignal(byte aSide, byte aStrength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | 1 << aSide);
        this.setOutputRedstoneSignal(aSide, aStrength);
    }

    public ItemStack decrStackSize(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mMetaTileEntity.decrStackSize(aIndex, aAmount);
        }
        return null;
    }

    @Override
    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.injectEnergyUnits(aSide, aVoltage, aAmperage);
        }
        return 0L;
    }

    @Override
    public boolean drainEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        return false;
    }

    @Override
    public boolean acceptsRotationalEnergy(byte aSide) {
        if (!this.canAccessData() || this.getCoverIDAtSide(aSide) != 0) {
            return false;
        }
        return this.mMetaTileEntity.acceptsRotationalEnergy(aSide);
    }

    @Override
    public boolean injectRotationalEnergy(byte aSide, long aSpeed, long aEnergy) {
        if (!this.canAccessData() || this.getCoverIDAtSide(aSide) != 0) {
            return false;
        }
        return this.mMetaTileEntity.injectRotationalEnergy(aSide, aSpeed, aEnergy);
    }

    private boolean canMoveFluidOnSide(ForgeDirection aSide, Fluid aFluid, boolean isFill) {
        if (aSide == ForgeDirection.UNKNOWN) {
            return true;
        }
        IFluidHandler tTileEntity = this.getITankContainerAtSide((byte)aSide.ordinal());
        if (tTileEntity != null && !this.mMetaTileEntity.isConnectedAtSide((byte)aSide.ordinal())) {
            return false;
        }
        if (isFill && this.mMetaTileEntity.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid, this)) {
            return true;
        }
        return !isFill && this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid, this);
    }

    public int fill(ForgeDirection aSide, FluidStack aFluidStack, boolean doFill) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(aSide, aFluidStack == null ? null : aFluidStack.getFluid(), true)) {
            return this.mMetaTileEntity.fill(aSide, aFluidStack, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(aSide, this.mMetaTileEntity.getFluid() == null ? null : this.mMetaTileEntity.getFluid().getFluid(), false)) {
            return this.mMetaTileEntity.drain(aSide, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluidStack, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(aSide, aFluidStack == null ? null : aFluidStack.getFluid(), false)) {
            return this.mMetaTileEntity.drain(aSide, aFluidStack, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(aSide, aFluid, true)) {
            return this.mMetaTileEntity.canFill(aSide, aFluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && this.canMoveFluidOnSide(aSide, aFluid, false)) {
            return this.mMetaTileEntity.canDrain(aSide, aFluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (this.canAccessData() && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), null, this) || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), null, this))) {
            return this.mMetaTileEntity.getTankInfo(aSide);
        }
        return new FluidTankInfo[0];
    }

    @Override
    public boolean isInvalidTileEntity() {
        return this.isInvalid();
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.getSizeInventory()) {
            return false;
        }
        ItemStack tStack = this.getStackInSlot(aIndex);
        if (GT_Utility.isStackInvalid(tStack)) {
            this.setInventorySlotContents(aIndex, aStack);
            return true;
        }
        if (GT_Utility.areStacksEqual(tStack, aStack = GT_OreDictUnificator.get(aStack)) && tStack.stackSize + aStack.stackSize <= Math.min(aStack.getMaxStackSize(), this.getInventoryStackLimit())) {
            tStack.stackSize += aStack.stackSize;
            return true;
        }
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GT_Utility.copyAmount(aAmount, aStack));
    }

    @Override
    public byte getColorization() {
        return (byte)(this.mColor - 1);
    }

    @Override
    public byte setColorization(byte aColor) {
        if (aColor > 15 || aColor < -1) {
            aColor = (byte)-1;
        }
        this.mColor = (byte)(aColor + 1);
        if (this.canAccessData()) {
            this.mMetaTileEntity.onColorChangeServer(aColor);
        }
        return this.mColor;
    }

    @Override
    public float getThickNess() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getThickNess();
        }
        return 1.0f;
    }

    public boolean renderInside(byte aSide) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.renderInside(aSide);
        }
        return false;
    }

    @Override
    public float getBlastResistance(byte aSide) {
        return (this.mConnections & 0xC0) != 0 ? 50.0f : 5.0f;
    }

    @Override
    public boolean isMufflerUpgradable() {
        return false;
    }

    @Override
    public boolean addMufflerUpgrade() {
        return false;
    }

    @Override
    public boolean hasMufflerUpgrade() {
        return false;
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return this.getUniversalEnergyStored() >= aEnergyAmount;
    }

    @Override
    public String[] getInfoData() {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().getInfoData();
        }
        return new String[0];
    }

    @Override
    public byte getConnections() {
        return this.mConnections;
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.mInventoryChanged = true;
    }

    public void onNeighborBlockChange(int aX, int aY, int aZ) {
        IMetaTileEntity meta;
        if (this.canAccessData() && (meta = this.getMetaTileEntity()) instanceof MetaPipeEntity) {
            ((MetaPipeEntity)meta).setCheckConnections();
        }
    }

    @Override
    public int getLightOpacity() {
        return this.mMetaTileEntity == null ? 0 : this.mMetaTileEntity.getLightOpacity();
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        this.mMetaTileEntity.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return this.mMetaTileEntity.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
        this.mMetaTileEntity.onEntityCollidedWithBlock(aWorld, aX, aY, aZ, collider);
    }
}

