/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import com.gtnewhorizon.structurelib.alignment.IAlignment;
import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.IConstructableProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import cpw.mods.fml.common.Optional;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.graphs.GenerateNodeMap;
import gregtech.api.graphs.GenerateNodeMapPower;
import gregtech.api.graphs.Node;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.net.GT_Packet_TileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.XSTR;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Client;
import gregtech.common.GT_Pollution;
import ic2.api.Direction;
import ic2.api.info.Info;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2", striprefs=true), @Optional.Interface(iface="appeng.me.helpers.IGridProxyable", modid="appliedenergistics2", striprefs=true)})
public class BaseMetaTileEntity
extends BaseTileEntity
implements IGregTechTileEntity,
IActionHost,
IGridProxyable,
IAlignmentProvider,
IConstructableProvider {
    private final GT_CoverBehavior[] mCoverBehaviors = new GT_CoverBehavior[]{GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior, GregTech_API.sNoBehavior};
    protected MetaTileEntity mMetaTileEntity;
    protected long mStoredEnergy = 0L;
    protected long mStoredSteam = 0L;
    protected int mAverageEUInputIndex = 0;
    protected int mAverageEUOutputIndex = 0;
    protected boolean mReleaseEnergy = false;
    protected long[] mAverageEUInput = new long[]{0L, 0L, 0L, 0L, 0L};
    protected long[] mAverageEUOutput = new long[]{0L, 0L, 0L, 0L, 0L};
    private final boolean[] mActiveEUInputs = new boolean[]{false, false, false, false, false, false};
    private final boolean[] mActiveEUOutputs = new boolean[]{false, false, false, false, false, false};
    private byte[] mSidedRedstone = new byte[]{15, 15, 15, 15, 15, 15};
    private int[] mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
    private int[] mCoverData = new int[]{0, 0, 0, 0, 0, 0};
    private final int[] mTimeStatistics = new int[GregTech_API.TICKS_FOR_LAG_AVERAGING];
    private boolean mHasEnoughEnergy = true;
    private boolean mRunningThroughTick = false;
    private boolean mInputDisabled = false;
    private boolean mOutputDisabled = false;
    private boolean mMuffler = false;
    private boolean mLockUpgrade = false;
    private boolean mActive = false;
    private boolean mRedstone = false;
    private boolean mWorkUpdate = false;
    private boolean mSteamConverter = false;
    private boolean mInventoryChanged = false;
    private boolean mWorks = true;
    private boolean mNeedsUpdate = true;
    private boolean mNeedsBlockUpdate = true;
    private boolean mSendClientData = false;
    private boolean oRedstone = false;
    private byte mColor = 0;
    private byte oColor = 0;
    private byte oStrongRedstone = 0;
    private byte mStrongRedstone = 0;
    private byte oRedstoneData = (byte)63;
    private byte oTextureData = 0;
    private byte oUpdateData = 0;
    private byte oTexturePage = 0;
    private byte oLightValueClient = (byte)-1;
    private byte oLightValue = (byte)-1;
    private byte mLightValue = 0;
    private byte mOtherUpgrades = 0;
    private byte mFacing = 0;
    private byte oFacing = 0;
    private byte mWorkData = 0;
    private int mDisplayErrorCode = 0;
    private int oX = 0;
    private int oY = 0;
    private int oZ = 0;
    private int mTimeStatisticsIndex = 0;
    private int mLagWarningCount = 0;
    private short mID = 0;
    public long mTickTimer = 0L;
    private long oOutput = 0L;
    private long mAcceptedAmperes = Long.MAX_VALUE;
    public long mLastSoundTick = 0L;
    private long mLastCheckTick = 0L;
    private String mOwnerName = "";
    private UUID mOwnerUuid = GT_Utility.defaultUuid;
    private NBTTagCompound mRecipeStuff = new NBTTagCompound();
    private int cableUpdateDelay = 30;
    public boolean mWasShutdown = false;
    private static final Field ENTITY_ITEM_HEALTH_FIELD;

    @Override
    public void writeToNBT(NBTTagCompound aNBT) {
        try {
            super.writeToNBT(aNBT);
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        try {
            aNBT.setInteger("mID", (int)this.mID);
            aNBT.setLong("mStoredSteam", this.mStoredSteam);
            aNBT.setLong("mStoredEnergy", this.mStoredEnergy);
            aNBT.setIntArray("mCoverData", this.mCoverData);
            aNBT.setIntArray("mCoverSides", this.mCoverSides);
            aNBT.setByteArray("mRedstoneSided", this.mSidedRedstone);
            aNBT.setByte("mColor", this.mColor);
            aNBT.setByte("mLightValue", this.mLightValue);
            aNBT.setByte("mOtherUpgrades", this.mOtherUpgrades);
            aNBT.setByte("mWorkData", this.mWorkData);
            aNBT.setByte("mStrongRedstone", this.mStrongRedstone);
            aNBT.setShort("mFacing", (short)this.mFacing);
            aNBT.setString("mOwnerName", this.mOwnerName);
            aNBT.setString("mOwnerUuid", this.mOwnerUuid == null ? "" : this.mOwnerUuid.toString());
            aNBT.setBoolean("mLockUpgrade", this.mLockUpgrade);
            aNBT.setBoolean("mMuffler", this.mMuffler);
            aNBT.setBoolean("mSteamConverter", this.mSteamConverter);
            aNBT.setBoolean("mActive", this.mActive);
            aNBT.setBoolean("mRedstone", this.mRedstone);
            aNBT.setBoolean("mWorks", !this.mWorks);
            aNBT.setBoolean("mInputDisabled", this.mInputDisabled);
            aNBT.setBoolean("mOutputDisabled", this.mOutputDisabled);
            aNBT.setTag("GT.CraftingComponents", (NBTBase)this.mRecipeStuff);
            aNBT.setInteger("nbtVersion", GT_Mod.TOTAL_VERSION);
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        try {
            if (this.hasValidMetaTileEntity()) {
                NBTTagList tItemList = new NBTTagList();
                for (int i = 0; i < this.mMetaTileEntity.getRealInventory().length; ++i) {
                    ItemStack tStack = this.mMetaTileEntity.getRealInventory()[i];
                    if (tStack == null) continue;
                    NBTTagCompound tTag = new NBTTagCompound();
                    tTag.setInteger("IntSlot", i);
                    tStack.writeToNBT(tTag);
                    tItemList.appendTag((NBTBase)tTag);
                }
                aNBT.setTag("Inventory", (NBTBase)tItemList);
                try {
                    this.mMetaTileEntity.saveNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
                    e.printStackTrace(GT_Log.err);
                }
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered CRITICAL ERROR while saving MetaTileEntity, the Chunk whould've been corrupted by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound aNBT) {
        super.readFromNBT(aNBT);
        this.setInitialValuesAsNBT(aNBT, (short)0);
    }

    @Override
    public void setInitialValuesAsNBT(NBTTagCompound aNBT, short aID) {
        if (aNBT == null) {
            byte[] byArray;
            if (aID > 0) {
                this.mID = aID;
            } else {
                short s = this.mID = this.mID > 0 ? this.mID : (short)0;
            }
            if (this.mID != 0) {
                this.createNewMetatileEntity(this.mID);
            }
            if (this.hasValidMetaTileEntity() && this.mMetaTileEntity.hasSidedRedstoneOutputBehavior()) {
                byte[] byArray2 = new byte[6];
                byArray2[0] = 0;
                byArray2[1] = 0;
                byArray2[2] = 0;
                byArray2[3] = 0;
                byArray2[4] = 0;
                byArray = byArray2;
                byArray2[5] = 0;
            } else {
                byte[] byArray3 = new byte[6];
                byArray3[0] = 15;
                byArray3[1] = 15;
                byArray3[2] = 15;
                byArray3[3] = 15;
                byArray3[4] = 15;
                byArray = byArray3;
                byArray3[5] = 15;
            }
            this.mSidedRedstone = byArray;
        } else {
            this.mID = aID <= 0 ? (short)aNBT.getInteger("mID") : aID;
            this.mStoredSteam = aNBT.getLong("mStoredSteam");
            this.mStoredEnergy = aNBT.getLong("mStoredEnergy");
            this.mColor = aNBT.getByte("mColor");
            this.mLightValue = aNBT.getByte("mLightValue");
            this.mWorkData = aNBT.getByte("mWorkData");
            this.mStrongRedstone = aNBT.getByte("mStrongRedstone");
            this.mFacing = this.oFacing = (byte)aNBT.getShort("mFacing");
            this.mOwnerName = aNBT.getString("mOwnerName");
            try {
                this.mOwnerUuid = UUID.fromString(aNBT.getString("mOwnerUuid"));
            }
            catch (IllegalArgumentException e) {
                this.mOwnerUuid = null;
            }
            this.mLockUpgrade = aNBT.getBoolean("mLockUpgrade");
            this.mMuffler = aNBT.getBoolean("mMuffler");
            this.mSteamConverter = aNBT.getBoolean("mSteamConverter");
            this.mActive = aNBT.getBoolean("mActive");
            this.mRedstone = aNBT.getBoolean("mRedstone");
            this.mWorks = !aNBT.getBoolean("mWorks");
            this.mInputDisabled = aNBT.getBoolean("mInputDisabled");
            this.mOutputDisabled = aNBT.getBoolean("mOutputDisabled");
            this.mOtherUpgrades = (byte)(aNBT.getByte("mOtherUpgrades") + aNBT.getByte("mBatteries") + aNBT.getByte("mLiBatteries"));
            this.mCoverSides = aNBT.getIntArray("mCoverSides");
            this.mCoverData = aNBT.getIntArray("mCoverData");
            this.mSidedRedstone = aNBT.getByteArray("mRedstoneSided");
            this.mRecipeStuff = aNBT.getCompoundTag("GT.CraftingComponents");
            int nbtVersion = aNBT.getInteger("nbtVersion");
            if (this.mCoverData.length != 6) {
                this.mCoverData = new int[]{0, 0, 0, 0, 0, 0};
            }
            if (this.mCoverSides.length != 6) {
                this.mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
            }
            if (this.mSidedRedstone.length != 6) {
                this.mSidedRedstone = this.hasValidMetaTileEntity() && this.mMetaTileEntity.hasSidedRedstoneOutputBehavior() ? new byte[]{0, 0, 0, 0, 0, 0} : new byte[]{15, 15, 15, 15, 15, 15};
            }
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
            }
            if (this.mID != 0 && this.createNewMetatileEntity(this.mID)) {
                NBTTagList tItemList = aNBT.getTagList("Inventory", 10);
                for (int i = 0; i < tItemList.tagCount(); ++i) {
                    NBTTagCompound tTag = tItemList.getCompoundTagAt(i);
                    int tSlot = tTag.getInteger("IntSlot");
                    if ((tSlot = this.shiftInventoryIndex(tSlot, nbtVersion)) < 0 || tSlot >= this.mMetaTileEntity.getRealInventory().length) continue;
                    this.mMetaTileEntity.getRealInventory()[tSlot] = GT_Utility.loadItem(tTag);
                }
                try {
                    this.mMetaTileEntity.loadNBTData(aNBT);
                }
                catch (Throwable e) {
                    GT_Log.err.println("Encountered Exception while loading MetaTileEntity, the Server should've crashed now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
                    e.printStackTrace(GT_Log.err);
                }
            }
        }
        if (this.mCoverData.length != 6) {
            this.mCoverData = new int[]{0, 0, 0, 0, 0, 0};
        }
        if (this.mCoverSides.length != 6) {
            this.mCoverSides = new int[]{0, 0, 0, 0, 0, 0};
        }
        if (this.mSidedRedstone.length != 6) {
            this.mSidedRedstone = this.hasValidMetaTileEntity() && this.mMetaTileEntity.hasSidedRedstoneOutputBehavior() ? new byte[]{0, 0, 0, 0, 0, 0} : new byte[]{15, 15, 15, 15, 15, 15};
        }
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
        }
    }

    private boolean createNewMetatileEntity(short aID) {
        if (aID > 0 && aID < GregTech_API.METATILEENTITIES.length && GregTech_API.METATILEENTITIES[aID] != null) {
            if (this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.setBaseMetaTileEntity(null);
            }
            GregTech_API.METATILEENTITIES[aID].newMetaEntity(this).setBaseMetaTileEntity(this);
            this.mTickTimer = 0L;
            this.mID = aID;
            return true;
        }
        GT_Log.err.println("MetaID " + aID + " not loadable => locking TileEntity!");
        return false;
    }

    public void updateStatus() {
    }

    public void chargeItem(ItemStack aStack) {
        this.decreaseStoredEU(GT_ModHandler.chargeElectricItem(aStack, (int)Math.min(Integer.MAX_VALUE, this.getStoredEU()), (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getOutputTier()), false, false), true);
    }

    public void dischargeItem(ItemStack aStack) {
        this.increaseStoredEnergyUnits(GT_ModHandler.dischargeElectricItem(aStack, (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity() - this.getStoredEU()), (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getInputTier()), false, false, false), true);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.hasValidMetaTileEntity()) {
            if (this.mMetaTileEntity == null) {
                return;
            }
            this.mMetaTileEntity.setBaseMetaTileEntity(this);
        }
        this.mRunningThroughTick = true;
        long tTime = System.nanoTime();
        int tCode = 0;
        boolean aSideServer = this.isServerSide();
        boolean aSideClient = this.isClientSide();
        try {
            tCode = 0;
            while (this.hasValidMetaTileEntity() && tCode >= 0) {
                switch (tCode) {
                    case 0: {
                        byte i;
                        ++tCode;
                        if (this.mTickTimer++ == 0L) {
                            this.oX = this.xCoord;
                            this.oY = this.yCoord;
                            this.oZ = this.zCoord;
                            if (aSideServer) {
                                for (i = 0; i < 6; i = (byte)(i + 1)) {
                                    if (this.getCoverIDAtSide(i) == 0 || this.mMetaTileEntity.allowCoverOnSide(i, new GT_ItemStack(this.getCoverIDAtSide(i)))) continue;
                                    this.dropCover(i, i, true);
                                }
                            }
                            this.worldObj.markTileEntityChunkModified(this.xCoord, this.yCoord, this.zCoord, (TileEntity)this);
                            this.mMetaTileEntity.onFirstTick(this);
                            if (!this.hasValidMetaTileEntity()) {
                                this.mRunningThroughTick = false;
                                return;
                            }
                        }
                    }
                    case 1: {
                        ++tCode;
                        if (aSideClient) {
                            if (this.mColor != this.oColor) {
                                this.oColor = this.mColor;
                                this.mMetaTileEntity.onColorChangeClient(this.oColor);
                                this.issueTextureUpdate();
                            }
                            if (this.mLightValue != this.oLightValueClient) {
                                this.worldObj.setLightValue(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord, (int)this.mLightValue);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord + 1, this.yCoord, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord - 1, this.yCoord, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord + 1, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord - 1, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord + 1);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord - 1);
                                this.oLightValueClient = this.mLightValue;
                                this.issueTextureUpdate();
                            }
                            if (this.mNeedsUpdate) {
                                this.worldObj.markBlockForUpdate(this.xCoord, this.yCoord, this.zCoord);
                                this.mNeedsUpdate = false;
                            }
                        }
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        byte i;
                        if (aSideServer && this.mTickTimer > 10L) {
                            for (i = (byte)(tCode - 2); i < 6; i = (byte)(i + 1)) {
                                if (this.getCoverIDAtSide(i) == 0) continue;
                                ++tCode;
                                GT_CoverBehavior tCover = this.getCoverBehaviorAtSide(i);
                                int tCoverTickRate = tCover.getTickRate(i, this.getCoverIDAtSide(i), this.mCoverData[i], this);
                                if (tCoverTickRate <= 0 || this.mTickTimer % (long)tCoverTickRate != 0L) continue;
                                byte tRedstone = tCover.isRedstoneSensitive(i, this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer) ? this.getInputRedstoneSignal(i) : (byte)0;
                                this.mCoverData[i] = tCover.doCoverThings(i, tRedstone, this.getCoverIDAtSide(i), this.mCoverData[i], this, this.mTickTimer);
                                if (this.hasValidMetaTileEntity()) continue;
                                this.mRunningThroughTick = false;
                                return;
                            }
                        }
                    }
                    case 8: {
                        tCode = 9;
                        if (aSideServer) {
                            if (++this.mAverageEUInputIndex >= this.mAverageEUInput.length) {
                                this.mAverageEUInputIndex = 0;
                            }
                            if (++this.mAverageEUOutputIndex >= this.mAverageEUOutput.length) {
                                this.mAverageEUOutputIndex = 0;
                            }
                            this.mAverageEUInput[this.mAverageEUInputIndex] = 0L;
                            this.mAverageEUOutput[this.mAverageEUOutputIndex] = 0L;
                        }
                    }
                    case 9: {
                        ++tCode;
                        this.mMetaTileEntity.onPreTick(this, this.mTickTimer);
                        if (!this.hasValidMetaTileEntity()) {
                            this.mRunningThroughTick = false;
                            return;
                        }
                    }
                    case 10: {
                        byte i;
                        ++tCode;
                        if (aSideServer) {
                            if (this.mRedstone != this.oRedstone || this.mTickTimer == 10L) {
                                for (i = 0; i < 6; i = (byte)(i + 1)) {
                                    this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
                                }
                                this.oRedstone = this.mRedstone;
                                this.issueBlockUpdate();
                            }
                            if (this.mTickTimer == 10L) {
                                this.joinEnet();
                            }
                            if (this.xCoord != this.oX || this.yCoord != this.oY || this.zCoord != this.oZ) {
                                this.oX = this.xCoord;
                                this.oY = this.yCoord;
                                this.oZ = this.zCoord;
                                this.issueClientUpdate();
                                this.clearTileEntityBuffer();
                            }
                            if (this.mFacing != this.oFacing) {
                                this.oFacing = this.mFacing;
                                for (i = 0; i < 6; i = (byte)(i + 1)) {
                                    if (this.getCoverIDAtSide(i) == 0 || this.mMetaTileEntity.allowCoverOnSide(i, new GT_ItemStack(this.getCoverIDAtSide(i)))) continue;
                                    this.dropCover(i, i, true);
                                }
                                this.issueBlockUpdate();
                            }
                            if (this.mTickTimer > 20L && this.mMetaTileEntity.isElectric()) {
                                this.mAcceptedAmperes = 0L;
                                if (this.getOutputVoltage() != this.oOutput) {
                                    this.oOutput = this.getOutputVoltage();
                                }
                                if (this.mMetaTileEntity.isEnetOutput() || this.mMetaTileEntity.isEnetInput()) {
                                    for (i = 0; i < 6; i = (byte)(i + 1)) {
                                        boolean temp = this.isEnergyInputSide(i);
                                        if (temp != this.mActiveEUInputs[i]) {
                                            this.mActiveEUInputs[i] = temp;
                                        }
                                        if ((temp = this.isEnergyOutputSide(i)) == this.mActiveEUOutputs[i]) continue;
                                        this.mActiveEUOutputs[i] = temp;
                                    }
                                }
                                if (this.mMetaTileEntity.isEnetOutput() && this.oOutput > 0L) {
                                    long tOutputVoltage = Math.max(this.oOutput, this.oOutput + (long)(1 << GT_Utility.getTier(this.oOutput)));
                                    long tUsableAmperage = Math.min(this.getOutputAmperage(), (this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU()) / tOutputVoltage);
                                    if (tUsableAmperage > 0L) {
                                        long tEU = tOutputVoltage * IEnergyConnected.Util.emitEnergyToNetwork(this.oOutput, tUsableAmperage, this);
                                        int n = this.mAverageEUOutputIndex;
                                        this.mAverageEUOutput[n] = this.mAverageEUOutput[n] + tEU;
                                        this.decreaseStoredEU(tEU, true);
                                    }
                                }
                                if (this.getEUCapacity() > 0L) {
                                    Block tBlock;
                                    if (GregTech_API.sMachineFireExplosions && this.getRandomNumber(1000) == 0 && (tBlock = this.getBlockAtSide((byte)this.getRandomNumber(6))) instanceof BlockFire) {
                                        this.doEnergyExplosion();
                                    }
                                    if (!this.hasValidMetaTileEntity()) {
                                        this.mRunningThroughTick = false;
                                        return;
                                    }
                                    if (this.getRandomNumber(1000) == 0) {
                                        int precipitationHeightAtSide2 = this.worldObj.getPrecipitationHeight(this.xCoord, this.zCoord - 1);
                                        int precipitationHeightAtSide3 = this.worldObj.getPrecipitationHeight(this.xCoord, this.zCoord + 1);
                                        int precipitationHeightAtSide4 = this.worldObj.getPrecipitationHeight(this.xCoord - 1, this.zCoord);
                                        int precipitationHeightAtSide5 = this.worldObj.getPrecipitationHeight(this.xCoord + 1, this.zCoord);
                                        if (this.getCoverIDAtSide((byte)1) == 0 && this.worldObj.getPrecipitationHeight(this.xCoord, this.zCoord) - 2 < this.yCoord || this.getCoverIDAtSide((byte)2) == 0 && precipitationHeightAtSide2 - 1 < this.yCoord && precipitationHeightAtSide2 > -1 || this.getCoverIDAtSide((byte)3) == 0 && precipitationHeightAtSide3 - 1 < this.yCoord && precipitationHeightAtSide3 > -1 || this.getCoverIDAtSide((byte)4) == 0 && precipitationHeightAtSide4 - 1 < this.yCoord && precipitationHeightAtSide4 > -1 || this.getCoverIDAtSide((byte)5) == 0 && precipitationHeightAtSide5 - 1 < this.yCoord && precipitationHeightAtSide5 > -1) {
                                            if (GregTech_API.sMachineRainExplosions && this.worldObj.isRaining() && this.getBiome().rainfall > 0.0f) {
                                                if (this.getRandomNumber(10) == 0) {
                                                    try {
                                                        GT_Mod.achievements.issueAchievement(this.getWorldObj().getPlayerEntityByName(this.mOwnerName), "badweather");
                                                    }
                                                    catch (Exception exception) {
                                                        // empty catch block
                                                    }
                                                    GT_Log.exp.println("Machine at: " + this.getXCoord() + " | " + this.getYCoord() + " | " + this.getZCoord() + " DIMID: " + this.worldObj.provider.dimensionId + " explosion due to rain!");
                                                    this.doEnergyExplosion();
                                                } else {
                                                    GT_Log.exp.println("Machine at: " + this.getXCoord() + " | " + this.getYCoord() + " | " + this.getZCoord() + " DIMID: " + this.worldObj.provider.dimensionId + "  set to Fire due to rain!");
                                                    this.setOnFire();
                                                }
                                            }
                                            if (!this.hasValidMetaTileEntity()) {
                                                this.mRunningThroughTick = false;
                                                return;
                                            }
                                            if (GregTech_API.sMachineThunderExplosions && this.worldObj.isThundering() && this.getBiome().rainfall > 0.0f && this.getRandomNumber(3) == 0) {
                                                try {
                                                    GT_Mod.achievements.issueAchievement(this.getWorldObj().getPlayerEntityByName(this.mOwnerName), "badweather");
                                                }
                                                catch (Exception exception) {
                                                    // empty catch block
                                                }
                                                GT_Log.exp.println("Machine at: " + this.getXCoord() + " | " + this.getYCoord() + " | " + this.getZCoord() + " DIMID: " + this.worldObj.provider.dimensionId + " explosion due to Thunderstorm!");
                                                this.doEnergyExplosion();
                                            }
                                        }
                                    }
                                }
                            }
                            if (!this.hasValidMetaTileEntity()) {
                                this.mRunningThroughTick = false;
                                return;
                            }
                        }
                    }
                    case 11: {
                        int k;
                        ++tCode;
                        if (aSideServer && this.mMetaTileEntity.dechargerSlotCount() > 0 && this.getStoredEU() < this.getEUCapacity()) {
                            int i;
                            k = this.mMetaTileEntity.dechargerSlotCount() + i;
                            for (i = this.mMetaTileEntity.dechargerSlotStartIndex(); i < k; ++i) {
                                if (this.mMetaTileEntity.mInventory[i] == null || this.getStoredEU() >= this.getEUCapacity()) continue;
                                this.dischargeItem(this.mMetaTileEntity.mInventory[i]);
                                if (Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]) > 0.0 && (double)this.getStoredEU() + Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]) < (double)this.getEUCapacity()) {
                                    this.increaseStoredEnergyUnits((long)Info.itemEnergy.getEnergyValue(this.mMetaTileEntity.mInventory[i]), false);
                                    --this.mMetaTileEntity.mInventory[i].stackSize;
                                    this.mInventoryChanged = true;
                                }
                                if (this.mMetaTileEntity.mInventory[i].stackSize > 0) continue;
                                this.mMetaTileEntity.mInventory[i] = null;
                                this.mInventoryChanged = true;
                            }
                        }
                    }
                    case 12: {
                        int k;
                        ++tCode;
                        if (aSideServer && this.mMetaTileEntity.rechargerSlotCount() > 0 && this.getStoredEU() > 0L) {
                            int i;
                            k = this.mMetaTileEntity.rechargerSlotCount() + i;
                            for (i = this.mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                                if (this.getStoredEU() <= 0L || this.mMetaTileEntity.mInventory[i] == null) continue;
                                this.chargeItem(this.mMetaTileEntity.mInventory[i]);
                                if (this.mMetaTileEntity.mInventory[i].stackSize > 0) continue;
                                this.mMetaTileEntity.mInventory[i] = null;
                                this.mInventoryChanged = true;
                            }
                        }
                    }
                    case 13: {
                        ++tCode;
                        this.updateStatus();
                        if (!this.hasValidMetaTileEntity()) {
                            this.mRunningThroughTick = false;
                            return;
                        }
                    }
                    case 14: {
                        ++tCode;
                        this.mMetaTileEntity.onPostTick(this, this.mTickTimer);
                        if (!this.hasValidMetaTileEntity()) {
                            this.mRunningThroughTick = false;
                            return;
                        }
                    }
                    case 15: {
                        ++tCode;
                        if (!aSideServer) break;
                        if (this.mTickTimer > 20L && this.cableUpdateDelay == 0) {
                            this.generatePowerNodes();
                            --this.cableUpdateDelay;
                        } else {
                            --this.cableUpdateDelay;
                        }
                        if (this.mTickTimer % 10L == 0L && this.mSendClientData) {
                            this.oTextureData = (byte)(this.mFacing & 7 | (this.mActive ? 8 : 0) | (this.mRedstone ? 16 : 0) | (this.mLockUpgrade ? 32 : 0) | (this.mWorks ? 64 : 0));
                            this.oTexturePage = this.hasValidMetaTileEntity() && this.mMetaTileEntity instanceof GT_MetaTileEntity_Hatch ? ((GT_MetaTileEntity_Hatch)this.mMetaTileEntity).getTexturePage() : (byte)0;
                            this.oUpdateData = this.hasValidMetaTileEntity() ? this.mMetaTileEntity.getUpdateData() : (byte)0;
                            this.oRedstoneData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0));
                            this.oColor = this.mColor;
                            GT_Values.NW.sendPacketToAllPlayersInRange(this.worldObj, new GT_Packet_TileEntity(this.xCoord, (short)this.yCoord, this.zCoord, this.mID, this.mCoverSides[0], this.mCoverSides[1], this.mCoverSides[2], this.mCoverSides[3], this.mCoverSides[4], this.mCoverSides[5], this.oTextureData, this.oTexturePage, this.oUpdateData, this.oRedstoneData, this.oColor), this.xCoord, this.zCoord);
                            this.mSendClientData = false;
                        }
                        if (this.mTickTimer > 10L) {
                            byte tData = (byte)(this.mFacing & 7 | (this.mActive ? 8 : 0) | (this.mRedstone ? 16 : 0) | (this.mLockUpgrade ? 32 : 0) | (this.mWorks ? 64 : 0));
                            if (tData != this.oTextureData) {
                                this.oTextureData = tData;
                                this.sendBlockEvent((byte)0, this.oTextureData);
                            }
                            if ((tData = this.mMetaTileEntity.getUpdateData()) != this.oUpdateData) {
                                this.oUpdateData = tData;
                                this.sendBlockEvent((byte)1, this.oUpdateData);
                            }
                            if (this.mMetaTileEntity instanceof GT_MetaTileEntity_Hatch && (tData = ((GT_MetaTileEntity_Hatch)this.mMetaTileEntity).getTexturePage()) != this.oTexturePage) {
                                this.oTexturePage = tData;
                                this.sendBlockEvent((byte)1, (byte)(this.oTexturePage | 0x80));
                            }
                            if (this.mColor != this.oColor) {
                                this.oColor = this.mColor;
                                this.sendBlockEvent((byte)2, this.oColor);
                            }
                            if ((tData = (byte)((this.mSidedRedstone[0] > 0 ? 1 : 0) | (this.mSidedRedstone[1] > 0 ? 2 : 0) | (this.mSidedRedstone[2] > 0 ? 4 : 0) | (this.mSidedRedstone[3] > 0 ? 8 : 0) | (this.mSidedRedstone[4] > 0 ? 16 : 0) | (this.mSidedRedstone[5] > 0 ? 32 : 0))) != this.oRedstoneData) {
                                this.oRedstoneData = tData;
                                this.sendBlockEvent((byte)3, this.oRedstoneData);
                            }
                            if (this.mLightValue != this.oLightValue) {
                                this.worldObj.setLightValue(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord, (int)this.mLightValue);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord + 1, this.yCoord, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord - 1, this.yCoord, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord + 1, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord - 1, this.zCoord);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord + 1);
                                this.worldObj.updateLightByType(EnumSkyBlock.Block, this.xCoord, this.yCoord, this.zCoord - 1);
                                this.issueTextureUpdate();
                                this.oLightValue = this.mLightValue;
                                this.sendBlockEvent((byte)7, this.oLightValue);
                            }
                        }
                        if (!this.mNeedsBlockUpdate) break;
                        this.updateNeighbours(this.mStrongRedstone, this.oStrongRedstone);
                        this.oStrongRedstone = this.mStrongRedstone;
                        this.mNeedsBlockUpdate = false;
                    }
                }
                tCode = -1;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(GT_Log.err);
        }
        if (aSideServer && this.hasValidMetaTileEntity()) {
            tTime = System.nanoTime() - tTime;
            if (this.mTimeStatistics.length > 0) {
                this.mTimeStatisticsIndex = (this.mTimeStatisticsIndex + 1) % this.mTimeStatistics.length;
                this.mTimeStatistics[this.mTimeStatisticsIndex] = (int)tTime;
            }
            if (tTime > 0L && tTime > (long)(GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING * 1000000) && this.mTickTimer > 1000L && this.getMetaTileEntity().doTickProfilingMessageDuringThisTick() && this.mLagWarningCount++ < 10) {
                GT_Mod.GT_FML_LOGGER.warn("WARNING: Possible Lag Source at [" + this.xCoord + ", " + this.yCoord + ", " + this.zCoord + "] in Dimension " + this.worldObj.provider.dimensionId + " with " + tTime + "ns caused by an instance of " + this.getMetaTileEntity().getClass());
            }
        }
        this.mRunningThroughTick = false;
        this.mInventoryChanged = false;
        this.mWorkUpdate = false;
    }

    public Packet getDescriptionPacket() {
        this.issueClientUpdate();
        return null;
    }

    public final void receiveMetaTileEntityData(short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aTextureData, byte aTexturePage, byte aUpdateData, byte aRedstoneData, byte aColorData) {
        this.issueTextureUpdate();
        if (this.mID != aID && aID > 0) {
            this.mID = aID;
            this.createNewMetatileEntity(this.mID);
        }
        this.mCoverSides[0] = aCover0;
        this.mCoverSides[1] = aCover1;
        this.mCoverSides[2] = aCover2;
        this.mCoverSides[3] = aCover3;
        this.mCoverSides[4] = aCover4;
        this.mCoverSides[5] = aCover5;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
        }
        this.receiveClientEvent(0, aTextureData);
        this.receiveClientEvent(1, aUpdateData & 0x7F);
        this.receiveClientEvent(1, aTexturePage | 0x80);
        this.receiveClientEvent(2, aColorData);
        this.receiveClientEvent(3, aRedstoneData);
    }

    @Deprecated
    public final void receiveMetaTileEntityData(short aID, int aCover0, int aCover1, int aCover2, int aCover3, int aCover4, int aCover5, byte aTextureData, byte aUpdateData, byte aRedstoneData, byte aColorData) {
        this.issueTextureUpdate();
        if (this.mID != aID && aID > 0) {
            this.mID = aID;
            this.createNewMetatileEntity(this.mID);
        }
        this.mCoverSides[0] = aCover0;
        this.mCoverSides[1] = aCover1;
        this.mCoverSides[2] = aCover2;
        this.mCoverSides[3] = aCover3;
        this.mCoverSides[4] = aCover4;
        this.mCoverSides[5] = aCover5;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            this.mCoverBehaviors[i] = GregTech_API.getCoverBehavior(this.mCoverSides[i]);
        }
        this.receiveClientEvent(0, aTextureData);
        this.receiveClientEvent(1, aUpdateData & 0x7F);
        this.receiveClientEvent(1, 128);
        this.receiveClientEvent(2, aColorData);
        this.receiveClientEvent(3, aRedstoneData);
    }

    public boolean receiveClientEvent(int aEventID, int aValue) {
        super.receiveClientEvent(aEventID, aValue);
        if (this.hasValidMetaTileEntity()) {
            try {
                this.mMetaTileEntity.receiveClientEvent((byte)aEventID, (byte)aValue);
            }
            catch (Throwable e) {
                GT_Log.err.println("Encountered Exception while receiving Data from the Server, the Client should've been crashed by now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
                e.printStackTrace(GT_Log.err);
            }
        }
        if (this.isClientSide()) {
            this.issueTextureUpdate();
            switch (aEventID) {
                case 0: {
                    this.mFacing = (byte)(aValue & 7);
                    this.mActive = (aValue & 8) != 0;
                    this.mRedstone = (aValue & 0x10) != 0;
                    this.mWorks = (aValue & 0x40) != 0;
                    break;
                }
                case 1: {
                    if (!this.hasValidMetaTileEntity()) break;
                    if ((aValue & 0x80) == 0) {
                        this.mMetaTileEntity.onValueUpdate((byte)(aValue & 0x7F));
                        break;
                    }
                    if (!(this.mMetaTileEntity instanceof GT_MetaTileEntity_Hatch)) break;
                    ((GT_MetaTileEntity_Hatch)this.mMetaTileEntity).onTexturePageUpdate((byte)(aValue & 0x7F));
                    break;
                }
                case 2: {
                    if (aValue > 16 || aValue < 0) {
                        aValue = 0;
                    }
                    this.mColor = (byte)aValue;
                    break;
                }
                case 3: {
                    this.mSidedRedstone[0] = (byte)((aValue & 1) == 1 ? 15 : 0);
                    this.mSidedRedstone[1] = (byte)((aValue & 2) == 2 ? 15 : 0);
                    this.mSidedRedstone[2] = (byte)((aValue & 4) == 4 ? 15 : 0);
                    this.mSidedRedstone[3] = (byte)((aValue & 8) == 8 ? 15 : 0);
                    this.mSidedRedstone[4] = (byte)((aValue & 0x10) == 16 ? 15 : 0);
                    this.mSidedRedstone[5] = (byte)((aValue & 0x20) == 32 ? 15 : 0);
                    break;
                }
                case 4: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.doSound((byte)aValue, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                    break;
                }
                case 5: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.startSoundLoop((byte)aValue, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                    break;
                }
                case 6: {
                    if (!this.hasValidMetaTileEntity() || this.mTickTimer <= 20L) break;
                    this.mMetaTileEntity.stopSoundLoop((byte)aValue, (double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5);
                    break;
                }
                case 7: {
                    this.mLightValue = (byte)aValue;
                }
            }
        }
        return true;
    }

    public ArrayList<String> getDebugInfo(EntityPlayer aPlayer, int aLogLevel) {
        ArrayList<String> tList = new ArrayList<String>();
        if (aLogLevel > 2) {
            tList.add("Meta-ID: " + EnumChatFormatting.BLUE + this.mID + EnumChatFormatting.RESET + (this.canAccessData() ? EnumChatFormatting.GREEN + " valid" + EnumChatFormatting.RESET : EnumChatFormatting.RED + " invalid" + EnumChatFormatting.RESET) + (this.mMetaTileEntity == null ? EnumChatFormatting.RED + " MetaTileEntity == null!" + EnumChatFormatting.RESET : " "));
        }
        if (aLogLevel > 1) {
            if (this.mTimeStatistics.length > 0) {
                double tAverageTime = 0.0;
                double tWorstTime = 0.0;
                for (int tTime : this.mTimeStatistics) {
                    tAverageTime += (double)tTime;
                    if (!((double)tTime > tWorstTime)) continue;
                    tWorstTime = tTime;
                }
                tList.add("Average CPU load of ~" + GT_Utility.formatNumbers(tAverageTime / (double)this.mTimeStatistics.length) + "ns over " + GT_Utility.formatNumbers(this.mTimeStatistics.length) + " ticks with worst time of " + GT_Utility.formatNumbers(tWorstTime) + "ns.");
                tList.add("Recorded " + GT_Utility.formatNumbers(this.mMetaTileEntity.mSoundRequests) + " sound requests in " + GT_Utility.formatNumbers(this.mTickTimer - this.mLastCheckTick) + " ticks.");
                this.mLastCheckTick = this.mTickTimer;
                this.mMetaTileEntity.mSoundRequests = 0L;
            }
            if (this.mLagWarningCount > 0) {
                tList.add("Caused " + (this.mLagWarningCount >= 10 ? "more than 10" : Integer.valueOf(this.mLagWarningCount)) + " Lag Spike Warnings (anything taking longer than " + GregTech_API.MILLISECOND_THRESHOLD_UNTIL_LAG_WARNING + "ms) on the Server.");
            }
            tList.add("Is" + (this.mMetaTileEntity.isAccessAllowed(aPlayer) ? " " : EnumChatFormatting.RED + " not " + EnumChatFormatting.RESET) + "accessible for you");
        }
        if (aLogLevel > 0) {
            if (this.getSteamCapacity() > 0L && this.hasSteamEngineUpgrade()) {
                tList.add(GT_Utility.formatNumbers(this.getStoredSteam()) + " of " + GT_Utility.formatNumbers(this.getSteamCapacity()) + " Steam");
            }
            tList.add("Machine is " + (this.mActive ? EnumChatFormatting.GREEN + "active" + EnumChatFormatting.RESET : EnumChatFormatting.RED + "inactive" + EnumChatFormatting.RESET));
            if (!this.mHasEnoughEnergy) {
                tList.add(EnumChatFormatting.RED + "ATTENTION: This Device needs more power." + EnumChatFormatting.RESET);
            }
        }
        if (this.joinedIc2Enet) {
            tList.add("Joined IC2 ENet");
        }
        return this.mMetaTileEntity.getSpecialDebugInfo(this, aPlayer, aLogLevel, tList);
    }

    @Override
    public void issueTextureUpdate() {
        this.mNeedsUpdate = true;
    }

    @Override
    public void issueBlockUpdate() {
        this.mNeedsBlockUpdate = true;
    }

    @Override
    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    @Override
    public void issueCoverUpdate(byte aSide) {
        this.issueClientUpdate();
    }

    @Override
    public void receiveCoverData(byte coverSide, int coverID, int coverData) {
        if (coverSide >= 0 && coverSide < 6 && this.mCoverSides[coverSide] == coverID) {
            this.setCoverDataAtSide(coverSide, coverData);
        }
    }

    @Override
    public byte getStrongestRedstone() {
        return (byte)Math.max(this.getInternalInputRedstoneSignal((byte)0), Math.max(this.getInternalInputRedstoneSignal((byte)1), Math.max(this.getInternalInputRedstoneSignal((byte)2), Math.max(this.getInternalInputRedstoneSignal((byte)3), Math.max(this.getInternalInputRedstoneSignal((byte)4), this.getInternalInputRedstoneSignal((byte)5))))));
    }

    @Override
    public boolean getRedstone() {
        return this.getRedstone((byte)0) || this.getRedstone((byte)1) || this.getRedstone((byte)2) || this.getRedstone((byte)3) || this.getRedstone((byte)4) || this.getRedstone((byte)5);
    }

    @Override
    public boolean getRedstone(byte aSide) {
        return this.getInternalInputRedstoneSignal(aSide) > 0;
    }

    public ITexture getCoverTexture(byte aSide) {
        if (this.getCoverIDAtSide(aSide) == 0) {
            return null;
        }
        if (GT_Mod.instance.isClientSide() && (GT_Client.hideValue & 1) != 0) {
            return Textures.BlockIcons.HIDDEN_TEXTURE[0];
        }
        return GregTech_API.sCovers.get(new GT_ItemStack(this.getCoverIDAtSide(aSide)));
    }

    @Override
    public boolean isGivingInformation() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isGivingInformation();
        }
        return false;
    }

    @Override
    public boolean isValidFacing(byte aSide) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isFacingValid(aSide);
        }
        return false;
    }

    @Override
    public byte getBackFacing() {
        return GT_Utility.getOppositeSide(this.mFacing);
    }

    @Override
    public byte getFrontFacing() {
        return this.mFacing;
    }

    @Override
    public void setFrontFacing(byte aFacing) {
        if (this.isValidFacing(aFacing)) {
            this.mFacing = aFacing;
            this.mMetaTileEntity.onFacingChange();
            this.doEnetUpdate();
            this.cableUpdateDelay = 10;
            if (this.mMetaTileEntity.shouldTriggerBlockUpdate()) {
                GregTech_API.causeMachineUpdate(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
            } else {
                this.onMachineBlockUpdate();
            }
        }
    }

    public int getSizeInventory() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getSizeInventory();
        }
        return 0;
    }

    public ItemStack getStackInSlot(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getStackInSlot(aIndex);
        }
        return null;
    }

    public void setInventorySlotContents(int aIndex, ItemStack aStack) {
        this.mInventoryChanged = true;
        if (this.canAccessData()) {
            this.mMetaTileEntity.setInventorySlotContents(aIndex, this.worldObj.isRemote ? aStack : GT_OreDictUnificator.setStack(true, aStack));
        }
    }

    public String getInventoryName() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getInventoryName();
        }
        if (GregTech_API.METATILEENTITIES[this.mID] != null) {
            return GregTech_API.METATILEENTITIES[this.mID].getInventoryName();
        }
        return "";
    }

    public int getInventoryStackLimit() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getInventoryStackLimit();
        }
        return 64;
    }

    public void openInventory() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onOpenGUI();
        }
    }

    public void closeInventory() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onCloseGUI();
        }
    }

    public boolean isUseableByPlayer(EntityPlayer aPlayer) {
        return this.canAccessData() && this.playerOwnsThis(aPlayer, false) && this.mTickTimer > 40L && this.getTileEntityOffset(0, 0, 0) == this && aPlayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) < 64.0 && this.mMetaTileEntity.isAccessAllowed(aPlayer);
    }

    @Override
    public void validate() {
        super.validate();
        this.mTickTimer = 0L;
    }

    @Override
    public void invalidate() {
        this.tileEntityInvalid = false;
        this.leaveEnet();
        if (this.canAccessData()) {
            if (GregTech_API.mAE2) {
                this.invalidateAE();
            }
            this.mMetaTileEntity.onRemoval();
            this.mMetaTileEntity.setBaseMetaTileEntity(null);
        }
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (GregTech_API.mAE2) {
            this.onChunkUnloadAE();
        }
    }

    public boolean hasCustomInventoryName() {
        return false;
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        if (stack != null) {
            this.setInventorySlotContents(slot, null);
        }
        return stack;
    }

    @Override
    public void onMachineBlockUpdate() {
        if (this.canAccessData()) {
            this.mMetaTileEntity.onMachineBlockUpdate();
        }
        this.cableUpdateDelay = 10;
    }

    @Override
    public boolean isMachineBlockUpdateRecursive() {
        return this.canAccessData() && this.mMetaTileEntity.isMachineBlockUpdateRecursive();
    }

    @Override
    public int getProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.getProgresstime() : 0;
    }

    @Override
    public int getMaxProgress() {
        return this.canAccessData() ? this.mMetaTileEntity.maxProgresstime() : 0;
    }

    @Override
    public boolean increaseProgress(int aProgressAmountInTicks) {
        return this.canAccessData() && this.mMetaTileEntity.increaseProgress(aProgressAmountInTicks) != aProgressAmountInTicks;
    }

    @Override
    public boolean hasThingsToDo() {
        return this.getMaxProgress() > 0;
    }

    @Override
    public void enableWorking() {
        if (!this.mWorks) {
            this.mWorkUpdate = true;
        }
        this.mWorks = true;
        this.mWasShutdown = false;
    }

    @Override
    public void disableWorking() {
        this.mWorks = false;
    }

    @Override
    public boolean isAllowedToWork() {
        return this.mWorks;
    }

    @Override
    public boolean hasWorkJustBeenEnabled() {
        return this.mWorkUpdate;
    }

    @Override
    public byte getWorkDataValue() {
        return this.mWorkData;
    }

    @Override
    public void setWorkDataValue(byte aValue) {
        this.mWorkData = aValue;
    }

    @Override
    public int getMetaTileID() {
        return this.mID;
    }

    @Override
    public int setMetaTileID(short aID) {
        this.mID = aID;
        return this.mID;
    }

    @Override
    public boolean isActive() {
        return this.mActive;
    }

    @Override
    public void setActive(boolean aActive) {
        this.mActive = aActive;
    }

    @Override
    public long getTimer() {
        return this.mTickTimer;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        this.mHasEnoughEnergy = this.decreaseStoredEU(aEnergy, aIgnoreTooLessEnergy) || this.decreaseStoredSteam(aEnergy, false) || aIgnoreTooLessEnergy && this.decreaseStoredSteam(aEnergy, true);
        return this.mHasEnoughEnergy;
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.getStoredEU() < this.getEUCapacity() || aIgnoreTooMuchEnergy) {
            this.setStoredEU(this.mMetaTileEntity.getEUVar() + aEnergy);
            return true;
        }
        return false;
    }

    @Override
    public boolean inputEnergyFrom(byte aSide) {
        return this.inputEnergyFrom(aSide, true);
    }

    @Override
    public boolean inputEnergyFrom(byte aSide, boolean waitForActive) {
        if (aSide == 6) {
            return true;
        }
        if (this.isServerSide() && waitForActive) {
            return aSide >= 0 && aSide < 6 && this.mActiveEUInputs[aSide] && !this.mReleaseEnergy;
        }
        return this.isEnergyInputSide(aSide);
    }

    @Override
    public boolean outputsEnergyTo(byte aSide) {
        return this.outputsEnergyTo(aSide, true);
    }

    @Override
    public boolean outputsEnergyTo(byte aSide, boolean waitForActive) {
        if (aSide == 6) {
            return true;
        }
        if (this.isServerSide() && waitForActive) {
            return aSide >= 0 && aSide < 6 && this.mActiveEUOutputs[aSide] || this.mReleaseEnergy;
        }
        return this.isEnergyOutputSide(aSide);
    }

    public void generatePowerNodes() {
        if (this.isServerSide() && this.mMetaTileEntity != null && (this.mMetaTileEntity.isEnetInput() || this.mMetaTileEntity.isEnetOutput())) {
            int time = MinecraftServer.getServer().getTickCounter();
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                IGregTechTileEntity TE;
                if (!this.outputsEnergyTo(i, false) && !this.inputEnergyFrom(i, false) || !((TE = this.getIGregTechTileEntityAtSide(i)) instanceof BaseMetaPipeEntity)) continue;
                Node node = ((BaseMetaPipeEntity)TE).getNode();
                if (node == null) {
                    new GenerateNodeMapPower((BaseMetaPipeEntity)TE);
                    continue;
                }
                if (node.mCreationTime == time) continue;
                GenerateNodeMap.clearNodeMap(node, -1);
                new GenerateNodeMapPower((BaseMetaPipeEntity)TE);
            }
        }
    }

    @Override
    public long getOutputAmperage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxAmperesOut();
        }
        return 0L;
    }

    @Override
    public long getOutputVoltage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
            return this.mMetaTileEntity.maxEUOutput();
        }
        return 0L;
    }

    @Override
    public long getInputAmperage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxAmperesIn();
        }
        return 0L;
    }

    @Override
    public long getInputVoltage() {
        if (this.canAccessData() && this.mMetaTileEntity.isElectric()) {
            return this.mMetaTileEntity.maxEUInput();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean increaseStoredSteam(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getSteamVar() < this.getSteamCapacity() || aIgnoreTooMuchEnergy) {
            this.setStoredSteam(this.mMetaTileEntity.getSteamVar() + aEnergy);
            return true;
        }
        return false;
    }

    @Override
    public String[] getDescription() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getDescription();
        }
        return new String[0];
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isValidSlot(aIndex);
        }
        return false;
    }

    @Override
    public long getUniversalEnergyStored() {
        return Math.max(this.getStoredEU(), this.getStoredSteam());
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return Math.max(this.getEUCapacity(), this.getSteamCapacity());
    }

    @Override
    public long getStoredEU() {
        if (this.canAccessData()) {
            return Math.min(this.mMetaTileEntity.getEUVar(), this.getEUCapacity());
        }
        return 0L;
    }

    @Override
    public long getEUCapacity() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.maxEUStore();
        }
        return 0L;
    }

    @Override
    public long getStoredSteam() {
        if (this.canAccessData()) {
            return Math.min(this.mMetaTileEntity.getSteamVar(), this.getSteamCapacity());
        }
        return 0L;
    }

    @Override
    public long getSteamCapacity() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.maxSteamStore();
        }
        return 0L;
    }

    @Override
    public ITexture[] getTexture(Block aBlock, byte aSide) {
        ITexture[] textureUncovered;
        ITexture coverTexture = this.getCoverTexture(aSide);
        ITexture[] iTextureArray = this.hasValidMetaTileEntity() ? this.mMetaTileEntity.getTexture(this, aSide, this.mFacing, (byte)(this.mColor - 1), this.mActive, this.getOutputRedstoneSignal(aSide) > 0) : (textureUncovered = Textures.BlockIcons.ERROR_RENDERING);
        if (coverTexture != null) {
            ITexture[] textureCovered = Arrays.copyOf(textureUncovered, textureUncovered.length + 1);
            textureCovered[textureUncovered.length] = coverTexture;
            return textureCovered;
        }
        return textureUncovered;
    }

    private boolean isEnergyInputSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            if (!this.getCoverBehaviorAtSide(aSide).letsEnergyIn(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
                return false;
            }
            if (this.isInvalid() || this.mReleaseEnergy) {
                return false;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetInput()) {
                return this.mMetaTileEntity.isInputFacing(aSide);
            }
        }
        return false;
    }

    private boolean isEnergyOutputSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            if (!this.getCoverBehaviorAtSide(aSide).letsEnergyOut(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
                return false;
            }
            if (this.isInvalid() || this.mReleaseEnergy) {
                return this.mReleaseEnergy;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
                return this.mMetaTileEntity.isOutputFacing(aSide);
            }
        }
        return false;
    }

    protected boolean hasValidMetaTileEntity() {
        return this.mMetaTileEntity != null && this.mMetaTileEntity.getBaseMetaTileEntity() == this;
    }

    protected boolean canAccessData() {
        return !this.isDead && this.hasValidMetaTileEntity();
    }

    public boolean setStoredEU(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setEUVar(aEnergy);
        return true;
    }

    public boolean setStoredSteam(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setSteamVar(aEnergy);
        return true;
    }

    public boolean decreaseStoredEU(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getEUVar() - aEnergy >= 0L || aIgnoreTooLessEnergy) {
            this.setStoredEU(this.mMetaTileEntity.getEUVar() - aEnergy);
            if (this.mMetaTileEntity.getEUVar() < 0L) {
                this.setStoredEU(0L);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean decreaseStoredSteam(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getSteamVar() - aEnergy >= 0L || aIgnoreTooLessEnergy) {
            this.setStoredSteam(this.mMetaTileEntity.getSteamVar() - aEnergy);
            if (this.mMetaTileEntity.getSteamVar() < 0L) {
                this.setStoredSteam(0L);
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean playerOwnsThis(EntityPlayer aPlayer, boolean aCheckPrecicely) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aCheckPrecicely || this.privateAccess() || this.mOwnerName.length() == 0) {
            if (this.mOwnerName.length() == 0 && this.isServerSide()) {
                this.setOwnerName(aPlayer.getDisplayName());
                this.setOwnerUuid(aPlayer.getUniqueID());
            } else {
                return !this.privateAccess() || aPlayer.getDisplayName().equals("Player") || this.mOwnerName.equals("Player") || this.mOwnerName.equals(aPlayer.getDisplayName());
            }
        }
        return true;
    }

    public boolean privateAccess() {
        if (!this.canAccessData()) {
            return this.mLockUpgrade;
        }
        return this.mLockUpgrade || this.mMetaTileEntity.ownerControl();
    }

    public void doEnergyExplosion() {
        if (this.getUniversalEnergyCapacity() > 0L && this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 5L) {
            GT_Log.exp.println("Energy Explosion, injected " + this.getUniversalEnergyStored() + "EU >= " + (double)this.getUniversalEnergyCapacity() / 5.0 + "Capacity of the Machine!");
            this.doExplosion(this.oOutput * (long)(this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() ? 4 : (this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 2L ? 2 : 1)));
            GT_Mod.achievements.issueAchievement(this.getWorldObj().getPlayerEntityByName(this.mOwnerName), "electricproblems");
        }
    }

    @Override
    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            if (GregTech_API.sMachineWireFire && this.mMetaTileEntity.isElectric()) {
                try {
                    this.mReleaseEnergy = true;
                    IEnergyConnected.Util.emitEnergyToNetwork(GT_Values.V[5], Math.max(1L, this.getStoredEU() / GT_Values.V[5]), this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mReleaseEnergy = false;
            this.mMetaTileEntity.onExplosion();
            if (GT_Mod.gregtechproxy.mExplosionItemDrop) {
                for (int i = 0; i < this.getSizeInventory(); ++i) {
                    ItemStack tItem = this.getStackInSlot(i);
                    if (tItem == null || tItem.stackSize <= 0 || !this.isValidSlot(i)) continue;
                    this.dropItems(tItem);
                    this.setInventorySlotContents(i, null);
                }
            }
            if (this.mRecipeStuff != null) {
                for (int i = 0; i < 9; ++i) {
                    if (this.getRandomNumber(100) >= 50) continue;
                    this.dropItems(GT_Utility.loadItem(this.mRecipeStuff, "Ingredient." + i));
                }
            }
            GT_Pollution.addPollution(this, 100000);
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    public void dropItems(ItemStack tItem) {
        if (tItem == null) {
            return;
        }
        EntityItem tItemEntity = new EntityItem(this.worldObj, (double)((float)this.xCoord + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)this.yCoord + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), (double)((float)this.zCoord + XSTR.XSTR_INSTANCE.nextFloat() * 0.8f + 0.1f), new ItemStack(tItem.getItem(), tItem.stackSize, tItem.getItemDamage()));
        if (tItem.hasTagCompound()) {
            tItemEntity.getEntityItem().setTagCompound((NBTTagCompound)tItem.getTagCompound().copy());
        }
        tItemEntity.motionX = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581;
        tItemEntity.motionY = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581 + 0.2000000029802322;
        tItemEntity.motionZ = XSTR.XSTR_INSTANCE.nextGaussian() * 0.0500000007450581;
        tItemEntity.hurtResistantTime = 999999;
        tItemEntity.lifespan = 60000;
        try {
            if (ENTITY_ITEM_HEALTH_FIELD != null) {
                ENTITY_ITEM_HEALTH_FIELD.setInt(tItemEntity, 99999999);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.worldObj.spawnEntityInWorld((Entity)tItemEntity);
        tItem.stackSize = 0;
    }

    @Override
    public ArrayList<ItemStack> getDrops() {
        ItemStack rStack = new ItemStack(GregTech_API.sBlockMachines, 1, (int)this.mID);
        NBTTagCompound tNBT = new NBTTagCompound();
        if (this.mRecipeStuff != null && !this.mRecipeStuff.hasNoTags()) {
            tNBT.setTag("GT.CraftingComponents", (NBTBase)this.mRecipeStuff);
        }
        if (this.mMuffler) {
            tNBT.setBoolean("mMuffler", this.mMuffler);
        }
        if (this.mLockUpgrade) {
            tNBT.setBoolean("mLockUpgrade", this.mLockUpgrade);
        }
        if (this.mSteamConverter) {
            tNBT.setBoolean("mSteamConverter", this.mSteamConverter);
        }
        if (this.mColor > 0) {
            tNBT.setByte("mColor", this.mColor);
        }
        if (this.mOtherUpgrades > 0) {
            tNBT.setByte("mOtherUpgrades", this.mOtherUpgrades);
        }
        if (this.mStrongRedstone > 0) {
            tNBT.setByte("mStrongRedstone", this.mStrongRedstone);
        }
        for (int i = 0; i < this.mCoverSides.length; i = (int)((byte)(i + 1))) {
            if (this.mCoverSides[i] == 0) continue;
            tNBT.setIntArray("mCoverData", this.mCoverData);
            tNBT.setIntArray("mCoverSides", this.mCoverSides);
            break;
        }
        if (this.hasValidMetaTileEntity()) {
            this.mMetaTileEntity.setItemNBT(tNBT);
        }
        if (!tNBT.hasNoTags()) {
            rStack.setTagCompound(tNBT);
        }
        return new ArrayList<ItemStack>(Arrays.asList(rStack));
    }

    public int getUpgradeCount() {
        return (this.mMuffler ? 1 : 0) + (this.mLockUpgrade ? 1 : 0) + (this.mSteamConverter ? 1 : 0) + this.mOtherUpgrades;
    }

    @Override
    public boolean onRightclick(EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        if (this.isClientSide()) {
            if (aPlayer.isSneaking()) {
                byte tSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                return this.getCoverBehaviorAtSide(tSide).hasCoverGUI();
            }
            if (this.getCoverBehaviorAtSide(aSide).onCoverRightclickClient(aSide, this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverBehaviorAtSide(aSide).isGUIClickable(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
                return false;
            }
        }
        if (this.isServerSide() && (!this.privateAccess() || aPlayer.getDisplayName().equalsIgnoreCase(this.getOwnerName()))) {
            ItemStack tCurrentItem = aPlayer.inventory.getCurrentItem();
            if (tCurrentItem != null) {
                if (this.getColorization() >= 0 && GT_Utility.areStacksEqual(new ItemStack(Items.water_bucket, 1), tCurrentItem)) {
                    tCurrentItem.func_150996_a(Items.bucket);
                    this.setColorization((byte)(this.getColorization() >= 16 ? -2 : -1));
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWrenchList)) {
                    if (aPlayer.isSneaking() && this.mMetaTileEntity instanceof GT_MetaTileEntity_BasicMachine && ((GT_MetaTileEntity_BasicMachine)this.mMetaTileEntity).setMainFacing(GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ))) {
                        GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        this.cableUpdateDelay = 10;
                    } else if (this.mMetaTileEntity.onWrenchRightClick(aSide, GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ), aPlayer, aX, aY, aZ)) {
                        GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer);
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        this.cableUpdateDelay = 10;
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sScrewdriverList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 200, (EntityLivingBase)aPlayer)) {
                        this.setCoverDataAtSide(aSide, this.getCoverBehaviorAtSide(aSide).onCoverScrewdriverclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer, aX, aY, aZ));
                        this.mMetaTileEntity.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sHardHammerList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        boolean bl = this.mInputDisabled = !this.mInputDisabled;
                        if (this.mInputDisabled) {
                            this.mOutputDisabled = !this.mOutputDisabled;
                        }
                        GT_Utility.sendChatToPlayer(aPlayer, this.trans("086", "Auto-Input: ") + (this.mInputDisabled ? this.trans("087", "Disabled") : this.trans("088", "Enabled") + this.trans("089", "  Auto-Output: ") + (this.mOutputDisabled ? this.trans("087", "Disabled") : this.trans("088", "Enabled"))));
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(1), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSoftHammerList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        if (this.mWorks) {
                            this.disableWorking();
                        } else {
                            this.enableWorking();
                        }
                        String tChat = this.trans("090", "Machine Processing: ") + (this.isAllowedToWork() ? this.trans("088", "Enabled") : this.trans("087", "Disabled"));
                        if (this.getMetaTileEntity() != null && this.getMetaTileEntity().hasAlternativeModeText()) {
                            tChat = this.getMetaTileEntity().getAlternativeModeText();
                        }
                        GT_Utility.sendChatToPlayer(aPlayer, tChat);
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(101), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    }
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sSolderingToolList)) {
                    byte tSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
                    if (this.mMetaTileEntity.onSolderingToolRightClick(aSide, tSide, aPlayer, aX, aY, aZ)) {
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(103), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    } else if (GT_ModHandler.useSolderingIron(tCurrentItem, (EntityLivingBase)aPlayer)) {
                        this.mStrongRedstone = (byte)(this.mStrongRedstone ^ 1 << tSide);
                        GT_Utility.sendChatToPlayer(aPlayer, this.trans("091", "Redstone Output at Side ") + tSide + this.trans("092", " set to: ") + ((this.mStrongRedstone & 1 << tSide) != 0 ? this.trans("093", "Strong") : this.trans("094", "Weak")));
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(103), 3.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        this.issueBlockUpdate();
                    }
                    this.doEnetUpdate();
                    this.cableUpdateDelay = 10;
                    return true;
                }
                if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sWireCutterList)) {
                    byte tSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
                    if (this.mMetaTileEntity.onWireCutterRightClick(aSide, tSide, aPlayer, aX, aY, aZ)) {
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                    }
                    this.doEnetUpdate();
                    this.cableUpdateDelay = 10;
                    return true;
                }
                byte coverSide = aSide;
                if (this.getCoverIDAtSide(aSide) == 0) {
                    coverSide = GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ);
                }
                if (this.getCoverIDAtSide(coverSide) == 0) {
                    if (GregTech_API.sCovers.containsKey(new GT_ItemStack(tCurrentItem))) {
                        if (GregTech_API.getCoverBehavior(tCurrentItem).isCoverPlaceable(coverSide, new GT_ItemStack(tCurrentItem), this) && this.mMetaTileEntity.allowCoverOnSide(coverSide, new GT_ItemStack(tCurrentItem))) {
                            this.setCoverItemAtSide(coverSide, tCurrentItem);
                            if (!aPlayer.capabilities.isCreativeMode) {
                                --tCurrentItem.stackSize;
                            }
                            GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(100), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        }
                        return true;
                    }
                } else if (GT_Utility.isStackInList(tCurrentItem, GregTech_API.sCrowbarList)) {
                    if (GT_ModHandler.damageOrDechargeItem(tCurrentItem, 1, 1000, (EntityLivingBase)aPlayer)) {
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(0), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        this.dropCover(coverSide, aSide, false);
                    }
                    return true;
                }
            } else if (aPlayer.isSneaking()) {
                aSide = this.getCoverIDAtSide(aSide) == 0 ? GT_Utility.determineWrenchingSide(aSide, aX, aY, aZ) : aSide;
                return this.getCoverIDAtSide(aSide) > 0 && this.getCoverBehaviorAtSide(aSide).onCoverShiftRightclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer);
            }
            if (this.getCoverBehaviorAtSide(aSide).onCoverRightclick(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this, aPlayer, aX, aY, aZ)) {
                return true;
            }
            if (!this.getCoverBehaviorAtSide(aSide).isGUIClickable(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
                return false;
            }
            if (this.isUpgradable() && tCurrentItem != null) {
                if (ItemList.Upgrade_Muffler.isStackEqual(aPlayer.inventory.getCurrentItem())) {
                    if (this.addMufflerUpgrade()) {
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(3), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        if (!aPlayer.capabilities.isCreativeMode) {
                            --aPlayer.inventory.getCurrentItem().stackSize;
                        }
                    }
                    return true;
                }
                if (ItemList.Upgrade_Lock.isStackEqual(aPlayer.inventory.getCurrentItem())) {
                    if (this.isUpgradable() && !this.mLockUpgrade) {
                        this.mLockUpgrade = true;
                        this.setOwnerName(aPlayer.getDisplayName());
                        this.setOwnerUuid(aPlayer.getUniqueID());
                        GT_Utility.sendSoundToPlayers(this.worldObj, GregTech_API.sSoundList.get(3), 1.0f, -1.0f, this.xCoord, this.yCoord, this.zCoord);
                        if (!aPlayer.capabilities.isCreativeMode) {
                            --aPlayer.inventory.getCurrentItem().stackSize;
                        }
                    }
                    return true;
                }
            }
        }
        try {
            if (!aPlayer.isSneaking() && this.hasValidMetaTileEntity()) {
                return this.mMetaTileEntity.onRightclick(this, aPlayer, aSide, aX, aY, aZ);
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered Exception while rightclicking TileEntity, the Game should've crashed now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
        return false;
    }

    @Override
    public void onLeftclick(EntityPlayer aPlayer) {
        try {
            if (aPlayer != null && this.hasValidMetaTileEntity()) {
                this.mMetaTileEntity.onLeftclick(this, aPlayer);
            }
        }
        catch (Throwable e) {
            GT_Log.err.println("Encountered Exception while leftclicking TileEntity, the Game should've crashed now, but I prevented that. Please report immediately to GregTech Intergalactical!!!");
            e.printStackTrace(GT_Log.err);
        }
    }

    @Override
    public boolean isDigitalChest() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.isDigitalChest();
        }
        return false;
    }

    @Override
    public ItemStack[] getStoredItemData() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getStoredItemData();
        }
        return null;
    }

    @Override
    public void setItemCount(int aCount) {
        if (this.canAccessData()) {
            this.mMetaTileEntity.setItemCount(aCount);
        }
    }

    @Override
    public int getMaxItemCount() {
        if (this.canAccessData()) {
            return this.mMetaTileEntity.getMaxItemCount();
        }
        return 0;
    }

    public boolean isItemValidForSlot(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mMetaTileEntity.isItemValidForSlot(aIndex, aStack);
    }

    public int[] getAccessibleSlotsFromSide(int aSide) {
        if (this.canAccessData() && (this.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), -1, this) || this.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), -1, this))) {
            return this.mMetaTileEntity.getAccessibleSlotsFromSide(aSide);
        }
        return new int[0];
    }

    public boolean canInsertItem(int aIndex, ItemStack aStack, int aSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && this.getCoverBehaviorAtSide((byte)aSide).letsItemsIn((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), aIndex, this) && this.mMetaTileEntity.canInsertItem(aIndex, aStack, aSide);
    }

    public boolean canExtractItem(int aIndex, ItemStack aStack, int aSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && this.getCoverBehaviorAtSide((byte)aSide).letsItemsOut((byte)aSide, this.getCoverIDAtSide((byte)aSide), this.getCoverDataAtSide((byte)aSide), aIndex, this) && this.mMetaTileEntity.canExtractItem(aIndex, aStack, aSide);
    }

    @Override
    public boolean isUpgradable() {
        return this.canAccessData() && this.getUpgradeCount() < 8;
    }

    @Override
    public byte getInternalInputRedstoneSignal(byte aSide) {
        return (byte)(this.getCoverBehaviorAtSide(aSide).getRedstoneInput(aSide, this.getInputRedstoneSignal(aSide), this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this) & 0xF);
    }

    @Override
    public byte getInputRedstoneSignal(byte aSide) {
        return (byte)(this.worldObj.getIndirectPowerLevelTo(this.getOffsetX(aSide, 1), (int)this.getOffsetY(aSide, 1), this.getOffsetZ(aSide, 1), (int)aSide) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(byte aSide) {
        return this.getCoverBehaviorAtSide(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this) ? this.mSidedRedstone[aSide] : this.getGeneralRS(aSide);
    }

    public byte getGeneralRS(byte aSide) {
        if (this.mMetaTileEntity == null) {
            return 0;
        }
        return this.mMetaTileEntity.allowGeneralRedstoneOutput() ? this.mSidedRedstone[aSide] : (byte)0;
    }

    @Override
    public void setInternalOutputRedstoneSignal(byte aSide, byte aStrength) {
        if (!this.getCoverBehaviorAtSide(aSide).manipulatesSidedRedstoneOutput(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this)) {
            this.setOutputRedstoneSignal(aSide, aStrength);
        }
    }

    @Override
    public void setOutputRedstoneSignal(byte aSide, byte aStrength) {
        aStrength = (byte)Math.min(Math.max(0, aStrength), 15);
        if (aSide >= 0 && aSide < 6 && this.mSidedRedstone[aSide] != aStrength) {
            this.mSidedRedstone[aSide] = aStrength;
            this.issueBlockUpdate();
        }
    }

    @Override
    public boolean isSteamEngineUpgradable() {
        return this.isUpgradable() && !this.hasSteamEngineUpgrade() && this.getSteamCapacity() > 0L;
    }

    @Override
    public boolean addSteamEngineUpgrade() {
        if (this.isSteamEngineUpgradable()) {
            this.issueBlockUpdate();
            this.mSteamConverter = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasSteamEngineUpgrade() {
        if (this.canAccessData() && this.mMetaTileEntity.isSteampowered()) {
            return true;
        }
        return this.mSteamConverter;
    }

    @Override
    public boolean hasMufflerUpgrade() {
        return this.mMuffler;
    }

    @Override
    public boolean isMufflerUpgradable() {
        return this.isUpgradable() && !this.hasMufflerUpgrade();
    }

    @Override
    public boolean addMufflerUpgrade() {
        if (this.isMufflerUpgradable()) {
            this.mMuffler = true;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    @Override
    public void markInventoryBeenModified() {
        this.mInventoryChanged = true;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    @Override
    public int getErrorDisplayID() {
        return this.mDisplayErrorCode;
    }

    @Override
    public void setErrorDisplayID(int aErrorID) {
        this.mDisplayErrorCode = aErrorID;
    }

    @Override
    public IMetaTileEntity getMetaTileEntity() {
        return this.hasValidMetaTileEntity() ? this.mMetaTileEntity : null;
    }

    @Override
    public void setMetaTileEntity(IMetaTileEntity aMetaTileEntity) {
        this.mMetaTileEntity = (MetaTileEntity)aMetaTileEntity;
    }

    @Override
    public GT_CoverBehavior getCoverBehaviorAtSide(byte aSide) {
        return aSide >= 0 && aSide < this.mCoverBehaviors.length ? this.mCoverBehaviors[aSide] : GregTech_API.sNoBehavior;
    }

    @Override
    public void setCoverIDAtSide(byte aSide, int aID) {
        if (aSide >= 0 && aSide < 6) {
            this.mCoverSides[aSide] = aID;
            this.mCoverData[aSide] = 0;
            this.mCoverBehaviors[aSide] = GregTech_API.getCoverBehavior(aID);
            this.issueCoverUpdate(aSide);
            this.issueBlockUpdate();
        }
    }

    @Override
    public void setCoverItemAtSide(byte aSide, ItemStack aCover) {
        GregTech_API.getCoverBehavior(aCover).placeCover(aSide, aCover, this);
    }

    @Override
    public int getCoverIDAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverSides[aSide];
        }
        return 0;
    }

    @Override
    public ItemStack getCoverItemAtSide(byte aSide) {
        return GT_Utility.intToStack(this.getCoverIDAtSide(aSide));
    }

    @Override
    public boolean canPlaceCoverIDAtSide(byte aSide, int aID) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public boolean canPlaceCoverItemAtSide(byte aSide, ItemStack aCover) {
        return this.getCoverIDAtSide(aSide) == 0;
    }

    @Override
    public void setCoverDataAtSide(byte aSide, int aData) {
        if (aSide >= 0 && aSide < 6) {
            this.mCoverData[aSide] = aData;
        }
    }

    @Override
    public int getCoverDataAtSide(byte aSide) {
        if (aSide >= 0 && aSide < 6) {
            return this.mCoverData[aSide];
        }
        return 0;
    }

    public byte getLightValue() {
        return this.mLightValue;
    }

    @Override
    public void setLightValue(byte aLightValue) {
        this.mLightValue = (byte)(aLightValue & 0xF);
    }

    @Override
    public long getAverageElectricInput() {
        long rEU = 0L;
        for (int i = 0; i < this.mAverageEUInput.length; ++i) {
            if (i == this.mAverageEUInputIndex) continue;
            rEU += this.mAverageEUInput[i];
        }
        return rEU / (long)(this.mAverageEUInput.length - 1);
    }

    @Override
    public long getAverageElectricOutput() {
        long rEU = 0L;
        for (int i = 0; i < this.mAverageEUOutput.length; ++i) {
            if (i == this.mAverageEUOutputIndex) continue;
            rEU += this.mAverageEUOutput[i];
        }
        return rEU / (long)(this.mAverageEUOutput.length - 1);
    }

    @Override
    public boolean dropCover(byte aSide, byte aDroppedSide, boolean aForced) {
        if (this.getCoverBehaviorAtSide(aSide).onCoverRemoval(aSide, this.getCoverIDAtSide(aSide), this.mCoverData[aSide], this, aForced) || aForced) {
            ItemStack tStack = this.getCoverBehaviorAtSide(aSide).getDrop(aSide, this.getCoverIDAtSide(aSide), this.getCoverDataAtSide(aSide), this);
            if (tStack != null) {
                tStack.setTagCompound(null);
                EntityItem tEntity = new EntityItem(this.worldObj, (double)this.getOffsetX(aDroppedSide, 1) + 0.5, (double)this.getOffsetY(aDroppedSide, 1) + 0.5, (double)this.getOffsetZ(aDroppedSide, 1) + 0.5, tStack);
                tEntity.motionX = 0.0;
                tEntity.motionY = 0.0;
                tEntity.motionZ = 0.0;
                this.worldObj.spawnEntityInWorld((Entity)tEntity);
            }
            this.setCoverIDAtSide(aSide, 0);
            if (this.mMetaTileEntity.hasSidedRedstoneOutputBehavior()) {
                this.setOutputRedstoneSignal(aSide, (byte)0);
            } else {
                this.setOutputRedstoneSignal(aSide, (byte)15);
            }
            return true;
        }
        return false;
    }

    @Override
    public String getOwnerName() {
        if (GT_Utility.isStringInvalid(this.mOwnerName)) {
            return "Player";
        }
        return this.mOwnerName;
    }

    @Override
    public String setOwnerName(String aName) {
        if (GT_Utility.isStringInvalid(aName)) {
            this.mOwnerName = "Player";
            return "Player";
        }
        this.mOwnerName = aName;
        return this.mOwnerName;
    }

    @Override
    public UUID getOwnerUuid() {
        return this.mOwnerUuid;
    }

    @Override
    public void setOwnerUuid(UUID uuid) {
        this.mOwnerUuid = uuid;
    }

    @Override
    public byte getComparatorValue(byte aSide) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(aSide) : (byte)0;
    }

    @Override
    public byte getStrongOutputRedstoneSignal(byte aSide) {
        return aSide >= 0 && aSide < 6 && (this.mStrongRedstone & 1 << aSide) != 0 ? (byte)(this.mSidedRedstone[aSide] & 0xF) : (byte)0;
    }

    @Override
    public void setStrongOutputRedstoneSignal(byte aSide, byte aStrength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | 1 << aSide);
        this.setOutputRedstoneSignal(aSide, aStrength);
    }

    public ItemStack decrStackSize(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mMetaTileEntity.decrStackSize(aIndex, aAmount);
        }
        return null;
    }

    @Override
    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.inputEnergyFrom(aSide) && aAmperage > 0L && aVoltage > 0L && this.getStoredEU() < this.getEUCapacity() && this.mMetaTileEntity.maxAmperesIn() > this.mAcceptedAmperes)) {
            return 0L;
        }
        if (aVoltage > this.getInputVoltage()) {
            GT_Log.exp.println("Energy Explosion, injected " + aVoltage + "EU/t in a " + this.getInputVoltage() + "EU/t Machine!");
            this.doExplosion(aVoltage);
            return 0L;
        }
        if (this.increaseStoredEnergyUnits(aVoltage * (aAmperage = Math.min(aAmperage, Math.min(this.mMetaTileEntity.maxAmperesIn() - this.mAcceptedAmperes, 1L + (this.getEUCapacity() - this.getStoredEU()) / aVoltage))), true)) {
            int n = this.mAverageEUInputIndex;
            this.mAverageEUInput[n] = this.mAverageEUInput[n] + aVoltage * aAmperage;
            this.mAcceptedAmperes += aAmperage;
            return aAmperage;
        }
        return 0L;
    }

    @Override
    public boolean drainEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.outputsEnergyTo(aSide) && this.getStoredEU() - aVoltage * aAmperage >= this.mMetaTileEntity.getMinimumStoredEU())) {
            return false;
        }
        if (this.decreaseStoredEU(aVoltage * aAmperage, false)) {
            int n = this.mAverageEUOutputIndex;
            this.mAverageEUOutput[n] = this.mAverageEUOutput[n] + aVoltage * aAmperage;
            return true;
        }
        return false;
    }

    @Override
    public boolean acceptsRotationalEnergy(byte aSide) {
        if (!this.canAccessData() || this.getCoverIDAtSide(aSide) != 0) {
            return false;
        }
        return this.mMetaTileEntity.acceptsRotationalEnergy(aSide);
    }

    @Override
    public boolean injectRotationalEnergy(byte aSide, long aSpeed, long aEnergy) {
        if (!this.canAccessData() || this.getCoverIDAtSide(aSide) != 0) {
            return false;
        }
        return this.mMetaTileEntity.injectRotationalEnergy(aSide, aSpeed, aEnergy);
    }

    public int fill(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid == null ? null : aFluid.getFluid(), this))) {
            return this.mMetaTileEntity.fill(aSide, aFluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), this.mMetaTileEntity.getFluid() == null ? null : this.mMetaTileEntity.getFluid().getFluid(), this))) {
            return this.mMetaTileEntity.drain(aSide, maxDrain, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid == null ? null : aFluid.getFluid(), this))) {
            return this.mMetaTileEntity.drain(aSide, aFluid, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid, this))) {
            return this.mMetaTileEntity.canFill(aSide, aFluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        if (this.mTickTimer > 5L && this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), aFluid, this))) {
            return this.mMetaTileEntity.canDrain(aSide, aFluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        if (this.canAccessData() && (aSide == ForgeDirection.UNKNOWN || this.mMetaTileEntity.isLiquidInput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidIn((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), null, this) || this.mMetaTileEntity.isLiquidOutput((byte)aSide.ordinal()) && this.getCoverBehaviorAtSide((byte)aSide.ordinal()).letsFluidOut((byte)aSide.ordinal(), this.getCoverIDAtSide((byte)aSide.ordinal()), this.getCoverDataAtSide((byte)aSide.ordinal()), null, this))) {
            return this.mMetaTileEntity.getTankInfo(aSide);
        }
        return new FluidTankInfo[0];
    }

    public double getOutputEnergyUnitsPerTick() {
        return this.oOutput;
    }

    public boolean isTeleporterCompatible(ForgeDirection aSide) {
        return this.canAccessData() && this.mMetaTileEntity.isTeleporterCompatible();
    }

    public double demandedEnergyUnits() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0.0;
        }
        return this.getEUCapacity() - this.getStoredEU();
    }

    public double injectEnergyUnits(ForgeDirection aDirection, double aAmount) {
        return this.injectEnergyUnits((byte)aDirection.ordinal(), (int)aAmount, 1L) > 0L ? 0.0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return this.inputEnergyFrom((byte)aDirection.ordinal());
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return this.outputsEnergyTo((byte)aDirection.ordinal());
    }

    public double getOfferedEnergy() {
        return this.canAccessData() && this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU() >= this.oOutput ? (double)Math.max(0L, this.oOutput) : 0.0;
    }

    public void drawEnergy(double amount) {
        int n = this.mAverageEUOutputIndex;
        this.mAverageEUOutput[n] = (long)((double)this.mAverageEUOutput[n] + amount);
        this.decreaseStoredEU((int)amount, true);
    }

    public int injectEnergy(ForgeDirection aForgeDirection, int aAmount) {
        return this.injectEnergyUnits((byte)aForgeDirection.ordinal(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public int addEnergy(int aEnergy) {
        if (!this.canAccessData()) {
            return 0;
        }
        if (aEnergy > 0) {
            this.increaseStoredEnergyUnits(aEnergy, true);
        } else {
            this.decreaseStoredEU(-aEnergy, true);
        }
        return (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getEUVar());
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int demandsEnergy() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0;
        }
        return this.getCapacity() - this.getStored();
    }

    public int getCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity());
    }

    public int getStored() {
        return (int)Math.min(Integer.MAX_VALUE, Math.min(this.getStoredEU(), (long)this.getCapacity()));
    }

    public void setStored(int aEU) {
        if (this.canAccessData()) {
            this.setStoredEU(aEU);
        }
    }

    public int getMaxSafeInput() {
        return (int)Math.min(Integer.MAX_VALUE, this.getInputVoltage());
    }

    public int getMaxEnergyOutput() {
        if (this.mReleaseEnergy) {
            return Integer.MAX_VALUE;
        }
        return this.getOutput();
    }

    public int getOutput() {
        return (int)Math.min(Integer.MAX_VALUE, this.oOutput);
    }

    public int injectEnergy(Direction aDirection, int aAmount) {
        return this.injectEnergyUnits((byte)aDirection.toSideValue(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public boolean isTeleporterCompatible(Direction aSide) {
        return this.canAccessData() && this.mMetaTileEntity.isTeleporterCompatible();
    }

    public boolean acceptsEnergyFrom(TileEntity aReceiver, Direction aDirection) {
        return this.inputEnergyFrom((byte)aDirection.toSideValue());
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, Direction aDirection) {
        return this.outputsEnergyTo((byte)aDirection.toSideValue());
    }

    @Override
    public boolean isInvalidTileEntity() {
        return this.isInvalid();
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.getSizeInventory()) {
            return false;
        }
        ItemStack tStack = this.getStackInSlot(aIndex);
        if (GT_Utility.isStackInvalid(tStack)) {
            this.setInventorySlotContents(aIndex, aStack);
            return true;
        }
        if (GT_Utility.areStacksEqual(tStack, aStack = GT_OreDictUnificator.get(aStack)) && tStack.stackSize + aStack.stackSize <= Math.min(aStack.getMaxStackSize(), this.getInventoryStackLimit())) {
            tStack.stackSize += aStack.stackSize;
            return true;
        }
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GT_Utility.copyAmount(aAmount, aStack));
    }

    @Override
    public byte getColorization() {
        return (byte)(this.mColor - 1);
    }

    @Override
    public byte setColorization(byte aColor) {
        if (aColor > 15 || aColor < -1) {
            aColor = (byte)-1;
        }
        this.mColor = (byte)(aColor + 1);
        if (this.canAccessData()) {
            this.mMetaTileEntity.onColorChangeServer(aColor);
        }
        return this.mColor;
    }

    @Override
    public float getBlastResistance(byte aSide) {
        return this.canAccessData() ? Math.max(0.0f, this.getMetaTileEntity().getExplosionResistance(aSide)) : 10.0f;
    }

    @Override
    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        if (this.getUniversalEnergyStored() >= aEnergyAmount) {
            return true;
        }
        this.mHasEnoughEnergy = false;
        return false;
    }

    @Override
    public String[] getInfoData() {
        if (this.canAccessData()) {
            return this.getMetaTileEntity().getInfoData();
        }
        return new String[0];
    }

    @Override
    public void markDirty() {
        super.markDirty();
        this.mInventoryChanged = true;
    }

    @Override
    public int getLightOpacity() {
        return this.mMetaTileEntity == null ? (this.getLightValue() > 0 ? 0 : 255) : this.mMetaTileEntity.getLightOpacity();
    }

    @Override
    public void addCollisionBoxesToList(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        this.mMetaTileEntity.addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World aWorld, int aX, int aY, int aZ) {
        return this.mMetaTileEntity.getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
    }

    @Override
    public void onEntityCollidedWithBlock(World aWorld, int aX, int aY, int aZ, Entity collider) {
        this.mMetaTileEntity.onEntityCollidedWithBlock(aWorld, aX, aY, aZ, collider);
    }

    private int shiftInventoryIndex(int slotIndex, int nbtVersion) {
        int newOutputSize;
        int newInputSize;
        int oldOutputSize;
        int oldInputSize;
        int chemistryUpdateVersion = GT_Mod.calculateTotalGTVersion(509, 31);
        if (this.mID >= 211 && this.mID <= 218) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 2;
            oldOutputSize = 1;
            newInputSize = 6;
            newOutputSize = 1;
        } else if (this.mID >= 421 && this.mID <= 428) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 2;
            oldOutputSize = 1;
            newInputSize = 2;
            newOutputSize = 2;
        } else if (this.mID >= 531 && this.mID <= 538) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 1;
            oldOutputSize = 0;
            newInputSize = 1;
            newOutputSize = 1;
        } else if (this.mID >= 581 && this.mID <= 588) {
            if (nbtVersion >= chemistryUpdateVersion) {
                return slotIndex;
            }
            oldInputSize = 4;
            oldOutputSize = 1;
            newInputSize = 6;
            newOutputSize = 1;
        } else {
            return slotIndex;
        }
        int indexShift = 0;
        if (slotIndex >= 4 + oldInputSize) {
            indexShift += newInputSize - oldInputSize;
        }
        if (slotIndex >= 4 + oldInputSize + oldOutputSize) {
            indexShift += newOutputSize - oldOutputSize;
        }
        return slotIndex + indexShift;
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(ForgeDirection forgeDirection) {
        if (this.mFacing != forgeDirection.ordinal()) {
            return null;
        }
        AENetworkProxy gp = this.getProxy();
        return gp != null ? gp.getNode() : null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.mMetaTileEntity == null ? AECableType.NONE : this.mMetaTileEntity.getCableConnectionType(forgeDirection);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        AENetworkProxy gp = this.getProxy();
        return gp != null ? gp.getNode() : null;
    }

    @Optional.Method(modid="appliedenergistics2")
    public AENetworkProxy getProxy() {
        return this.mMetaTileEntity == null ? null : this.mMetaTileEntity.getProxy();
    }

    @Optional.Method(modid="appliedenergistics2")
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void gridChanged() {
        if (this.mMetaTileEntity != null) {
            this.mMetaTileEntity.gridChanged();
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_READ)
    @Optional.Method(modid="appliedenergistics2")
    public void readFromNBT_AENetwork(NBTTagCompound data) {
        AENetworkProxy gp = this.getProxy();
        if (gp != null) {
            this.getProxy().readFromNBT(data);
        }
    }

    @TileEvent(value=TileEventType.WORLD_NBT_WRITE)
    @Optional.Method(modid="appliedenergistics2")
    public void writeToNBT_AENetwork(NBTTagCompound data) {
        AENetworkProxy gp = this.getProxy();
        if (gp != null) {
            gp.writeToNBT(data);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    void onChunkUnloadAE() {
        AENetworkProxy gp = this.getProxy();
        if (gp != null) {
            gp.onChunkUnload();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    void invalidateAE() {
        AENetworkProxy gp = this.getProxy();
        if (gp != null) {
            gp.invalidate();
        }
    }

    @Override
    public boolean wasShutdown() {
        return this.mWasShutdown;
    }

    @Override
    public void setShutdownStatus(boolean newStatus) {
        this.mWasShutdown = newStatus;
    }

    public IAlignment getAlignment() {
        return this.getMetaTileEntity() instanceof IAlignmentProvider ? ((IAlignmentProvider)this.getMetaTileEntity()).getAlignment() : new BasicAlignment();
    }

    @Nullable
    public IConstructable getConstructable() {
        return this.getMetaTileEntity() instanceof IConstructable ? (IConstructable)this.getMetaTileEntity() : null;
    }

    static {
        Field f = null;
        try {
            f = EntityItem.class.getDeclaredField("field_70291_e");
            f.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                f = EntityItem.class.getDeclaredField("health");
                f.setAccessible(true);
            }
            catch (Exception e2) {
                e1.printStackTrace();
                e2.printStackTrace();
            }
        }
        ENTITY_ITEM_HEALTH_FIELD = f;
    }

    private class BasicAlignment
    implements IAlignment {
        private BasicAlignment() {
        }

        public ExtendedFacing getExtendedFacing() {
            return ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)BaseMetaTileEntity.this.getFrontFacing()));
        }

        public void setExtendedFacing(ExtendedFacing alignment) {
            BaseMetaTileEntity.this.setFrontFacing((byte)Math.min(alignment.getDirection().ordinal(), ForgeDirection.UNKNOWN.ordinal() - 1));
        }

        public IAlignmentLimits getAlignmentLimits() {
            return (direction, rotation, flip) -> rotation.isNotRotated() && flip.isNotFlipped();
        }
    }

    public static class ClientEvents {
        public static final byte CHANGE_COMMON_DATA = 0;
        public static final byte CHANGE_CUSTOM_DATA = 1;
        public static final byte CHANGE_COLOR = 2;
        public static final byte CHANGE_REDSTONE_OUTPUT = 3;
        public static final byte DO_SOUND = 4;
        public static final byte START_SOUND_LOOP = 5;
        public static final byte STOP_SOUND_LOOP = 6;
        public static final byte CHANGE_LIGHT = 7;
    }
}

