/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import com.google.common.collect.Sets;
import gregtech.api.interfaces.metatileentity.IConnectable;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.metatileentity.IMetaTileEntityCable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Cable;
import gregtech.api.util.GT_Utility;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileIC2EnergySink
extends TileEntity
implements IEnergySink {
    private IGregTechTileEntity myMeta;
    private GT_MetaPipeEntity_Cable cableMeta = null;

    public TileIC2EnergySink(IGregTechTileEntity meta) {
        if (meta == null) {
            throw new NullPointerException("no null metas");
        }
        this.myMeta = meta;
        IMetaTileEntity metaTile = this.myMeta.getMetaTileEntity();
        if (metaTile instanceof IMetaTileEntityCable) {
            this.cableMeta = (GT_MetaPipeEntity_Cable)metaTile;
        }
        this.setWorldObj(meta.getWorld());
        this.xCoord = meta.getXCoord();
        this.yCoord = meta.getYCoord();
        this.zCoord = meta.getZCoord();
    }

    public double getDemandedEnergy() {
        if (this.cableMeta != null) {
            return this.cableMeta.mVoltage * this.cableMeta.mAmperage;
        }
        return this.myMeta.getEUCapacity() - this.myMeta.getStoredEU();
    }

    public int getSinkTier() {
        return GT_Utility.getTier(this.cableMeta != null ? this.cableMeta.mVoltage : this.myMeta.getInputVoltage());
    }

    public double injectEnergy(ForgeDirection directionFrom, double amount, double voltage) {
        long amps = (long)Math.max(amount / (this.cableMeta != null ? (double)this.cableMeta.mVoltage : (double)this.myMeta.getInputVoltage() * 1.0), 1.0);
        long euPerAmp = (long)(amount / ((double)amps * 1.0));
        IMetaTileEntity metaTile = this.myMeta.getMetaTileEntity();
        if (metaTile == null) {
            return amount;
        }
        long usedAmps = this.cableMeta != null ? ((IMetaTileEntityCable)metaTile).transferElectricity((byte)directionFrom.ordinal(), Math.min(euPerAmp, this.cableMeta.mVoltage), amps, Sets.newHashSet((Object[])new TileEntity[]{(TileEntity)this.myMeta})) : this.myMeta.injectEnergyUnits((byte)directionFrom.ordinal(), Math.min(euPerAmp, this.myMeta.getInputVoltage()), amps);
        return amount - (double)(usedAmps * euPerAmp);
    }

    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        IMetaTileEntity metaTile = this.myMeta.getMetaTileEntity();
        if (metaTile instanceof IMetaTileEntityCable && (direction == ForgeDirection.UNKNOWN || ((IConnectable)((Object)metaTile)).isConnectedAtSide(direction.ordinal()))) {
            return true;
        }
        return this.myMeta.inputEnergyFrom((byte)direction.ordinal(), false);
    }
}

