/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureElementNoPlacement;
import gregtech.api.GregTech_API;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IHeatingCoil;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Frame;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.IGT_HatchAdder;
import gregtech.common.blocks.GT_Block_Casings5;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class GT_StructureUtility {
    private GT_StructureUtility() {
        throw new AssertionError((Object)"Not instantiable");
    }

    public static <T> IStructureElementNoPlacement<T> ofHatchAdder(IGT_HatchAdder<T> aHatchAdder, int aTextureIndex, int aDots) {
        return GT_StructureUtility.ofHatchAdder(aHatchAdder, aTextureIndex, StructureLibAPI.getBlockHint(), aDots - 1);
    }

    public static <T> IStructureElement<T> ofFrame(final Materials aFrameMaterial) {
        if (aFrameMaterial == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){
            private IIcon[] mIcons;

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tBase = world.getTileEntity(x, y, z);
                if (tBase instanceof BaseMetaPipeEntity) {
                    BaseMetaPipeEntity tPipeBase = (BaseMetaPipeEntity)tBase;
                    if (tPipeBase.isInvalidTileEntity()) {
                        return false;
                    }
                    if (tPipeBase.getMetaTileEntity() instanceof GT_MetaPipeEntity_Frame) {
                        return aFrameMaterial == ((GT_MetaPipeEntity_Frame)tPipeBase.getMetaTileEntity()).mMaterial;
                    }
                }
                return false;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                if (this.mIcons == null) {
                    this.mIcons = new IIcon[6];
                    Arrays.fill(this.mIcons, aFrameMaterial.mIconSet.mTextures[OrePrefixes.frameGt.mTextureIndex].getIcon());
                }
                StructureLibAPI.hintParticleTinted((World)world, (int)x, (int)y, (int)z, (IIcon[])this.mIcons, (short[])aFrameMaterial.mRGBa);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                ItemStack tFrameStack = GT_OreDictUnificator.get(OrePrefixes.frameGt, aFrameMaterial, 1L);
                if (tFrameStack.getItem() instanceof ItemBlock) {
                    ItemBlock tFrameStackItem = (ItemBlock)tFrameStack.getItem();
                    return tFrameStackItem.placeBlockAt(tFrameStack, null, world, x, y, z, 6, 0.0f, 0.0f, 0.0f, Items.feather.getDamage(tFrameStack));
                }
                return false;
            }
        };
    }

    public static <T> IStructureElementNoPlacement<T> ofHatchAdder(final IGT_HatchAdder<T> aHatchAdder, final int aTextureIndex, final Block aHintBlock, final int aHintMeta) {
        if (aHatchAdder == null || aHintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElementNoPlacement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.getTileEntity(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && aHatchAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)aTextureIndex);
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aHintBlock, (int)aHintMeta);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofHatchAdderOptional(IGT_HatchAdder<T> aHatchAdder, int textureIndex, int dots, Block placeCasing, int placeCasingMeta) {
        return GT_StructureUtility.ofHatchAdderOptional(aHatchAdder, textureIndex, StructureLibAPI.getBlockHint(), dots - 1, placeCasing, placeCasingMeta);
    }

    public static <T> IStructureElement<T> ofHatchAdderOptional(final IGT_HatchAdder<T> aHatchAdder, final int aTextureIndex, final Block aHintBlock, final int hintMeta, final Block placeCasing, final int placeCasingMeta) {
        if (aHatchAdder == null || aHintBlock == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                TileEntity tileEntity = world.getTileEntity(x, y, z);
                Block worldBlock = world.getBlock(x, y, z);
                return tileEntity instanceof IGregTechTileEntity && aHatchAdder.apply(t, (IGregTechTileEntity)tileEntity, (short)aTextureIndex) || worldBlock == placeCasing && worldBlock.getDamageValue(world, x, y, z) == placeCasingMeta;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aHintBlock, (int)hintMeta);
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.setBlock(x, y, z, placeCasing, placeCasingMeta, 2);
                return true;
            }
        };
    }

    public static <T> IStructureElement<T> ofCoil(BiConsumer<T, HeatingCoilLevel> aHeatingCoilSetter, Function<T, HeatingCoilLevel> aHeatingCoilGetter) {
        return GT_StructureUtility.ofCoil((T t, HeatingCoilLevel l) -> {
            aHeatingCoilSetter.accept((Object)t, (HeatingCoilLevel)((Object)l));
            return true;
        }, aHeatingCoilGetter);
    }

    public static <T> IStructureElement<T> ofCoil(final BiPredicate<T, HeatingCoilLevel> aHeatingCoilSetter, final Function<T, HeatingCoilLevel> aHeatingCoilGetter) {
        if (aHeatingCoilSetter == null || aHeatingCoilGetter == null) {
            throw new IllegalArgumentException();
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block block = world.getBlock(x, y, z);
                if (!(block instanceof IHeatingCoil)) {
                    return false;
                }
                HeatingCoilLevel existingLevel = (HeatingCoilLevel)((Object)aHeatingCoilGetter.apply(t));
                HeatingCoilLevel newLevel = ((IHeatingCoil)block).getCoilHeat(world.getBlockMetadata(x, y, z));
                if (existingLevel == null || existingLevel == HeatingCoilLevel.None) {
                    return aHeatingCoilSetter.test(t, newLevel);
                }
                return newLevel == existingLevel;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)GregTech_API.sBlockCasings5, (int)this.getMeta(trigger));
                return true;
            }

            private int getMeta(ItemStack trigger) {
                return GT_Block_Casings5.getMetaFromCoilHeat(HeatingCoilLevel.getFromTier((byte)Math.min(HeatingCoilLevel.getMaxTier() - 4, Math.max(0, trigger.stackSize - 1))));
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.setBlock(x, y, z, GregTech_API.sBlockCasings5, this.getMeta(trigger), 3);
            }
        };
    }
}

