/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.GT_Container_BasicTank;
import gregtech.api.gui.GT_Slot_Output;
import gregtech.api.gui.GT_Slot_Render;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.util.GT_Utility;
import java.nio.ByteBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_Container_OutputHatch
extends GT_Container_BasicTank {
    private ByteBuffer buffer;
    private String fluidName = "";
    private byte mMode;

    public GT_Container_OutputHatch(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity) {
        super(aInventoryPlayer, aTileEntity);
    }

    @Override
    public void addSlots(InventoryPlayer aInventoryPlayer) {
        this.addSlotToContainer(new Slot((IInventory)this.mTileEntity, 0, 80, 17));
        this.addSlotToContainer(new GT_Slot_Output((IInventory)this.mTileEntity, 1, 80, 53));
        this.addSlotToContainer(new GT_Slot_Render((IInventory)this.mTileEntity, 2, 59, 42));
        this.addSlotToContainer(new GT_Slot_Render((IInventory)this.mTileEntity, 3, 150, 42));
    }

    @Override
    public ItemStack slotClick(int aSlotIndex, int aMouseclick, int aShifthold, EntityPlayer aPlayer) {
        if (aSlotIndex == 3 && aMouseclick < 2) {
            GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)this.mTileEntity.getMetaTileEntity();
            FluidStack tReadyLockFluid = GT_Utility.getFluidForFilledItem(aPlayer.inventory.getItemStack(), true);
            byte tMode = tHatch.getMode();
            if (tReadyLockFluid == null || tMode >= 8 && tReadyLockFluid.getUnlocalizedName().equals(tHatch.getLockedFluidName())) {
                tHatch.setLockedFluidName(null);
                GT_Utility.sendChatToPlayer(aPlayer, this.trans("300", "Fluid Lock Cleared."));
                tHatch.mMode = 0;
                this.fluidName = "";
            } else {
                tHatch.setLockedFluidName(tReadyLockFluid.getUnlocalizedName());
                GT_Utility.sendChatToPlayer(aPlayer, String.format(this.trans("151.4", "Sucessfully locked Fluid to %s"), tReadyLockFluid.getLocalizedName()));
                tHatch.mMode = (byte)9;
                this.fluidName = tReadyLockFluid.getUnlocalizedName();
            }
        }
        return super.slotClick(aSlotIndex, aMouseclick, aShifthold, aPlayer);
    }

    @Override
    public void addCraftingToCrafters(ICrafting clientHandle) {
        this.buffer.putInt(0, this.fluidName.length());
        this.buffer.put(4, this.mMode);
        for (int i = 0; i < this.fluidName.length(); ++i) {
            this.buffer.putChar(4 + 2 * i + 1, this.fluidName.charAt(i));
        }
        this.sendStateUpdate(clientHandle);
        super.addCraftingToCrafters(clientHandle);
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.buffer == null) {
            this.buffer = ByteBuffer.allocate(256);
        }
        if (this.mTileEntity.isServerSide()) {
            GT_MetaTileEntity_Hatch_Output tile = (GT_MetaTileEntity_Hatch_Output)this.mTileEntity.getMetaTileEntity();
            if (tile == null) {
                return;
            }
            this.fluidName = tile.getLockedFluidName() == null ? "" : tile.getLockedFluidName();
            this.mMode = tile.getMode();
            this.buffer.putInt(0, this.fluidName.length());
            this.buffer.put(4, this.mMode);
            for (int i = 0; i < this.fluidName.length(); ++i) {
                this.buffer.putChar(4 + 2 * i + 1, this.fluidName.charAt(i));
            }
            for (Object clientHandle : this.crafters) {
                this.sendStateUpdate((ICrafting)clientHandle);
            }
        }
    }

    private void sendStateUpdate(ICrafting clientHandle) {
        int bytes = 2 * this.fluidName.length() + 4 + 1;
        for (int i = 0; i < bytes; ++i) {
            clientHandle.sendProgressBarUpdate((Container)this, i + 110, (int)this.buffer.get(i));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateProgressBar(int index, int value) {
        super.updateProgressBar(index, value);
        if ((index -= 110) >= 0 && index < this.buffer.capacity()) {
            this.buffer.put(index, (byte)value);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getFluidName() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.buffer.getInt(0); ++i) {
            sb.append(this.buffer.getChar(i * 2 + 4 + 1));
        }
        byte mode = this.buffer.get(4);
        FluidStack tFluid = FluidRegistry.getFluidStack((String)sb.toString().replace("fluid.", "").replace("tile.", "").replace(".name", "").replace("ic2.fluid", "ic2").toLowerCase(), (int)1);
        if (tFluid == null || mode < 8) {
            return "Empty";
        }
        return tFluid.getLocalizedName().replace("fluid.", "");
    }
}

