/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.items.PropolisType;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidRegistry;

public class ItemPropolis
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public ItemPropolis() {
        this.setCreativeTab(Tabs.tabApiculture);
        this.setHasSubtypes(true);
        this.setUnlocalizedName("gt.propolis");
        GameRegistry.registerItem((Item)this, (String)"gt.propolis", (String)"gregtech");
    }

    public ItemStack getStackForType(PropolisType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public ItemStack getStackForType(PropolisType type, int count) {
        return new ItemStack((Item)this, count, type.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tabs, List list) {
        for (PropolisType type : PropolisType.values()) {
            if (!type.showInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister par1IconRegister) {
        this.itemIcon = par1IconRegister.registerIcon("forestry:propolis.0");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.itemIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        int meta = Math.max(0, Math.min(PropolisType.values().length - 1, stack.getItemDamage()));
        return PropolisType.values()[meta].getColours();
    }

    public String getItemStackDisplayName(ItemStack stack) {
        return PropolisType.values()[stack.getItemDamage()].getName();
    }

    public void initPropolisRecipes() {
        ItemStack tPropolis = this.getStackForType(PropolisType.End);
        this.addProcessHV(tPropolis, GT_ModHandler.getModItem("HardcoreEnderExpansion", "end_powder", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Stardust);
        this.addProcessHV(tPropolis, GT_ModHandler.getModItem("HardcoreEnderExpansion", "stardust", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Ectoplasma);
        this.addProcessEV(tPropolis, GT_ModHandler.getModItem("dreamcraft", "item.EctoplasmaChip", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Arcaneshard);
        this.addProcessEV(tPropolis, GT_ModHandler.getModItem("dreamcraft", "item.ArcaneShardChip", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Dragonessence);
        this.addProcessIV(tPropolis, GT_ModHandler.getModItem("HardcoreEnderExpansion", "essence", 16L, 0));
        tPropolis = this.getStackForType(PropolisType.Enderman);
        this.addProcessIV(tPropolis, GT_ModHandler.getModItem("HardcoreEnderExpansion", "enderman_head", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Silverfish);
        this.addProcessEV(tPropolis, GT_ModHandler.getModItem("HardcoreEnderExpansion", "silverfish_blood", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Endium);
        this.addProcessHV(tPropolis, GT_OreDictUnificator.get(OrePrefixes.dustSmall, Materials.HeeEndium, 1L));
        tPropolis = this.getStackForType(PropolisType.Fireessence);
        this.addProcessIV(tPropolis, GT_ModHandler.getModItem("HardcoreEnderExpansion", "essence", 16L, 1));
    }

    public void addProcessHV(ItemStack tPropolis, ItemStack aOutput2) {
        GT_Values.RA.addFluidExtractionRecipe(tPropolis, aOutput2, FluidRegistry.getFluidStack((String)"endergoo", (int)100), 5000, 50, 480);
    }

    public void addProcessEV(ItemStack tPropolis, ItemStack aOutput2) {
        GT_Values.RA.addFluidExtractionRecipe(tPropolis, aOutput2, FluidRegistry.getFluidStack((String)"endergoo", (int)200), 2500, 100, 1920);
    }

    public void addProcessIV(ItemStack tPropolis, ItemStack aOutput2) {
        GT_Values.RA.addFluidExtractionRecipe(tPropolis, aOutput2, FluidRegistry.getFluidStack((String)"endergoo", (int)300), 1500, 150, 7680);
    }
}

