/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import com.gtnewhorizon.structurelib.alignment.IAlignmentProvider;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.alignment.enumerable.Flip;
import com.gtnewhorizon.structurelib.alignment.enumerable.Rotation;
import gregtech.GT_Mod;
import gregtech.api.interfaces.IColorModulationContainer;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.LightingHelper;
import gregtech.common.render.GT_IconFlipped;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

class GT_RenderedTexture
implements ITexture,
IColorModulationContainer {
    protected final IIconContainer mIconContainer;
    private final short[] mRGBa;
    private final boolean glow;
    private final boolean stdOrient;
    private final boolean useExtFacing;

    GT_RenderedTexture(IIconContainer aIcon, short[] aRGBa, boolean allowAlpha, boolean glow, boolean stdOrient, boolean extFacing) {
        if (aRGBa.length != 4) {
            throw new IllegalArgumentException("RGBa doesn't have 4 Values @ GT_RenderedTexture");
        }
        this.mIconContainer = aIcon;
        this.mRGBa = aRGBa;
        this.glow = glow;
        this.stdOrient = stdOrient;
        this.useExtFacing = extFacing;
    }

    @Override
    public void renderXPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        boolean enableAO = aRenderer.enableAO;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (aRenderer.useInventoryTint) {
                return;
            }
            if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
                return;
            }
            aRenderer.enableAO = false;
            lighting.setLightnessOverride(1.0f);
            if (enableAO) {
                lighting.setBrightnessOverride(0xF000F0);
            }
        }
        lighting.setupLightingXPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.EAST.ordinal(), this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceXPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.EAST.ordinal(), 0xFFFFFF);
            this.renderFaceXPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderXNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        boolean enableAO = aRenderer.enableAO;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (aRenderer.useInventoryTint) {
                return;
            }
            if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
                return;
            }
            aRenderer.enableAO = false;
            lighting.setLightnessOverride(1.0f);
            if (enableAO) {
                lighting.setBrightnessOverride(0xF000F0);
            }
        }
        lighting.setupLightingXNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.WEST.ordinal(), this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceXNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.WEST.ordinal(), 0xFFFFFF);
            this.renderFaceXNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderYPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        boolean enableAO = aRenderer.enableAO;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (aRenderer.useInventoryTint) {
                return;
            }
            if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
                return;
            }
            aRenderer.enableAO = false;
            lighting.setLightnessOverride(1.0f);
            if (enableAO) {
                lighting.setBrightnessOverride(0xF000F0);
            }
        }
        lighting.setupLightingYPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.UP.ordinal(), this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceYPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.UP.ordinal(), 0xFFFFFF);
            this.renderFaceYPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderYNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        boolean enableAO = aRenderer.enableAO;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (aRenderer.useInventoryTint) {
                return;
            }
            if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
                return;
            }
            aRenderer.enableAO = false;
            lighting.setLightnessOverride(1.0f);
            if (enableAO) {
                lighting.setBrightnessOverride(0xF000F0);
            }
        }
        lighting.setupLightingYNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.DOWN.ordinal(), this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceYNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            Tessellator.instance.setColorRGBA(255, 255, 255, 255);
            this.renderFaceYNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderZPos(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        boolean enableAO = aRenderer.enableAO;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (aRenderer.useInventoryTint) {
                return;
            }
            if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
                return;
            }
            aRenderer.enableAO = false;
            lighting.setLightnessOverride(1.0f);
            if (enableAO) {
                lighting.setBrightnessOverride(0xF000F0);
            }
        }
        lighting.setupLightingZPos(aBlock, aX, aY, aZ).setupColor(ForgeDirection.SOUTH.ordinal(), this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceZPos(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.SOUTH.ordinal(), 0xFFFFFF);
            this.renderFaceZPos(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public void renderZNeg(RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
        boolean enableAO = aRenderer.enableAO;
        LightingHelper lighting = new LightingHelper(aRenderer);
        if (this.glow) {
            if (aRenderer.useInventoryTint) {
                return;
            }
            if (!GT_Mod.gregtechproxy.mRenderGlowTextures) {
                return;
            }
            aRenderer.enableAO = false;
            lighting.setLightnessOverride(1.0f);
            if (enableAO) {
                lighting.setBrightnessOverride(0xF000F0);
            }
        }
        lighting.setupLightingZNeg(aBlock, aX, aY, aZ).setupColor(ForgeDirection.NORTH.ordinal(), this.mRGBa);
        ExtendedFacing rotation = this.getExtendedFacing(aX, aY, aZ);
        this.renderFaceZNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getIcon(), rotation);
        if (this.mIconContainer.getOverlayIcon() != null) {
            lighting.setupColor(ForgeDirection.NORTH.ordinal(), 0xFFFFFF);
            this.renderFaceZNeg(aRenderer, aX, aY, aZ, this.mIconContainer.getOverlayIcon(), rotation);
        }
        aRenderer.enableAO = enableAO;
    }

    @Override
    public short[] getRGBA() {
        return this.mRGBa;
    }

    @Override
    public boolean isValidTexture() {
        return this.mIconContainer != null;
    }

    protected void renderFaceYNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        switch (this.useExtFacing ? extendedFacing.getRotation() : Rotation.NORMAL) {
            case COUNTER_CLOCKWISE: {
                aRenderer.uvRotateBottom = 2;
                break;
            }
            case CLOCKWISE: {
                aRenderer.uvRotateBottom = 1;
                break;
            }
            case UPSIDE_DOWN: {
                aRenderer.uvRotateBottom = 3;
                break;
            }
            default: {
                aRenderer.uvRotateBottom = 0;
            }
        }
        Flip aFlip = extendedFacing.getFlip();
        aRenderer.renderFaceYNeg(Blocks.air, x, y, z, (IIcon)(this.useExtFacing && GT_Mod.gregtechproxy.mRenderFlippedMachinesFlipped ? new GT_IconFlipped(icon, aFlip.isHorizontallyFlipped() ^ !this.stdOrient, aFlip.isVerticallyFliped()) : new GT_IconFlipped(icon, !this.stdOrient, false)));
        aRenderer.uvRotateBottom = 0;
    }

    protected void renderFaceYPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        switch (this.useExtFacing ? extendedFacing.getRotation() : Rotation.NORMAL) {
            case COUNTER_CLOCKWISE: {
                aRenderer.uvRotateTop = 2;
                break;
            }
            case CLOCKWISE: {
                aRenderer.uvRotateTop = 1;
                break;
            }
            case UPSIDE_DOWN: {
                aRenderer.uvRotateTop = 3;
                break;
            }
            default: {
                aRenderer.uvRotateTop = 0;
            }
        }
        Flip aFlip = extendedFacing.getFlip();
        aRenderer.renderFaceYPos(Blocks.air, x, y, z, (IIcon)(this.useExtFacing && GT_Mod.gregtechproxy.mRenderFlippedMachinesFlipped ? new GT_IconFlipped(icon, aFlip.isHorizontallyFlipped(), aFlip.isVerticallyFliped()) : icon));
        aRenderer.uvRotateTop = 0;
    }

    protected void renderFaceZNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        aRenderer.field_152631_f = true;
        switch (this.useExtFacing ? extendedFacing.getRotation() : Rotation.NORMAL) {
            case COUNTER_CLOCKWISE: {
                aRenderer.uvRotateEast = 2;
                break;
            }
            case CLOCKWISE: {
                aRenderer.uvRotateEast = 1;
                break;
            }
            case UPSIDE_DOWN: {
                aRenderer.uvRotateEast = 3;
                break;
            }
            default: {
                aRenderer.uvRotateEast = 0;
            }
        }
        Flip aFlip = extendedFacing.getFlip();
        aRenderer.renderFaceZNeg(Blocks.air, x, y, z, (IIcon)(this.useExtFacing && GT_Mod.gregtechproxy.mRenderFlippedMachinesFlipped ? new GT_IconFlipped(icon, aFlip.isHorizontallyFlipped(), aFlip.isVerticallyFliped()) : icon));
        aRenderer.uvRotateEast = 0;
        aRenderer.field_152631_f = false;
    }

    protected void renderFaceZPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        switch (this.useExtFacing ? extendedFacing.getRotation() : Rotation.NORMAL) {
            case COUNTER_CLOCKWISE: {
                aRenderer.uvRotateWest = 2;
                break;
            }
            case CLOCKWISE: {
                aRenderer.uvRotateWest = 1;
                break;
            }
            case UPSIDE_DOWN: {
                aRenderer.uvRotateWest = 3;
                break;
            }
            default: {
                aRenderer.uvRotateWest = 0;
            }
        }
        Flip aFlip = extendedFacing.getFlip();
        aRenderer.renderFaceZPos(Blocks.air, x, y, z, (IIcon)(this.useExtFacing && GT_Mod.gregtechproxy.mRenderFlippedMachinesFlipped ? new GT_IconFlipped(icon, aFlip.isHorizontallyFlipped(), aFlip.isVerticallyFliped()) : icon));
        aRenderer.uvRotateWest = 0;
    }

    protected void renderFaceXNeg(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        switch (this.useExtFacing ? extendedFacing.getRotation() : Rotation.NORMAL) {
            case COUNTER_CLOCKWISE: {
                aRenderer.uvRotateNorth = 2;
                break;
            }
            case CLOCKWISE: {
                aRenderer.uvRotateNorth = 1;
                break;
            }
            case UPSIDE_DOWN: {
                aRenderer.uvRotateNorth = 3;
                break;
            }
            default: {
                aRenderer.uvRotateNorth = 0;
            }
        }
        Flip aFlip = extendedFacing.getFlip();
        aRenderer.renderFaceXNeg(Blocks.air, x, y, z, (IIcon)(this.useExtFacing && GT_Mod.gregtechproxy.mRenderFlippedMachinesFlipped ? new GT_IconFlipped(icon, aFlip.isHorizontallyFlipped(), aFlip.isVerticallyFliped()) : icon));
        aRenderer.uvRotateNorth = 0;
    }

    protected void renderFaceXPos(RenderBlocks aRenderer, double x, double y, double z, IIcon icon, ExtendedFacing extendedFacing) {
        aRenderer.field_152631_f = true;
        switch (this.useExtFacing ? extendedFacing.getRotation() : Rotation.NORMAL) {
            case COUNTER_CLOCKWISE: {
                aRenderer.uvRotateSouth = 2;
                break;
            }
            case CLOCKWISE: {
                aRenderer.uvRotateSouth = 1;
                break;
            }
            case UPSIDE_DOWN: {
                aRenderer.uvRotateSouth = 3;
                break;
            }
            default: {
                aRenderer.uvRotateSouth = 0;
            }
        }
        Flip aFlip = extendedFacing.getFlip();
        aRenderer.renderFaceXPos(Blocks.air, x, y, z, (IIcon)(this.useExtFacing && GT_Mod.gregtechproxy.mRenderFlippedMachinesFlipped ? new GT_IconFlipped(icon, aFlip.isHorizontallyFlipped(), aFlip.isVerticallyFliped()) : icon));
        aRenderer.uvRotateSouth = 0;
        aRenderer.field_152631_f = false;
    }

    private ExtendedFacing getExtendedFacing(int x, int y, int z) {
        if (this.stdOrient) {
            return ExtendedFacing.DEFAULT;
        }
        EntityPlayer player = GT_Mod.gregtechproxy.getThePlayer();
        if (player == null) {
            return ExtendedFacing.DEFAULT;
        }
        World w = player.getEntityWorld();
        if (w == null) {
            return ExtendedFacing.DEFAULT;
        }
        TileEntity te = w.getTileEntity(x, y, z);
        if (te instanceof IGregTechTileEntity) {
            IMetaTileEntity meta = ((IGregTechTileEntity)te).getMetaTileEntity();
            if (meta instanceof IAlignmentProvider) {
                return ((IAlignmentProvider)meta).getAlignment().getExtendedFacing();
            }
            if (meta != null) {
                return ExtendedFacing.of((ForgeDirection)ForgeDirection.getOrientation((int)meta.getBaseMetaTileEntity().getFrontFacing()));
            }
        } else if (te instanceof IAlignmentProvider) {
            return ((IAlignmentProvider)te).getAlignment().getExtendedFacing();
        }
        return ExtendedFacing.DEFAULT;
    }
}

