/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.AEApi;
import appeng.api.networking.GridFlags;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.Platform;
import cpw.mods.fml.common.Optional;
import gregtech.api.GregTech_API;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_MetaTileEntity_Hatch_OutputBus_ME
extends GT_MetaTileEntity_Hatch_OutputBus {
    private BaseActionSource requestSource = null;
    private AENetworkProxy gridProxy = null;
    ItemStack cachedStack = null;
    long lastOutputTick = 0L;
    long tickCounter = 0L;
    boolean lastOutputFailed = false;

    public GT_MetaTileEntity_Hatch_OutputBus_ME(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 1, new String[]{"Item Output for Multiblocks", "Stores directly into ME"}, 0);
    }

    public GT_MetaTileEntity_Hatch_OutputBus_ME(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_OutputBus_ME(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_HATCH)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_HATCH)};
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy();
    }

    @Override
    public boolean storeAll(ItemStack aStack) {
        if (!GregTech_API.mAE2) {
            return false;
        }
        aStack.stackSize = this.store(aStack);
        return aStack.stackSize == 0;
    }

    @Optional.Method(modid="appliedenergistics2")
    public int store(ItemStack stack) {
        if (stack == null) {
            return 0;
        }
        try {
            AENetworkProxy proxy = this.getProxy();
            if (proxy == null) {
                this.lastOutputFailed = true;
                int cacheSize = this.cachedStack == null ? 0 : this.cachedStack.stackSize;
                this.cachedStack = null;
                return stack.stackSize + cacheSize;
            }
            if (this.lastOutputFailed) {
                IMEMonitor sg = proxy.getStorage().getItemInventory();
                IAEItemStack toStore = AEApi.instance().storage().createItemStack(stack);
                IAEItemStack rest = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)sg, (IAEStack)toStore, (BaseActionSource)this.getRequest());
                if (rest != null && rest.getStackSize() > 0L) {
                    return (int)rest.getStackSize();
                }
                this.lastOutputFailed = false;
            } else {
                if (!(this.cachedStack == null || this.tickCounter <= this.lastOutputTick + 20L && this.cachedStack.isItemEqual(stack))) {
                    this.lastOutputTick = this.tickCounter;
                    boolean sameStack = this.cachedStack.isItemEqual(stack);
                    if (sameStack) {
                        this.cachedStack.stackSize += stack.stackSize;
                    }
                    IMEMonitor sg = proxy.getStorage().getItemInventory();
                    IAEItemStack toStore = AEApi.instance().storage().createItemStack(this.cachedStack);
                    IAEItemStack rest = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)sg, (IAEStack)toStore, (BaseActionSource)this.getRequest());
                    if (rest != null && rest.getStackSize() > 0L) {
                        this.lastOutputFailed = true;
                        if (sameStack) {
                            this.cachedStack = null;
                            return (int)rest.getStackSize();
                        }
                        this.cachedStack.stackSize = (int)rest.getStackSize();
                        return stack.stackSize;
                    }
                    this.cachedStack = !sameStack ? stack.copy() : null;
                    return 0;
                }
                if (this.cachedStack == null) {
                    this.cachedStack = stack.copy();
                } else {
                    this.cachedStack.stackSize += stack.stackSize;
                }
            }
            return 0;
        }
        catch (GridAccessException ignored) {
            this.lastOutputFailed = true;
            return stack.stackSize;
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private BaseActionSource getRequest() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing((byte)forgeDirection.ordinal()) ? AECableType.SMART : AECableType.NONE;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", ItemList.Hatch_Output_Bus_ME.get(1L, new Object[0]), true);
            this.gridProxy.onReady();
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
        }
        return this.gridProxy;
    }

    @Override
    @Optional.Method(modid="appliedenergistics2")
    public void gridChanged() {
    }

    @Optional.Method(modid="appliedenergistics2")
    private void flushCachedStack() {
        if (this.cachedStack == null) {
            return;
        }
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null) {
            this.lastOutputFailed = true;
            return;
        }
        try {
            IMEMonitor sg = proxy.getStorage().getItemInventory();
            IAEItemStack toStore = AEApi.instance().storage().createItemStack(this.cachedStack);
            IAEItemStack rest = (IAEItemStack)Platform.poweredInsert((IEnergySource)proxy.getEnergy(), (IMEInventory)sg, (IAEStack)toStore, (BaseActionSource)this.getRequest());
            if (rest != null && rest.getStackSize() > 0L) {
                this.lastOutputFailed = true;
                this.cachedStack.stackSize = (int)rest.getStackSize();
            } else {
                this.cachedStack = null;
            }
        }
        catch (GridAccessException ignored) {
            this.lastOutputFailed = true;
        }
        this.lastOutputTick = this.tickCounter;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        this.tickCounter = aTick;
        if (this.tickCounter > this.lastOutputTick + 40L) {
            this.flushCachedStack();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.cachedStack != null) {
            NBTTagCompound tTag = new NBTTagCompound();
            this.cachedStack.writeToNBT(tTag);
            aNBT.setTag("cachedStack", (NBTBase)tTag);
        }
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTBase t = aNBT.getTag("cachedStack");
        if (t instanceof NBTTagCompound) {
            this.cachedStack = GT_Utility.loadItem((NBTTagCompound)t);
        }
    }

    public boolean isLastOutputFailed() {
        return this.lastOutputFailed;
    }
}

