/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_DistillationTower
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_DistillationTower> {
    protected static final int CASING_INDEX = 49;
    protected static final String STRUCTURE_PIECE_BASE = "base";
    protected static final String STRUCTURE_PIECE_LAYER = "layer";
    protected static final String STRUCTURE_PIECE_LAYER_HINT = "layerHint";
    protected static final String STRUCTURE_PIECE_TOP_HINT = "topHint";
    private static final IStructureDefinition<GT_MetaTileEntity_DistillationTower> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape("layer", StructureUtility.transpose((String[][])new String[][]{{"lll", "lcl", "lll"}})).addShape("layerHint", StructureUtility.transpose((String[][])new String[][]{{"lll", "l-l", "lll"}})).addShape("topHint", StructureUtility.transpose((String[][])new String[][]{{"lll", "lll", "lll"}})).addElement(Character.valueOf('b'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, 49, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, 49, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addInputToMachineList, 49, 1), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, 49, 1), StructureUtility.onElementPass(GT_MetaTileEntity_DistillationTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement(Character.valueOf('l'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addEnergyInputToMachineList, 49, 2), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_DistillationTower::addLayerOutputHatch, 49, 2), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, 49, 2), StructureUtility.onElementPass(GT_MetaTileEntity_DistillationTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1))})).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> t.onTopLayerFound(false), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addOutputToMachineList, 49, 3)), StructureUtility.onElementPass(t -> t.onTopLayerFound(false), GT_StructureUtility.ofHatchAdder(GT_MetaTileEntity_MultiBlockBase::addMaintenanceToMachineList, 49, 3)), StructureUtility.onElementPass(t -> t.onTopLayerFound(true), (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)1)), StructureUtility.isAir()})).build();
    protected final List<List<GT_MetaTileEntity_Hatch_Output>> mOutputHatchesByLayer = new ArrayList<List<GT_MetaTileEntity_Hatch_Output>>();
    protected int mHeight;
    protected int mCasing;
    protected boolean mTopLayerFound;

    public GT_MetaTileEntity_DistillationTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_DistillationTower(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_DistillationTower(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Distillery").addInfo("Controller block for the Distillation Tower").addInfo("Fluids are only put out at the correct height").addInfo("The correct height equals the slot number in the NEI recipe").addSeparator().beginVariableStructureBlock(3, 3, 3, 12, 3, 3, true).addController("Front bottom").addOtherStructurePart("Clean Stainless Steel Machine Casing", "7 x h - 5 (minimum)").addEnergyHatch("Any casing", 1, 2).addMaintenanceHatch("Any casing", 1, 2, 3).addInputHatch("Any bottom layer casing", 1).addOutputBus("Any bottom layer casing", 1).addOutputHatch("2-11x Output Hatches (At least one per layer except bottom layer)", 2, 3).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(49)};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "DistillationTower.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sDistillationRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        block0: for (int i = 0; i < tFluidList.size() - 1; ++i) {
            for (int j = i + 1; j < tFluidList.size(); ++j) {
                if (!GT_Utility.areFluidsEqual(tFluidList.get(i), tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    continue;
                }
                tFluidList.remove(i--);
                continue block0;
            }
        }
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(0, GT_Utility.getTier(tVoltage));
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
        if (tFluids.length > 0) {
            for (FluidStack tFluid : tFluids) {
                GT_Recipe tRecipe = GT_Recipe.GT_Recipe_Map.sDistillationRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], new FluidStack[]{tFluid}, new ItemStack[0]);
                if (tRecipe == null || !tRecipe.isRecipeInputEqual(true, tFluids, new ItemStack[0])) continue;
                this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                this.mEfficiencyIncrease = 10000;
                this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
                if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                    return false;
                }
                if (this.mEUt > 0) {
                    this.mEUt = -this.mEUt;
                }
                this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                this.mOutputItems = new ItemStack[]{tRecipe.getOutput(0)};
                this.mOutputFluids = (FluidStack[])tRecipe.mFluidOutputs.clone();
                this.updateSlots();
                return true;
            }
        }
        return false;
    }

    protected void onCasingFound() {
        ++this.mCasing;
    }

    protected void onTopLayerFound(boolean aIsCasing) {
        this.mTopLayerFound = true;
        if (aIsCasing) {
            this.onCasingFound();
        }
    }

    protected boolean addLayerOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null || aTileEntity.isDead() || !(aTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_Output)) {
            return false;
        }
        while (this.mOutputHatchesByLayer.size() < this.mHeight) {
            this.mOutputHatchesByLayer.add(new ArrayList());
        }
        GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aTileEntity.getMetaTileEntity();
        tHatch.updateTexture(aBaseCasingIndex);
        return this.mOutputHatchesByLayer.get(this.mHeight - 1).add(tHatch);
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_DistillationTower> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputHatchesByLayer.forEach(List::clear);
        this.mHeight = 1;
        this.mTopLayerFound = false;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 1, 0, 0)) {
            return false;
        }
        while (this.mHeight < 12 && this.checkPiece(STRUCTURE_PIECE_LAYER, 1, this.mHeight, 0) && !this.mTopLayerFound) {
            if (this.mOutputHatchesByLayer.get(this.mHeight - 1).isEmpty()) {
                return false;
            }
            ++this.mHeight;
        }
        return this.mCasing >= 7 * this.mHeight - 5 && this.mHeight >= 2 && this.mTopLayerFound && this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (int i = 0; i < mOutputFluids2.length && i < this.mOutputHatchesByLayer.size(); ++i) {
            FluidStack tStack = mOutputFluids2[i].copy();
            if (GT_MetaTileEntity_DistillationTower.dumpFluid(this.mOutputHatchesByLayer.get(i), tStack, true)) continue;
            GT_MetaTileEntity_DistillationTower.dumpFluid(this.mOutputHatchesByLayer.get(i), tStack, false);
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 1, 0, 0);
        int tTotalHeight = Math.min(12, stackSize.stackSize + 2);
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, hintsOnly, 1, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, hintsOnly, 1, tTotalHeight - 1, 0);
    }
}

