/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_CubicMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_ProcessingArray_Manager;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_ProcessingArray
extends GT_MetaTileEntity_CubicMultiBlockBase<GT_MetaTileEntity_ProcessingArray> {
    private GT_Recipe.GT_Recipe_Map mLastRecipeMap;
    private GT_Recipe mLastRecipe;
    private int tTier = 0;
    private int mMult = 0;
    private boolean mSeparate = false;
    private String mMachineName = "";

    public GT_MetaTileEntity_ProcessingArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_ProcessingArray(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ProcessingArray(this.mName);
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Processing Array").addInfo("Runs supplied machines as if placed in the world").addInfo("Place up to 64 singleblock GT machines into the controller").addInfo("Note that you still need to supply power to them all").addInfo("Use a screwdriver to enable separate input busses").addInfo("Maximal overclockedness of machines inside: Tier 9").addInfo("Doesn't work on certain machines, deal with it").addInfo("Use it if you hate GT++, or want even more speed later on").addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfo("Robust Tungstensteel Machine Casing", 14).addEnergyHatch("Any casing", 1).addMaintenanceHatch("Any casing", 1).addInputBus("Any casing", 1).addInputHatch("Any casing", 1).addOutputBus("Any casing", 1).addOutputHatch("Any casing", 1).toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_PROCESSING_ARRAY_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48]};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "ProcessingArray.png");
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (this.isCorrectMachinePart(this.mInventory[1])) {
            return GT_ProcessingArray_Manager.getRecipeMapForMeta(this.mInventory[1].getItemDamage());
        }
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.getUnlocalizedName().startsWith("gt.blockmachines.basicmachine.");
    }

    @Override
    public boolean checkRecipe(ItemStack aStack) {
        if (!this.isCorrectMachinePart(this.mInventory[1])) {
            return false;
        }
        GT_Recipe.GT_Recipe_Map map = this.getRecipeMap();
        if (map == null) {
            return false;
        }
        if (!this.mMachineName.equals(this.mInventory[1].getUnlocalizedName())) {
            this.mLastRecipe = null;
            this.mMachineName = this.mInventory[1].getUnlocalizedName();
        }
        int machineTier = 0;
        if (this.mLastRecipe == null) {
            try {
                int length = this.mMachineName.length();
                machineTier = Integer.parseInt(this.mMachineName.substring(length - 2));
            }
            catch (NumberFormatException length) {
                // empty catch block
            }
            switch (machineTier) {
                default: {
                    this.tTier = 0;
                    this.mMult = 0;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    this.tTier = machineTier;
                    this.mMult = 0;
                    break;
                }
                case 10: {
                    this.tTier = 9;
                    this.mMult = 2;
                    break;
                }
                case 11: {
                    this.tTier = 9;
                    this.mMult = 4;
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.tTier = 9;
                    this.mMult = 6;
                }
            }
        }
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
        if (this.mSeparate) {
            ArrayList<ItemStack> tInputList = new ArrayList<ItemStack>();
            for (GT_MetaTileEntity_Hatch_InputBus tHatch : this.mInputBusses) {
                IGregTechTileEntity tInputBus = tHatch.getBaseMetaTileEntity();
                for (int i = tInputBus.getSizeInventory() - 1; i >= 0; --i) {
                    if (tInputBus.getStackInSlot(i) == null) continue;
                    tInputList.add(tInputBus.getStackInSlot(i));
                }
                ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
                if (this.processRecipe(tInputs, tFluids, map)) {
                    return true;
                }
                tInputList.clear();
            }
        } else {
            ArrayList<ItemStack> tInputList = this.getStoredInputs();
            ItemStack[] tInputs = tInputList.toArray(new ItemStack[0]);
            return this.processRecipe(tInputs, tFluids, map);
        }
        return false;
    }

    public boolean processRecipe(ItemStack[] tInputs, FluidStack[] tFluids, GT_Recipe.GT_Recipe_Map map) {
        int i;
        if (tInputs.length <= 0 && tFluids.length <= 0) {
            return false;
        }
        GT_Recipe tRecipe = map.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[this.tTier], tFluids, tInputs);
        if (tRecipe == null) {
            return false;
        }
        if (GT_Mod.gregtechproxy.mLowGravProcessing && tRecipe.mSpecialValue == -100 && !GT_MetaTileEntity_BasicMachine.isValidForLowGravity(tRecipe, this.getBaseMetaTileEntity().getWorld().provider.dimensionId)) {
            return false;
        }
        this.mLastRecipe = tRecipe;
        this.mEUt = 0;
        this.mOutputItems = null;
        this.mOutputFluids = null;
        int machines = Math.min(64, this.mInventory[1].stackSize << this.mMult);
        for (i = 0; i < machines; ++i) {
            if (tRecipe.isRecipeInputEqual(true, tFluids, tInputs)) continue;
            if (i != 0) break;
            return false;
        }
        this.mMaxProgresstime = tRecipe.mDuration;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, map.mAmperage, GT_Values.V[this.tTier]);
        if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        this.mEUt = GT_Utility.safeInt((long)this.mEUt * (long)i >> this.mMult, 1);
        if (this.mEUt == 0x7FFFFFFE) {
            return false;
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        ItemStack[] tOut = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOut[h] = tRecipe.getOutput(h).copy();
            tOut[h].stackSize = 0;
        }
        FluidStack tFOut = null;
        if (tRecipe.getFluidOutput(0) != null) {
            tFOut = tRecipe.getFluidOutput(0).copy();
        }
        for (int f = 0; f < tOut.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOut[f] == null) continue;
            for (int g = 0; g < i; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(10000) >= tRecipe.getOutputChance(f)) continue;
                tOut[f].stackSize += tRecipe.mOutputs[f].stackSize;
            }
        }
        if (tFOut != null) {
            int tSize = tFOut.amount;
            tFOut.amount = tSize * i;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        this.mOutputItems = (ItemStack[])Arrays.stream(tOut).filter(Objects::nonNull).flatMap(GT_MetaTileEntity_ProcessingArray::splitOversizedStack).filter(is -> is.stackSize > 0).toArray(ItemStack[]::new);
        this.mOutputFluids = new FluidStack[]{tFOut};
        this.updateSlots();
        return true;
    }

    private static Stream<ItemStack> splitOversizedStack(ItemStack aStack) {
        int tMaxStackSize = aStack.getMaxStackSize();
        if (aStack.stackSize <= tMaxStackSize) {
            return Stream.of(aStack);
        }
        int tRepeat = aStack.stackSize / tMaxStackSize;
        aStack.stackSize %= tMaxStackSize;
        Stream.Builder<ItemStack> tBuilder = Stream.builder();
        tBuilder.add(aStack);
        for (int i = 0; i < tRepeat; ++i) {
            ItemStack rStack = aStack.copy();
            rStack.stackSize = tMaxStackSize;
            tBuilder.add(rStack);
        }
        return tBuilder.build();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        GT_Recipe.GT_Recipe_Map tCurrentMap;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mMachine && aTick % 20L == 0L && (tCurrentMap = this.getRecipeMap()) != this.mLastRecipeMap) {
            for (GT_MetaTileEntity_Hatch_InputBus tInputBus : this.mInputBusses) {
                tInputBus.mRecipeMap = tCurrentMap;
            }
            for (GT_MetaTileEntity_Hatch_Input tInputHatch : this.mInputHatches) {
                tInputHatch.mRecipeMap = tCurrentMap;
            }
            this.mLastRecipeMap = tCurrentMap;
        }
    }

    @Override
    protected IStructureElement<GT_MetaTileEntity_CubicMultiBlockBase<?>> getCasingElement() {
        return StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)0);
    }

    @Override
    protected int getHatchTextureIndex() {
        return 48;
    }

    @Override
    protected int getRequiredCasingCount() {
        return 14;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.setBoolean("mSeparate", this.mSeparate);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mSeparate = aNBT.getBoolean("mSeparate");
    }

    @Override
    public final void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mSeparate = !this.mSeparate;
        GT_Utility.sendChatToPlayer(aPlayer, StatCollector.translateToLocal((String)"GT5U.machines.separatebus") + " " + this.mSeparate);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        long storedEnergy = 0L;
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GT_MetaTileEntity_ProcessingArray.isValidMetaTileEntity(tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return new String[]{StatCollector.translateToLocal((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.translateToLocal((String)"GT5U.multiblock.energy") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(maxEnergy) + EnumChatFormatting.RESET + " EU", StatCollector.translateToLocal((String)"GT5U.multiblock.usage") + ": " + EnumChatFormatting.RED + GT_Utility.formatNumbers(-this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.translateToLocal((String)"GT5U.multiblock.mei") + ": " + EnumChatFormatting.YELLOW + GT_Utility.formatNumbers(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.translateToLocal((String)"GT5U.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier(this.getMaxInputVoltage())] + EnumChatFormatting.RESET, StatCollector.translateToLocal((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.translateToLocal((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.translateToLocal((String)"GT5U.PA.machinetier") + ": " + EnumChatFormatting.GREEN + this.tTier + EnumChatFormatting.RESET + " " + StatCollector.translateToLocal((String)"GT5U.PA.discount") + ": " + EnumChatFormatting.GREEN + (1 << this.mMult) + EnumChatFormatting.RESET + " x", StatCollector.translateToLocal((String)"GT5U.PA.parallel") + ": " + EnumChatFormatting.GREEN + GT_Utility.formatNumbers(this.mInventory[1] != null ? (long)(this.mInventory[1].stackSize << this.mMult) : 0L) + EnumChatFormatting.RESET};
    }
}

