/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerInputHandler;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import codechicken.nei.recipe.RecipeInfo;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.GT_GUIContainer_BasicMachine;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.nei.NEI_GT_Config;
import gregtech.nei.RecipeMapHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GT_NEI_AssLineHandler
extends RecipeMapHandler {
    public static final int sOffsetX = 5;
    public static final int sOffsetY = 11;

    public GT_NEI_AssLineHandler(GT_Recipe.GT_Recipe_Map aRecipeMap) {
        super(aRecipeMap);
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(138, 18, 18, 18), this.getOverlayIdentifier(), new Object[0]));
    }

    public List<GT_Recipe> getSortedRecipes() {
        ArrayList<GT_Recipe> result = new ArrayList<GT_Recipe>(this.mRecipeMap.mRecipeList);
        Collections.sort(result);
        return result;
    }

    public static void drawText(int aX, int aY, String aString, int aColor) {
        Minecraft.getMinecraft().fontRenderer.drawString(aString, aX, aY, aColor);
    }

    public TemplateRecipeHandler newInstance() {
        NEI_GT_Config.ALH = new GT_NEI_AssLineHandler(this.mRecipeMap);
        return NEI_GT_Config.ALH;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (GT_Recipe tRecipe : this.getSortedRecipes()) {
                if (!tRecipe.mHidden) {
                    this.arecipes.add(new CachedDefaultRecipe(tRecipe));
                    continue;
                }
                this.arecipes.remove((Object)new CachedDefaultRecipe(tRecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack aResult) {
        FluidStack tFluid;
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aResult);
        ArrayList<ItemStack> tResults = new ArrayList<ItemStack>();
        tResults.add(aResult);
        tResults.add(GT_OreDictUnificator.get(true, aResult));
        if (tPrefixMaterial != null && !tPrefixMaterial.mBlackListed && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tResults.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if ((tFluid = GT_Utility.getFluidForFilledItem(aResult, true)) != null) {
            tResults.add(GT_Utility.getFluidDisplayStack(tFluid, false));
            for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!tData.fluid.isFluidEqual(tFluid)) continue;
                tResults.add(GT_Utility.copyOrNull(tData.filledContainer));
            }
        }
        block2: for (GT_Recipe tRecipe : this.getSortedRecipes()) {
            CachedDefaultRecipe tNEIRecipe;
            if (!tRecipe.mHidden) {
                tNEIRecipe = new CachedDefaultRecipe(tRecipe);
                for (ItemStack tStack : tResults) {
                    if (!tNEIRecipe.contains(tNEIRecipe.mOutputs, tStack)) continue;
                    this.arecipes.add(tNEIRecipe);
                    continue block2;
                }
                continue;
            }
            tNEIRecipe = new CachedDefaultRecipe(tRecipe);
            for (ItemStack tStack : tResults) {
                if (!tNEIRecipe.contains(tNEIRecipe.mOutputs, tStack)) continue;
                this.arecipes.remove((Object)tNEIRecipe);
                continue block2;
            }
        }
    }

    public void loadUsageRecipes(ItemStack aInput) {
        FluidStack tFluid;
        ItemData tPrefixMaterial = GT_OreDictUnificator.getAssociation(aInput);
        ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
        tInputs.add(aInput);
        tInputs.add(GT_OreDictUnificator.get(false, aInput));
        if (tPrefixMaterial != null && !tPrefixMaterial.mPrefix.mFamiliarPrefixes.isEmpty()) {
            for (OrePrefixes tPrefix : tPrefixMaterial.mPrefix.mFamiliarPrefixes) {
                tInputs.add(GT_OreDictUnificator.get(tPrefix, tPrefixMaterial.mMaterial.mMaterial, 1L));
            }
        }
        if ((tFluid = GT_Utility.getFluidForFilledItem(aInput, true)) != null) {
            tInputs.add(GT_Utility.getFluidDisplayStack(tFluid, false));
            for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
                if (!tData.fluid.isFluidEqual(tFluid)) continue;
                tInputs.add(GT_Utility.copyOrNull(tData.filledContainer));
            }
        }
        block2: for (GT_Recipe tRecipe : this.mRecipeMap.mRecipeList) {
            CachedDefaultRecipe tNEIRecipe;
            if (!tRecipe.mHidden) {
                tNEIRecipe = new CachedDefaultRecipe(tRecipe);
                for (ItemStack tStack : tInputs) {
                    if (!tNEIRecipe.contains(tNEIRecipe.mInputs, tStack)) continue;
                    this.arecipes.add(tNEIRecipe);
                    continue block2;
                }
                continue;
            }
            tNEIRecipe = new CachedDefaultRecipe(tRecipe);
            for (ItemStack tStack : tInputs) {
                if (!tNEIRecipe.contains(tNEIRecipe.mInputs, tStack)) continue;
                this.arecipes.remove((Object)tNEIRecipe);
                continue block2;
            }
        }
    }

    public String getOverlayIdentifier() {
        return this.mRecipeMap.mNEIName;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)79);
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return GT_LanguageManager.getTranslation(this.mRecipeMap.mUnlocalizedName);
    }

    public String getGuiTexture() {
        return this.mRecipeMap.mNEIGUIPath;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof CachedDefaultRecipe) {
            CachedDefaultRecipe tRecipe = (CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof FixedPositionedStack) || ((FixedPositionedStack)tStack).mChance <= 0 || ((FixedPositionedStack)tStack).mChance == 10000) break;
                currenttip.add("Chance: " + ((FixedPositionedStack)tStack).mChance / 100 + "." + (((FixedPositionedStack)tStack).mChance % 100 < 10 ? "0" + ((FixedPositionedStack)tStack).mChance % 100 : Integer.valueOf(((FixedPositionedStack)tStack).mChance % 100)) + "%");
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (aStack != tStack.item) continue;
                if (gregtech.api.enums.ItemList.Display_Fluid.isStackEqual(tStack.item, true, true) || tStack.item.stackSize != 0) break;
                currenttip.add("Does not get consumed in the process");
                break;
            }
        }
        return currenttip;
    }

    public void drawExtras(int aRecipeIndex) {
        block9: {
            String[] recipeDesc;
            block7: {
                int tSpecial;
                block11: {
                    block10: {
                        block8: {
                            int tEUt = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mEUt;
                            int tDuration = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mDuration;
                            recipeDesc = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.getNeiDesc();
                            if (recipeDesc != null) break block7;
                            if (tEUt != 0) {
                                GT_NEI_AssLineHandler.drawText(10, 73, GT_Utility.trans("152", "Total: ") + GT_Utility.formatNumbers((long)tDuration * (long)tEUt) + " EU", -16777216);
                                GT_NEI_AssLineHandler.drawText(10, 83, GT_Utility.trans("153", "Usage: ") + GT_Utility.formatNumbers(tEUt) + " EU/t", -16777216);
                                if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                                    int voltage = tEUt / this.mRecipeMap.mAmperage;
                                    byte tier = GT_Utility.getTier(voltage);
                                    if (tier < 0 || tier >= 16) {
                                        GT_NEI_AssLineHandler.drawText(10, 93, GT_Utility.trans("154", "Voltage: ") + GT_Utility.formatNumbers(voltage) + " EU", -65536);
                                    } else {
                                        GT_NEI_AssLineHandler.drawText(10, 93, GT_Utility.trans("154", "Voltage: ") + GT_Utility.formatNumbers(voltage) + " EU (" + GT_Values.VN[tier] + ")", -16777216);
                                    }
                                    GT_NEI_AssLineHandler.drawText(10, 103, GT_Utility.trans("155", "Amperage: ") + GT_Utility.formatNumbers(this.mRecipeMap.mAmperage), -16777216);
                                } else {
                                    GT_NEI_AssLineHandler.drawText(10, 93, GT_Utility.trans("156", "Voltage: unspecified"), -16777216);
                                    GT_NEI_AssLineHandler.drawText(10, 103, GT_Utility.trans("157", "Amperage: unspecified"), -16777216);
                                }
                            }
                            if (tDuration > 0) {
                                GT_NEI_AssLineHandler.drawText(10, 113, GT_Utility.trans("158", "Time: ") + GT_Utility.formatNumbers(0.05 * (double)tDuration) + GT_Utility.trans("161", " secs"), -16777216);
                            }
                            if ((tSpecial = ((CachedDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mSpecialValue) != -100 || !GT_Mod.gregtechproxy.mLowGravProcessing) break block8;
                            GT_NEI_AssLineHandler.drawText(10, 123, GT_Utility.trans("159", "Needs Low Gravity"), -16777216);
                            break block9;
                        }
                        if (tSpecial != -200 || !GT_Mod.gregtechproxy.mEnableCleanroom) break block10;
                        GT_NEI_AssLineHandler.drawText(10, 123, GT_Utility.trans("160", "Needs Cleanroom"), -16777216);
                        break block9;
                    }
                    if (tSpecial != -201) break block11;
                    GT_NEI_AssLineHandler.drawText(10, 123, GT_Utility.trans("206", "Scan for Assembly Line"), -16777216);
                    break block9;
                }
                if (!GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePre) && !GT_Utility.isStringValid(this.mRecipeMap.mNEISpecialValuePost)) break block9;
                GT_NEI_AssLineHandler.drawText(10, 123, this.mRecipeMap.mNEISpecialValuePre + GT_Utility.formatNumbers(tSpecial * this.mRecipeMap.mNEISpecialValueMultiplier) + this.mRecipeMap.mNEISpecialValuePost, -16777216);
                break block9;
            }
            int i = 0;
            for (String descLine : recipeDesc) {
                GT_NEI_AssLineHandler.drawText(10, 73 + 10 * i, descLine, -16777216);
                ++i;
            }
        }
    }

    static {
        GuiContainerManager.addInputHandler((IContainerInputHandler)new GT_RectHandler());
        GuiContainerManager.addTooltipHandler((IContainerTooltipHandler)new GT_RectHandler());
    }

    public class CachedDefaultRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public final GT_Recipe mRecipe;
        public final List<PositionedStack> mOutputs;
        public final List<PositionedStack> mInputs;

        public CachedDefaultRecipe(GT_Recipe aRecipe) {
            super((TemplateRecipeHandler)GT_NEI_AssLineHandler.this);
            this.mOutputs = new ArrayList<PositionedStack>();
            this.mInputs = new ArrayList<PositionedStack>();
            this.mRecipe = aRecipe;
            for (int i = 0; i < 16; ++i) {
                Object obj;
                Object object = obj = aRecipe instanceof GT_Recipe.GT_Recipe_WithAlt ? ((GT_Recipe.GT_Recipe_WithAlt)aRecipe).getAltRepresentativeInput(i) : aRecipe.getRepresentativeInput(i);
                if (obj == null) continue;
                this.mInputs.add(new FixedPositionedStack(obj, 18 * (i % 4) + 12, 18 * (i / 4)));
            }
            if (aRecipe.mSpecialItems != null) {
                this.mInputs.add(new FixedPositionedStack(aRecipe.mSpecialItems, 138, 36));
            }
            if (aRecipe.getOutput(0) != null) {
                this.mOutputs.add(new FixedPositionedStack(aRecipe.getOutput(0), 138, 0, aRecipe.getOutputChance(0)));
            }
            if (aRecipe.mFluidInputs.length > 0 && aRecipe.mFluidInputs[0] != null && aRecipe.mFluidInputs[0].getFluid() != null) {
                this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[0], true), 102, 0));
                if (aRecipe.mFluidInputs.length > 1 && aRecipe.mFluidInputs[1] != null && aRecipe.mFluidInputs[1].getFluid() != null) {
                    this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[1], true), 102, 18));
                    if (aRecipe.mFluidInputs.length > 2 && aRecipe.mFluidInputs[2] != null && aRecipe.mFluidInputs[2].getFluid() != null) {
                        this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[2], true), 102, 36));
                        if (aRecipe.mFluidInputs.length > 3 && aRecipe.mFluidInputs[3] != null && aRecipe.mFluidInputs[3].getFluid() != null) {
                            this.mInputs.add(new FixedPositionedStack(GT_Utility.getFluidDisplayStack(aRecipe.mFluidInputs[3], true), 102, 54));
                        }
                    }
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(GT_NEI_AssLineHandler.this.cycleticks / 10, this.mInputs);
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.mOutputs;
        }
    }

    public class FixedPositionedStack
    extends PositionedStack {
        public final int mChance;
        public boolean permutated;

        public FixedPositionedStack(Object object, int x, int y) {
            this(object, x, y, 0);
        }

        public FixedPositionedStack(Object object, int x, int y, int aChance) {
            super(object, x, y, true);
            this.permutated = false;
            this.mChance = aChance;
        }

        public void generatePermutations() {
            if (this.permutated) {
                return;
            }
            ArrayList<ItemStack> tDisplayStacks = new ArrayList<ItemStack>();
            for (ItemStack tStack : this.items) {
                if (!GT_Utility.isStackValid(tStack)) continue;
                if (tStack.getItemDamage() == Short.MAX_VALUE) {
                    List permutations = ItemList.itemMap.get((Object)tStack.getItem());
                    if (!permutations.isEmpty()) {
                        for (ItemStack stack : permutations) {
                            tDisplayStacks.add(GT_Utility.copyAmount(tStack.stackSize, stack));
                        }
                        continue;
                    }
                    ItemStack base = new ItemStack(tStack.getItem(), tStack.stackSize);
                    base.stackTagCompound = tStack.stackTagCompound;
                    tDisplayStacks.add(base);
                    continue;
                }
                tDisplayStacks.add(GT_Utility.copyOrNull(tStack));
            }
            this.items = tDisplayStacks.toArray(new ItemStack[0]);
            if (this.items.length == 0) {
                this.items = new ItemStack[]{new ItemStack((Block)Blocks.fire)};
            }
            this.permutated = true;
            this.setPermutationToRender(0);
        }
    }

    public static class GT_RectHandler
    implements IContainerInputHandler,
    IContainerTooltipHandler {
        public boolean mouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
            return false;
        }

        public boolean lastKeyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public boolean canHandle(GuiContainer gui) {
            return false;
        }

        public List<String> handleTooltip(GuiContainer gui, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        private boolean transferRect(GuiContainer gui, boolean usage) {
            return this.canHandle(gui) && new Rectangle(138, 18, 18, 18).contains(new Point(GuiDraw.getMousePosition().x - ((GT_GUIContainer_BasicMachine)gui).getLeft() - RecipeInfo.getGuiOffset((GuiContainer)gui)[0], GuiDraw.getMousePosition().y - ((GT_GUIContainer_BasicMachine)gui).getTop() - RecipeInfo.getGuiOffset((GuiContainer)gui)[1])) && (usage ? GuiUsageRecipe.openRecipeGui((String)((GT_GUIContainer_BasicMachine)gui).mNEI, (Object[])new Object[0]) : GuiCraftingRecipe.openRecipeGui((String)((GT_GUIContainer_BasicMachine)gui).mNEI, (Object[])new Object[0]));
        }

        public List<String> handleItemDisplayName(GuiContainer gui, ItemStack itemstack, List<String> currenttip) {
            return currenttip;
        }

        public List<String> handleItemTooltip(GuiContainer gui, ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
            return currenttip;
        }

        public boolean keyTyped(GuiContainer gui, char keyChar, int keyCode) {
            return false;
        }

        public void onKeyTyped(GuiContainer gui, char keyChar, int keyID) {
        }

        public void onMouseClicked(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public void onMouseUp(GuiContainer gui, int mousex, int mousey, int button) {
        }

        public boolean mouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
            return false;
        }

        public void onMouseScrolled(GuiContainer gui, int mousex, int mousey, int scrolled) {
        }

        public void onMouseDragged(GuiContainer gui, int mousex, int mousey, int button, long heldTime) {
        }
    }
}

