/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.gui;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.buttons.ButtonNext;
import amerifrance.guideapi.buttons.ButtonPrev;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.network.PacketHandler;
import amerifrance.guideapi.network.PacketSyncHome;
import amerifrance.guideapi.wrappers.CategoryWrapper;
import com.google.common.collect.HashMultimap;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiHome
extends GuiBase {
    public ResourceLocation outlineTexture;
    public ResourceLocation pageTexture;
    public Book book;
    public HashMultimap<Integer, CategoryWrapper> categoryWrapperMap;
    public ButtonNext buttonNext;
    public ButtonPrev buttonPrev;
    public int categoryPage;

    public GuiHome(Book book, EntityPlayer player, ItemStack bookStack) {
        super(player, bookStack);
        this.book = book;
        this.pageTexture = book.pageTexture;
        this.outlineTexture = book.outlineTexture;
        this.categoryPage = 0;
        this.categoryWrapperMap = HashMultimap.create();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.categoryWrapperMap.clear();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.buttonNext = new ButtonNext(0, this.guiLeft + 4 * this.xSize / 6, this.guiTop + 5 * this.ySize / 6, this);
        this.field_146292_n.add(this.buttonNext);
        this.buttonPrev = new ButtonPrev(1, this.guiLeft + this.xSize / 5, this.guiTop + 5 * this.ySize / 6, this);
        this.field_146292_n.add(this.buttonPrev);
        int cX = this.guiLeft;
        int cY = this.guiTop + 15;
        boolean drawOnLeft = true;
        int i = 0;
        int pageNumber = 0;
        for (CategoryAbstract category : this.book.categoryList) {
            category.onInit(this.book, this, this.player, this.bookStack);
            if (drawOnLeft) {
                this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX, cY, 15, 15, this.player, this.field_146289_q, field_146296_j, drawOnLeft, this.bookStack));
                cX = this.guiLeft + 180;
                drawOnLeft = false;
            } else {
                this.categoryWrapperMap.put((Object)pageNumber, (Object)new CategoryWrapper(this.book, category, cX, cY, 15, 15, this.player, this.field_146289_q, field_146296_j, drawOnLeft, this.bookStack));
                cY += 25;
                cX = this.guiLeft;
                drawOnLeft = true;
            }
            if (++i < 12) continue;
            i = 0;
            cX = this.guiLeft;
            cY = this.guiTop + 15;
            ++pageNumber;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float renderPartialTicks) {
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.draw(mouseX, mouseY, this);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.pageTexture);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.outlineTexture);
        this.drawTexturedModalRectWithColor(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize, this.book.bookColor);
        this.drawSplitString(this.book.getLocalizedWelcomeMessage(), this.guiLeft + 37, this.guiTop + 12, 4 * this.xSize / 6 - 4, 0);
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.canPlayerSee()) continue;
            wrapper.drawExtras(mouseX, mouseY, this);
        }
        this.func_73732_a(this.field_146289_q, String.valueOf(this.categoryPage + 1) + "/" + String.valueOf(this.categoryWrapperMap.asMap().size()), this.guiLeft + this.xSize / 2, this.guiTop + 5 * this.ySize / 6, 0);
        this.drawCenteredStringWithShadow(this.field_146289_q, this.book.getLocalizedBookTitle(), this.guiLeft + this.xSize / 2, this.guiTop - 10, Color.WHITE.getRGB());
        this.buttonPrev.field_146125_m = this.categoryPage != 0;
        this.buttonNext.field_146125_m = this.categoryPage != this.categoryWrapperMap.asMap().size() - 1;
        super.func_73863_a(mouseX, mouseY, renderPartialTicks);
    }

    public void func_73864_a(int mouseX, int mouseY, int typeofClick) {
        super.func_73864_a(mouseX, mouseY, typeofClick);
        for (CategoryWrapper wrapper : this.categoryWrapperMap.get((Object)this.categoryPage)) {
            if (!wrapper.isMouseOnWrapper(mouseX, mouseY) || !wrapper.canPlayerSee()) continue;
            if (typeofClick == 0) {
                wrapper.category.onLeftClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
                continue;
            }
            if (typeofClick != 1) continue;
            wrapper.category.onRightClicked(this.book, mouseX, mouseY, this.player, this.bookStack);
        }
    }

    @Override
    public void func_73869_a(char typedChar, int keyCode) {
        super.func_73869_a(typedChar, keyCode);
        if ((keyCode == 200 || keyCode == 205) && this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
            ++this.categoryPage;
        }
        if ((keyCode == 208 || keyCode == 203) && this.categoryPage > 0) {
            --this.categoryPage;
        }
    }

    public void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 && this.categoryPage + 1 < this.categoryWrapperMap.asMap().size()) {
            ++this.categoryPage;
        } else if (button.field_146127_k == 1 && this.categoryPage > 0) {
            --this.categoryPage;
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSyncHome(this.categoryPage));
    }
}

