/*
 * Decompiled with CFR 0.152.
 */
package amerifrance.guideapi.pages.reciperenderers;

import amerifrance.guideapi.api.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.abstraction.EntryAbstract;
import amerifrance.guideapi.api.base.Book;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.pages.reciperenderers.BasicRecipeRenderer;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedOreRecipeRenderer
extends BasicRecipeRenderer<ShapedOreRecipe> {
    private static final Field _width = ReflectionHelper.findField(ShapedOreRecipe.class, (String[])new String[]{"width"});
    private static final Field _height = ReflectionHelper.findField(ShapedOreRecipe.class, (String[])new String[]{"height"});
    private int width;
    private int height;

    public ShapedOreRecipeRenderer(ShapedOreRecipe recipe) {
        super(recipe);
        try {
            this.width = _width.getInt(recipe);
            this.height = _height.getInt(recipe);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRenderer) {
        super.draw(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRenderer);
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                ArrayList list;
                int stackX = (x + 1) * 17 + (guiLeft + 29);
                int stackY = (y + 1) * 17 + (guiTop + 40);
                Object component = ((ShapedOreRecipe)this.recipe).getInput()[y * this.width + x];
                if (component == null) continue;
                if (component instanceof ItemStack) {
                    GuiHelper.drawItemStack((ItemStack)component, stackX, stackY);
                    if (!GuiHelper.isMouseBetween(mouseX, mouseY, stackX, stackY, 15, 15)) continue;
                    this.tooltips = GuiHelper.getTooltip((ItemStack)component);
                    continue;
                }
                if (!(component instanceof ArrayList) || (list = (ArrayList)component).isEmpty()) continue;
                ItemStack stack = (ItemStack)list.get(this.getRandomizedCycle(x + y * this.width, list.size()));
                GuiHelper.drawItemStack(stack, stackX, stackY);
                if (!GuiHelper.isMouseBetween(mouseX, mouseY, stackX, stackY, 15, 15)) continue;
                this.tooltips = GuiHelper.getTooltip(stack);
            }
        }
    }
}

