/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.game.save.types.player;

import chylex.hee.game.save.types.PlayerFile;
import chylex.hee.system.abstractions.Pos;
import chylex.hee.system.util.NBTUtil;
import java.util.Optional;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PortalFile
extends PlayerFile {
    private Pos strongholdPos;
    private InventoryBasic inventory = new InventoryBasic("", false, 27);

    public PortalFile(String filename) {
        super("portal", filename);
    }

    public void setStrongholdPos(Pos pos) {
        this.strongholdPos = pos.immutable();
        this.setModified();
    }

    public Optional<Pos> getStrongholdPos() {
        return Optional.ofNullable(this.strongholdPos);
    }

    public void onTokenInventoryUpdated() {
        this.setModified();
    }

    public InventoryBasic getTokenInventory() {
        return this.inventory;
    }

    @Override
    protected void onSave(NBTTagCompound nbt) {
        if (this.strongholdPos != null) {
            nbt.func_74772_a("stronghold", this.strongholdPos.toLong());
        }
        nbt.func_74782_a("inv", (NBTBase)NBTUtil.writeInventory((IInventory)this.inventory));
    }

    @Override
    protected void onLoad(NBTTagCompound nbt) {
        this.strongholdPos = nbt.func_74764_b("stronghold") ? Pos.at((long)nbt.func_74763_f("stronghold")) : null;
        NBTUtil.readInventory((NBTTagList)nbt.func_150295_c("inv", 10), (IInventory)this.inventory);
    }
}

