/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.gui.controls;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.network.NetworkHelper;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityThermo;

@SideOnly(value=Side.CLIENT)
public class GuiRemoteThermoSlider
extends GuiButton {
    private static final String TEXTURE_FILE = "nuclearcontrol:textures/gui/GUIRemoteThermo.png";
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("nuclearcontrol:textures/gui/GUIRemoteThermo.png");
    private static final int ARROW_WIDTH = 6;
    private static final float TEMP_RANGE = 16000.0f;
    private static final int HEAT_STEP = 100;
    public float sliderValue;
    public boolean dragging;
    private String label;
    private TileEntityThermo thermo;
    private float effectiveWidth;
    private double sliderValueStep;

    public GuiRemoteThermoSlider(int id, int x, int y, String label, TileEntityThermo thermo) {
        super(id, x, y, 181, 16, label);
        this.thermo = thermo;
        this.dragging = false;
        this.label = label;
        this.sliderValue = (float)thermo.getHeatLevel().intValue() / 16000.0f;
        this.field_146126_j = String.format(label, this.getNormalizedHeatLevel());
        this.effectiveWidth = this.field_146120_f - 8 - 12;
        this.sliderValueStep = 0.00625f;
    }

    public void checkMouseWheel(int mouseX, int mouseY) {
        int delta;
        boolean isHover;
        boolean bl = isHover = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        if (isHover && (delta = Mouse.getEventDWheel()) != 0) {
            int multiplier;
            int n = multiplier = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54) ? 1 : 3;
            if (delta > 0) {
                this.setSliderPos(this.field_146128_h + 1, multiplier);
            } else {
                this.setSliderPos(this.field_146128_h + this.field_146120_f - 1, multiplier);
            }
        }
    }

    private int getNormalizedHeatLevel() {
        return (int)Math.floor(16000.0f * this.sliderValue) / 100 * 100;
    }

    private void setSliderPos(int targetX, int multiplier) {
        this.sliderValue = targetX < this.field_146128_h + 6 ? (float)((double)this.sliderValue - this.sliderValueStep * (double)multiplier) : (targetX > this.field_146128_h + this.field_146120_f - 6 ? (float)((double)this.sliderValue + this.sliderValueStep * (double)multiplier) : (float)(targetX - (this.field_146128_h + 4 + 6)) / this.effectiveWidth);
        if (this.sliderValue < 0.0f) {
            this.sliderValue = 0.0f;
        }
        if (this.sliderValue > 1.0f) {
            this.sliderValue = 1.0f;
        }
        int newHeatLevel = this.getNormalizedHeatLevel();
        if (this.thermo.getHeatLevel() != newHeatLevel) {
            this.thermo.setHeatLevel(newHeatLevel);
            NetworkHelper nh = new NetworkHelper();
            try {
                Method m1 = nh.getClass().getDeclaredMethod("initiateClientTileEntityEvent", new Class[0]);
                m1.setAccessible(true);
                m1.invoke((Object)this.thermo, newHeatLevel);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.field_146126_j = String.format(this.label, newHeatLevel);
    }

    public void func_146112_a(Minecraft minecraft, int targetX, int targetY) {
        if (this.field_146125_m) {
            minecraft.field_71446_o.func_110577_a(TEXTURE_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (this.dragging && targetX >= this.field_146128_h + 6 && targetX <= this.field_146128_h + this.field_146120_f - 6) {
                this.setSliderPos(targetX, 1);
            }
            this.func_73729_b(this.field_146128_h + 6 + (int)(this.sliderValue * this.effectiveWidth), this.field_146129_i, 0, 166, 8, 16);
            minecraft.field_71466_p.func_78276_b(this.field_146126_j, this.field_146128_h, this.field_146129_i - 12, 0x404040);
        }
    }

    public boolean func_146116_c(Minecraft minecraft, int targetX, int j) {
        if (super.func_146116_c(minecraft, targetX, j)) {
            this.setSliderPos(targetX, 1);
            this.dragging = true;
            return true;
        }
        return false;
    }

    public void func_146118_a(int i, int j) {
        super.func_146118_a(i, j);
        this.dragging = false;
    }
}

