/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.items;

import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidTankInfo;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.items.ItemSensorKitBase;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityAverageCounter;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityEnergyCounter;
import shedar.mods.ic2.nuclearcontrol.utils.LiquidStorageHelper;
import shedar.mods.ic2.nuclearcontrol.utils.TextureResolver;

public class ItemKitMultipleSensor
extends ItemSensorKitBase {
    public static final int TYPE_COUNTER = 0;
    public static final int TYPE_LIQUID = 1;
    public static final int TYPE_GENERATOR = 2;
    private static final String TEXTURE_KIT_COUNTER = "kitCounter";
    private static final String TEXTURE_KIT_LIQUID = "kitLiquid";
    private static final String TEXTURE_KIT_GENERATOR = "kitGenerator";
    private IIcon iconCounter;
    private IIcon iconLiquid;
    private IIcon iconGenerator;

    public ItemKitMultipleSensor() {
        super("");
    }

    public String func_77667_c(ItemStack stack) {
        int damage = stack.func_77960_j();
        switch (damage) {
            case 0: {
                return "item.ItemCounterSensorKit";
            }
            case 1: {
                return "item.ItemLiquidSensorKit";
            }
            case 2: {
                return "item.ItemGeneratorSensorKit";
            }
        }
        return "";
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.iconCounter = iconRegister.func_94245_a(TextureResolver.getItemTexture(TEXTURE_KIT_COUNTER));
        this.iconLiquid = iconRegister.func_94245_a(TextureResolver.getItemTexture(TEXTURE_KIT_LIQUID));
        this.iconGenerator = iconRegister.func_94245_a(TextureResolver.getItemTexture(TEXTURE_KIT_GENERATOR));
    }

    public IIcon func_77617_a(int damage) {
        switch (damage) {
            case 0: {
                return this.iconCounter;
            }
            case 1: {
                return this.iconLiquid;
            }
            case 2: {
                return this.iconGenerator;
            }
        }
        return null;
    }

    @Override
    protected ChunkCoordinates getTargetCoordinates(World world, int x, int y, int z, ItemStack stack) {
        int damage = stack.func_77960_j();
        switch (damage) {
            case 0: {
                TileEntity entity = world.func_147438_o(x, y, z);
                if (entity == null || !(entity instanceof TileEntityEnergyCounter) && !(entity instanceof TileEntityAverageCounter)) break;
                return new ChunkCoordinates(x, y, z);
            }
            case 1: {
                FluidTankInfo tank = LiquidStorageHelper.getStorageAt(world, x, y, z);
                if (tank == null) break;
                return new ChunkCoordinates(x, y, z);
            }
            case 2: {
                TileEntity tileentity = world.func_147438_o(x, y, z);
                if (tileentity == null || !(tileentity instanceof TileEntityBaseGenerator)) break;
                return new ChunkCoordinates(x, y, z);
            }
        }
        return null;
    }

    @Override
    protected ItemStack getItemStackByDamage(int damage) {
        switch (damage) {
            case 0: {
                return new ItemStack(IC2NuclearControl.itemMultipleSensorLocationCard, 1, 0);
            }
            case 1: {
                return new ItemStack(IC2NuclearControl.itemMultipleSensorLocationCard, 1, 1);
            }
            case 2: {
                return new ItemStack(IC2NuclearControl.itemMultipleSensorLocationCard, 1, 2);
            }
        }
        return null;
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
        list.add(new ItemStack(item, 1, 2));
    }
}

