/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.tileentities;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkDataProvider;
import ic2.api.network.INetworkUpdateListener;
import ic2.api.tile.IWrenchable;
import ic2.core.IC2;
import ic2.core.network.NetworkManager;
import java.util.List;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import shedar.mods.ic2.nuclearcontrol.IC2NuclearControl;
import shedar.mods.ic2.nuclearcontrol.IRedstoneConsumer;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntitySound;
import shedar.mods.ic2.nuclearcontrol.utils.RedstoneHelper;

public class TileEntityHowlerAlarm
extends TileEntity
implements INetworkDataProvider,
INetworkUpdateListener,
IWrenchable,
IRedstoneConsumer,
INetworkClientTileEntityEventListener {
    private static final String DEFAULT_SOUND_NAME = "default";
    private static final float BASE_SOUND_RANGE = 16.0f;
    private static final String SOUND_PREFIX = "nuclearcontrol:alarm-";
    private boolean init = false;
    private boolean soundReceived;
    private short prevFacing = 0;
    public short facing = 0;
    public int range;
    private int prevRange;
    public boolean powered = false;
    private boolean prevPowered = false;
    public String soundName = "";
    private String prevSoundName;
    private int updateTicker = 0;
    protected int tickRate = 2;
    private TileEntitySound sound;
    private int color;

    public TileEntityHowlerAlarm() {
        this.range = IC2NuclearControl.instance.alarmRange;
        this.soundReceived = false;
        this.color = 0xFFFFFF;
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.sound = new TileEntitySound();
        }
    }

    private void initData() {
        if (!this.field_145850_b.field_72995_K) {
            RedstoneHelper.checkPowered(this.field_145850_b, this);
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isServer() && "".equals(this.soundName)) {
            this.setSoundName(DEFAULT_SOUND_NAME);
        }
        this.init = true;
    }

    public int getRange() {
        return this.range;
    }

    public void setRange(int r) {
        this.range = r;
        if (this.prevRange != r) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "range");
        }
        this.prevRange = this.range;
    }

    public String getSoundName() {
        return this.soundName;
    }

    public void setSoundName(String name) {
        this.soundName = name;
        if (this.prevSoundName != name) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "soundName");
        }
        this.prevSoundName = name;
    }

    public void onNetworkEvent(EntityPlayer entityplayer, int i) {
        this.setRange(i);
    }

    public short getFacing() {
        return (short)Facing.field_71588_a[this.facing];
    }

    public void setFacing(short f) {
        this.setSide((short)Facing.field_71588_a[f]);
    }

    private void setSide(short f) {
        this.facing = f;
        if (this.prevFacing != f) {
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "facing");
        }
        this.prevFacing = f;
    }

    @Override
    public boolean getPowered() {
        return this.powered;
    }

    public void func_145843_s() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.sound.stopAlarm();
        }
        super.func_145843_s();
    }

    @Override
    public void setPowered(boolean value) {
        this.powered = value;
        if (this.prevPowered != value) {
            if (this.powered) {
                if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.soundReceived) {
                    this.sound.playAlarm((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, SOUND_PREFIX + this.soundName, this.getNormalizedRange(), false);
                }
            } else if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.sound.stopAlarm();
            }
            ((NetworkManager)IC2.network.get()).updateTileEntityField((TileEntity)this, "powered");
        }
        this.prevPowered = value;
    }

    public void setPoweredNoNotify(boolean value) {
        this.powered = value;
        if (this.prevPowered != value) {
            if (this.powered) {
                if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.soundReceived) {
                    this.sound.playAlarm((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, SOUND_PREFIX + this.soundName, this.getNormalizedRange(), false);
                }
            } else if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.sound.stopAlarm();
            }
        }
        this.prevPowered = value;
    }

    private float getNormalizedRange() {
        if (this.field_145850_b.field_72995_K) {
            return (float)Math.min(this.range, IC2NuclearControl.instance.SMPMaxAlarmRange) / 16.0f;
        }
        return (float)this.range / 16.0f;
    }

    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return true;
    }

    public float getWrenchDropRate() {
        return 1.0f;
    }

    public void onNetworkUpdate(String field) {
        if (field.equals("facing") && this.prevFacing != this.facing) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.prevFacing = this.facing;
        }
        if (field.equals("powered") && this.prevPowered != this.powered) {
            this.setPoweredNoNotify(this.powered);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.field_72995_K && field.equals("soundName") && this.prevSoundName != this.soundName) {
            if (IC2NuclearControl.instance.availableAlarms != null && !IC2NuclearControl.instance.availableAlarms.contains(this.soundName)) {
                IC2NuclearControl.logger.info("Can't set sound '%s' at %d,%d,%d, using default", new Object[]{this.soundName, this.field_145851_c, this.field_145848_d, this.field_145849_e});
                this.soundName = DEFAULT_SOUND_NAME;
            }
            this.prevSoundName = this.soundName;
        }
        if (field.equals("soundName")) {
            this.soundReceived = true;
        }
    }

    public List<String> getNetworkedFields() {
        Vector<String> vector = new Vector<String>(2);
        vector.add("facing");
        vector.add("powered");
        vector.add("range");
        vector.add("soundName");
        return vector;
    }

    public void func_145845_h() {
        if (!this.init) {
            this.initData();
        }
        super.func_145845_h();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            if (this.tickRate != -1 && this.updateTicker-- > 0) {
                return;
            }
            this.updateTicker = this.tickRate;
            this.checkStatus();
        }
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.prevFacing = this.facing = nbttagcompound.func_74765_d("facing");
        this.color = nbttagcompound.func_74762_e("color");
        if (nbttagcompound.func_74764_b("soundName")) {
            this.prevSoundName = this.soundName = nbttagcompound.func_74779_i("soundName");
            this.prevRange = this.range = nbttagcompound.func_74762_e("range");
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74777_a("facing", this.facing);
        nbttagcompound.func_74778_a("soundName", this.soundName);
        nbttagcompound.func_74768_a("range", this.range);
        nbttagcompound.func_74768_a("color", this.color);
    }

    protected void checkStatus() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient() && this.powered && this.soundReceived && !this.sound.isPlaying()) {
            this.sound.playAlarm((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, SOUND_PREFIX + this.soundName, this.getNormalizedRange(), true);
        }
    }

    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack((Block)IC2NuclearControl.blockNuclearControlMain, 1, 2);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int Color) {
        this.color = Color;
    }

    public Packet func_145844_m() {
        NBTTagCompound syncData = new NBTTagCompound();
        syncData.func_74768_a("Color", this.color);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, syncData);
    }

    public void onDataPacket(net.minecraft.network.NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.color = pkt.func_148857_g().func_74762_e("Color");
    }
}

