/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ArcFurnaceRecipe {
    public final Object input;
    public final String oreInputString;
    public final ItemStack output;
    public final ItemStack slag;
    public final Object[] additives;
    public final int time;
    public final int energyPerTick;
    public String specialRecipeType;
    public static ArrayList<String> specialRecipeTypes = new ArrayList();
    public static ArrayList<ArcFurnaceRecipe> recipeList = new ArrayList();
    public static ArrayList recyclingAllowed = new ArrayList();
    public static ArrayList invalidRecyclingOutput = new ArrayList();

    public ArcFurnaceRecipe(ItemStack output, Object input, ItemStack slag, int time, int energyPerTick, Object ... additives) {
        this.output = output;
        this.input = input == null ? null : ApiUtils.convertToValidRecipeInput(input);
        this.oreInputString = input instanceof String ? (String)input : null;
        this.slag = slag;
        this.time = time;
        this.energyPerTick = energyPerTick;
        if (additives == null) {
            this.additives = new Object[0];
        } else {
            this.additives = new Object[additives.length];
            for (int i = 0; i < additives.length; ++i) {
                this.additives[i] = ApiUtils.convertToValidRecipeInput(additives[i]);
            }
        }
    }

    public ItemStack[] getOutputs(ItemStack input, ItemStack[] additives) {
        return new ItemStack[]{this.output};
    }

    public boolean matches(ItemStack input, ItemStack[] additives) {
        if (ApiUtils.stackMatchesObject(input, this.input)) {
            ArrayList<ItemStack> qAdd = new ArrayList<ItemStack>(additives.length);
            for (ItemStack itemStack : additives) {
                qAdd.add(itemStack);
            }
            for (Object object : this.additives) {
                if (object == null) continue;
                int addAmount = object instanceof ItemStack ? ((ItemStack)object).stackSize : 1;
                Iterator it = qAdd.iterator();
                while (it.hasNext()) {
                    ItemStack query = (ItemStack)it.next();
                    if (query == null) continue;
                    if (ApiUtils.stackMatchesObject(query, object)) {
                        if (query.stackSize > addAmount) {
                            query.stackSize -= addAmount;
                            addAmount = 0;
                        } else {
                            addAmount -= query.stackSize;
                            query.stackSize = 0;
                        }
                    }
                    if (query.stackSize <= 0) {
                        it.remove();
                    }
                    if (addAmount > 0) continue;
                    break;
                }
                if (addAmount <= 0) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isValidInput(ItemStack stack) {
        return ApiUtils.stackMatchesObject(stack, this.input);
    }

    public boolean isValidAdditive(ItemStack stack) {
        for (Object add : this.additives) {
            if (!ApiUtils.stackMatchesObject(stack, add)) continue;
            return true;
        }
        return false;
    }

    public ArcFurnaceRecipe setSpecialRecipeType(String type) {
        this.specialRecipeType = type;
        if (!specialRecipeTypes.contains(type)) {
            specialRecipeTypes.add(type);
        }
        return this;
    }

    public static ArcFurnaceRecipe addRecipe(ItemStack output, Object input, ItemStack slag, int time, int energyPerTick, Object ... additives) {
        ArcFurnaceRecipe recipe = new ArcFurnaceRecipe(output, input, slag, time, energyPerTick, additives);
        if (recipe.input != null) {
            recipeList.add(recipe);
        }
        return recipe;
    }

    public static ArcFurnaceRecipe findRecipe(ItemStack input, ItemStack[] additives) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (recipe == null || !recipe.matches(input, additives)) continue;
            return recipe;
        }
        return null;
    }

    public static List<ArcFurnaceRecipe> removeRecipes(ItemStack stack) {
        ArrayList<ArcFurnaceRecipe> list = new ArrayList<ArcFurnaceRecipe>();
        Iterator<ArcFurnaceRecipe> it = recipeList.iterator();
        while (it.hasNext()) {
            ArcFurnaceRecipe ir = it.next();
            if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)stack, (boolean)true)) continue;
            list.add(ir);
            it.remove();
        }
        return list;
    }

    public static boolean isValidRecipeInput(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (recipe == null || !recipe.isValidInput(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidRecipeAdditive(ItemStack stack) {
        for (ArcFurnaceRecipe recipe : recipeList) {
            if (recipe == null || !recipe.isValidAdditive(stack)) continue;
            return true;
        }
        return false;
    }

    public static void allowItemForRecycling(Object stack) {
        recyclingAllowed.add(ApiUtils.convertToValidRecipeInput(stack));
    }

    public static void makeItemInvalidRecyclingOutput(Object stack) {
        invalidRecyclingOutput.add(ApiUtils.convertToValidRecipeInput(stack));
    }
}

