/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.ComparableItemStack;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class MetalPressRecipe {
    public final Object input;
    public final ComparableItemStack mold;
    public final ItemStack output;
    public final int energy;
    public int inputSize;
    public static ArrayListMultimap<ComparableItemStack, MetalPressRecipe> recipeList = ArrayListMultimap.create();

    public MetalPressRecipe(ItemStack output, Object input, ItemStack mould, int energy) {
        this.output = output;
        this.input = ApiUtils.convertToValidRecipeInput(input);
        this.mold = ApiUtils.createComparableItemStack(mould);
        this.energy = energy;
        this.inputSize = this.input instanceof ItemStack ? ((ItemStack)this.input).stackSize : 1;
    }

    public MetalPressRecipe setInputSize(int size) {
        this.inputSize = size;
        if (this.input instanceof ItemStack) {
            ((ItemStack)this.input).stackSize = size;
        }
        return this;
    }

    public static MetalPressRecipe addRecipe(ItemStack output, Object input, ItemStack mold, int energy) {
        MetalPressRecipe r = new MetalPressRecipe(output, input, mold, energy);
        recipeList.put((Object)r.mold, (Object)r);
        return r;
    }

    public static MetalPressRecipe findRecipe(ItemStack mould, ItemStack input, boolean checkStackSize) {
        if (mould == null || input == null) {
            return null;
        }
        ComparableItemStack comp = ApiUtils.createComparableItemStack(mould);
        List list = recipeList.get((Object)comp);
        for (MetalPressRecipe recipe : list) {
            if (!ApiUtils.stackMatchesObject(input, recipe.input) || checkStackSize && input.stackSize < recipe.inputSize) continue;
            return recipe;
        }
        return null;
    }

    public static List<MetalPressRecipe> removeRecipes(ItemStack output) {
        ArrayList<MetalPressRecipe> list = new ArrayList<MetalPressRecipe>();
        for (ComparableItemStack mold : recipeList.keySet()) {
            Iterator it = recipeList.get((Object)mold).iterator();
            while (it.hasNext()) {
                MetalPressRecipe ir = (MetalPressRecipe)it.next();
                if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)output, (boolean)true)) continue;
                list.add(ir);
                it.remove();
            }
        }
        return list;
    }

    public static boolean isValidMold(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return recipeList.containsKey((Object)ApiUtils.createComparableItemStack(itemStack));
    }
}

