/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.AdvancedAABB;
import blusunrize.immersiveengineering.api.crafting.BlastFurnaceRecipe;
import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.api.energy.WireType;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.client.ClientProxy;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.fx.ParticleRenderer;
import blusunrize.immersiveengineering.client.gui.GuiBlastFurnace;
import blusunrize.immersiveengineering.client.models.ModelIEObj;
import blusunrize.immersiveengineering.client.render.TileRenderArcFurnace;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.gui.ContainerRevolver;
import blusunrize.immersiveengineering.common.items.ItemChemthrower;
import blusunrize.immersiveengineering.common.items.ItemDrill;
import blusunrize.immersiveengineering.common.items.ItemRevolver;
import blusunrize.immersiveengineering.common.items.ItemSkyhook;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Lib;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.compat.GregTechHelper;
import blusunrize.immersiveengineering.common.util.network.MessageRequestBlockUpdate;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelVillager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class ClientEventHandler {
    public static IIcon iconItemBlank;
    public static int itemSheetWidth;
    public static int itemSheetHeight;
    public static Set<ImmersiveNetHandler.Connection> skyhookGrabableConnections;
    static boolean connectionsRendered;

    @SubscribeEvent
    public void textureStich(TextureStitchEvent.Pre event) {
        if (event.map.getTextureType() == 0) {
            if (IEContent.IECreosote) {
                IEContent.fluidCreosote.setIcons(event.map.registerIcon("immersiveengineering:fluid/creosote_still"), event.map.registerIcon("immersiveengineering:fluid/creosote_flow"));
            }
            if (IEContent.IEPlantoil) {
                IEContent.fluidPlantoil.setIcons(event.map.registerIcon("immersiveengineering:fluid/plantoil_still"), event.map.registerIcon("immersiveengineering:fluid/plantoil_flow"));
            }
            if (IEContent.IEEthanol) {
                IEContent.fluidEthanol.setIcons(event.map.registerIcon("immersiveengineering:fluid/ethanol_still"), event.map.registerIcon("immersiveengineering:fluid/ethanol_flow"));
            }
            if (IEContent.IEBiodiesel) {
                IEContent.fluidBiodiesel.setIcons(event.map.registerIcon("immersiveengineering:fluid/biodiesel_still"), event.map.registerIcon("immersiveengineering:fluid/biodiesel_flow"));
            }
            WireType.iconDefaultWire = event.map.registerIcon("immersiveengineering:wire");
            TileRenderArcFurnace.hotMetal_flow = event.map.registerIcon("immersiveengineering:fluid/hotMetal_flow");
            TileRenderArcFurnace.hotMetal_still = event.map.registerIcon("immersiveengineering:fluid/hotMetal_still");
        }
        if (event.map.getTextureType() == 1) {
            iconItemBlank = event.map.registerIcon("immersiveengineering:white");
        }
        if (event.map.getTextureType() == Config.getInt("revolverSheetID")) {
            IELogger.info("Stitching Revolver Textures!");
            ((ItemRevolver)IEContent.itemRevolver).stichRevolverTextures((IIconRegister)event.map);
        }
        for (ShaderRegistry.ShaderRegistryEntry entry : ShaderRegistry.shaderRegistry.values()) {
            for (ShaderCase sCase : entry.getCases()) {
                sCase.stichTextures((IIconRegister)event.map, event.map.getTextureType());
            }
        }
    }

    @SubscribeEvent
    public void textureStich(TextureStitchEvent.Post event) {
        if (event.map.getTextureType() == 0) {
            for (ModelIEObj modelIE : ModelIEObj.existingStaticRenders) {
                WavefrontObject model = modelIE.rebindModel();
                this.rebindUVsToIcon(model, modelIE);
            }
        }
        if (event.map.getTextureType() == 1) {
            itemSheetWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            itemSheetHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        }
    }

    void rebindUVsToIcon(WavefrontObject model, ModelIEObj modelIE) {
        for (GroupObject groupObject : model.groupObjects) {
            IIcon icon = modelIE.getBlockIcon(groupObject.name);
            if (icon == null) continue;
            float minU = icon.getInterpolatedU(0.0);
            float sizeU = icon.getInterpolatedU(16.0) - minU;
            float minV = icon.getInterpolatedV(0.0);
            float sizeV = icon.getInterpolatedV(16.0) - minV;
            float baseOffsetU = 16.0f / (float)icon.getIconWidth() * 5.0E-4f;
            float baseOffsetV = 16.0f / (float)icon.getIconHeight() * 5.0E-4f;
            for (Face face : groupObject.faces) {
                int i;
                float averageU = 0.0f;
                float averageV = 0.0f;
                if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                    for (i = 0; i < face.textureCoordinates.length; ++i) {
                        averageU += face.textureCoordinates[i].u;
                        averageV += face.textureCoordinates[i].v;
                    }
                    averageU /= (float)face.textureCoordinates.length;
                    averageV /= (float)face.textureCoordinates.length;
                }
                for (i = 0; i < face.vertices.length; ++i) {
                    TextureCoordinate textureCoordinate = face.textureCoordinates[i];
                    float offsetU = baseOffsetU;
                    float offsetV = baseOffsetV;
                    if (face.textureCoordinates[i].u > averageU) {
                        offsetU = -offsetU;
                    }
                    if (face.textureCoordinates[i].v > averageV) {
                        offsetV = -offsetV;
                    }
                    face.textureCoordinates[i] = new TextureCoordinate(minU + sizeU * (textureCoordinate.u + offsetU), minV + sizeV * (textureCoordinate.v + offsetV));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        ItemStack stack;
        EntityPlayer player;
        if (event.side.isClient() && event.phase == TickEvent.Phase.START && event.player == ClientUtils.mc().renderViewEntity) {
            skyhookGrabableConnections.clear();
            player = event.player;
            stack = player.getCurrentEquippedItem();
            if (stack != null && stack.getItem() instanceof ItemSkyhook) {
                TileEntity connector = null;
                double lastDist = 0.0;
                ImmersiveNetHandler.Connection line = null;
                double py = player.posY + (double)player.getEyeHeight();
                for (int xx = -2; xx <= 2; ++xx) {
                    for (int zz = -2; zz <= 2; ++zz) {
                        for (int yy = 0; yy <= 3; ++yy) {
                            ImmersiveNetHandler.Connection con;
                            TileEntity tile = player.worldObj.getTileEntity((int)player.posX + xx, (int)py + yy, (int)player.posZ + zz);
                            if (tile == null || (con = SkylineHelper.getTargetConnection(player.worldObj, tile.xCoord, tile.yCoord, tile.zCoord, (EntityLivingBase)player, null)) == null) continue;
                            double d = tile.getDistanceFrom(player.posX, py, player.posZ);
                            if (connector != null && !(d < lastDist)) continue;
                            connector = tile;
                            lastDist = d;
                            line = con;
                        }
                    }
                }
                if (line != null && connector != null) {
                    skyhookGrabableConnections.add(line);
                }
            }
        }
        if (event.side.isClient() && event.phase == TickEvent.Phase.END && event.player != null) {
            boolean twohanded;
            player = event.player;
            stack = player.getCurrentEquippedItem();
            boolean bl = twohanded = stack != null && stack.getItem() instanceof ItemDrill;
            if (twohanded && (player != ClientUtils.mc().renderViewEntity || ClientUtils.mc().gameSettings.thirdPersonView != 0) && player.getItemInUseCount() <= 0) {
                player.clearItemInUse();
                player.setItemInUse(stack, Integer.MAX_VALUE);
            }
            if (!Minecraft.getMinecraft().isIntegratedServerRunning() && ItemDrill.animationTimer != null && ItemDrill.animationTimer.containsKey(player.getCommandSenderName())) {
                ConcurrentHashMap<String, Integer> concurrentHashMap = ItemDrill.animationTimer;
                synchronized (concurrentHashMap) {
                    Integer timer;
                    Integer n = timer = ItemDrill.animationTimer.get(player.getCommandSenderName());
                    Integer n2 = timer = Integer.valueOf(timer - 1);
                    if (timer < 18 && timer > 15) {
                        timer = 20;
                    }
                    if (timer > 0) {
                        ItemDrill.animationTimer.put(player.getCommandSenderName(), timer);
                    } else {
                        ItemDrill.animationTimer.remove(player.getCommandSenderName());
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && ClientUtils.mc().currentScreen != null && ClientUtils.mc().currentScreen instanceof GuiBlastFurnace && BlastFurnaceRecipe.isValidBlastFuel(event.itemStack)) {
            event.toolTip.add(EnumChatFormatting.GRAY + StatCollector.translateToLocalFormatted((String)"desc.ImmersiveEngineering.info.blastFuelTime", (Object[])new Object[]{BlastFurnaceRecipe.getBlastFuelTime(event.itemStack)}));
        }
    }

    @SubscribeEvent
    public void lastWorldRender(RenderWorldLastEvent event) {
        connectionsRendered = false;
        ParticleRenderer.dispatch();
    }

    public static void renderAllIEConnections(float partial) {
        if (connectionsRendered) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        RenderHelper.enableStandardItemLighting();
        Tessellator.instance.startDrawing(7);
        EntityLivingBase viewer = ClientUtils.mc().renderViewEntity;
        double dx = viewer.lastTickPosX + (viewer.posX - viewer.lastTickPosX) * (double)partial;
        double dy = viewer.lastTickPosY + (viewer.posY - viewer.lastTickPosY) * (double)partial;
        double dz = viewer.lastTickPosZ + (viewer.posZ - viewer.lastTickPosZ) * (double)partial;
        for (Object o : ClientUtils.mc().renderGlobal.tileEntities) {
            if (!(o instanceof IImmersiveConnectable)) continue;
            TileEntity tile = (TileEntity)o;
            Tessellator.instance.setTranslation((double)tile.xCoord - dx, (double)tile.yCoord - dy, (double)tile.zCoord - dz);
            ClientUtils.renderAttachedConnections(tile);
        }
        Iterator<ImmersiveNetHandler.Connection> it = skyhookGrabableConnections.iterator();
        World world = viewer.worldObj;
        while (it.hasNext()) {
            ImmersiveNetHandler.Connection con = it.next();
            Tessellator.instance.setTranslation((double)con.start.posX - dx, (double)con.start.posY - dy, (double)con.start.posZ - dz);
            double r = con.cableType.getRenderDiameter() / 2.0;
            ClientUtils.drawConnection(con, Utils.toIIC(con.start, world), Utils.toIIC(con.end, world), 65433, 128, r * 1.75, con.cableType.getIcon(con));
        }
        Tessellator.instance.setTranslation(0.0, 0.0, 0.0);
        Tessellator.instance.draw();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        connectionsRendered = true;
    }

    @SubscribeEvent
    public void onRenderOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (ZoomHandler.isZooming && event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (ZoomHandler.isZooming) {
                ZoomHandler.IZoomTool tool;
                float[] steps;
                ClientUtils.bindTexture("immersiveengineering:textures/gui/scope.png");
                int width = event.resolution.getScaledWidth();
                int height = event.resolution.getScaledHeight();
                int resMin = Math.min(width, height);
                float offsetX = (float)(width - resMin) / 2.0f;
                float offsetY = (float)(height - resMin) / 2.0f;
                if (resMin == width) {
                    ClientUtils.drawColouredRect(0, 0, width, (int)offsetY + 1, -16777216);
                    ClientUtils.drawColouredRect(0, (int)offsetY + resMin, width, (int)offsetY + 1, -16777216);
                } else {
                    ClientUtils.drawColouredRect(0, 0, (int)offsetX + 1, height, -16777216);
                    ClientUtils.drawColouredRect((int)offsetX + resMin, 0, (int)offsetX + 1, height, -16777216);
                }
                GL11.glEnable((int)3042);
                OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
                GL11.glTranslatef((float)offsetX, (float)offsetY, (float)0.0f);
                ClientUtils.drawTexturedRect(0.0f, 0.0f, (float)resMin, (float)resMin, 0.0, 1.0, 0.0, 1.0);
                ClientUtils.bindTexture("immersiveengineering:textures/gui/hudElements.png");
                ClientUtils.drawTexturedRect(0.8515625f * (float)resMin, 0.25f * (float)resMin, 0.09375f * (float)resMin, 0.5f * (float)resMin, 0.25, 0.34375, 0.375, 0.875);
                ItemStack equipped = ClientUtils.mc().thePlayer.getCurrentEquippedItem();
                if (equipped != null && equipped.getItem() instanceof ZoomHandler.IZoomTool && (steps = (tool = (ZoomHandler.IZoomTool)equipped.getItem()).getZoomSteps(equipped, (EntityPlayer)ClientUtils.mc().thePlayer)) != null && steps.length > 1) {
                    int curStep = -1;
                    float dist = 0.0f;
                    float totalOffset = 0.0f;
                    float stepLength = 118.0f / (float)steps.length;
                    float stepOffset = (stepLength - 7.0f) / 2.0f;
                    GL11.glTranslatef((float)(0.87109375f * (float)resMin), (float)(0.25f * (float)resMin), (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)((5.0f + stepOffset) / 256.0f * (float)resMin), (float)0.0f);
                    for (int i = 0; i < steps.length; ++i) {
                        ClientUtils.drawTexturedRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375, 0.375, 0.375, 0.40234375);
                        GL11.glTranslatef((float)0.0f, (float)(stepLength / 256.0f * (float)resMin), (float)0.0f);
                        totalOffset += stepLength;
                        if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                        curStep = i;
                        dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                    }
                    GL11.glTranslatef((float)0.0f, (float)(-totalOffset / 256.0f * (float)resMin), (float)0.0f);
                    if (curStep >= 0 && curStep < steps.length) {
                        GL11.glTranslatef((float)(0.0234375f * (float)resMin), (float)((float)curStep * stepLength / 256.0f * (float)resMin), (float)0.0f);
                        ClientUtils.drawTexturedRect(0.0f, 0.0f, 0.03125f * (float)resMin, 0.02734375f * (float)resMin, 0.34375, 0.3828125, 0.40234375, 0.4296875);
                        ClientUtils.font().drawString(1.0f / steps[curStep] + "x", (int)(0.0625f * (float)resMin), 0, 0xFFFFFF);
                        GL11.glTranslatef((float)(-0.0234375f * (float)resMin), (float)((float)(-curStep) * stepLength / 256.0f * (float)resMin), (float)0.0f);
                    }
                    GL11.glTranslatef((float)0.0f, (float)(-((5.0f + stepOffset) / 256.0f * (float)resMin)), (float)0.0f);
                    GL11.glTranslatef((float)(-0.87109375f * (float)resMin), (float)(-0.25f * (float)resMin), (float)0.0f);
                }
                GL11.glTranslatef((float)(-offsetX), (float)(-offsetY), (float)0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent.Post event) {
        if (ClientUtils.mc().thePlayer != null && event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            TileEntity tileEntity;
            MovingObjectPosition mop;
            EntityClientPlayerMP player = ClientUtils.mc().thePlayer;
            if (player.getCurrentEquippedItem() != null) {
                ItemStack equipped = player.getCurrentEquippedItem();
                if (OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 2), (ItemStack)equipped, (boolean)false) || OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemWireCoil, 1, Short.MAX_VALUE), (ItemStack)equipped, (boolean)false)) {
                    int[] link;
                    if (ItemNBTHelper.hasKey(equipped, "linkingPos") && (link = ItemNBTHelper.getIntArray(equipped, "linkingPos")) != null && link.length > 3) {
                        String s = StatCollector.translateToLocalFormatted((String)"desc.ImmersiveEngineering.info.attachedTo", (Object[])new Object[]{link[1], link[2], link[3]});
                        ClientUtils.font().drawString(s, event.resolution.getScaledWidth() / 2 - ClientUtils.font().getStringWidth(s) / 2, event.resolution.getScaledHeight() - GuiIngameForge.left_height - 10, WireType.ELECTRUM.getColour(null), true);
                    }
                } else if (equipped.getItem() instanceof ItemRevolver && equipped.getItemDamage() != 2) {
                    ClientUtils.bindTexture("immersiveengineering:textures/gui/revolver.png");
                    ItemStack[] bullets = ((ItemRevolver)equipped.getItem()).getBullets(equipped);
                    int bulletAmount = bullets.length;
                    float dx = event.resolution.getScaledWidth() - 32 - 48;
                    float dy = event.resolution.getScaledHeight() - 64;
                    GL11.glPushMatrix();
                    GL11.glEnable((int)3042);
                    GL11.glTranslated((double)dx, (double)dy, (double)0.0);
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
                    ClientUtils.drawTexturedRect(0.0f, 1.0f, 74.0f, 74.0f, 0.0, 0.2890625, 0.19921875, 0.48828125);
                    if (bulletAmount >= 18) {
                        ClientUtils.drawTexturedRect(47.0f, 1.0f, 103.0f, 74.0f, 0.2890625, 0.69140625, 0.19921875, 0.48828125);
                    } else if (bulletAmount > 8) {
                        ClientUtils.drawTexturedRect(57.0f, 1.0f, 79.0f, 39.0f, 0.22265625, 0.53125, 0.046875, 0.19921875);
                    }
                    RenderItem ir = RenderItem.getInstance();
                    int[][] slots = ContainerRevolver.slotPositions[bulletAmount >= 18 ? 2 : (bulletAmount > 8 ? 1 : 0)];
                    for (int i = 0; i < bulletAmount; ++i) {
                        if (bullets[i] == null) continue;
                        int x = 0;
                        int y = 0;
                        if (i == 0) {
                            x = 29;
                            y = 3;
                        } else if (i - 1 < slots.length) {
                            x = slots[i - 1][0];
                            y = slots[i - 1][1];
                        } else {
                            int ii = i - (slots.length + 1);
                            int n = ii == 0 ? 48 : (ii == 1 ? 29 : (x = ii == 3 ? 2 : 10));
                            y = ii == 1 ? 57 : (ii == 3 ? 30 : (ii == 4 ? 11 : 49));
                        }
                        ir.renderItemIntoGUI(ClientUtils.mc().fontRenderer, ClientUtils.mc().renderEngine, bullets[i], x, y);
                    }
                    RenderHelper.disableStandardItemLighting();
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                } else if (equipped.getItem() instanceof ItemDrill && equipped.getItemDamage() == 0 || equipped.getItem() instanceof ItemChemthrower) {
                    int amount;
                    boolean drill = equipped.getItem() instanceof ItemDrill;
                    ClientUtils.bindTexture("immersiveengineering:textures/gui/hudElements.png");
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    float dx = event.resolution.getScaledWidth() - 16;
                    float dy = event.resolution.getScaledHeight();
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)dx, (double)dy, (double)0.0);
                    int w = 31;
                    int h = 62;
                    double uMin = 0.69921875;
                    double uMax = 0.8203125;
                    double vMin = 0.03515625;
                    double vMax = 0.27734375;
                    ClientUtils.drawTexturedRect(-24.0f, -68.0f, (float)w, (float)h, uMin, uMax, vMin, vMax);
                    GL11.glTranslated((double)-23.0, (double)-37.0, (double)0.0);
                    FluidStack fuel = ((IFluidContainerItem)equipped.getItem()).getFluid(equipped);
                    int n = amount = fuel != null ? fuel.amount : 0;
                    if (!drill && player.isUsingItem()) {
                        amount -= player.getItemInUseDuration() * Config.getInt("chemthrower_consumption");
                    }
                    float cap = ((IFluidContainerItem)equipped.getItem()).getCapacity(equipped);
                    float angle = 83.0f - (float)(166 * amount) / cap;
                    GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
                    ClientUtils.drawTexturedRect(6.0f, -2.0f, 24.0f, 4.0f, 0.35546875, 0.48046875, 0.3125, 0.33984375);
                    GL11.glRotatef((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)23.0, (double)37.0, (double)0.0);
                    if (drill) {
                        ClientUtils.drawTexturedRect(-54.0f, -73.0f, 66.0f, 72.0f, 0.421875, 0.6796875, 0.015625, 0.296875);
                        RenderItem ir = RenderItem.getInstance();
                        ItemStack head = ((ItemDrill)equipped.getItem()).getHead(equipped);
                        if (head != null) {
                            ir.renderItemIntoGUI(ClientUtils.mc().fontRenderer, ClientUtils.mc().renderEngine, head, -51, -45);
                            ir.renderItemOverlayIntoGUI(ClientUtils.font(), ClientUtils.mc().renderEngine, head, -51, -45);
                            RenderHelper.disableStandardItemLighting();
                        }
                    } else {
                        ClientUtils.drawTexturedRect(-41.0f, -73.0f, 53.0f, 72.0f, 0.03125, 0.23828125, 0.015625, 0.296875);
                        boolean ignite = ItemNBTHelper.getBoolean(equipped, "ignite");
                        ClientUtils.drawTexturedRect(-32.0f, -43.0f, 12.0f, 12.0f, 0.2578125, 0.3046875, (float)(ignite ? 21 : 9) / 256.0f, (float)(ignite ? 33 : 21) / 256.0f);
                    }
                    GL11.glPopMatrix();
                }
                if ((mop = ClientUtils.mc().objectMouseOver) != null) {
                    tileEntity = player.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ);
                    if (OreDictionary.itemMatches((ItemStack)new ItemStack((Item)IEContent.itemTool, 1, 2), (ItemStack)equipped, (boolean)true)) {
                        int col = Config.getBoolean("nixietubeFont") ? 0xFF9900 : 0xFFFFFF;
                        String[] text = null;
                        if (tileEntity instanceof IEnergyReceiver) {
                            ForgeDirection fd = ForgeDirection.getOrientation((int)mop.sideHit);
                            int maxStorage = ((IEnergyReceiver)tileEntity).getMaxEnergyStored(fd);
                            int storage = ((IEnergyReceiver)tileEntity).getEnergyStored(fd);
                            if (maxStorage > 0) {
                                text = StatCollector.translateToLocalFormatted((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{"<br>" + Utils.toScientificNotation(storage, "0##", 100000) + " / " + Utils.toScientificNotation(maxStorage, "0##", 100000)}).split("<br>");
                            }
                        } else if (Lib.GREG && GregTechHelper.gregtech_isValidEnergyOutput(tileEntity)) {
                            String gregStored = GregTechHelper.gregtech_getEnergyStored(tileEntity);
                            if (gregStored != null) {
                                text = StatCollector.translateToLocalFormatted((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{"<br>" + gregStored}).split("<br>");
                            }
                        } else if (mop.entityHit instanceof IEnergyReceiver) {
                            int maxStorage = ((IEnergyReceiver)mop.entityHit).getMaxEnergyStored(ForgeDirection.UNKNOWN);
                            int storage = ((IEnergyReceiver)mop.entityHit).getEnergyStored(ForgeDirection.UNKNOWN);
                            if (maxStorage > 0) {
                                text = StatCollector.translateToLocalFormatted((String)"desc.ImmersiveEngineering.info.energyStored", (Object[])new Object[]{"<br>" + Utils.toScientificNotation(storage, "0##", 100000) + " / " + Utils.toScientificNotation(maxStorage, "0##", 100000)}).split("<br>");
                            }
                        }
                        if (text != null) {
                            if (player.worldObj.getTotalWorldTime() % 20L == 0L) {
                                ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageRequestBlockUpdate(mop.blockX, mop.blockY, mop.blockZ, player.dimension));
                            }
                            int i = 0;
                            for (String s : text) {
                                if (s == null) continue;
                                int w = ClientProxy.nixieFontOptional.getStringWidth(s);
                                ClientProxy.nixieFontOptional.drawString(s, event.resolution.getScaledWidth() / 2 - w / 2, event.resolution.getScaledHeight() / 2 - 4 - text.length * (ClientProxy.nixieFontOptional.FONT_HEIGHT + 2) + i++ * (ClientProxy.nixieFontOptional.FONT_HEIGHT + 2), col, true);
                            }
                        }
                    }
                }
            }
            if (ClientUtils.mc().objectMouseOver != null) {
                boolean hammer = player.getCurrentEquippedItem() != null ? Utils.isHammer(player.getCurrentEquippedItem()) : false;
                mop = ClientUtils.mc().objectMouseOver;
                tileEntity = player.worldObj.getTileEntity(mop.blockX, mop.blockY, mop.blockZ);
                if (tileEntity instanceof IEBlockInterfaces.IBlockOverlayText) {
                    IEBlockInterfaces.IBlockOverlayText overlayBlock = (IEBlockInterfaces.IBlockOverlayText)tileEntity;
                    String[] text = overlayBlock.getOverlayText((EntityPlayer)ClientUtils.mc().thePlayer, mop, hammer);
                    boolean useNixie = overlayBlock.useNixieFont((EntityPlayer)ClientUtils.mc().thePlayer, mop);
                    if (text != null && text.length > 0) {
                        FontRenderer font = useNixie ? ClientProxy.nixieFontOptional : ClientUtils.font();
                        int col = useNixie && Config.getBoolean("nixietubeFont") ? 0xFF9900 : 0xFFFFFF;
                        int i = 0;
                        for (String s : text) {
                            if (s == null) continue;
                            font.drawString(s, event.resolution.getScaledWidth() / 2 + 8, event.resolution.getScaledHeight() / 2 + 8 + i++ * font.FONT_HEIGHT, col, true);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onFOVUpdate(FOVUpdateEvent event) {
        EntityClientPlayerMP player = ClientUtils.mc().thePlayer;
        if (player.getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof ZoomHandler.IZoomTool) {
            if (player.isSneaking() && player.onGround) {
                ItemStack equipped = player.getCurrentEquippedItem();
                ZoomHandler.IZoomTool tool = (ZoomHandler.IZoomTool)equipped.getItem();
                if (tool.canZoom(equipped, (EntityPlayer)player)) {
                    if (!ZoomHandler.isZooming) {
                        float[] steps = tool.getZoomSteps(equipped, (EntityPlayer)player);
                        if (steps != null && steps.length > 0) {
                            int curStep = -1;
                            float dist = 0.0f;
                            for (int i = 0; i < steps.length; ++i) {
                                if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                                curStep = i;
                                dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
                            }
                            ZoomHandler.fovZoom = curStep != -1 ? steps[curStep] : event.fov;
                        }
                        ZoomHandler.isZooming = true;
                    }
                    event.newfov = ZoomHandler.fovZoom;
                } else if (ZoomHandler.isZooming) {
                    ZoomHandler.isZooming = false;
                }
            } else if (ZoomHandler.isZooming) {
                ZoomHandler.isZooming = false;
            }
        } else if (ZoomHandler.isZooming) {
            ZoomHandler.isZooming = false;
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        float[] steps;
        ItemStack equipped;
        ZoomHandler.IZoomTool tool;
        EntityClientPlayerMP player;
        if (event.dwheel != 0 && (player = ClientUtils.mc().thePlayer).getCurrentEquippedItem() != null && player.getCurrentEquippedItem().getItem() instanceof ZoomHandler.IZoomTool && player.isSneaking() && (tool = (ZoomHandler.IZoomTool)(equipped = player.getCurrentEquippedItem()).getItem()).canZoom(equipped, (EntityPlayer)player) && (steps = tool.getZoomSteps(equipped, (EntityPlayer)player)) != null && steps.length > 0) {
            int curStep = -1;
            float dist = 0.0f;
            for (int i = 0; i < steps.length; ++i) {
                if (curStep != -1 && !(Math.abs(steps[i] - ZoomHandler.fovZoom) < dist)) continue;
                curStep = i;
                dist = Math.abs(steps[i] - ZoomHandler.fovZoom);
            }
            if (curStep != -1) {
                int newStep = curStep + (event.dwheel > 0 ? -1 : 1);
                if (newStep >= 0 && newStep < steps.length) {
                    ZoomHandler.fovZoom = steps[newStep];
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void renderAdditionalBlockBounds(DrawBlockHighlightEvent event) {
        if (event.subID == 0 && event.target.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            ItemStack head;
            float f1 = 0.002f;
            double d0 = event.player.lastTickPosX + (event.player.posX - event.player.lastTickPosX) * (double)event.partialTicks;
            double d1 = event.player.lastTickPosY + (event.player.posY - event.player.lastTickPosY) * (double)event.partialTicks;
            double d2 = event.player.lastTickPosZ + (event.player.posZ - event.player.lastTickPosZ) * (double)event.partialTicks;
            if (event.player.worldObj.getBlock(event.target.blockX, event.target.blockY, event.target.blockZ) instanceof IEBlockInterfaces.ICustomBoundingboxes) {
                ChunkCoordinates cc = new ChunkCoordinates(event.target.blockX, event.target.blockY, event.target.blockZ);
                IEBlockInterfaces.ICustomBoundingboxes block = (IEBlockInterfaces.ICustomBoundingboxes)event.player.worldObj.getBlock(event.target.blockX, event.target.blockY, event.target.blockZ);
                ArrayList<AxisAlignedBB> set = block.addCustomSelectionBoxesToList(event.player.worldObj, cc.posX, cc.posY, cc.posZ);
                if (!set.isEmpty()) {
                    GL11.glEnable((int)3042);
                    OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
                    GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    GL11.glLineWidth((float)2.0f);
                    GL11.glDisable((int)3553);
                    GL11.glDepthMask((boolean)false);
                    ArrayList<AxisAlignedBB> specialBoxes = new ArrayList<AxisAlignedBB>();
                    AxisAlignedBB overrideBox = null;
                    for (AxisAlignedBB aabb : set) {
                        boolean b;
                        if (aabb == null || !(b = block.addSpecifiedSubBox(event.player.worldObj, cc.posX, cc.posY, cc.posZ, event.player, aabb, event.target.hitVec, specialBoxes))) continue;
                        overrideBox = specialBoxes.get(specialBoxes.size() - 1);
                    }
                    if (overrideBox != null) {
                        ClientEventHandler.renderBoundingBox(overrideBox, (double)cc.posX - d0, (double)cc.posY - d1, (double)cc.posZ - d2, f1);
                    } else {
                        for (AxisAlignedBB aabb : specialBoxes.isEmpty() ? set : specialBoxes) {
                            if (aabb == null) continue;
                            ClientEventHandler.renderBoundingBox(aabb, (double)cc.posX - d0, (double)cc.posY - d1, (double)cc.posZ - d2, f1);
                        }
                    }
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)3553);
                    GL11.glDisable((int)3042);
                    event.setCanceled(true);
                }
            }
            ItemStack stack = event.player.getCurrentEquippedItem();
            World world = event.player.worldObj;
            if (stack != null && stack.getItem() instanceof ItemDrill && ((ItemDrill)stack.getItem()).isEffective(world.getBlock(event.target.blockX, event.target.blockY, event.target.blockZ).getMaterial()) && (head = ((ItemDrill)stack.getItem()).getHead(stack)) != null) {
                int side = event.target.sideHit;
                int diameter = ((IDrillHead)head.getItem()).getMiningSize(head) + ((ItemDrill)stack.getItem()).getUpgrades(stack).getInteger("size");
                int depth = ((IDrillHead)head.getItem()).getMiningDepth(head) + ((ItemDrill)stack.getItem()).getUpgrades(stack).getInteger("depth");
                int startX = event.target.blockX;
                int startY = event.target.blockY;
                int startZ = event.target.blockZ;
                if (diameter % 2 == 0) {
                    float hx = (float)event.target.hitVec.xCoord - (float)event.target.blockX;
                    float hy = (float)event.target.hitVec.yCoord - (float)event.target.blockY;
                    float hz = (float)event.target.hitVec.zCoord - (float)event.target.blockZ;
                    if (side < 2 && (double)hx < 0.5 || side < 4 && (double)hx < 0.5) {
                        startX -= diameter / 2;
                    }
                    if (side > 1 && (double)hy < 0.5) {
                        startY -= diameter / 2;
                    }
                    if (side < 2 && (double)hz < 0.5 || side > 3 && (double)hz < 0.5) {
                        startZ -= diameter / 2;
                    }
                } else {
                    startX -= side == 4 || side == 5 ? 0 : diameter / 2;
                    startY -= side == 0 || side == 1 ? 0 : diameter / 2;
                    startZ -= side == 2 || side == 3 ? 0 : diameter / 2;
                }
                GL11.glColor4f((float)0.1f, (float)0.1f, (float)0.1f, (float)0.4f);
                GL11.glLineWidth((float)1.0f);
                GL11.glDisable((int)3553);
                for (int dd = 0; dd < depth; ++dd) {
                    for (int dw = 0; dw < diameter; ++dw) {
                        for (int dh = 0; dh < diameter; ++dh) {
                            AxisAlignedBB aabb;
                            int z;
                            int y;
                            int x = startX + (side == 4 || side == 5 ? dd : dw);
                            Block block = event.player.worldObj.getBlock(x, y = startY + (side == 0 || side == 1 ? dd : dh), z = startZ + (side == 0 || side == 1 ? dh : (side == 4 || side == 5 ? dw : dd)));
                            if (block == null || block.isAir((IBlockAccess)world, x, y, z) || block.getPlayerRelativeBlockHardness(event.player, world, x, y, z) == 0.0f || !((ItemDrill)stack.getItem()).canBreakExtraBlock(world, block, x, y, z, world.getBlockMetadata(x, y, z), event.player, stack, head, false) || (aabb = block.getSelectedBoundingBoxFromPool(event.player.worldObj, x, y, z)) == null) continue;
                            RenderGlobal.drawOutlinedBoundingBox((AxisAlignedBB)aabb.expand((double)f1, (double)f1, (double)f1).getOffsetBoundingBox(-d0, -d1, -d2), (int)-1);
                        }
                    }
                }
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)3553);
                GL11.glDisable((int)3042);
            }
        }
    }

    static void renderBoundingBox(AxisAlignedBB aabb, double offsetX, double offsetY, double offsetZ, float expand) {
        if (aabb instanceof AdvancedAABB && ((AdvancedAABB)aabb).drawOverride != null && ((AdvancedAABB)aabb).drawOverride.length > 0) {
            double midX = aabb.minX + (aabb.maxX - aabb.minX) / 2.0;
            double midY = aabb.minY + (aabb.maxY - aabb.minY) / 2.0;
            double midZ = aabb.minZ + (aabb.maxZ - aabb.minZ) / 2.0;
            ClientUtils.tes().addTranslation((float)offsetX, (float)offsetY, (float)offsetZ);
            for (Vec3[] face : ((AdvancedAABB)aabb).drawOverride) {
                ClientUtils.tes().startDrawing(2);
                for (Vec3 v : face) {
                    ClientUtils.tes().addVertex(v.xCoord + (double)(v.xCoord < midX ? -expand : expand), v.yCoord + (double)(v.yCoord < midY ? -expand : expand), v.zCoord + (double)(v.zCoord < midZ ? -expand : expand));
                }
                ClientUtils.tes().draw();
            }
            ClientUtils.tes().addTranslation((float)(-offsetX), (float)(-offsetY), (float)(-offsetZ));
        } else {
            RenderGlobal.drawOutlinedBoundingBox((AxisAlignedBB)aabb.getOffsetBoundingBox(offsetX, offsetY, offsetZ).expand((double)expand, (double)expand, (double)expand), (int)-1);
        }
    }

    @SubscribeEvent
    public void onClientDeath(LivingDeathEvent event) {
    }

    @SubscribeEvent
    public void onRenderLivingPre(RenderLivingEvent.Pre event) {
        if (event.entity.getEntityData().hasKey("headshot")) {
            ModelBase model = event.renderer.mainModel;
            if (model instanceof ModelBiped) {
                ((ModelBiped)model).bipedHead.showModel = false;
            } else if (model instanceof ModelVillager) {
                ((ModelVillager)model).villagerHead.showModel = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderLivingPost(RenderLivingEvent.Post event) {
        if (event.entity.getEntityData().hasKey("headshot")) {
            ModelBase model = event.renderer.mainModel;
            if (model instanceof ModelBiped) {
                ((ModelBiped)model).bipedHead.showModel = true;
            } else if (model instanceof ModelVillager) {
                ((ModelVillager)model).villagerHead.showModel = true;
            }
        }
    }

    static {
        skyhookGrabableConnections = new HashSet<ImmersiveNetHandler.Connection>();
        connectionsRendered = false;
    }
}

