/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.api.energy.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.energy.ImmersiveNetHandler;
import blusunrize.immersiveengineering.client.render.TileRenderIE;
import blusunrize.immersiveengineering.common.util.IESound;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import codechicken.lib.gui.GuiDraw;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Timer;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.GroupObject;
import net.minecraftforge.client.model.obj.TextureCoordinate;
import net.minecraftforge.client.model.obj.Vertex;
import net.minecraftforge.client.model.obj.WavefrontObject;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidTank;
import org.lwjgl.opengl.GL11;

public class ClientUtils {
    public static final AxisAlignedBB standardBlockAABB = AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
    public static final Vec3 up = Vec3.createVectorHelper((double)0.0, (double)1.0, (double)0.0);
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();
    static int[] chatColours = new int[]{0, 170, 43520, 43690, 0xAA0000, 0xAA00AA, 0xFFAA00, 0xAAAAAA, 0x555555, 0x5555FF, 0x55FF55, 0x55FFFF, 0xFF5555, 0xFF55FF, 0xFFFF55, 0xFFFFFF};

    public static void renderAttachedConnections(TileEntity tile) {
        Set<ImmersiveNetHandler.Connection> outputs;
        if (tile.getWorldObj() != null && tile instanceof IImmersiveConnectable && (outputs = ImmersiveNetHandler.INSTANCE.getConnections(tile.getWorldObj(), Utils.toCC(tile))) != null) {
            for (ImmersiveNetHandler.Connection con : outputs) {
                TileEntity tileEnd = tile.getWorldObj().getTileEntity(con.end.posX, con.end.posY, con.end.posZ);
                if (!(tileEnd instanceof IImmersiveConnectable)) continue;
                TileEntity startTileForRender = tile;
                int xDif = con.end.posX - con.start.posX;
                if (xDif < 0) {
                    con = new ImmersiveNetHandler.Connection(con.end, con.start, con.cableType, con.length);
                    startTileForRender = tileEnd;
                    tileEnd = tile;
                } else if (xDif == 0) {
                    int zDif;
                    int yDif = con.end.posY - con.start.posY;
                    if (yDif < 0) {
                        con = new ImmersiveNetHandler.Connection(con.end, con.start, con.cableType, con.length);
                        startTileForRender = tileEnd;
                        tileEnd = tile;
                    } else if (yDif == 0 && (zDif = con.end.posZ - con.start.posZ) < 0) {
                        con = new ImmersiveNetHandler.Connection(con.end, con.start, con.cableType, con.length);
                        startTileForRender = tileEnd;
                        tileEnd = tile;
                    }
                }
                ClientUtils.drawConnection(con, (IImmersiveConnectable)startTileForRender, (IImmersiveConnectable)tileEnd, con.cableType.getIcon(con));
            }
        }
    }

    public static void drawConnection(ImmersiveNetHandler.Connection connection, IImmersiveConnectable start, IImmersiveConnectable end, IIcon icon) {
        if (connection == null || start == null || end == null) {
            return;
        }
        int col = connection.cableType.getColour(connection);
        double r = connection.cableType.getRenderDiameter() / 2.0;
        ClientUtils.drawConnection(connection, start, end, col, 255, r, icon);
    }

    public static void drawConnection(ImmersiveNetHandler.Connection connection, IImmersiveConnectable start, IImmersiveConnectable end, int colour, int alpha, double radius, IIcon icon) {
        boolean b;
        if (connection == null || start == null || end == null || connection.end == null || connection.start == null) {
            return;
        }
        Vec3 startOffset = start.getConnectionOffset(connection);
        Vec3 endOffset = end.getConnectionOffset(connection);
        if (startOffset == null) {
            startOffset = Vec3.createVectorHelper((double)0.5, (double)0.5, (double)0.5);
        }
        if (endOffset == null) {
            endOffset = Vec3.createVectorHelper((double)0.5, (double)0.5, (double)0.5);
        }
        double dx = (double)connection.end.posX + endOffset.xCoord - ((double)connection.start.posX + startOffset.xCoord);
        double dy = (double)connection.end.posY + endOffset.yCoord - ((double)connection.start.posY + startOffset.yCoord);
        double dz = (double)connection.end.posZ + endOffset.zCoord - ((double)connection.start.posZ + startOffset.zCoord);
        double dw = Math.sqrt(dx * dx + dz * dz);
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        World world = ((TileEntity)start).getWorldObj();
        Tessellator tes = ClientUtils.tes();
        double rmodx = dz / dw;
        double rmodz = dx / dw;
        Vec3[] vertex = connection.getSubVertices(world);
        Vec3 initPos = Vec3.createVectorHelper((double)((double)connection.start.posX + startOffset.xCoord), (double)((double)connection.start.posY + startOffset.yCoord), (double)((double)connection.start.posZ + startOffset.zCoord));
        double uMin = icon.getMinU();
        double uMax = icon.getMaxU();
        double vMin = icon.getMinV();
        double vMax = icon.getMaxV();
        double uD = uMax - uMin;
        boolean vertical = connection.end.posX == connection.start.posX && connection.end.posZ == connection.start.posZ;
        boolean bl = b = dx < 0.0 && dz <= 0.0 || dz < 0.0 && dx <= 0.0 || dz < 0.0 && dx > 0.0;
        if (vertical) {
            tes.addTranslation((float)initPos.xCoord, (float)initPos.yCoord, (float)initPos.zCoord);
            tes.setColorRGBA_I(colour, alpha);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.posX - radius, connection.start.posY, connection.start.posZ));
            tes.addVertexWithUV(0.0 - radius, 0.0, 0.0, uMin, vMin);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.posX - radius, (double)connection.start.posY + dy, connection.start.posZ));
            tes.addVertexWithUV(dx - radius, dy, dz, uMax, vMin);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.posX + radius, (double)connection.start.posY + dy, connection.start.posZ));
            tes.addVertexWithUV(dx + radius, dy, dz, uMax, vMax);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.posX + radius, connection.start.posY, connection.start.posZ));
            tes.addVertexWithUV(0.0 + radius, 0.0, 0.0, uMin, vMax);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.posX - radius, (double)connection.start.posY + dy, connection.start.posZ));
            tes.addVertexWithUV(dx - radius, dy, dz, uMax, vMin);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.posX - radius, connection.start.posY, connection.start.posZ));
            tes.addVertexWithUV(0.0 - radius, 0.0, 0.0, uMin, vMin);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.posX + radius, connection.start.posY, connection.start.posZ));
            tes.addVertexWithUV(0.0 + radius, 0.0, 0.0, uMin, vMax);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, (double)connection.start.posX + radius, (double)connection.start.posY + dy, connection.start.posZ));
            tes.addVertexWithUV(dx + radius, dy, dz, uMax, vMax);
            tes.setColorRGBA_I(colour, alpha);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.posX, connection.start.posY, (double)connection.start.posZ - radius));
            tes.addVertexWithUV(0.0, 0.0, 0.0 - radius, uMin, vMin);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.posX, (double)connection.start.posY + dy, (double)connection.start.posZ - radius));
            tes.addVertexWithUV(dx, dy, dz - radius, uMax, vMin);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.posX, (double)connection.start.posY + dy, (double)connection.start.posZ + radius));
            tes.addVertexWithUV(dx, dy, dz + radius, uMax, vMax);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.posX, connection.start.posY, (double)connection.start.posZ + radius));
            tes.addVertexWithUV(0.0, 0.0, 0.0 + radius, uMin, vMax);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.posX, (double)connection.start.posY + dy, (double)connection.start.posZ - radius));
            tes.addVertexWithUV(dx, dy, dz - radius, uMax, vMin);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.posX, connection.start.posY, (double)connection.start.posZ - radius));
            tes.addVertexWithUV(0.0, 0.0, 0.0 - radius, uMin, vMin);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.posX, connection.start.posY, (double)connection.start.posZ + radius));
            tes.addVertexWithUV(0.0, 0.0, 0.0 + radius, uMin, vMax);
            tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, connection.start.posX, (double)connection.start.posY + dy, (double)connection.start.posZ + radius));
            tes.addVertexWithUV(dx, dy, dz + radius, uMax, vMax);
            tes.addTranslation((float)(-initPos.xCoord), (float)(-initPos.yCoord), (float)(-initPos.zCoord));
        } else {
            int i;
            double u0 = uMin;
            double u1 = uMin;
            int n = i = b ? vertex.length - 1 : 0;
            while (b ? i >= 0 : i < vertex.length) {
                Vec3 v0 = i > 0 ? vertex[i - 1] : initPos;
                Vec3 v1 = vertex[i];
                Vec3 wireDir = v0.subtract(v1);
                Vec3 renderOff1 = wireDir.crossProduct(up);
                double l = renderOff1.lengthVector();
                renderOff1 = Utils.scalarProd(renderOff1, radius / l);
                Vec3 renderOff2 = wireDir.crossProduct(renderOff1);
                l = renderOff2.lengthVector();
                renderOff2 = Utils.scalarProd(renderOff2, radius / l);
                u0 = u1;
                u1 = u0 + v0.distanceTo(v1) / d * uD;
                if (dx < 0.0 && dz <= 0.0 || dz < 0.0 && dx <= 0.0 || dz < 0.0 && dx > 0.0) {
                    u1 = uMin;
                    u0 = uMax;
                }
                tes.setColorRGBA_I(colour, alpha);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v0.xCoord + renderOff1.xCoord, v0.yCoord + renderOff1.yCoord, v0.zCoord + renderOff1.zCoord));
                tes.addVertexWithUV(v0.xCoord + renderOff1.xCoord, v0.yCoord + renderOff1.yCoord, v0.zCoord + renderOff1.zCoord, u0, vMax);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v1.xCoord + renderOff1.xCoord, v1.yCoord + renderOff1.yCoord, v1.zCoord + renderOff1.zCoord));
                tes.addVertexWithUV(v1.xCoord + renderOff1.xCoord, v1.yCoord + renderOff1.yCoord, v1.zCoord + renderOff1.zCoord, u1, vMax);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v1.xCoord - renderOff1.xCoord, v1.yCoord - renderOff1.yCoord, v1.zCoord - renderOff1.zCoord));
                tes.addVertexWithUV(v1.xCoord - renderOff1.xCoord, v1.yCoord - renderOff1.yCoord, v1.zCoord - renderOff1.zCoord, u1, vMin);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v0.xCoord - renderOff1.xCoord, v0.yCoord - renderOff1.yCoord, v0.zCoord - renderOff1.zCoord));
                tes.addVertexWithUV(v0.xCoord - renderOff1.xCoord, v0.yCoord - renderOff1.yCoord, v0.zCoord - renderOff1.zCoord, u0, vMin);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v1.xCoord + renderOff1.xCoord, v1.yCoord + renderOff1.yCoord, v1.zCoord + renderOff1.zCoord));
                tes.addVertexWithUV(v1.xCoord + renderOff1.xCoord, v1.yCoord + renderOff1.yCoord, v1.zCoord + renderOff1.zCoord, u1, vMax);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v0.xCoord + renderOff1.xCoord, v0.yCoord + renderOff1.yCoord, v0.zCoord + renderOff1.zCoord));
                tes.addVertexWithUV(v0.xCoord + renderOff1.xCoord, v0.yCoord + renderOff1.yCoord, v0.zCoord + renderOff1.zCoord, u0, vMax);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v0.xCoord - renderOff1.xCoord, v0.yCoord - renderOff1.yCoord, v0.zCoord - renderOff1.zCoord));
                tes.addVertexWithUV(v0.xCoord - renderOff1.xCoord, v0.yCoord - renderOff1.yCoord, v0.zCoord - renderOff1.zCoord, u0, vMin);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v1.xCoord - renderOff1.xCoord, v1.yCoord - renderOff1.yCoord, v1.zCoord - renderOff1.zCoord));
                tes.addVertexWithUV(v1.xCoord - renderOff1.xCoord, v1.yCoord - renderOff1.yCoord, v1.zCoord - renderOff1.zCoord, u1, vMin);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v0.xCoord + renderOff2.xCoord, v0.yCoord + renderOff2.yCoord, v0.zCoord + renderOff2.zCoord));
                tes.addVertexWithUV(v0.xCoord + renderOff2.xCoord, v0.yCoord + renderOff2.yCoord, v0.zCoord + renderOff2.zCoord, u0, vMax);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v1.xCoord + renderOff2.xCoord, v1.yCoord + renderOff2.yCoord, v1.zCoord + renderOff2.zCoord));
                tes.addVertexWithUV(v1.xCoord + renderOff2.xCoord, v1.yCoord + renderOff2.yCoord, v1.zCoord + renderOff2.zCoord, u1, vMax);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v1.xCoord - renderOff2.xCoord, v1.yCoord - renderOff2.yCoord, v1.zCoord - renderOff2.zCoord));
                tes.addVertexWithUV(v1.xCoord - renderOff2.xCoord, v1.yCoord - renderOff2.yCoord, v1.zCoord - renderOff2.zCoord, u1, vMin);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v0.xCoord - renderOff2.xCoord, v0.yCoord - renderOff2.yCoord, v0.zCoord - renderOff2.zCoord));
                tes.addVertexWithUV(v0.xCoord - renderOff2.xCoord, v0.yCoord - renderOff2.yCoord, v0.zCoord - renderOff2.zCoord, u0, vMin);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v1.xCoord + renderOff2.xCoord, v1.yCoord + renderOff2.yCoord, v1.zCoord + renderOff2.zCoord));
                tes.addVertexWithUV(v1.xCoord + renderOff2.xCoord, v1.yCoord + renderOff2.yCoord, v1.zCoord + renderOff2.zCoord, u1, vMax);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v0.xCoord + renderOff2.xCoord, v0.yCoord + renderOff2.yCoord, v0.zCoord + renderOff2.zCoord));
                tes.addVertexWithUV(v0.xCoord + renderOff2.xCoord, v0.yCoord + renderOff2.yCoord, v0.zCoord + renderOff2.zCoord, u0, vMax);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v0.xCoord - renderOff2.xCoord, v0.yCoord - renderOff2.yCoord, v0.zCoord - renderOff2.zCoord));
                tes.addVertexWithUV(v0.xCoord - renderOff2.xCoord, v0.yCoord - renderOff2.yCoord, v0.zCoord - renderOff2.zCoord, u0, vMin);
                tes.setBrightness(ClientUtils.calcBrightness((IBlockAccess)world, v1.xCoord - renderOff2.xCoord, v1.yCoord - renderOff2.yCoord, v1.zCoord - renderOff2.zCoord));
                tes.addVertexWithUV(v1.xCoord - renderOff2.xCoord, v1.yCoord - renderOff2.yCoord, v1.zCoord - renderOff2.zCoord, u1, vMin);
                i += b ? -1 : 1;
            }
        }
        tes.setColorRGBA_I(0xFFFFFF, 255);
    }

    public static int calcBrightness(IBlockAccess world, double x, double y, double z) {
        return world.getLightBrightnessForSkyBlocks((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z), 0);
    }

    public static void tessellateBox(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax, IIcon icon) {
        ClientUtils.tes().addVertexWithUV(xMin, yMin, zMax, (double)icon.getInterpolatedU(xMin * 16.0), (double)icon.getInterpolatedV(zMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMin, zMin, (double)icon.getInterpolatedU(xMin * 16.0), (double)icon.getInterpolatedV(zMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMin, zMin, (double)icon.getInterpolatedU(xMax * 16.0), (double)icon.getInterpolatedV(zMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMin, zMax, (double)icon.getInterpolatedU(xMax * 16.0), (double)icon.getInterpolatedV(zMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMax, zMin, (double)icon.getInterpolatedU(xMin * 16.0), (double)icon.getInterpolatedV(zMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMax, zMax, (double)icon.getInterpolatedU(xMin * 16.0), (double)icon.getInterpolatedV(zMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMax, zMax, (double)icon.getInterpolatedU(xMax * 16.0), (double)icon.getInterpolatedV(zMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMax, zMin, (double)icon.getInterpolatedU(xMax * 16.0), (double)icon.getInterpolatedV(zMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMin, zMin, (double)icon.getInterpolatedU(xMin * 16.0), (double)icon.getInterpolatedV(yMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMin, zMin, (double)icon.getInterpolatedU(xMax * 16.0), (double)icon.getInterpolatedV(yMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMax, zMin, (double)icon.getInterpolatedU(xMax * 16.0), (double)icon.getInterpolatedV(yMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMax, zMin, (double)icon.getInterpolatedU(xMin * 16.0), (double)icon.getInterpolatedV(yMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMin, zMax, (double)icon.getInterpolatedU(xMax * 16.0), (double)icon.getInterpolatedV(yMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMin, zMax, (double)icon.getInterpolatedU(xMin * 16.0), (double)icon.getInterpolatedV(yMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMax, zMax, (double)icon.getInterpolatedU(xMin * 16.0), (double)icon.getInterpolatedV(yMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMax, zMax, (double)icon.getInterpolatedU(xMax * 16.0), (double)icon.getInterpolatedV(yMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMin, zMin, (double)icon.getInterpolatedU(zMin * 16.0), (double)icon.getInterpolatedV(yMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMin, zMax, (double)icon.getInterpolatedU(zMax * 16.0), (double)icon.getInterpolatedV(yMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMax, zMax, (double)icon.getInterpolatedU(zMax * 16.0), (double)icon.getInterpolatedV(yMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMin, yMax, zMin, (double)icon.getInterpolatedU(zMin * 16.0), (double)icon.getInterpolatedV(yMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMin, zMax, (double)icon.getInterpolatedU(zMax * 16.0), (double)icon.getInterpolatedV(yMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMin, zMin, (double)icon.getInterpolatedU(zMin * 16.0), (double)icon.getInterpolatedV(yMax * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMax, zMin, (double)icon.getInterpolatedU(zMin * 16.0), (double)icon.getInterpolatedV(yMin * 16.0));
        ClientUtils.tes().addVertexWithUV(xMax, yMax, zMax, (double)icon.getInterpolatedU(zMax * 16.0), (double)icon.getInterpolatedV(yMin * 16.0));
    }

    public static Tessellator tes() {
        return Tessellator.instance;
    }

    public static Minecraft mc() {
        return Minecraft.getMinecraft();
    }

    public static void bindTexture(String path) {
        ClientUtils.mc().getTextureManager().bindTexture(ClientUtils.getResource(path));
    }

    public static void bindAtlas(int i) {
        ClientUtils.mc().getTextureManager().bindTexture(i == 0 ? TextureMap.locationBlocksTexture : TextureMap.locationItemsTexture);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static WavefrontObject getModel(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return (WavefrontObject)AdvancedModelLoader.loadModel((ResourceLocation)rl);
    }

    public static FontRenderer font() {
        return ClientUtils.mc().fontRenderer;
    }

    public static Timer timer() {
        return ClientUtils.mc().timer;
    }

    public static String getResourceNameForItemStack(ItemStack stack) {
        if (stack != null) {
            IIcon ic = null;
            Block b = Block.getBlockFromItem((Item)stack.getItem());
            ic = b != null && b != Blocks.air ? b.getIcon(2, stack.getItemDamage()) : stack.getIconIndex();
            if (ic != null) {
                String name = ic.getIconName();
                String resource = "";
                String icon = "";
                if (name.indexOf(":") > 0) {
                    String[] split = name.split(":", 2);
                    resource = split[0] + ":";
                    icon = split[1];
                } else {
                    icon = name;
                }
                return resource + "textures/" + (stack.getItemSpriteNumber() == 0 ? "blocks" : "items") + "/" + icon + ".png";
            }
        }
        return "";
    }

    public static int getFormattingColour(EnumChatFormatting rarityColor) {
        return rarityColor.ordinal() < 16 ? chatColours[rarityColor.ordinal()] : 0;
    }

    public static IESound generatePositionedIESound(String soundName, float volume, float pitch, boolean repeat, int delay, double x, double y, double z) {
        IESound sound = new IESound(new ResourceLocation(soundName), volume, pitch, repeat, delay, x, y, z, ISound.AttenuationType.LINEAR);
        sound.evaluateVolume();
        ClientUtils.mc().getSoundHandler().playSound((ISound)sound);
        return sound;
    }

    public static ModelRenderer[] copyModelRenderers(ModelBase model, ModelRenderer ... oldRenderers) {
        ModelRenderer[] newRenderers = new ModelRenderer[oldRenderers.length];
        for (int i = 0; i < newRenderers.length; ++i) {
            if (oldRenderers[i] == null) continue;
            newRenderers[i] = new ModelRenderer(model, oldRenderers[i].boxName);
            int toX = oldRenderers[i].textureOffsetX;
            int toY = oldRenderers[i].textureOffsetY;
            newRenderers[i].setTextureOffset(toX, toY);
            newRenderers[i].mirror = oldRenderers[i].mirror;
            ArrayList<ModelBox> newCubes = new ArrayList<ModelBox>();
            for (ModelBox cube : oldRenderers[i].cubeList) {
                newCubes.add(new ModelBox(newRenderers[i], toX, toY, cube.posX1, cube.posY1, cube.posZ1, (int)(cube.posX2 - cube.posX1), (int)(cube.posY2 - cube.posY1), (int)(cube.posZ2 - cube.posZ1), 0.0f));
            }
            newRenderers[i].cubeList = newCubes;
            newRenderers[i].setRotationPoint(oldRenderers[i].rotationPointX, oldRenderers[i].rotationPointY, oldRenderers[i].rotationPointZ);
            newRenderers[i].rotateAngleX = oldRenderers[i].rotateAngleX;
            newRenderers[i].rotateAngleY = oldRenderers[i].rotateAngleY;
            newRenderers[i].rotateAngleZ = oldRenderers[i].rotateAngleZ;
            newRenderers[i].offsetX = oldRenderers[i].offsetX;
            newRenderers[i].offsetY = oldRenderers[i].offsetY;
            newRenderers[i].offsetZ = oldRenderers[i].offsetZ;
        }
        return newRenderers;
    }

    public static void handleStaticTileRenderer(TileEntity tile) {
        ClientUtils.handleStaticTileRenderer(tile, true);
    }

    public static void handleStaticTileRenderer(TileEntity tile, boolean translate) {
        TileEntitySpecialRenderer tesr = TileEntityRendererDispatcher.instance.getSpecialRenderer(tile);
        if (tesr instanceof TileRenderIE) {
            Matrix4 matrixT = new Matrix4();
            if (translate) {
                matrixT.translate(tile.xCoord, tile.yCoord, tile.zCoord);
            }
            ((TileRenderIE)tesr).renderStatic(tile, Tessellator.instance, matrixT, new Matrix4());
        }
    }

    public static void renderStaticWavefrontModel(TileEntity tile, WavefrontObject model, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix, int offsetLighting, boolean invertFaces, String ... renderedParts) {
        ClientUtils.renderStaticWavefrontModel(tile, model, tes, translationMatrix, rotationMatrix, offsetLighting, invertFaces, 1.0f, 1.0f, 1.0f, renderedParts);
    }

    public static void renderStaticWavefrontModel(TileEntity tile, WavefrontObject model, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix, int offsetLighting, boolean invertFaces, float colR, float colG, float colB, String ... renderedParts) {
        ClientUtils.renderStaticWavefrontModel((IBlockAccess)tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord, model, tes, translationMatrix, rotationMatrix, offsetLighting, invertFaces, colR, colG, colB, renderedParts);
    }

    public static void renderStaticWavefrontModel(IBlockAccess world, int x, int y, int z, WavefrontObject model, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix, int offsetLighting, boolean invertFaces, float colR, float colG, float colB, String ... renderedParts) {
        if (world != null) {
            int lb = world.getLightBrightnessForSkyBlocks(x, y, z, 0);
            int lb_j = lb % 65536;
            int lb_k = lb / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)lb_j / 1.0f), (float)((float)lb_k / 1.0f));
        }
        Vertex vertexCopy = new Vertex(0.0f, 0.0f, 0.0f);
        Vertex normalCopy = new Vertex(0.0f, 0.0f, 0.0f);
        for (GroupObject groupObject : model.groupObjects) {
            boolean render = false;
            if (renderedParts == null || renderedParts.length < 1) {
                render = true;
            } else {
                for (String s : renderedParts) {
                    if (!groupObject.name.equalsIgnoreCase(s)) continue;
                    render = true;
                }
            }
            if (!render) continue;
            for (Face face : groupObject.faces) {
                if (face.faceNormal == null) {
                    face.faceNormal = face.calculateFaceNormal();
                }
                normalCopy.x = face.faceNormal.x;
                normalCopy.y = face.faceNormal.y;
                normalCopy.z = face.faceNormal.z;
                rotationMatrix.apply(normalCopy);
                float biggestNormal = Math.max(Math.abs(normalCopy.y), Math.max(Math.abs(normalCopy.x), Math.abs(normalCopy.z)));
                int side = biggestNormal == Math.abs(normalCopy.y) ? (normalCopy.y < 0.0f ? 0 : 1) : (biggestNormal == Math.abs(normalCopy.z) ? (normalCopy.z < 0.0f ? 2 : 3) : (normalCopy.x < 0.0f ? 4 : 5));
                BlockLightingInfo faceLight = null;
                if (offsetLighting == 0 && world != null) {
                    faceLight = ClientUtils.calculateBlockLighting(side, world, world.getBlock(x, y, z), x, y, z, colR, colG, colB, standardBlockAABB);
                } else if (offsetLighting == 1 && world != null) {
                    double faceMinX = face.vertices[0].x;
                    double faceMinY = face.vertices[0].y;
                    double faceMinZ = face.vertices[0].z;
                    double faceMaxX = face.vertices[0].x;
                    double faceMaxY = face.vertices[0].y;
                    double faceMaxZ = face.vertices[0].z;
                    for (int i = 1; i < face.vertices.length; ++i) {
                        faceMinX = Math.min(faceMinX, (double)face.vertices[i].x);
                        faceMinY = Math.min(faceMinY, (double)face.vertices[i].y);
                        faceMinZ = Math.min(faceMinZ, (double)face.vertices[i].z);
                        faceMaxX = Math.max(faceMaxX, (double)face.vertices[i].x);
                        faceMaxY = Math.max(faceMaxY, (double)face.vertices[i].y);
                        faceMaxZ = Math.max(faceMaxZ, (double)face.vertices[i].z);
                    }
                    faceLight = ClientUtils.calculateBlockLighting(side, world, world.getBlock(x, y, z), x, y, z, colR, colG, colB, AxisAlignedBB.getBoundingBox((double)faceMinX, (double)faceMinY, (double)faceMinZ, (double)faceMaxX, (double)faceMaxY, (double)faceMaxZ));
                }
                tes.setNormal(face.faceNormal.x, face.faceNormal.y, face.faceNormal.z);
                for (int i = 0; i < face.vertices.length; ++i) {
                    int target = !invertFaces ? i : face.vertices.length - 1 - i;
                    int corner = (int)((float)target / (float)face.vertices.length * 4.0f);
                    Vertex vertex = face.vertices[target];
                    vertexCopy.x = vertex.x;
                    vertexCopy.y = vertex.y;
                    vertexCopy.z = vertex.z;
                    rotationMatrix.apply(vertexCopy);
                    translationMatrix.apply(vertexCopy);
                    if (faceLight != null) {
                        float g;
                        float r;
                        int bright = corner == 0 ? faceLight.brightnessTopLeft : (corner == 1 ? faceLight.brightnessBottomLeft : (corner == 2 ? faceLight.brightnessBottomRight : faceLight.brightnessTopRight));
                        int last = bright & 0xFF;
                        if (last > 247) {
                            bright -= last;
                        }
                        tes.setBrightness(bright);
                        float f = corner == 0 ? faceLight.colorRedTopLeft : (corner == 1 ? faceLight.colorRedBottomLeft : (r = corner == 2 ? faceLight.colorRedBottomRight : faceLight.colorRedTopRight));
                        float f2 = corner == 0 ? faceLight.colorGreenTopLeft : (corner == 1 ? faceLight.colorGreenBottomLeft : (g = corner == 2 ? faceLight.colorGreenBottomRight : faceLight.colorGreenTopRight));
                        float b = corner == 0 ? faceLight.colorBlueTopLeft : (corner == 1 ? faceLight.colorBlueBottomLeft : (corner == 2 ? faceLight.colorBlueBottomRight : faceLight.colorBlueTopRight));
                        tes.setColorOpaque_F(r, g, b);
                    } else if (world != null) {
                        tes.setBrightness(0xB000B0);
                        tes.setColorOpaque_F(colR, colG, colB);
                    }
                    if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                        TextureCoordinate textureCoordinate = face.textureCoordinates[target];
                        tes.addVertexWithUV((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z, (double)textureCoordinate.u, (double)textureCoordinate.v);
                        continue;
                    }
                    tes.addVertex((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z);
                }
            }
        }
    }

    public static void renderStaticWavefrontModelWithIcon(TileEntity tile, WavefrontObject model, IIcon icon, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix, int offsetLighting, boolean invertFaces, float colR, float colG, float colB, String ... renderedParts) {
        ClientUtils.renderStaticWavefrontModelWithIcon((IBlockAccess)tile.getWorldObj(), tile.xCoord, tile.yCoord, tile.zCoord, model, icon, tes, translationMatrix, rotationMatrix, offsetLighting, invertFaces, colR, colG, colB, renderedParts);
    }

    public static void renderStaticWavefrontModelWithIcon(IBlockAccess world, int x, int y, int z, WavefrontObject model, IIcon icon, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix, int offsetLighting, boolean invertFaces, float colR, float colG, float colB, String ... renderedParts) {
        if (icon == null) {
            return;
        }
        if (world != null) {
            int lb = world.getLightBrightnessForSkyBlocks(x, y, z, 0);
            int lb_j = lb % 65536;
            int lb_k = lb / 65536;
            OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)((float)lb_j / 1.0f), (float)((float)lb_k / 1.0f));
        }
        Vertex normalCopy = new Vertex(0.0f, 0.0f, 0.0f);
        float minU = icon.getInterpolatedU(0.0);
        float sizeU = icon.getInterpolatedU(16.0) - minU;
        float minV = icon.getInterpolatedV(0.0);
        float sizeV = icon.getInterpolatedV(16.0) - minV;
        float baseOffsetU = 16.0f / (float)icon.getIconWidth() * 5.0E-4f;
        float baseOffsetV = 16.0f / (float)icon.getIconHeight() * 5.0E-4f;
        for (GroupObject groupObject : model.groupObjects) {
            boolean render = false;
            if (renderedParts == null || renderedParts.length < 1) {
                render = true;
            } else {
                for (String s : renderedParts) {
                    if (!groupObject.name.equalsIgnoreCase(s)) continue;
                    render = true;
                }
            }
            if (!render) continue;
            for (Face face : groupObject.faces) {
                int v;
                if (face.faceNormal == null) {
                    face.faceNormal = face.calculateFaceNormal();
                }
                normalCopy.x = face.faceNormal.x;
                normalCopy.y = face.faceNormal.y;
                normalCopy.z = face.faceNormal.z;
                rotationMatrix.apply(normalCopy);
                float biggestNormal = Math.max(Math.abs(normalCopy.y), Math.max(Math.abs(normalCopy.x), Math.abs(normalCopy.z)));
                int side = biggestNormal == Math.abs(normalCopy.y) ? (normalCopy.y < 0.0f ? 0 : 1) : (biggestNormal == Math.abs(normalCopy.z) ? (normalCopy.z < 0.0f ? 2 : 3) : (normalCopy.x < 0.0f ? 4 : 5));
                BlockLightingInfo faceLight = null;
                if (offsetLighting == 0 && world != null) {
                    faceLight = ClientUtils.calculateBlockLighting(side, world, world.getBlock(x, y, z), x, y, z, colR, colG, colB, standardBlockAABB);
                } else if (offsetLighting == 1 && world != null) {
                    double faceMinX = face.vertices[0].x;
                    double faceMinY = face.vertices[0].y;
                    double faceMinZ = face.vertices[0].z;
                    double faceMaxX = face.vertices[0].x;
                    double faceMaxY = face.vertices[0].y;
                    double faceMaxZ = face.vertices[0].z;
                    for (int i = 1; i < face.vertices.length; ++i) {
                        faceMinX = Math.min(faceMinX, (double)face.vertices[i].x);
                        faceMinY = Math.min(faceMinY, (double)face.vertices[i].y);
                        faceMinZ = Math.min(faceMinZ, (double)face.vertices[i].z);
                        faceMaxX = Math.max(faceMaxX, (double)face.vertices[i].x);
                        faceMaxY = Math.max(faceMaxY, (double)face.vertices[i].y);
                        faceMaxZ = Math.max(faceMaxZ, (double)face.vertices[i].z);
                    }
                    faceLight = ClientUtils.calculateBlockLighting(side, world, world.getBlock(x, y, z), x, y, z, colR, colG, colB, AxisAlignedBB.getBoundingBox((double)faceMinX, (double)faceMinY, (double)faceMinZ, (double)faceMaxX, (double)faceMaxY, (double)faceMaxZ));
                }
                tes.setNormal(face.faceNormal.x, face.faceNormal.y, face.faceNormal.z);
                float averageU = 0.0f;
                float averageV = 0.0f;
                if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                    for (int i = 0; i < face.textureCoordinates.length; ++i) {
                        averageU += face.textureCoordinates[i].u;
                        averageV += face.textureCoordinates[i].v;
                    }
                    averageU /= (float)face.textureCoordinates.length;
                    averageV /= (float)face.textureCoordinates.length;
                }
                TextureCoordinate[] oldUVs = new TextureCoordinate[face.textureCoordinates.length];
                for (v = 0; v < face.vertices.length; ++v) {
                    float offsetU = baseOffsetU;
                    float offsetV = baseOffsetV;
                    if (face.textureCoordinates[v].u > averageU) {
                        offsetU = -offsetU;
                    }
                    if (face.textureCoordinates[v].v > averageV) {
                        offsetV = -offsetV;
                    }
                    oldUVs[v] = face.textureCoordinates[v];
                    TextureCoordinate textureCoordinate = face.textureCoordinates[v];
                    face.textureCoordinates[v] = new TextureCoordinate(minU + sizeU * (textureCoordinate.u + offsetU), minV + sizeV * (textureCoordinate.v + offsetV));
                }
                ClientUtils.addFaceToWorldRender(face, tes, faceLight, translationMatrix, rotationMatrix, invertFaces, colR, colG, colB);
                for (v = 0; v < face.vertices.length; ++v) {
                    face.textureCoordinates[v] = new TextureCoordinate(oldUVs[v].u, oldUVs[v].v);
                }
            }
        }
    }

    public static void renderWavefrontModelWithModifications(WavefrontObject model, Tessellator tes, Matrix4 translationMatrix, Matrix4 rotationMatrix, boolean flipTextureU, String ... renderedParts) {
        Vertex vertexCopy = new Vertex(0.0f, 0.0f, 0.0f);
        Vertex normalCopy = new Vertex(0.0f, 0.0f, 0.0f);
        for (GroupObject groupObject : model.groupObjects) {
            boolean render = false;
            if (renderedParts == null || renderedParts.length < 1) {
                render = true;
            } else {
                for (String s : renderedParts) {
                    if (!groupObject.name.equalsIgnoreCase(s)) continue;
                    render = true;
                }
            }
            if (!render) continue;
            for (Face face : groupObject.faces) {
                if (face.faceNormal == null) {
                    face.faceNormal = face.calculateFaceNormal();
                }
                normalCopy.x = face.faceNormal.x;
                normalCopy.y = face.faceNormal.y;
                normalCopy.z = face.faceNormal.z;
                rotationMatrix.apply(normalCopy);
                tes.setNormal(face.faceNormal.x, face.faceNormal.y, face.faceNormal.z);
                for (int i = 0; i < face.vertices.length; ++i) {
                    Vertex vertex = face.vertices[i];
                    vertexCopy.x = vertex.x;
                    vertexCopy.y = vertex.y;
                    vertexCopy.z = vertex.z;
                    rotationMatrix.apply(vertexCopy);
                    translationMatrix.apply(vertexCopy);
                    if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                        TextureCoordinate textureCoordinate = face.textureCoordinates[flipTextureU ? face.textureCoordinates.length - 1 - i : i];
                        tes.addVertexWithUV((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z, (double)textureCoordinate.u, (double)textureCoordinate.v);
                        continue;
                    }
                    tes.addVertex((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z);
                }
            }
        }
    }

    public static void renderWavefrontWithIconUVs(WavefrontObject model, IIcon icon, String ... parts) {
        ClientUtils.renderWavefrontWithIconUVs(model, 7, icon, parts);
        ClientUtils.renderWavefrontWithIconUVs(model, 4, icon, parts);
    }

    public static void renderWavefrontWithIconUVs(WavefrontObject model, int glDrawingMode, IIcon icon, String ... parts) {
        if (icon == null) {
            return;
        }
        List<String> renderParts = Arrays.asList(parts);
        ClientUtils.tes().startDrawing(glDrawingMode);
        for (GroupObject go : model.groupObjects) {
            if (go.glDrawingMode != glDrawingMode || !renderParts.isEmpty() && !renderParts.contains(go.name)) continue;
            ClientUtils.tessellateWavefrontGroupObjectWithIconUVs(go, icon);
        }
        ClientUtils.tes().draw();
    }

    public static void tessellateWavefrontGroupObjectWithIconUVs(GroupObject object, IIcon icon) {
        if (icon == null) {
            return;
        }
        float minU = icon.getInterpolatedU(0.0);
        float sizeU = icon.getInterpolatedU(16.0) - minU;
        float minV = icon.getInterpolatedV(0.0);
        float sizeV = icon.getInterpolatedV(16.0) - minV;
        float baseOffsetU = 16.0f / (float)icon.getIconWidth() * 5.0E-4f;
        float baseOffsetV = 16.0f / (float)icon.getIconHeight() * 5.0E-4f;
        for (Face face : object.faces) {
            int v;
            float averageU = 0.0f;
            float averageV = 0.0f;
            if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                for (int i = 0; i < face.textureCoordinates.length; ++i) {
                    averageU += face.textureCoordinates[i].u;
                    averageV += face.textureCoordinates[i].v;
                }
                averageU /= (float)face.textureCoordinates.length;
                averageV /= (float)face.textureCoordinates.length;
            }
            TextureCoordinate[] oldUVs = new TextureCoordinate[face.textureCoordinates.length];
            for (v = 0; v < face.vertices.length; ++v) {
                float offsetU = baseOffsetU;
                float offsetV = baseOffsetV;
                if (face.textureCoordinates[v].u > averageU) {
                    offsetU = -offsetU;
                }
                if (face.textureCoordinates[v].v > averageV) {
                    offsetV = -offsetV;
                }
                oldUVs[v] = face.textureCoordinates[v];
                TextureCoordinate textureCoordinate = face.textureCoordinates[v];
                face.textureCoordinates[v] = new TextureCoordinate(minU + sizeU * (textureCoordinate.u + offsetU), minV + sizeV * (textureCoordinate.v + offsetV));
            }
            face.addFaceForRender(ClientUtils.tes(), 0.0f);
            for (v = 0; v < face.vertices.length; ++v) {
                face.textureCoordinates[v] = new TextureCoordinate(oldUVs[v].u, oldUVs[v].v);
            }
        }
    }

    public static void addFaceToWorldRender(Face face, Tessellator tes, BlockLightingInfo light, Matrix4 translationMatrix, Matrix4 rotationMatrix, boolean invert, float colR, float colG, float colB) {
        Vertex vertexCopy = new Vertex(0.0f, 0.0f, 0.0f);
        for (int i = 0; i < face.vertices.length; ++i) {
            int target = !invert ? i : face.vertices.length - 1 - i;
            int corner = (int)((float)target / (float)face.vertices.length * 4.0f);
            Vertex vertex = face.vertices[target];
            vertexCopy.x = vertex.x;
            vertexCopy.y = vertex.y;
            vertexCopy.z = vertex.z;
            rotationMatrix.apply(vertexCopy);
            translationMatrix.apply(vertexCopy);
            if (light != null) {
                float g;
                float r;
                tes.setBrightness(corner == 0 ? light.brightnessTopLeft : (corner == 1 ? light.brightnessBottomLeft : (corner == 2 ? light.brightnessBottomRight : light.brightnessTopRight)));
                float f = corner == 0 ? light.colorRedTopLeft : (corner == 1 ? light.colorRedBottomLeft : (r = corner == 2 ? light.colorRedBottomRight : light.colorRedTopRight));
                float f2 = corner == 0 ? light.colorGreenTopLeft : (corner == 1 ? light.colorGreenBottomLeft : (g = corner == 2 ? light.colorGreenBottomRight : light.colorGreenTopRight));
                float b = corner == 0 ? light.colorBlueTopLeft : (corner == 1 ? light.colorBlueBottomLeft : (corner == 2 ? light.colorBlueBottomRight : light.colorBlueTopRight));
                tes.setColorOpaque_F(r, g, b);
            } else {
                tes.setBrightness(0xB000B0);
                tes.setColorOpaque_F(colR, colG, colB);
            }
            if (face.textureCoordinates != null && face.textureCoordinates.length > 0) {
                TextureCoordinate textureCoordinate = face.textureCoordinates[target];
                tes.addVertexWithUV((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z, (double)textureCoordinate.u, (double)textureCoordinate.v);
                continue;
            }
            tes.addVertex((double)vertexCopy.x, (double)vertexCopy.y, (double)vertexCopy.z);
        }
    }

    public static void renderItemIn2D(IIcon icon, double[] uv, int width, int height, float depth) {
        double f9;
        double f8;
        double f7;
        int k;
        double uMin = icon.getInterpolatedU(uv[0] * 16.0);
        double uMax = icon.getInterpolatedU(uv[1] * 16.0);
        double vMin = icon.getInterpolatedV(uv[2] * 16.0);
        double vMax = icon.getInterpolatedV(uv[3] * 16.0);
        double w = (double)width / 16.0 / 2.0;
        double h = (double)height / 16.0;
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setNormal(0.0f, 0.0f, 1.0f);
        ClientUtils.tes().addVertexWithUV(-w, 0.0, 0.0, uMin, vMax);
        ClientUtils.tes().addVertexWithUV(w, 0.0, 0.0, uMax, vMax);
        ClientUtils.tes().addVertexWithUV(w, h, 0.0, uMax, vMin);
        ClientUtils.tes().addVertexWithUV(-w, h, 0.0, uMin, vMin);
        ClientUtils.tes().draw();
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setNormal(0.0f, 0.0f, -1.0f);
        ClientUtils.tes().addVertexWithUV(-w, h, (double)(0.0f - depth), uMin, vMin);
        ClientUtils.tes().addVertexWithUV(w, h, (double)(0.0f - depth), uMax, vMin);
        ClientUtils.tes().addVertexWithUV(w, 0.0, (double)(0.0f - depth), uMax, vMax);
        ClientUtils.tes().addVertexWithUV(-w, 0.0, (double)(0.0f - depth), uMin, vMax);
        ClientUtils.tes().draw();
        double f5 = 0.5 * (uMin - uMax) / (double)width;
        double f6 = 0.5 * (vMax - vMin) / (double)height;
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setNormal(0.0f, 1.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (double)k / (double)width;
            f8 = uMin + (uMax - uMin) * f7 - f5;
            f9 = (double)k / (double)icon.getIconWidth();
            ClientUtils.tes().addVertexWithUV(-w + f9, 0.0, (double)(-depth), f8, vMax);
            ClientUtils.tes().addVertexWithUV(-w + f9, 0.0, 0.0, f8, vMax);
            ClientUtils.tes().addVertexWithUV(-w + f9, h, 0.0, f8, vMin);
            ClientUtils.tes().addVertexWithUV(-w + f9, h, (double)(-depth), f8, vMin);
        }
        ClientUtils.tes().draw();
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setNormal(1.0f, 0.0f, 0.0f);
        for (k = 0; k < width; ++k) {
            f7 = (double)k / (double)width;
            f8 = uMin + (uMax - uMin) * f7 - f5;
            f9 = (double)(k + 1) / (double)icon.getIconWidth();
            ClientUtils.tes().addVertexWithUV(-w + f9, h, (double)(-depth), f8, vMin);
            ClientUtils.tes().addVertexWithUV(-w + f9, h, 0.0, f8, vMin);
            ClientUtils.tes().addVertexWithUV(-w + f9, 0.0, 0.0, f8, vMax);
            ClientUtils.tes().addVertexWithUV(-w + f9, 0.0, (double)(-depth), f8, vMax);
        }
        ClientUtils.tes().draw();
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setNormal(0.0f, 1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (double)k / (double)height;
            f8 = vMax + (vMin - vMax) * f7 - f6;
            f9 = (double)(k + 1) / (double)icon.getIconHeight();
            ClientUtils.tes().addVertexWithUV(-w, f9, 0.0, uMin, f8);
            ClientUtils.tes().addVertexWithUV(w, f9, 0.0, uMax, f8);
            ClientUtils.tes().addVertexWithUV(w, f9, (double)(-depth), uMax, f8);
            ClientUtils.tes().addVertexWithUV(-w, f9, (double)(-depth), uMin, f8);
        }
        ClientUtils.tes().draw();
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setNormal(0.0f, -1.0f, 0.0f);
        for (k = 0; k < height; ++k) {
            f7 = (double)k / (double)height;
            f8 = vMax + (vMin - vMax) * f7 - f6;
            f9 = (double)k / (double)icon.getIconHeight();
            ClientUtils.tes().addVertexWithUV(w, f9, 0.0, uMax, f8);
            ClientUtils.tes().addVertexWithUV(-w, f9, 0.0, uMin, f8);
            ClientUtils.tes().addVertexWithUV(-w, f9, (double)(-depth), uMin, f8);
            ClientUtils.tes().addVertexWithUV(w, f9, (double)(-depth), uMax, f8);
        }
        ClientUtils.tes().draw();
    }

    public static void drawInventoryBlock(Block block, int metadata, RenderBlocks renderer) {
        Tessellator tes = ClientUtils.tes();
        GL11.glPushMatrix();
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        tes.startDrawingQuads();
        tes.setNormal(0.0f, -1.0f, 0.0f);
        renderer.renderFaceYNeg(block, 0.0, 0.0, 0.0, renderer.overrideBlockTexture != null ? renderer.overrideBlockTexture : renderer.getBlockIconFromSideAndMetadata(block, 0, metadata));
        tes.draw();
        tes.startDrawingQuads();
        tes.setNormal(0.0f, 1.0f, 0.0f);
        renderer.renderFaceYPos(block, 0.0, 0.0, 0.0, renderer.overrideBlockTexture != null ? renderer.overrideBlockTexture : renderer.getBlockIconFromSideAndMetadata(block, 1, metadata));
        tes.draw();
        tes.startDrawingQuads();
        tes.setNormal(0.0f, 0.0f, -1.0f);
        renderer.renderFaceZNeg(block, 0.0, 0.0, 0.0, renderer.overrideBlockTexture != null ? renderer.overrideBlockTexture : renderer.getBlockIconFromSideAndMetadata(block, 2, metadata));
        tes.draw();
        tes.startDrawingQuads();
        tes.setNormal(0.0f, 0.0f, 1.0f);
        renderer.renderFaceZPos(block, 0.0, 0.0, 0.0, renderer.overrideBlockTexture != null ? renderer.overrideBlockTexture : renderer.getBlockIconFromSideAndMetadata(block, 3, metadata));
        tes.draw();
        tes.startDrawingQuads();
        tes.setNormal(-1.0f, 0.0f, 0.0f);
        renderer.renderFaceXNeg(block, 0.0, 0.0, 0.0, renderer.overrideBlockTexture != null ? renderer.overrideBlockTexture : renderer.getBlockIconFromSideAndMetadata(block, 4, metadata));
        tes.draw();
        tes.startDrawingQuads();
        tes.setNormal(1.0f, 0.0f, 0.0f);
        renderer.renderFaceXPos(block, 0.0, 0.0, 0.0, renderer.overrideBlockTexture != null ? renderer.overrideBlockTexture : renderer.getBlockIconFromSideAndMetadata(block, 5, metadata));
        tes.draw();
        GL11.glPopMatrix();
    }

    public static void drawColouredRect(int x, int y, int w, int h, int colour) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().setColorRGBA_I(colour, colour >> 24 & 0xFF);
        ClientUtils.tes().addVertex((double)x, (double)(y + h), 0.0);
        ClientUtils.tes().addVertex((double)(x + w), (double)(y + h), 0.0);
        ClientUtils.tes().addVertex((double)(x + w), (double)y, 0.0);
        ClientUtils.tes().addVertex((double)x, (double)y, 0.0);
        ClientUtils.tes().draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawGradientRect(int x0, int y0, int x1, int y1, int colour0, int colour1) {
        float f = (float)(colour0 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(colour0 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour0 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour0 & 0xFF) / 255.0f;
        float f4 = (float)(colour1 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colour1 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.instance;
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA_F(f1, f2, f3, f);
        tessellator.addVertex((double)x1, (double)y0, 0.0);
        tessellator.addVertex((double)x0, (double)y0, 0.0);
        tessellator.setColorRGBA_F(f5, f6, f7, f4);
        tessellator.addVertex((double)x0, (double)y1, 0.0);
        tessellator.addVertex((double)x1, (double)y1, 0.0);
        tessellator.draw();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawTexturedRect(float x, float y, float w, float h, double ... uv) {
        ClientUtils.tes().startDrawingQuads();
        ClientUtils.tes().addVertexWithUV((double)x, (double)(y + h), 0.0, uv[0], uv[3]);
        ClientUtils.tes().addVertexWithUV((double)(x + w), (double)(y + h), 0.0, uv[1], uv[3]);
        ClientUtils.tes().addVertexWithUV((double)(x + w), (double)y, 0.0, uv[1], uv[2]);
        ClientUtils.tes().addVertexWithUV((double)x, (double)y, 0.0, uv[0], uv[2]);
        ClientUtils.tes().draw();
    }

    public static void drawTexturedRect(int x, int y, int w, int h, float picSize, int ... uv) {
        double[] d_uv = new double[]{(float)uv[0] / picSize, (float)uv[1] / picSize, (float)uv[2] / picSize, (float)uv[3] / picSize};
        ClientUtils.drawTexturedRect((float)x, (float)y, (float)w, (float)h, d_uv);
    }

    public static void drawRepeatedFluidIcon(Fluid fluid, float x, float y, float w, float h) {
        ClientUtils.bindTexture(TextureMap.locationBlocksTexture.toString());
        IIcon icon = fluid.getIcon();
        if (icon != null) {
            int iW = icon.getIconWidth();
            int iH = icon.getIconHeight();
            if (iW > 0 && iH > 0) {
                ClientUtils.drawRepeatedIcon(x, y, w, h, iW, iH, icon.getMinU(), icon.getMaxU(), icon.getMinV(), icon.getMaxV());
            }
        }
    }

    public static void drawRepeatedIcon(float x, float y, float w, float h, int iconWidth, int iconHeight, float uMin, float uMax, float vMin, float vMax) {
        int iterMaxW = (int)(w / (float)iconWidth);
        int iterMaxH = (int)(h / (float)iconHeight);
        float leftoverW = w % (float)iconWidth;
        float leftoverH = h % (float)iconHeight;
        float leftoverWf = leftoverW / (float)iconWidth;
        float leftoverHf = leftoverH / (float)iconHeight;
        float iconUDif = uMax - uMin;
        float iconVDif = vMax - vMin;
        for (int ww = 0; ww < iterMaxW; ++ww) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(x + (float)(ww * iconWidth), y + (float)(hh * iconHeight), (float)iconWidth, (float)iconHeight, uMin, uMax, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(x + (float)(ww * iconWidth), y + (float)(iterMaxH * iconHeight), (float)iconWidth, leftoverH, uMin, uMax, vMin, vMin + iconVDif * leftoverHf);
        }
        if (leftoverW > 0.0f) {
            for (int hh = 0; hh < iterMaxH; ++hh) {
                ClientUtils.drawTexturedRect(x + (float)(iterMaxW * iconWidth), y + (float)(hh * iconHeight), leftoverW, (float)iconHeight, uMin, uMin + iconUDif * leftoverWf, vMin, vMax);
            }
            ClientUtils.drawTexturedRect(x + (float)(iterMaxW * iconWidth), y + (float)(iterMaxH * iconHeight), leftoverW, leftoverH, uMin, uMin + iconUDif * leftoverWf, vMin, vMin + iconVDif * leftoverHf);
        }
    }

    public static void drawSlot(int x, int y, int w, int h) {
        ClientUtils.drawSlot(x, y, w, h, 255);
    }

    public static void drawSlot(int x, int y, int w, int h, int alpha) {
        GuiDraw.drawRect((int)(x + 8 - w / 2), (int)(y + 8 - h / 2 - 1), (int)w, (int)1, (int)((alpha << 24) + 0x373737));
        GuiDraw.drawRect((int)(x + 8 - w / 2 - 1), (int)(y + 8 - h / 2 - 1), (int)1, (int)(h + 1), (int)((alpha << 24) + 0x373737));
        GuiDraw.drawRect((int)(x + 8 - w / 2), (int)(y + 8 - h / 2), (int)w, (int)h, (int)((alpha << 24) + 0x8B8B8B));
        GuiDraw.drawRect((int)(x + 8 - w / 2), (int)(y + 8 + h / 2), (int)(w + 1), (int)1, (int)((alpha << 24) + 0xFFFFFF));
        GuiDraw.drawRect((int)(x + 8 + w / 2), (int)(y + 8 - h / 2), (int)1, (int)h, (int)((alpha << 24) + 0xFFFFFF));
    }

    public static void renderToolTip(ItemStack stack, int x, int y) {
        List list = stack.getTooltip((EntityPlayer)ClientUtils.mc().thePlayer, ClientUtils.mc().gameSettings.advancedItemTooltips);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, stack.getRarity().rarityColor + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = stack.getItem().getFontRenderer(stack);
        ClientUtils.drawHoveringText(list, x, y, font == null ? ClientUtils.font() : font);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer font) {
        ClientUtils.drawHoveringText(list, x, y, font, -1, -1);
    }

    public static void drawHoveringText(List<String> list, int x, int y, FontRenderer font, int xSize, int ySize) {
        if (!list.isEmpty()) {
            boolean uni = ClientUtils.font().getUnicodeFlag();
            ClientUtils.font().setUnicodeFlag(false);
            GL11.glDisable((int)32826);
            RenderHelper.disableStandardItemLighting();
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            int k = 0;
            for (String s : list) {
                int l = font.getStringWidth(s);
                if (l <= k) continue;
                k = l;
            }
            int j2 = x + 12;
            int k2 = y - 12;
            int i1 = 8;
            boolean shift = false;
            if (xSize > 0 && j2 + k > xSize) {
                j2 -= 28 + k;
                shift = true;
            }
            if (ySize > 0 && k2 + i1 + 6 > ySize) {
                k2 = ySize - i1 - 6;
                shift = true;
            }
            if (!shift && ClientUtils.mc().currentScreen != null) {
                if (j2 + k > ClientUtils.mc().currentScreen.width) {
                    j2 -= 28 + k;
                }
                if (k2 + i1 + 6 > ClientUtils.mc().currentScreen.height) {
                    k2 = ClientUtils.mc().currentScreen.height - i1 - 6;
                }
            }
            if (list.size() > 1) {
                i1 += 2 + (list.size() - 1) * 10;
            }
            int j1 = -267386864;
            ClientUtils.drawGradientRect(j2 - 3, k2 - 4, j2 + k + 3, k2 - 3, j1, j1);
            ClientUtils.drawGradientRect(j2 - 3, k2 + i1 + 3, j2 + k + 3, k2 + i1 + 4, j1, j1);
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 + i1 + 3, j1, j1);
            ClientUtils.drawGradientRect(j2 - 4, k2 - 3, j2 - 3, k2 + i1 + 3, j1, j1);
            ClientUtils.drawGradientRect(j2 + k + 3, k2 - 3, j2 + k + 4, k2 + i1 + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3 + 1, j2 - 3 + 1, k2 + i1 + 3 - 1, k1, l1);
            ClientUtils.drawGradientRect(j2 + k + 2, k2 - 3 + 1, j2 + k + 3, k2 + i1 + 3 - 1, k1, l1);
            ClientUtils.drawGradientRect(j2 - 3, k2 - 3, j2 + k + 3, k2 - 3 + 1, k1, k1);
            ClientUtils.drawGradientRect(j2 - 3, k2 + i1 + 2, j2 + k + 3, k2 + i1 + 3, l1, l1);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = list.get(i2);
                font.drawStringWithShadow(s1, j2, k2, -1);
                if (i2 == 0) {
                    k2 += 2;
                }
                k2 += 10;
            }
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            RenderHelper.enableStandardItemLighting();
            GL11.glEnable((int)32826);
            ClientUtils.font().setUnicodeFlag(uni);
        }
    }

    public static void handleGuiTank(FluidTank tank, int x, int y, int w, int h, int oX, int oY, int oW, int oH, int mX, int mY, String originalTexture, ArrayList<String> tooltip) {
        if (tooltip == null) {
            if (tank.getFluid() != null && tank.getFluid().getFluid() != null) {
                int fluidHeight = (int)((float)h * ((float)tank.getFluid().amount / (float)tank.getCapacity()));
                ClientUtils.drawRepeatedFluidIcon(tank.getFluid().getFluid(), x, y + h - fluidHeight, w, fluidHeight);
                ClientUtils.bindTexture(originalTexture);
            }
            int xOff = (w - oW) / 2;
            int yOff = (h - oH) / 2;
            ClientUtils.drawTexturedRect(x + xOff, y + yOff, oW, oH, 256.0f, oX, oX + oW, oY, oY + oH);
        } else if (mX >= x && mX < x + w && mY >= y && mY < y + h) {
            if (tank.getFluid() != null && tank.getFluid().getFluid() != null) {
                tooltip.add(tank.getFluid().getLocalizedName());
            } else {
                tooltip.add(StatCollector.translateToLocal((String)"gui.ImmersiveEngineering.empty"));
            }
            tooltip.add(tank.getFluidAmount() + "/" + tank.getCapacity() + "mB");
        }
    }

    public static BlockLightingInfo calculateBlockLighting(int side, IBlockAccess world, Block block, int x, int y, int z, float colR, float colG, float colB) {
        return ClientUtils.calculateBlockLighting(side, world, block, x, y, z, colR, colG, colB, standardBlockAABB);
    }

    public static BlockLightingInfo calculateBlockLighting(int side, IBlockAccess world, Block block, int x, int y, int z, float colR, float colG, float colB, AxisAlignedBB bounds) {
        int i2;
        int l1;
        int k1;
        int j1;
        float f11;
        float f10;
        float f9;
        float f8;
        float f7;
        int i1;
        boolean flag5;
        boolean flag4;
        boolean flag3;
        boolean flag2;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        int l = block.getMixedBrightnessForBlock(world, x, y, z);
        BlockLightingInfo lightingInfo = new BlockLightingInfo();
        if (side == 0) {
            if (bounds.minY <= 0.0) {
                --y;
            }
            lightingInfo.aoBrightnessXYNN = block.getMixedBrightnessForBlock(world, x - 1, y, z);
            lightingInfo.aoBrightnessYZNN = block.getMixedBrightnessForBlock(world, x, y, z - 1);
            lightingInfo.aoBrightnessYZNP = block.getMixedBrightnessForBlock(world, x, y, z + 1);
            lightingInfo.aoBrightnessXYPN = block.getMixedBrightnessForBlock(world, x + 1, y, z);
            lightingInfo.aoLightValueScratchXYNN = world.getBlock(x - 1, y, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchYZNN = world.getBlock(x, y, z - 1).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchYZNP = world.getBlock(x, y, z + 1).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXYPN = world.getBlock(x + 1, y, z).getAmbientOcclusionLightValue();
            flag2 = world.getBlock(x + 1, y - 1, z).getCanBlockGrass();
            flag3 = world.getBlock(x - 1, y - 1, z).getCanBlockGrass();
            flag4 = world.getBlock(x, y - 1, z + 1).getCanBlockGrass();
            flag5 = world.getBlock(x, y - 1, z - 1).getCanBlockGrass();
            if (!flag5 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNNN = lightingInfo.aoLightValueScratchXYNN;
                lightingInfo.aoBrightnessXYZNNN = lightingInfo.aoBrightnessXYNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNNN = world.getBlock(x - 1, y, z - 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNNN = block.getMixedBrightnessForBlock(world, x - 1, y, z - 1);
            }
            if (!flag4 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNNP = lightingInfo.aoLightValueScratchXYNN;
                lightingInfo.aoBrightnessXYZNNP = lightingInfo.aoBrightnessXYNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNNP = world.getBlock(x - 1, y, z + 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNNP = block.getMixedBrightnessForBlock(world, x - 1, y, z + 1);
            }
            if (!flag5 && !flag2) {
                lightingInfo.aoLightValueScratchXYZPNN = lightingInfo.aoLightValueScratchXYPN;
                lightingInfo.aoBrightnessXYZPNN = lightingInfo.aoBrightnessXYPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPNN = world.getBlock(x + 1, y, z - 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPNN = block.getMixedBrightnessForBlock(world, x + 1, y, z - 1);
            }
            if (!flag4 && !flag2) {
                lightingInfo.aoLightValueScratchXYZPNP = lightingInfo.aoLightValueScratchXYPN;
                lightingInfo.aoBrightnessXYZPNP = lightingInfo.aoBrightnessXYPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPNP = world.getBlock(x + 1, y, z + 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPNP = block.getMixedBrightnessForBlock(world, x + 1, y, z + 1);
            }
            if (bounds.minY <= 0.0) {
                ++y;
            }
            i1 = l;
            if (bounds.minY <= 0.0 || !world.getBlock(x, y - 1, z).isOpaqueCube()) {
                i1 = block.getMixedBrightnessForBlock(world, x, y - 1, z);
            }
            f7 = world.getBlock(x, y - 1, z).getAmbientOcclusionLightValue();
            f3 = (lightingInfo.aoLightValueScratchXYZNNP + lightingInfo.aoLightValueScratchXYNN + lightingInfo.aoLightValueScratchYZNP + f7) / 4.0f;
            f6 = (lightingInfo.aoLightValueScratchYZNP + f7 + lightingInfo.aoLightValueScratchXYZPNP + lightingInfo.aoLightValueScratchXYPN) / 4.0f;
            f5 = (f7 + lightingInfo.aoLightValueScratchYZNN + lightingInfo.aoLightValueScratchXYPN + lightingInfo.aoLightValueScratchXYZPNN) / 4.0f;
            f4 = (lightingInfo.aoLightValueScratchXYNN + lightingInfo.aoLightValueScratchXYZNNN + f7 + lightingInfo.aoLightValueScratchYZNN) / 4.0f;
            lightingInfo.brightnessTopLeft = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNNP, lightingInfo.aoBrightnessXYNN, lightingInfo.aoBrightnessYZNP, i1);
            lightingInfo.brightnessTopRight = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZNP, lightingInfo.aoBrightnessXYZPNP, lightingInfo.aoBrightnessXYPN, i1);
            lightingInfo.brightnessBottomRight = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZNN, lightingInfo.aoBrightnessXYPN, lightingInfo.aoBrightnessXYZPNN, i1);
            lightingInfo.brightnessBottomLeft = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYNN, lightingInfo.aoBrightnessXYZNNN, lightingInfo.aoBrightnessYZNN, i1);
            lightingInfo.colorRedBottomRight = lightingInfo.colorRedTopRight = colR * 0.5f;
            lightingInfo.colorRedBottomLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorRedTopLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorGreenBottomRight = lightingInfo.colorGreenTopRight = colG * 0.5f;
            lightingInfo.colorGreenBottomLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorGreenTopLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorBlueBottomRight = lightingInfo.colorBlueTopRight = colB * 0.5f;
            lightingInfo.colorBlueBottomLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorBlueTopLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 1) {
            if (bounds.maxY >= 1.0) {
                ++y;
            }
            lightingInfo.aoBrightnessXYNP = block.getMixedBrightnessForBlock(world, x - 1, y, z);
            lightingInfo.aoBrightnessXYPP = block.getMixedBrightnessForBlock(world, x + 1, y, z);
            lightingInfo.aoBrightnessYZPN = block.getMixedBrightnessForBlock(world, x, y, z - 1);
            lightingInfo.aoBrightnessYZPP = block.getMixedBrightnessForBlock(world, x, y, z + 1);
            lightingInfo.aoLightValueScratchXYNP = world.getBlock(x - 1, y, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXYPP = world.getBlock(x + 1, y, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchYZPN = world.getBlock(x, y, z - 1).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchYZPP = world.getBlock(x, y, z + 1).getAmbientOcclusionLightValue();
            flag2 = world.getBlock(x + 1, y + 1, z).getCanBlockGrass();
            flag3 = world.getBlock(x - 1, y + 1, z).getCanBlockGrass();
            flag4 = world.getBlock(x, y + 1, z + 1).getCanBlockGrass();
            flag5 = world.getBlock(x, y + 1, z - 1).getCanBlockGrass();
            if (!flag5 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNPN = lightingInfo.aoLightValueScratchXYNP;
                lightingInfo.aoBrightnessXYZNPN = lightingInfo.aoBrightnessXYNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNPN = world.getBlock(x - 1, y, z - 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNPN = block.getMixedBrightnessForBlock(world, x - 1, y, z - 1);
            }
            if (!flag5 && !flag2) {
                lightingInfo.aoLightValueScratchXYZPPN = lightingInfo.aoLightValueScratchXYPP;
                lightingInfo.aoBrightnessXYZPPN = lightingInfo.aoBrightnessXYPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPPN = world.getBlock(x + 1, y, z - 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPPN = block.getMixedBrightnessForBlock(world, x + 1, y, z - 1);
            }
            if (!flag4 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNPP = lightingInfo.aoLightValueScratchXYNP;
                lightingInfo.aoBrightnessXYZNPP = lightingInfo.aoBrightnessXYNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNPP = world.getBlock(x - 1, y, z + 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNPP = block.getMixedBrightnessForBlock(world, x - 1, y, z + 1);
            }
            if (!flag4 && !flag2) {
                lightingInfo.aoLightValueScratchXYZPPP = lightingInfo.aoLightValueScratchXYPP;
                lightingInfo.aoBrightnessXYZPPP = lightingInfo.aoBrightnessXYPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPPP = world.getBlock(x + 1, y, z + 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPPP = block.getMixedBrightnessForBlock(world, x + 1, y, z + 1);
            }
            if (bounds.maxY >= 1.0) {
                --y;
            }
            i1 = l;
            if (bounds.maxY >= 1.0 || !world.getBlock(x, y + 1, z).isOpaqueCube()) {
                i1 = block.getMixedBrightnessForBlock(world, x, y + 1, z);
            }
            f7 = world.getBlock(x, y + 1, z).getAmbientOcclusionLightValue();
            f6 = (lightingInfo.aoLightValueScratchXYZNPP + lightingInfo.aoLightValueScratchXYNP + lightingInfo.aoLightValueScratchYZPP + f7) / 4.0f;
            f3 = (lightingInfo.aoLightValueScratchYZPP + f7 + lightingInfo.aoLightValueScratchXYZPPP + lightingInfo.aoLightValueScratchXYPP) / 4.0f;
            f4 = (f7 + lightingInfo.aoLightValueScratchYZPN + lightingInfo.aoLightValueScratchXYPP + lightingInfo.aoLightValueScratchXYZPPN) / 4.0f;
            f5 = (lightingInfo.aoLightValueScratchXYNP + lightingInfo.aoLightValueScratchXYZNPN + f7 + lightingInfo.aoLightValueScratchYZPN) / 4.0f;
            lightingInfo.brightnessTopRight = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNPP, lightingInfo.aoBrightnessXYNP, lightingInfo.aoBrightnessYZPP, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZPP, lightingInfo.aoBrightnessXYZPPP, lightingInfo.aoBrightnessXYPP, i1);
            lightingInfo.brightnessBottomLeft = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZPN, lightingInfo.aoBrightnessXYPP, lightingInfo.aoBrightnessXYZPPN, i1);
            lightingInfo.brightnessBottomRight = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYNP, lightingInfo.aoBrightnessXYZNPN, lightingInfo.aoBrightnessYZPN, i1);
            lightingInfo.colorRedBottomRight = lightingInfo.colorRedTopRight = colR;
            lightingInfo.colorRedBottomLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorRedTopLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorGreenBottomRight = lightingInfo.colorGreenTopRight = colG;
            lightingInfo.colorGreenBottomLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorGreenTopLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorBlueBottomRight = lightingInfo.colorBlueTopRight = colB;
            lightingInfo.colorBlueBottomLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorBlueTopLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 2) {
            if (bounds.minZ <= 0.0) {
                --z;
            }
            lightingInfo.aoLightValueScratchXZNN = world.getBlock(x - 1, y, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchYZNN = world.getBlock(x, y - 1, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchYZPN = world.getBlock(x, y + 1, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXZPN = world.getBlock(x + 1, y, z).getAmbientOcclusionLightValue();
            lightingInfo.aoBrightnessXZNN = block.getMixedBrightnessForBlock(world, x - 1, y, z);
            lightingInfo.aoBrightnessYZNN = block.getMixedBrightnessForBlock(world, x, y - 1, z);
            lightingInfo.aoBrightnessYZPN = block.getMixedBrightnessForBlock(world, x, y + 1, z);
            lightingInfo.aoBrightnessXZPN = block.getMixedBrightnessForBlock(world, x + 1, y, z);
            flag2 = world.getBlock(x + 1, y, z - 1).getCanBlockGrass();
            flag3 = world.getBlock(x - 1, y, z - 1).getCanBlockGrass();
            flag4 = world.getBlock(x, y + 1, z - 1).getCanBlockGrass();
            flag5 = world.getBlock(x, y - 1, z - 1).getCanBlockGrass();
            if (!flag3 && !flag5) {
                lightingInfo.aoLightValueScratchXYZNNN = lightingInfo.aoLightValueScratchXZNN;
                lightingInfo.aoBrightnessXYZNNN = lightingInfo.aoBrightnessXZNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNNN = world.getBlock(x - 1, y - 1, z).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNNN = block.getMixedBrightnessForBlock(world, x - 1, y - 1, z);
            }
            if (!flag3 && !flag4) {
                lightingInfo.aoLightValueScratchXYZNPN = lightingInfo.aoLightValueScratchXZNN;
                lightingInfo.aoBrightnessXYZNPN = lightingInfo.aoBrightnessXZNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNPN = world.getBlock(x - 1, y + 1, z).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNPN = block.getMixedBrightnessForBlock(world, x - 1, y + 1, z);
            }
            if (!flag2 && !flag5) {
                lightingInfo.aoLightValueScratchXYZPNN = lightingInfo.aoLightValueScratchXZPN;
                lightingInfo.aoBrightnessXYZPNN = lightingInfo.aoBrightnessXZPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPNN = world.getBlock(x + 1, y - 1, z).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPNN = block.getMixedBrightnessForBlock(world, x + 1, y - 1, z);
            }
            if (!flag2 && !flag4) {
                lightingInfo.aoLightValueScratchXYZPPN = lightingInfo.aoLightValueScratchXZPN;
                lightingInfo.aoBrightnessXYZPPN = lightingInfo.aoBrightnessXZPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPPN = world.getBlock(x + 1, y + 1, z).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPPN = block.getMixedBrightnessForBlock(world, x + 1, y + 1, z);
            }
            if (bounds.minZ <= 0.0) {
                ++z;
            }
            i1 = l;
            if (bounds.minZ <= 0.0 || !world.getBlock(x, y, z - 1).isOpaqueCube()) {
                i1 = block.getMixedBrightnessForBlock(world, x, y, z - 1);
            }
            f7 = world.getBlock(x, y, z - 1).getAmbientOcclusionLightValue();
            f8 = (lightingInfo.aoLightValueScratchXZNN + lightingInfo.aoLightValueScratchXYZNPN + f7 + lightingInfo.aoLightValueScratchYZPN) / 4.0f;
            f9 = (f7 + lightingInfo.aoLightValueScratchYZPN + lightingInfo.aoLightValueScratchXZPN + lightingInfo.aoLightValueScratchXYZPPN) / 4.0f;
            f10 = (lightingInfo.aoLightValueScratchYZNN + f7 + lightingInfo.aoLightValueScratchXYZPNN + lightingInfo.aoLightValueScratchXZPN) / 4.0f;
            f11 = (lightingInfo.aoLightValueScratchXYZNNN + lightingInfo.aoLightValueScratchXZNN + lightingInfo.aoLightValueScratchYZNN + f7) / 4.0f;
            f3 = (float)((double)f8 * bounds.maxY * (1.0 - bounds.minX) + (double)f9 * bounds.maxY * bounds.minX + (double)f10 * (1.0 - bounds.maxY) * bounds.minX + (double)f11 * (1.0 - bounds.maxY) * (1.0 - bounds.minX));
            f4 = (float)((double)f8 * bounds.maxY * (1.0 - bounds.maxX) + (double)f9 * bounds.maxY * bounds.maxX + (double)f10 * (1.0 - bounds.maxY) * bounds.maxX + (double)f11 * (1.0 - bounds.maxY) * (1.0 - bounds.maxX));
            f5 = (float)((double)f8 * bounds.minY * (1.0 - bounds.maxX) + (double)f9 * bounds.minY * bounds.maxX + (double)f10 * (1.0 - bounds.minY) * bounds.maxX + (double)f11 * (1.0 - bounds.minY) * (1.0 - bounds.maxX));
            f6 = (float)((double)f8 * bounds.minY * (1.0 - bounds.minX) + (double)f9 * bounds.minY * bounds.minX + (double)f10 * (1.0 - bounds.minY) * bounds.minX + (double)f11 * (1.0 - bounds.minY) * (1.0 - bounds.minX));
            j1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZNN, lightingInfo.aoBrightnessXYZNPN, lightingInfo.aoBrightnessYZPN, i1);
            k1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZPN, lightingInfo.aoBrightnessXZPN, lightingInfo.aoBrightnessXYZPPN, i1);
            l1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZNN, lightingInfo.aoBrightnessXYZPNN, lightingInfo.aoBrightnessXZPN, i1);
            i2 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNNN, lightingInfo.aoBrightnessXZNN, lightingInfo.aoBrightnessYZNN, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.mixAoBrightness(j1, k1, l1, i2, bounds.maxY * (1.0 - bounds.minX), bounds.maxY * bounds.minX, (1.0 - bounds.maxY) * bounds.minX, (1.0 - bounds.maxY) * (1.0 - bounds.minX));
            lightingInfo.brightnessBottomLeft = lightingInfo.mixAoBrightness(j1, k1, l1, i2, bounds.maxY * (1.0 - bounds.maxX), bounds.maxY * bounds.maxX, (1.0 - bounds.maxY) * bounds.maxX, (1.0 - bounds.maxY) * (1.0 - bounds.maxX));
            lightingInfo.brightnessBottomRight = lightingInfo.mixAoBrightness(j1, k1, l1, i2, bounds.minY * (1.0 - bounds.maxX), bounds.minY * bounds.maxX, (1.0 - bounds.minY) * bounds.maxX, (1.0 - bounds.minY) * (1.0 - bounds.maxX));
            lightingInfo.brightnessTopRight = lightingInfo.mixAoBrightness(j1, k1, l1, i2, bounds.minY * (1.0 - bounds.minX), bounds.minY * bounds.minX, (1.0 - bounds.minY) * bounds.minX, (1.0 - bounds.minY) * (1.0 - bounds.minX));
            lightingInfo.colorRedBottomRight = lightingInfo.colorRedTopRight = colR * 0.8f;
            lightingInfo.colorRedBottomLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorRedTopLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorGreenBottomRight = lightingInfo.colorGreenTopRight = colG * 0.8f;
            lightingInfo.colorGreenBottomLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorGreenTopLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorBlueBottomRight = lightingInfo.colorBlueTopRight = colB * 0.8f;
            lightingInfo.colorBlueBottomLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorBlueTopLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 3) {
            if (bounds.maxZ >= 1.0) {
                ++z;
            }
            lightingInfo.aoLightValueScratchXZNP = world.getBlock(x - 1, y, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXZPP = world.getBlock(x + 1, y, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchYZNP = world.getBlock(x, y - 1, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchYZPP = world.getBlock(x, y + 1, z).getAmbientOcclusionLightValue();
            lightingInfo.aoBrightnessXZNP = block.getMixedBrightnessForBlock(world, x - 1, y, z);
            lightingInfo.aoBrightnessXZPP = block.getMixedBrightnessForBlock(world, x + 1, y, z);
            lightingInfo.aoBrightnessYZNP = block.getMixedBrightnessForBlock(world, x, y - 1, z);
            lightingInfo.aoBrightnessYZPP = block.getMixedBrightnessForBlock(world, x, y + 1, z);
            flag2 = world.getBlock(x + 1, y, z + 1).getCanBlockGrass();
            flag3 = world.getBlock(x - 1, y, z + 1).getCanBlockGrass();
            flag4 = world.getBlock(x, y + 1, z + 1).getCanBlockGrass();
            flag5 = world.getBlock(x, y - 1, z + 1).getCanBlockGrass();
            if (!flag3 && !flag5) {
                lightingInfo.aoLightValueScratchXYZNNP = lightingInfo.aoLightValueScratchXZNP;
                lightingInfo.aoBrightnessXYZNNP = lightingInfo.aoBrightnessXZNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNNP = world.getBlock(x - 1, y - 1, z).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNNP = block.getMixedBrightnessForBlock(world, x - 1, y - 1, z);
            }
            if (!flag3 && !flag4) {
                lightingInfo.aoLightValueScratchXYZNPP = lightingInfo.aoLightValueScratchXZNP;
                lightingInfo.aoBrightnessXYZNPP = lightingInfo.aoBrightnessXZNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNPP = world.getBlock(x - 1, y + 1, z).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNPP = block.getMixedBrightnessForBlock(world, x - 1, y + 1, z);
            }
            if (!flag2 && !flag5) {
                lightingInfo.aoLightValueScratchXYZPNP = lightingInfo.aoLightValueScratchXZPP;
                lightingInfo.aoBrightnessXYZPNP = lightingInfo.aoBrightnessXZPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPNP = world.getBlock(x + 1, y - 1, z).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPNP = block.getMixedBrightnessForBlock(world, x + 1, y - 1, z);
            }
            if (!flag2 && !flag4) {
                lightingInfo.aoLightValueScratchXYZPPP = lightingInfo.aoLightValueScratchXZPP;
                lightingInfo.aoBrightnessXYZPPP = lightingInfo.aoBrightnessXZPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPPP = world.getBlock(x + 1, y + 1, z).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPPP = block.getMixedBrightnessForBlock(world, x + 1, y + 1, z);
            }
            if (bounds.maxZ >= 1.0) {
                --z;
            }
            i1 = l;
            if (bounds.maxZ >= 1.0 || !world.getBlock(x, y, z + 1).isOpaqueCube()) {
                i1 = block.getMixedBrightnessForBlock(world, x, y, z + 1);
            }
            f7 = world.getBlock(x, y, z + 1).getAmbientOcclusionLightValue();
            f8 = (lightingInfo.aoLightValueScratchXZNP + lightingInfo.aoLightValueScratchXYZNPP + f7 + lightingInfo.aoLightValueScratchYZPP) / 4.0f;
            f9 = (f7 + lightingInfo.aoLightValueScratchYZPP + lightingInfo.aoLightValueScratchXZPP + lightingInfo.aoLightValueScratchXYZPPP) / 4.0f;
            f10 = (lightingInfo.aoLightValueScratchYZNP + f7 + lightingInfo.aoLightValueScratchXYZPNP + lightingInfo.aoLightValueScratchXZPP) / 4.0f;
            f11 = (lightingInfo.aoLightValueScratchXYZNNP + lightingInfo.aoLightValueScratchXZNP + lightingInfo.aoLightValueScratchYZNP + f7) / 4.0f;
            f3 = (float)((double)f8 * bounds.maxY * (1.0 - bounds.minX) + (double)f9 * bounds.maxY * bounds.minX + (double)f10 * (1.0 - bounds.maxY) * bounds.minX + (double)f11 * (1.0 - bounds.maxY) * (1.0 - bounds.minX));
            f4 = (float)((double)f8 * bounds.minY * (1.0 - bounds.minX) + (double)f9 * bounds.minY * bounds.minX + (double)f10 * (1.0 - bounds.minY) * bounds.minX + (double)f11 * (1.0 - bounds.minY) * (1.0 - bounds.minX));
            f5 = (float)((double)f8 * bounds.minY * (1.0 - bounds.maxX) + (double)f9 * bounds.minY * bounds.maxX + (double)f10 * (1.0 - bounds.minY) * bounds.maxX + (double)f11 * (1.0 - bounds.minY) * (1.0 - bounds.maxX));
            f6 = (float)((double)f8 * bounds.maxY * (1.0 - bounds.maxX) + (double)f9 * bounds.maxY * bounds.maxX + (double)f10 * (1.0 - bounds.maxY) * bounds.maxX + (double)f11 * (1.0 - bounds.maxY) * (1.0 - bounds.maxX));
            j1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZNP, lightingInfo.aoBrightnessXYZNPP, lightingInfo.aoBrightnessYZPP, i1);
            k1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZPP, lightingInfo.aoBrightnessXZPP, lightingInfo.aoBrightnessXYZPPP, i1);
            l1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessYZNP, lightingInfo.aoBrightnessXYZPNP, lightingInfo.aoBrightnessXZPP, i1);
            i2 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNNP, lightingInfo.aoBrightnessXZNP, lightingInfo.aoBrightnessYZNP, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.mixAoBrightness(j1, i2, l1, k1, bounds.maxY * (1.0 - bounds.minX), (1.0 - bounds.maxY) * (1.0 - bounds.minX), (1.0 - bounds.maxY) * bounds.minX, bounds.maxY * bounds.minX);
            lightingInfo.brightnessBottomLeft = lightingInfo.mixAoBrightness(j1, i2, l1, k1, bounds.minY * (1.0 - bounds.minX), (1.0 - bounds.minY) * (1.0 - bounds.minX), (1.0 - bounds.minY) * bounds.minX, bounds.minY * bounds.minX);
            lightingInfo.brightnessBottomRight = lightingInfo.mixAoBrightness(j1, i2, l1, k1, bounds.minY * (1.0 - bounds.maxX), (1.0 - bounds.minY) * (1.0 - bounds.maxX), (1.0 - bounds.minY) * bounds.maxX, bounds.minY * bounds.maxX);
            lightingInfo.brightnessTopRight = lightingInfo.mixAoBrightness(j1, i2, l1, k1, bounds.maxY * (1.0 - bounds.maxX), (1.0 - bounds.maxY) * (1.0 - bounds.maxX), (1.0 - bounds.maxY) * bounds.maxX, bounds.maxY * bounds.maxX);
            lightingInfo.colorRedBottomRight = lightingInfo.colorRedTopRight = colR * 0.8f;
            lightingInfo.colorRedBottomLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorRedTopLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorGreenBottomRight = lightingInfo.colorGreenTopRight = colG * 0.8f;
            lightingInfo.colorGreenBottomLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorGreenTopLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorBlueBottomRight = lightingInfo.colorBlueTopRight = colB * 0.8f;
            lightingInfo.colorBlueBottomLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorBlueTopLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 4) {
            if (bounds.minX <= 0.0) {
                --x;
            }
            lightingInfo.aoLightValueScratchXYNN = world.getBlock(x, y - 1, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXZNN = world.getBlock(x, y, z - 1).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXZNP = world.getBlock(x, y, z + 1).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXYNP = world.getBlock(x, y + 1, z).getAmbientOcclusionLightValue();
            lightingInfo.aoBrightnessXYNN = block.getMixedBrightnessForBlock(world, x, y - 1, z);
            lightingInfo.aoBrightnessXZNN = block.getMixedBrightnessForBlock(world, x, y, z - 1);
            lightingInfo.aoBrightnessXZNP = block.getMixedBrightnessForBlock(world, x, y, z + 1);
            lightingInfo.aoBrightnessXYNP = block.getMixedBrightnessForBlock(world, x, y + 1, z);
            flag2 = world.getBlock(x - 1, y + 1, z).getCanBlockGrass();
            flag3 = world.getBlock(x - 1, y - 1, z).getCanBlockGrass();
            flag4 = world.getBlock(x - 1, y, z - 1).getCanBlockGrass();
            flag5 = world.getBlock(x - 1, y, z + 1).getCanBlockGrass();
            if (!flag4 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNNN = lightingInfo.aoLightValueScratchXZNN;
                lightingInfo.aoBrightnessXYZNNN = lightingInfo.aoBrightnessXZNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNNN = world.getBlock(x, y - 1, z - 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNNN = block.getMixedBrightnessForBlock(world, x, y - 1, z - 1);
            }
            if (!flag5 && !flag3) {
                lightingInfo.aoLightValueScratchXYZNNP = lightingInfo.aoLightValueScratchXZNP;
                lightingInfo.aoBrightnessXYZNNP = lightingInfo.aoBrightnessXZNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNNP = world.getBlock(x, y - 1, z + 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNNP = block.getMixedBrightnessForBlock(world, x, y - 1, z + 1);
            }
            if (!flag4 && !flag2) {
                lightingInfo.aoLightValueScratchXYZNPN = lightingInfo.aoLightValueScratchXZNN;
                lightingInfo.aoBrightnessXYZNPN = lightingInfo.aoBrightnessXZNN;
            } else {
                lightingInfo.aoLightValueScratchXYZNPN = world.getBlock(x, y + 1, z - 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNPN = block.getMixedBrightnessForBlock(world, x, y + 1, z - 1);
            }
            if (!flag5 && !flag2) {
                lightingInfo.aoLightValueScratchXYZNPP = lightingInfo.aoLightValueScratchXZNP;
                lightingInfo.aoBrightnessXYZNPP = lightingInfo.aoBrightnessXZNP;
            } else {
                lightingInfo.aoLightValueScratchXYZNPP = world.getBlock(x, y + 1, z + 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZNPP = block.getMixedBrightnessForBlock(world, x, y + 1, z + 1);
            }
            if (bounds.minX <= 0.0) {
                ++x;
            }
            i1 = l;
            if (bounds.minX <= 0.0 || !world.getBlock(x - 1, y, z).isOpaqueCube()) {
                i1 = block.getMixedBrightnessForBlock(world, x - 1, y, z);
            }
            f7 = world.getBlock(x - 1, y, z).getAmbientOcclusionLightValue();
            f8 = (lightingInfo.aoLightValueScratchXYNN + lightingInfo.aoLightValueScratchXYZNNP + f7 + lightingInfo.aoLightValueScratchXZNP) / 4.0f;
            f9 = (f7 + lightingInfo.aoLightValueScratchXZNP + lightingInfo.aoLightValueScratchXYNP + lightingInfo.aoLightValueScratchXYZNPP) / 4.0f;
            f10 = (lightingInfo.aoLightValueScratchXZNN + f7 + lightingInfo.aoLightValueScratchXYZNPN + lightingInfo.aoLightValueScratchXYNP) / 4.0f;
            f11 = (lightingInfo.aoLightValueScratchXYZNNN + lightingInfo.aoLightValueScratchXYNN + lightingInfo.aoLightValueScratchXZNN + f7) / 4.0f;
            f3 = (float)((double)f9 * bounds.maxY * bounds.maxZ + (double)f10 * bounds.maxY * (1.0 - bounds.maxZ) + (double)f11 * (1.0 - bounds.maxY) * (1.0 - bounds.maxZ) + (double)f8 * (1.0 - bounds.maxY) * bounds.maxZ);
            f4 = (float)((double)f9 * bounds.maxY * bounds.minZ + (double)f10 * bounds.maxY * (1.0 - bounds.minZ) + (double)f11 * (1.0 - bounds.maxY) * (1.0 - bounds.minZ) + (double)f8 * (1.0 - bounds.maxY) * bounds.minZ);
            f5 = (float)((double)f9 * bounds.minY * bounds.minZ + (double)f10 * bounds.minY * (1.0 - bounds.minZ) + (double)f11 * (1.0 - bounds.minY) * (1.0 - bounds.minZ) + (double)f8 * (1.0 - bounds.minY) * bounds.minZ);
            f6 = (float)((double)f9 * bounds.minY * bounds.maxZ + (double)f10 * bounds.minY * (1.0 - bounds.maxZ) + (double)f11 * (1.0 - bounds.minY) * (1.0 - bounds.maxZ) + (double)f8 * (1.0 - bounds.minY) * bounds.maxZ);
            j1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYNN, lightingInfo.aoBrightnessXYZNNP, lightingInfo.aoBrightnessXZNP, i1);
            k1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZNP, lightingInfo.aoBrightnessXYNP, lightingInfo.aoBrightnessXYZNPP, i1);
            l1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZNN, lightingInfo.aoBrightnessXYZNPN, lightingInfo.aoBrightnessXYNP, i1);
            i2 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZNNN, lightingInfo.aoBrightnessXYNN, lightingInfo.aoBrightnessXZNN, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.mixAoBrightness(k1, l1, i2, j1, bounds.maxY * bounds.maxZ, bounds.maxY * (1.0 - bounds.maxZ), (1.0 - bounds.maxY) * (1.0 - bounds.maxZ), (1.0 - bounds.maxY) * bounds.maxZ);
            lightingInfo.brightnessBottomLeft = lightingInfo.mixAoBrightness(k1, l1, i2, j1, bounds.maxY * bounds.minZ, bounds.maxY * (1.0 - bounds.minZ), (1.0 - bounds.maxY) * (1.0 - bounds.minZ), (1.0 - bounds.maxY) * bounds.minZ);
            lightingInfo.brightnessBottomRight = lightingInfo.mixAoBrightness(k1, l1, i2, j1, bounds.minY * bounds.minZ, bounds.minY * (1.0 - bounds.minZ), (1.0 - bounds.minY) * (1.0 - bounds.minZ), (1.0 - bounds.minY) * bounds.minZ);
            lightingInfo.brightnessTopRight = lightingInfo.mixAoBrightness(k1, l1, i2, j1, bounds.minY * bounds.maxZ, bounds.minY * (1.0 - bounds.maxZ), (1.0 - bounds.minY) * (1.0 - bounds.maxZ), (1.0 - bounds.minY) * bounds.maxZ);
            lightingInfo.colorRedBottomRight = lightingInfo.colorRedTopRight = colR * 0.6f;
            lightingInfo.colorRedBottomLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorRedTopLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorGreenBottomRight = lightingInfo.colorGreenTopRight = colG * 0.6f;
            lightingInfo.colorGreenBottomLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorGreenTopLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorBlueBottomRight = lightingInfo.colorBlueTopRight = colB * 0.6f;
            lightingInfo.colorBlueBottomLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorBlueTopLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        if (side == 5) {
            if (bounds.maxX >= 1.0) {
                ++x;
            }
            lightingInfo.aoLightValueScratchXYPN = world.getBlock(x, y - 1, z).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXZPN = world.getBlock(x, y, z - 1).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXZPP = world.getBlock(x, y, z + 1).getAmbientOcclusionLightValue();
            lightingInfo.aoLightValueScratchXYPP = world.getBlock(x, y + 1, z).getAmbientOcclusionLightValue();
            lightingInfo.aoBrightnessXYPN = block.getMixedBrightnessForBlock(world, x, y - 1, z);
            lightingInfo.aoBrightnessXZPN = block.getMixedBrightnessForBlock(world, x, y, z - 1);
            lightingInfo.aoBrightnessXZPP = block.getMixedBrightnessForBlock(world, x, y, z + 1);
            lightingInfo.aoBrightnessXYPP = block.getMixedBrightnessForBlock(world, x, y + 1, z);
            flag2 = world.getBlock(x + 1, y + 1, z).getCanBlockGrass();
            flag3 = world.getBlock(x + 1, y - 1, z).getCanBlockGrass();
            flag4 = world.getBlock(x + 1, y, z + 1).getCanBlockGrass();
            flag5 = world.getBlock(x + 1, y, z - 1).getCanBlockGrass();
            if (!flag3 && !flag5) {
                lightingInfo.aoLightValueScratchXYZPNN = lightingInfo.aoLightValueScratchXZPN;
                lightingInfo.aoBrightnessXYZPNN = lightingInfo.aoBrightnessXZPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPNN = world.getBlock(x, y - 1, z - 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPNN = block.getMixedBrightnessForBlock(world, x, y - 1, z - 1);
            }
            if (!flag3 && !flag4) {
                lightingInfo.aoLightValueScratchXYZPNP = lightingInfo.aoLightValueScratchXZPP;
                lightingInfo.aoBrightnessXYZPNP = lightingInfo.aoBrightnessXZPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPNP = world.getBlock(x, y - 1, z + 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPNP = block.getMixedBrightnessForBlock(world, x, y - 1, z + 1);
            }
            if (!flag2 && !flag5) {
                lightingInfo.aoLightValueScratchXYZPPN = lightingInfo.aoLightValueScratchXZPN;
                lightingInfo.aoBrightnessXYZPPN = lightingInfo.aoBrightnessXZPN;
            } else {
                lightingInfo.aoLightValueScratchXYZPPN = world.getBlock(x, y + 1, z - 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPPN = block.getMixedBrightnessForBlock(world, x, y + 1, z - 1);
            }
            if (!flag2 && !flag4) {
                lightingInfo.aoLightValueScratchXYZPPP = lightingInfo.aoLightValueScratchXZPP;
                lightingInfo.aoBrightnessXYZPPP = lightingInfo.aoBrightnessXZPP;
            } else {
                lightingInfo.aoLightValueScratchXYZPPP = world.getBlock(x, y + 1, z + 1).getAmbientOcclusionLightValue();
                lightingInfo.aoBrightnessXYZPPP = block.getMixedBrightnessForBlock(world, x, y + 1, z + 1);
            }
            if (bounds.maxX >= 1.0) {
                --x;
            }
            i1 = l;
            if (bounds.maxX >= 1.0 || !world.getBlock(x + 1, y, z).isOpaqueCube()) {
                i1 = block.getMixedBrightnessForBlock(world, x + 1, y, z);
            }
            f7 = world.getBlock(x + 1, y, z).getAmbientOcclusionLightValue();
            f8 = (lightingInfo.aoLightValueScratchXYPN + lightingInfo.aoLightValueScratchXYZPNP + f7 + lightingInfo.aoLightValueScratchXZPP) / 4.0f;
            f9 = (lightingInfo.aoLightValueScratchXYZPNN + lightingInfo.aoLightValueScratchXYPN + lightingInfo.aoLightValueScratchXZPN + f7) / 4.0f;
            f10 = (lightingInfo.aoLightValueScratchXZPN + f7 + lightingInfo.aoLightValueScratchXYZPPN + lightingInfo.aoLightValueScratchXYPP) / 4.0f;
            f11 = (f7 + lightingInfo.aoLightValueScratchXZPP + lightingInfo.aoLightValueScratchXYPP + lightingInfo.aoLightValueScratchXYZPPP) / 4.0f;
            f3 = (float)((double)f8 * (1.0 - bounds.minY) * bounds.maxZ + (double)f9 * (1.0 - bounds.minY) * (1.0 - bounds.maxZ) + (double)f10 * bounds.minY * (1.0 - bounds.maxZ) + (double)f11 * bounds.minY * bounds.maxZ);
            f4 = (float)((double)f8 * (1.0 - bounds.minY) * bounds.minZ + (double)f9 * (1.0 - bounds.minY) * (1.0 - bounds.minZ) + (double)f10 * bounds.minY * (1.0 - bounds.minZ) + (double)f11 * bounds.minY * bounds.minZ);
            f5 = (float)((double)f8 * (1.0 - bounds.maxY) * bounds.minZ + (double)f9 * (1.0 - bounds.maxY) * (1.0 - bounds.minZ) + (double)f10 * bounds.maxY * (1.0 - bounds.minZ) + (double)f11 * bounds.maxY * bounds.minZ);
            f6 = (float)((double)f8 * (1.0 - bounds.maxY) * bounds.maxZ + (double)f9 * (1.0 - bounds.maxY) * (1.0 - bounds.maxZ) + (double)f10 * bounds.maxY * (1.0 - bounds.maxZ) + (double)f11 * bounds.maxY * bounds.maxZ);
            j1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYPN, lightingInfo.aoBrightnessXYZPNP, lightingInfo.aoBrightnessXZPP, i1);
            k1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZPP, lightingInfo.aoBrightnessXYPP, lightingInfo.aoBrightnessXYZPPP, i1);
            l1 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXZPN, lightingInfo.aoBrightnessXYZPPN, lightingInfo.aoBrightnessXYPP, i1);
            i2 = lightingInfo.getAoBrightness(lightingInfo.aoBrightnessXYZPNN, lightingInfo.aoBrightnessXYPN, lightingInfo.aoBrightnessXZPN, i1);
            lightingInfo.brightnessTopLeft = lightingInfo.mixAoBrightness(j1, i2, l1, k1, (1.0 - bounds.minY) * bounds.maxZ, (1.0 - bounds.minY) * (1.0 - bounds.maxZ), bounds.minY * (1.0 - bounds.maxZ), bounds.minY * bounds.maxZ);
            lightingInfo.brightnessBottomLeft = lightingInfo.mixAoBrightness(j1, i2, l1, k1, (1.0 - bounds.minY) * bounds.minZ, (1.0 - bounds.minY) * (1.0 - bounds.minZ), bounds.minY * (1.0 - bounds.minZ), bounds.minY * bounds.minZ);
            lightingInfo.brightnessBottomRight = lightingInfo.mixAoBrightness(j1, i2, l1, k1, (1.0 - bounds.maxY) * bounds.minZ, (1.0 - bounds.maxY) * (1.0 - bounds.minZ), bounds.maxY * (1.0 - bounds.minZ), bounds.maxY * bounds.minZ);
            lightingInfo.brightnessTopRight = lightingInfo.mixAoBrightness(j1, i2, l1, k1, (1.0 - bounds.maxY) * bounds.maxZ, (1.0 - bounds.maxY) * (1.0 - bounds.maxZ), bounds.maxY * (1.0 - bounds.maxZ), bounds.maxY * bounds.maxZ);
            lightingInfo.colorRedBottomRight = lightingInfo.colorRedTopRight = colR * 0.6f;
            lightingInfo.colorRedBottomLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorRedTopLeft = lightingInfo.colorRedTopRight;
            lightingInfo.colorGreenBottomRight = lightingInfo.colorGreenTopRight = colG * 0.6f;
            lightingInfo.colorGreenBottomLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorGreenTopLeft = lightingInfo.colorGreenTopRight;
            lightingInfo.colorBlueBottomRight = lightingInfo.colorBlueTopRight = colB * 0.6f;
            lightingInfo.colorBlueBottomLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorBlueTopLeft = lightingInfo.colorBlueTopRight;
            lightingInfo.colorRedTopLeft *= f3;
            lightingInfo.colorGreenTopLeft *= f3;
            lightingInfo.colorBlueTopLeft *= f3;
            lightingInfo.colorRedBottomLeft *= f4;
            lightingInfo.colorGreenBottomLeft *= f4;
            lightingInfo.colorBlueBottomLeft *= f4;
            lightingInfo.colorRedBottomRight *= f5;
            lightingInfo.colorGreenBottomRight *= f5;
            lightingInfo.colorBlueBottomRight *= f5;
            lightingInfo.colorRedTopRight *= f6;
            lightingInfo.colorGreenTopRight *= f6;
            lightingInfo.colorBlueTopRight *= f6;
        }
        return lightingInfo;
    }

    public static boolean drawWorldBlock(IBlockAccess world, Block block, int x, int y, int z, int meta) {
        return ClientUtils.drawWorldBlock(world, block, x, y, z, meta, AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).getOffsetBoundingBox((double)x, (double)y, (double)z));
    }

    public static boolean drawWorldBlock(IBlockAccess world, Block block, int x, int y, int z, int meta, AxisAlignedBB aabb) {
        IIcon iBot = block.getIcon(0, meta);
        IIcon iTop = block.getIcon(1, meta);
        IIcon iNorth = block.getIcon(2, meta);
        IIcon iSouth = block.getIcon(3, meta);
        IIcon iWest = block.getIcon(4, meta);
        IIcon iEast = block.getIcon(5, meta);
        double[][] uv = new double[][]{{iBot.getMinU(), iBot.getMaxU(), iBot.getMinV(), iBot.getMaxV()}, {iTop.getMinU(), iTop.getMaxU(), iTop.getMinV(), iTop.getMaxV()}, {iNorth.getMinU(), iNorth.getMaxU(), iNorth.getMinV(), iNorth.getMaxV()}, {iSouth.getMinU(), iSouth.getMaxU(), iSouth.getMinV(), iSouth.getMaxV()}, {iWest.getMinU(), iWest.getMaxU(), iWest.getMinV(), iWest.getMaxV()}, {iEast.getMinU(), iEast.getMaxU(), iEast.getMinV(), iEast.getMaxV()}};
        return ClientUtils.drawWorldBlock(world, block, x, y, z, uv, aabb);
    }

    public static boolean drawWorldBlock(IBlockAccess world, Block block, int x, int y, int z, double[][] uv) {
        return ClientUtils.drawWorldBlock(world, block, x, y, z, uv, AxisAlignedBB.getBoundingBox((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0).getOffsetBoundingBox((double)x, (double)y, (double)z));
    }

    public static boolean drawWorldBlock(IBlockAccess world, Block block, int x, int y, int z, double[][] uv, AxisAlignedBB bounds) {
        BlockLightingInfo info;
        Tessellator tes = ClientUtils.tes();
        boolean flag = false;
        AxisAlignedBB lightBounds = bounds.getOffsetBoundingBox((double)(-x), (double)(-y), (double)(-z));
        if (block.shouldSideBeRendered(world, x, y, z, 0)) {
            info = ClientUtils.calculateBlockLighting(0, world, block, x, y, z, 1.0f, 1.0f, 1.0f, lightBounds);
            tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.setBrightness(info.brightnessTopLeft);
            tes.addVertexWithUV(bounds.minX, bounds.minY, bounds.maxZ, uv[0][0], uv[0][3]);
            tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.setBrightness(info.brightnessBottomLeft);
            tes.addVertexWithUV(bounds.minX, bounds.minY, bounds.minZ, uv[0][0], uv[0][2]);
            tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.setBrightness(info.brightnessBottomRight);
            tes.addVertexWithUV(bounds.maxX, bounds.minY, bounds.minZ, uv[0][1], uv[0][2]);
            tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.setBrightness(info.brightnessTopRight);
            tes.addVertexWithUV(bounds.maxX, bounds.minY, bounds.maxZ, uv[0][1], uv[0][3]);
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 1)) {
            info = ClientUtils.calculateBlockLighting(1, world, block, x, y, z, 1.0f, 1.0f, 1.0f, lightBounds);
            tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.setBrightness(info.brightnessTopLeft);
            tes.addVertexWithUV(bounds.maxX, bounds.maxY, bounds.maxZ, uv[1][1], uv[1][3]);
            tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.setBrightness(info.brightnessBottomLeft);
            tes.addVertexWithUV(bounds.maxX, bounds.maxY, bounds.minZ, uv[1][1], uv[1][2]);
            tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.setBrightness(info.brightnessBottomRight);
            tes.addVertexWithUV(bounds.minX, bounds.maxY, bounds.minZ, uv[1][0], uv[1][2]);
            tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.setBrightness(info.brightnessTopRight);
            tes.addVertexWithUV(bounds.minX, bounds.maxY, bounds.maxZ, uv[1][0], uv[1][3]);
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 2)) {
            info = ClientUtils.calculateBlockLighting(2, world, block, x, y, z, 1.0f, 1.0f, 1.0f, lightBounds);
            tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.setBrightness(info.brightnessTopLeft);
            tes.addVertexWithUV(bounds.minX, bounds.maxY, bounds.minZ, uv[2][1], uv[2][2]);
            tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.setBrightness(info.brightnessBottomLeft);
            tes.addVertexWithUV(bounds.maxX, bounds.maxY, bounds.minZ, uv[2][0], uv[2][2]);
            tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.setBrightness(info.brightnessBottomRight);
            tes.addVertexWithUV(bounds.maxX, bounds.minY, bounds.minZ, uv[2][0], uv[2][3]);
            tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.setBrightness(info.brightnessTopRight);
            tes.addVertexWithUV(bounds.minX, bounds.minY, bounds.minZ, uv[2][1], uv[2][3]);
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 3)) {
            info = ClientUtils.calculateBlockLighting(3, world, block, x, y, z, 1.0f, 1.0f, 1.0f, lightBounds);
            tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.setBrightness(info.brightnessTopLeft);
            tes.addVertexWithUV(bounds.minX, bounds.maxY, bounds.maxZ, uv[3][0], uv[3][2]);
            tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.setBrightness(info.brightnessBottomLeft);
            tes.addVertexWithUV(bounds.minX, bounds.minY, bounds.maxZ, uv[3][0], uv[3][3]);
            tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.setBrightness(info.brightnessBottomRight);
            tes.addVertexWithUV(bounds.maxX, bounds.minY, bounds.maxZ, uv[3][1], uv[3][3]);
            tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.setBrightness(info.brightnessTopRight);
            tes.addVertexWithUV(bounds.maxX, bounds.maxY, bounds.maxZ, uv[3][1], uv[3][2]);
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 4)) {
            info = ClientUtils.calculateBlockLighting(4, world, block, x, y, z, 1.0f, 1.0f, 1.0f, lightBounds);
            tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.setBrightness(info.brightnessTopLeft);
            tes.addVertexWithUV(bounds.minX, bounds.maxY, bounds.maxZ, uv[4][1], uv[4][2]);
            tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.setBrightness(info.brightnessBottomLeft);
            tes.addVertexWithUV(bounds.minX, bounds.maxY, bounds.minZ, uv[4][0], uv[4][2]);
            tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.setBrightness(info.brightnessBottomRight);
            tes.addVertexWithUV(bounds.minX, bounds.minY, bounds.minZ, uv[4][0], uv[4][3]);
            tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.setBrightness(info.brightnessTopRight);
            tes.addVertexWithUV(bounds.minX, bounds.minY, bounds.maxZ, uv[4][1], uv[4][3]);
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 5)) {
            info = ClientUtils.calculateBlockLighting(5, world, block, x, y, z, 1.0f, 1.0f, 1.0f, lightBounds);
            tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
            tes.setBrightness(info.brightnessTopLeft);
            tes.addVertexWithUV(bounds.maxX, bounds.minY, bounds.maxZ, uv[5][0], uv[5][3]);
            tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
            tes.setBrightness(info.brightnessBottomLeft);
            tes.addVertexWithUV(bounds.maxX, bounds.minY, bounds.minZ, uv[5][1], uv[5][3]);
            tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
            tes.setBrightness(info.brightnessBottomRight);
            tes.addVertexWithUV(bounds.maxX, bounds.maxY, bounds.minZ, uv[5][1], uv[5][2]);
            tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
            tes.setBrightness(info.brightnessTopRight);
            tes.addVertexWithUV(bounds.maxX, bounds.maxY, bounds.maxZ, uv[5][0], uv[5][2]);
            flag = true;
        }
        return flag;
    }

    public static boolean drawWorldSubBlock(RenderBlocks renderer, IBlockAccess world, Block block, int x, int y, int z, Vec3[] vs) {
        double d10;
        double d9;
        double d8;
        double d7;
        double d6;
        double d5;
        double d4;
        double d3;
        BlockLightingInfo info;
        IIcon icon;
        Tessellator tes = ClientUtils.tes();
        boolean flag = false;
        AxisAlignedBB bounds = AxisAlignedBB.getBoundingBox((double)Math.min(Math.min(vs[0].xCoord, vs[1].xCoord), Math.min(vs[4].xCoord, vs[5].xCoord)), (double)Math.min(Math.min(vs[0].yCoord, vs[1].yCoord), Math.min(vs[2].yCoord, vs[3].yCoord)), (double)Math.min(Math.min(vs[0].zCoord, vs[2].zCoord), Math.min(vs[4].zCoord, vs[6].zCoord)), (double)Math.min(Math.min(vs[2].xCoord, vs[3].xCoord), Math.min(vs[6].xCoord, vs[7].xCoord)), (double)Math.min(Math.min(vs[4].yCoord, vs[5].yCoord), Math.min(vs[6].yCoord, vs[7].yCoord)), (double)Math.min(Math.min(vs[1].zCoord, vs[3].zCoord), Math.min(vs[5].zCoord, vs[7].zCoord)));
        if (block.shouldSideBeRendered(world, x, y, z, 0)) {
            icon = renderer.hasOverrideBlockTexture() ? renderer.overrideBlockTexture : block.getIcon(world, x, y, z, 0);
            info = ClientUtils.calculateBlockLighting(0, world, block, x, y, z, 1.0f, 1.0f, 1.0f, bounds);
            d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[0].xCoord * 16.0)));
            d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[3].xCoord * 16.0)));
            d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[0].zCoord * 16.0)));
            d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[3].zCoord * 16.0)));
            d7 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[2].xCoord * 16.0)));
            d8 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[1].xCoord * 16.0)));
            d9 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[2].zCoord * 16.0)));
            d10 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[1].zCoord * 16.0)));
            if (renderer.uvRotateBottom == 2) {
                d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[0].zCoord * 16.0)));
                d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[3].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[3].zCoord * 16.0)));
                d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[0].xCoord * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.uvRotateBottom == 1) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[3].zCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[0].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[0].zCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[3].xCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.uvRotateBottom == 3) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[0].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[3].xCoord * 16.0)));
                d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[0].zCoord * 16.0)));
                d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[3].zCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.enableAO) {
                tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.setBrightness(info.brightnessTopLeft);
                tes.addVertexWithUV((double)x + vs[1].xCoord, (double)y + vs[1].yCoord, (double)z + vs[1].zCoord, d8, d10);
                tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.setBrightness(info.brightnessBottomLeft);
                tes.addVertexWithUV((double)x + vs[0].xCoord, (double)y + vs[0].yCoord, (double)z + vs[0].zCoord, d3, d5);
                tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.setBrightness(info.brightnessBottomRight);
                tes.addVertexWithUV((double)x + vs[2].xCoord, (double)y + vs[2].yCoord, (double)z + vs[2].zCoord, d7, d9);
                tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.setBrightness(info.brightnessTopRight);
                tes.addVertexWithUV((double)x + vs[3].xCoord, (double)y + vs[3].yCoord, (double)z + vs[3].zCoord, d4, d6);
            } else {
                tes.setColorOpaque_I(0xFFFFFF);
                tes.addVertexWithUV((double)x + vs[1].xCoord, (double)y + vs[1].yCoord, (double)z + vs[1].zCoord, d8, d10);
                tes.addVertexWithUV((double)x + vs[0].xCoord, (double)y + vs[0].yCoord, (double)z + vs[0].zCoord, d3, d5);
                tes.addVertexWithUV((double)x + vs[2].xCoord, (double)y + vs[2].yCoord, (double)z + vs[2].zCoord, d7, d9);
                tes.addVertexWithUV((double)x + vs[3].xCoord, (double)y + vs[3].yCoord, (double)z + vs[3].zCoord, d4, d6);
            }
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 1)) {
            icon = renderer.hasOverrideBlockTexture() ? renderer.overrideBlockTexture : block.getIcon(world, x, y, z, 1);
            info = ClientUtils.calculateBlockLighting(1, world, block, x, y, z, 1.0f, 1.0f, 1.0f, bounds);
            tes.setBrightness(983055);
            d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[4].xCoord * 16.0)));
            d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[7].xCoord * 16.0)));
            d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[4].zCoord * 16.0)));
            d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[7].zCoord * 16.0)));
            d7 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[6].xCoord * 16.0)));
            d8 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[5].xCoord * 16.0)));
            d9 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[6].zCoord * 16.0)));
            d10 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[5].zCoord * 16.0)));
            if (renderer.uvRotateTop == 1) {
                d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[4].zCoord * 16.0)));
                d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[7].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[7].zCoord * 16.0)));
                d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[4].xCoord * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.uvRotateTop == 2) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[7].zCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[4].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[4].zCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[7].xCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.uvRotateTop == 3) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[4].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[7].xCoord * 16.0)));
                d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[4].zCoord * 16.0)));
                d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[7].zCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.enableAO) {
                tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.setBrightness(info.brightnessTopLeft);
                tes.addVertexWithUV((double)x + vs[7].xCoord, (double)y + vs[7].yCoord, (double)z + vs[7].zCoord, d4, d6);
                tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.setBrightness(info.brightnessBottomLeft);
                tes.addVertexWithUV((double)x + vs[6].xCoord, (double)y + vs[6].yCoord, (double)z + vs[6].zCoord, d7, d9);
                tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.setBrightness(info.brightnessBottomRight);
                tes.addVertexWithUV((double)x + vs[4].xCoord, (double)y + vs[4].yCoord, (double)z + vs[4].zCoord, d3, d5);
                tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.setBrightness(info.brightnessTopRight);
                tes.addVertexWithUV((double)x + vs[5].xCoord, (double)y + vs[5].yCoord, (double)z + vs[5].zCoord, d8, d10);
            } else {
                tes.setColorOpaque_I(0xFFFFFF);
                tes.addVertexWithUV((double)x + vs[7].xCoord, (double)y + vs[7].yCoord, (double)z + vs[7].zCoord, d4, d6);
                tes.addVertexWithUV((double)x + vs[6].xCoord, (double)y + vs[6].yCoord, (double)z + vs[6].zCoord, d7, d9);
                tes.addVertexWithUV((double)x + vs[4].xCoord, (double)y + vs[4].yCoord, (double)z + vs[4].zCoord, d3, d5);
                tes.addVertexWithUV((double)x + vs[5].xCoord, (double)y + vs[5].yCoord, (double)z + vs[5].zCoord, d8, d10);
            }
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 2)) {
            icon = renderer.hasOverrideBlockTexture() ? renderer.overrideBlockTexture : block.getIcon(world, x, y, z, 2);
            info = ClientUtils.calculateBlockLighting(2, world, block, x, y, z, 1.0f, 1.0f, 1.0f, bounds);
            tes.setBrightness(983055);
            d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[0].xCoord * 16.0)));
            d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[6].xCoord * 16.0)));
            d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[6].yCoord * 16.0)));
            d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[0].yCoord * 16.0)));
            d7 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[2].xCoord * 16.0)));
            d8 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[4].xCoord * 16.0)));
            d9 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[4].yCoord * 16.0)));
            d10 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[2].yCoord * 16.0)));
            if (renderer.uvRotateEast == 2) {
                d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[0].yCoord * 16.0)));
                d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[6].yCoord * 16.0)));
                d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[6].xCoord * 16.0)));
                d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[0].xCoord * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.uvRotateEast == 1) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[6].yCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[0].yCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[0].xCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[6].xCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.uvRotateEast == 3) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[6].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[0].xCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[0].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[6].yCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.enableAO) {
                tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.setBrightness(info.brightnessTopLeft);
                tes.addVertexWithUV((double)x + vs[4].xCoord, (double)y + vs[4].yCoord, (double)z + vs[4].zCoord, d7, d9);
                tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.setBrightness(info.brightnessBottomLeft);
                tes.addVertexWithUV((double)x + vs[6].xCoord, (double)y + vs[6].yCoord, (double)z + vs[6].zCoord, d3, d5);
                tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.setBrightness(info.brightnessBottomRight);
                tes.addVertexWithUV((double)x + vs[2].xCoord, (double)y + vs[2].yCoord, (double)z + vs[2].zCoord, d8, d10);
                tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.setBrightness(info.brightnessTopRight);
                tes.addVertexWithUV((double)x + vs[0].xCoord, (double)y + vs[0].yCoord, (double)z + vs[0].zCoord, d4, d6);
            } else {
                tes.setColorOpaque_I(0xFFFFFF);
                tes.addVertexWithUV((double)x + vs[4].xCoord, (double)y + vs[4].yCoord, (double)z + vs[4].zCoord, d7, d9);
                tes.addVertexWithUV((double)x + vs[6].xCoord, (double)y + vs[6].yCoord, (double)z + vs[6].zCoord, d3, d5);
                tes.addVertexWithUV((double)x + vs[2].xCoord, (double)y + vs[2].yCoord, (double)z + vs[2].zCoord, d8, d10);
                tes.addVertexWithUV((double)x + vs[0].xCoord, (double)y + vs[0].yCoord, (double)z + vs[0].zCoord, d4, d6);
            }
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 3)) {
            icon = renderer.hasOverrideBlockTexture() ? renderer.overrideBlockTexture : block.getIcon(world, x, y, z, 3);
            info = ClientUtils.calculateBlockLighting(3, world, block, x, y, z, 1.0f, 1.0f, 1.0f, bounds);
            tes.setBrightness(983055);
            d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[5].xCoord * 16.0)));
            d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[3].xCoord * 16.0)));
            d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[5].yCoord * 16.0)));
            d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[3].yCoord * 16.0)));
            d7 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[7].xCoord * 16.0)));
            d8 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[1].xCoord * 16.0)));
            d9 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[7].yCoord * 16.0)));
            d10 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[1].yCoord * 16.0)));
            if (renderer.uvRotateWest == 1) {
                d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[3].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[5].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[5].yCoord * 16.0)));
                d9 = d5 = (double)icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[3].xCoord * 16.0)));
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.uvRotateWest == 2) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[5].yCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[5].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[3].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[3].xCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.uvRotateWest == 3) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[5].xCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[3].xCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[5].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[3].yCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.enableAO) {
                tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.setBrightness(info.brightnessTopLeft);
                tes.addVertexWithUV((double)x + vs[5].xCoord, (double)y + vs[5].yCoord, (double)z + vs[5].zCoord, d3, d5);
                tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.setBrightness(info.brightnessBottomLeft);
                tes.addVertexWithUV((double)x + vs[1].xCoord, (double)y + vs[1].yCoord, (double)z + vs[1].zCoord, d8, d10);
                tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.setBrightness(info.brightnessBottomRight);
                tes.addVertexWithUV((double)x + vs[3].xCoord, (double)y + vs[3].yCoord, (double)z + vs[3].zCoord, d4, d6);
                tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.setBrightness(info.brightnessTopRight);
                tes.addVertexWithUV((double)x + vs[7].xCoord, (double)y + vs[7].yCoord, (double)z + vs[7].zCoord, d7, d9);
            } else {
                tes.setColorOpaque_I(0xFFFFFF);
                tes.addVertexWithUV((double)x + vs[5].xCoord, (double)y + vs[5].yCoord, (double)z + vs[5].zCoord, d3, d5);
                tes.addVertexWithUV((double)x + vs[1].xCoord, (double)y + vs[1].yCoord, (double)z + vs[1].zCoord, d8, d10);
                tes.addVertexWithUV((double)x + vs[3].xCoord, (double)y + vs[3].yCoord, (double)z + vs[3].zCoord, d4, d6);
                tes.addVertexWithUV((double)x + vs[7].xCoord, (double)y + vs[7].yCoord, (double)z + vs[7].zCoord, d7, d9);
            }
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 4)) {
            icon = renderer.hasOverrideBlockTexture() ? renderer.overrideBlockTexture : block.getIcon(world, x, y, z, 4);
            info = ClientUtils.calculateBlockLighting(4, world, block, x, y, z, 1.0f, 1.0f, 1.0f, bounds);
            tes.setBrightness(983055);
            d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[4].zCoord * 16.0)));
            d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[1].zCoord * 16.0)));
            d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[4].yCoord * 16.0)));
            d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[1].yCoord * 16.0)));
            d7 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[5].zCoord * 16.0)));
            d8 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[0].zCoord * 16.0)));
            d9 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[5].yCoord * 16.0)));
            d10 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[0].yCoord * 16.0)));
            if (renderer.uvRotateNorth == 1) {
                d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[1].yCoord * 16.0)));
                d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[1].zCoord * 16.0)));
                d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[4].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[4].zCoord * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.uvRotateNorth == 2) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[4].yCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[4].zCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[1].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[1].zCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.uvRotateNorth == 3) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[4].zCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[1].zCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[4].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[1].yCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.enableAO) {
                tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.setBrightness(info.brightnessTopLeft);
                tes.addVertexWithUV((double)x + vs[5].xCoord, (double)y + vs[5].yCoord, (double)z + vs[5].zCoord, d7, d9);
                tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.setBrightness(info.brightnessBottomLeft);
                tes.addVertexWithUV((double)x + vs[4].xCoord, (double)y + vs[4].yCoord, (double)z + vs[4].zCoord, d3, d5);
                tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.setBrightness(info.brightnessBottomRight);
                tes.addVertexWithUV((double)x + vs[0].xCoord, (double)y + vs[0].yCoord, (double)z + vs[0].zCoord, d8, d10);
                tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.setBrightness(info.brightnessTopRight);
                tes.addVertexWithUV((double)x + vs[1].xCoord, (double)y + vs[1].yCoord, (double)z + vs[1].zCoord, d4, d6);
            } else {
                tes.setColorOpaque_I(0xFFFFFF);
                tes.addVertexWithUV((double)x + vs[5].xCoord, (double)y + vs[5].yCoord, (double)z + vs[5].zCoord, d7, d9);
                tes.addVertexWithUV((double)x + vs[4].xCoord, (double)y + vs[4].yCoord, (double)z + vs[4].zCoord, d3, d5);
                tes.addVertexWithUV((double)x + vs[0].xCoord, (double)y + vs[0].yCoord, (double)z + vs[0].zCoord, d8, d10);
                tes.addVertexWithUV((double)x + vs[1].xCoord, (double)y + vs[1].yCoord, (double)z + vs[1].zCoord, d4, d6);
            }
            flag = true;
        }
        if (block.shouldSideBeRendered(world, x, y, z, 5)) {
            icon = renderer.hasOverrideBlockTexture() ? renderer.overrideBlockTexture : block.getIcon(world, x, y, z, 5);
            info = ClientUtils.calculateBlockLighting(5, world, block, x, y, z, 1.0f, 1.0f, 1.0f, bounds);
            tes.setBrightness(983055);
            d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[7].zCoord * 16.0)));
            d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[2].zCoord * 16.0)));
            d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[7].yCoord * 16.0)));
            d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[2].yCoord * 16.0)));
            d7 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[6].zCoord * 16.0)));
            d8 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[3].zCoord * 16.0)));
            d9 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[6].yCoord * 16.0)));
            d10 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[3].yCoord * 16.0)));
            if (renderer.uvRotateSouth == 2) {
                d3 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[2].yCoord * 16.0)));
                d5 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[7].zCoord * 16.0)));
                d4 = icon.getInterpolatedU(Math.min(16.0, Math.max(0.0, vs[7].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(16.0 - Math.min(16.0, Math.max(0.0, vs[2].zCoord * 16.0)));
                d9 = d5;
                d10 = d6;
                d7 = d3;
                d8 = d4;
                d5 = d6;
                d6 = d9;
            } else if (renderer.uvRotateSouth == 1) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[7].yCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[2].zCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[2].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[7].zCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d3 = d4;
                d4 = d8;
                d9 = d6;
                d10 = d5;
            } else if (renderer.uvRotateSouth == 3) {
                d3 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[7].zCoord * 16.0)));
                d4 = icon.getInterpolatedU(16.0 - Math.min(16.0, Math.max(0.0, vs[2].zCoord * 16.0)));
                d5 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[7].yCoord * 16.0)));
                d6 = icon.getInterpolatedV(Math.min(16.0, Math.max(0.0, vs[2].yCoord * 16.0)));
                d7 = d4;
                d8 = d3;
                d9 = d5;
                d10 = d6;
            }
            if (renderer.enableAO) {
                tes.setColorOpaque_F(info.colorRedTopLeft, info.colorGreenTopLeft, info.colorBlueTopLeft);
                tes.setBrightness(info.brightnessTopLeft);
                tes.addVertexWithUV((double)x + vs[3].xCoord, (double)y + vs[3].yCoord, (double)z + vs[3].zCoord, d8, d10);
                tes.setColorOpaque_F(info.colorRedBottomLeft, info.colorGreenBottomLeft, info.colorBlueBottomLeft);
                tes.setBrightness(info.brightnessBottomLeft);
                tes.addVertexWithUV((double)x + vs[2].xCoord, (double)y + vs[2].yCoord, (double)z + vs[2].zCoord, d4, d6);
                tes.setColorOpaque_F(info.colorRedBottomRight, info.colorGreenBottomRight, info.colorBlueBottomRight);
                tes.setBrightness(info.brightnessBottomRight);
                tes.addVertexWithUV((double)x + vs[6].xCoord, (double)y + vs[6].yCoord, (double)z + vs[6].zCoord, d7, d9);
                tes.setColorOpaque_F(info.colorRedTopRight, info.colorGreenTopRight, info.colorBlueTopRight);
                tes.setBrightness(info.brightnessTopRight);
                tes.addVertexWithUV((double)x + vs[7].xCoord, (double)y + vs[7].yCoord, (double)z + vs[7].zCoord, d3, d5);
            } else {
                tes.setColorOpaque_I(0xFFFFFF);
                tes.addVertexWithUV((double)x + vs[3].xCoord, (double)y + vs[3].yCoord, (double)z + vs[3].zCoord, d8, d10);
                tes.addVertexWithUV((double)x + vs[2].xCoord, (double)y + vs[2].yCoord, (double)z + vs[2].zCoord, d4, d6);
                tes.addVertexWithUV((double)x + vs[6].xCoord, (double)y + vs[6].yCoord, (double)z + vs[6].zCoord, d7, d9);
                tes.addVertexWithUV((double)x + vs[7].xCoord, (double)y + vs[7].yCoord, (double)z + vs[7].zCoord, d3, d5);
            }
            flag = true;
        }
        return flag;
    }

    public static class BlockLightingInfo {
        public int aoBrightnessXYNN;
        public int aoBrightnessYZNN;
        public int aoBrightnessYZNP;
        public int aoBrightnessXYPN;
        public float aoLightValueScratchXYNN;
        public float aoLightValueScratchYZNN;
        public float aoLightValueScratchYZNP;
        public float aoLightValueScratchXYPN;
        public float aoLightValueScratchXYZNNN;
        public int aoBrightnessXYZNNN;
        public float aoLightValueScratchXYZNNP;
        public int aoBrightnessXYZNNP;
        public float aoLightValueScratchXYZPNN;
        public int aoBrightnessXYZPNN;
        public float aoLightValueScratchXYZPNP;
        public int aoBrightnessXYZPNP;
        public int brightnessTopLeft;
        public int brightnessTopRight;
        public int brightnessBottomRight;
        public int brightnessBottomLeft;
        public float colorRedTopLeft;
        public float colorGreenTopLeft;
        public float colorBlueTopLeft;
        public float colorRedBottomLeft;
        public float colorRedBottomRight;
        public float colorRedTopRight;
        public float colorGreenTopRight;
        public float colorBlueTopRight;
        public float colorGreenBottomRight;
        public float colorBlueBottomRight;
        public float colorGreenBottomLeft;
        public float colorBlueBottomLeft;
        public int aoBrightnessXYNP;
        public int aoBrightnessXYPP;
        public int aoBrightnessYZPN;
        public int aoBrightnessYZPP;
        public float aoLightValueScratchXYNP;
        public float aoLightValueScratchXYPP;
        public float aoLightValueScratchYZPN;
        public float aoLightValueScratchYZPP;
        public float aoLightValueScratchXYZNPN;
        public int aoBrightnessXYZNPN;
        public float aoLightValueScratchXYZPPN;
        public int aoBrightnessXYZPPN;
        public float aoLightValueScratchXYZNPP;
        public int aoBrightnessXYZNPP;
        public float aoLightValueScratchXYZPPP;
        public int aoBrightnessXYZPPP;
        public float aoLightValueScratchXZNN;
        public float aoLightValueScratchXZPN;
        public int aoBrightnessXZNN;
        public int aoBrightnessXZPN;
        public float aoLightValueScratchXZNP;
        public float aoLightValueScratchXZPP;
        public int aoBrightnessXZNP;
        public int aoBrightnessXZPP;

        public int getAoBrightness(int par0, int par1, int par2, int par3) {
            if (par0 == 0) {
                par0 = par3;
            }
            if (par1 == 0) {
                par1 = par3;
            }
            if (par2 == 0) {
                par2 = par3;
            }
            return par0 + par1 + par2 + par3 >> 2 & 0xFF00FF;
        }

        public int mixAoBrightness(int par0, int par1, int par2, int par3, double par4, double par5, double par6, double par7) {
            int i1 = (int)((double)(par0 >> 16 & 0xFF) * par4 + (double)(par1 >> 16 & 0xFF) * par5 + (double)(par2 >> 16 & 0xFF) * par6 + (double)(par3 >> 16 & 0xFF) * par7) & 0xFF;
            int j1 = (int)((double)(par0 & 0xFF) * par4 + (double)(par1 & 0xFF) * par5 + (double)(par2 & 0xFF) * par6 + (double)(par3 & 0xFF) * par7) & 0xFF;
            return i1 << 16 | j1;
        }
    }
}

