/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityArcFurnace;
import blusunrize.immersiveengineering.common.gui.ContainerArcFurnace;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import org.lwjgl.opengl.GL11;

public class GuiArcFurnace
extends GuiContainer {
    TileEntityArcFurnace tile;

    public GuiArcFurnace(InventoryPlayer inventoryPlayer, TileEntityArcFurnace tile) {
        super((Container)new ContainerArcFurnace(inventoryPlayer, tile));
        this.ySize = 207;
        this.tile = tile;
    }

    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mx > this.guiLeft + 157 && mx < this.guiLeft + 164 && my > this.guiTop + 22 && my < this.guiTop + 68) {
            tooltip.add(this.tile.energyStorage.getEnergyStored() + "/" + this.tile.energyStorage.getMaxEnergyStored() + " RF");
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRendererObj, this.guiLeft + this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/arcFurnace.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        for (int i = 0; i < 12; ++i) {
            if (this.tile.process[i] <= 0 || this.tile.processMax[i] <= 0) continue;
            float mod = (float)this.tile.process[i] / (float)this.tile.processMax[i];
            int h = (int)Math.max(1.0f, mod * 16.0f);
            this.drawTexturedModalRect(this.guiLeft + 27 + i % 3 * 21, this.guiTop + 34 + i / 3 * 18 + (16 - h), 176, 16 - h, 2, h);
        }
        int stored = (int)(46.0f * ((float)this.tile.energyStorage.getEnergyStored() / (float)this.tile.energyStorage.getMaxEnergyStored()));
        ClientUtils.drawGradientRect(this.guiLeft + 157, this.guiTop + 22 + (46 - stored), this.guiLeft + 164, this.guiTop + 68, -4909824, -10482944);
    }
}

