/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityAssembler;
import blusunrize.immersiveengineering.common.gui.ContainerAssembler;
import blusunrize.immersiveengineering.common.util.network.MessageTileSync;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class GuiAssembler
extends GuiContainer {
    public TileEntityAssembler tile;

    public GuiAssembler(InventoryPlayer inventoryPlayer, TileEntityAssembler tile) {
        super((Container)new ContainerAssembler(inventoryPlayer, tile));
        this.tile = tile;
        this.xSize = 230;
        this.ySize = 218;
    }

    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        this.buttonList.add(new GuiButton(0, this.guiLeft + 49, this.guiTop + 65, 10, 10, EnumChatFormatting.GRAY + "\u2716"));
        this.buttonList.add(new GuiButton(1, this.guiLeft + 107, this.guiTop + 65, 10, 10, EnumChatFormatting.GRAY + "\u2716"));
        this.buttonList.add(new GuiButton(2, this.guiLeft + 165, this.guiTop + 65, 10, 10, EnumChatFormatting.GRAY + "\u2716"));
    }

    protected void actionPerformed(GuiButton button) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.setInteger("buttonID", button.id);
        ImmersiveEngineering.packetHandler.sendToServer((IMessage)new MessageTileSync(this.tile, tag));
    }

    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        if (mx >= this.guiLeft + 187 && mx < this.guiLeft + 194 && my >= this.guiTop + 12 && my < this.guiTop + 59) {
            tooltip.add(this.tile.energyStorage.getEnergyStored() + "/" + this.tile.energyStorage.getMaxEnergyStored() + " RF");
        }
        ClientUtils.handleGuiTank(this.tile.tanks[0], this.guiLeft + 204, this.guiTop + 13, 16, 46, 250, 0, 20, 50, mx, my, "immersiveengineering:textures/gui/assembler.png", tooltip);
        ClientUtils.handleGuiTank(this.tile.tanks[1], this.guiLeft + 182, this.guiTop + 70, 16, 46, 250, 0, 20, 50, mx, my, "immersiveengineering:textures/gui/assembler.png", tooltip);
        ClientUtils.handleGuiTank(this.tile.tanks[2], this.guiLeft + 204, this.guiTop + 70, 16, 46, 250, 0, 20, 50, mx, my, "immersiveengineering:textures/gui/assembler.png", tooltip);
        for (int i = 0; i < this.tile.patterns.length; ++i) {
            if (this.tile.inventory[18 + i] != null || this.tile.patterns[i].inv[9] == null || mx < this.guiLeft + 27 + i * 58 || mx >= this.guiLeft + 43 + i * 58 || my < this.guiTop + 64 || my >= this.guiTop + 80) continue;
            tooltip.add(this.tile.patterns[i].inv[9].getDisplayName());
            this.tile.patterns[i].inv[9].getItem().addInformation(this.tile.patterns[i].inv[9], (EntityPlayer)ClientUtils.mc().thePlayer, tooltip, false);
            for (int j = 0; j < tooltip.size(); ++j) {
                tooltip.set(j, (j == 0 ? this.tile.patterns[i].inv[9].getRarity().rarityColor : EnumChatFormatting.GRAY) + tooltip.get(j));
            }
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRendererObj, this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/assembler.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        int stored = (int)(46.0f * ((float)this.tile.energyStorage.getEnergyStored() / (float)this.tile.energyStorage.getMaxEnergyStored()));
        ClientUtils.drawGradientRect(this.guiLeft + 187, this.guiTop + 13 + (46 - stored), this.guiLeft + 194, this.guiTop + 59, -4909824, -10482944);
        ClientUtils.handleGuiTank(this.tile.tanks[0], this.guiLeft + 204, this.guiTop + 13, 16, 46, 230, 0, 20, 50, mx, my, "immersiveengineering:textures/gui/assembler.png", null);
        ClientUtils.handleGuiTank(this.tile.tanks[1], this.guiLeft + 182, this.guiTop + 70, 16, 46, 230, 0, 20, 50, mx, my, "immersiveengineering:textures/gui/assembler.png", null);
        ClientUtils.handleGuiTank(this.tile.tanks[2], this.guiLeft + 204, this.guiTop + 70, 16, 46, 230, 0, 20, 50, mx, my, "immersiveengineering:textures/gui/assembler.png", null);
        for (int i = 0; i < this.tile.patterns.length; ++i) {
            if (this.tile.inventory[18 + i] != null || this.tile.patterns[i].inv[9] == null) continue;
            ItemStack stack = this.tile.patterns[i].inv[9];
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.disableStandardItemLighting();
            this.zLevel = 200.0f;
            GuiAssembler.itemRender.zLevel = 200.0f;
            FontRenderer font = null;
            if (stack != null) {
                font = stack.getItem().getFontRenderer(stack);
            }
            if (font == null) {
                font = this.fontRendererObj;
            }
            itemRender.renderItemAndEffectIntoGUI(font, this.mc.getTextureManager(), stack, this.guiLeft + 27 + i * 58, this.guiTop + 64);
            itemRender.renderItemOverlayIntoGUI(font, this.mc.getTextureManager(), stack, this.guiLeft + 27 + i * 58, this.guiTop + 64, EnumChatFormatting.GRAY.toString() + stack.stackSize);
            this.zLevel = 0.0f;
            GuiAssembler.itemRender.zLevel = 0.0f;
            GL11.glDisable((int)2896);
            GL11.glDisable((int)2929);
            ClientUtils.drawColouredRect(this.guiLeft + 27 + i * 58, this.guiTop + 64, 16, 16, 0x77444444);
            GL11.glEnable((int)2896);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }
}

