/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.gui;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntitySqueezer;
import blusunrize.immersiveengineering.common.gui.ContainerSqueezer;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import org.lwjgl.opengl.GL11;

public class GuiSqueezer
extends GuiContainer {
    TileEntitySqueezer tile;

    public GuiSqueezer(InventoryPlayer inventoryPlayer, TileEntitySqueezer tile) {
        super((Container)new ContainerSqueezer(inventoryPlayer, tile));
        this.tile = tile;
    }

    public void drawScreen(int mx, int my, float partial) {
        super.drawScreen(mx, my, partial);
        ArrayList<String> tooltip = new ArrayList<String>();
        ClientUtils.handleGuiTank(this.tile.tank, this.guiLeft + 111, this.guiTop + 21, 16, 47, 177, 31, 20, 51, mx, my, "immersiveengineering:textures/gui/fluidProducer.png", tooltip);
        if (mx > this.guiLeft + 157 && mx < this.guiLeft + 164 && my > this.guiTop + 22 && my < this.guiTop + 68) {
            tooltip.add(this.tile.energyStorage.getEnergyStored() + "/" + this.tile.energyStorage.getMaxEnergyStored() + " RF");
        }
        if (!tooltip.isEmpty()) {
            ClientUtils.drawHoveringText(tooltip, mx, my, this.fontRendererObj, this.guiLeft + this.xSize, -1);
            RenderHelper.enableGUIStandardItemLighting();
        }
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mx, int my) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ClientUtils.bindTexture("immersiveengineering:textures/gui/fluidProducer.png");
        this.drawTexturedModalRect(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        if (this.tile.tick > 0) {
            int h = this.tile.getScaledProgress(18);
            ClientUtils.drawGradientRect(this.guiLeft + 80, this.guiTop + 34 + h, this.guiLeft + 87, this.guiTop + 52, -2829653, -3882338);
        }
        int stored = (int)(46.0f * ((float)this.tile.energyStorage.getEnergyStored() / (float)this.tile.energyStorage.getMaxEnergyStored()));
        ClientUtils.drawGradientRect(this.guiLeft + 157, this.guiTop + 22 + (46 - stored), this.guiLeft + 164, this.guiTop + 68, -4909824, -10482944);
        ClientUtils.handleGuiTank(this.tile.tank, this.guiLeft + 111, this.guiTop + 21, 16, 47, 177, 31, 20, 51, mx, my, "immersiveengineering:textures/gui/fluidProducer.png", null);
    }
}

