/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IERecipes;
import blusunrize.immersiveengineering.common.util.Utils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.OreDictionary;

public class NEIHammerCrushingHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "ieHammerCrushing", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (String oreName : IERecipes.hammerCrushingList) {
                this.arecipes.add(new CachedHammerCrushingRecipe("ore", oreName));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"recipe.ImmersiveEngineering.hammerCrushing");
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getOverlayIdentifier() {
        return "ieHammerCrushing";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result != null) {
            for (String oreName : IERecipes.hammerCrushingList) {
                if (!Utils.compareToOreName(result, "dust" + oreName)) continue;
                this.arecipes.add(new CachedHammerCrushingRecipe("ore", oreName));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block4: {
            if (ingredient == null) break block4;
            if (ingredient.getItem().getToolClasses(ingredient).contains("IE_HAMMER")) {
                for (String oreName : IERecipes.hammerCrushingList) {
                    this.arecipes.add(new CachedHammerCrushingRecipe("ore", oreName));
                }
            } else {
                for (String oreName : IERecipes.hammerCrushingList) {
                    if (!Utils.compareToOreName(ingredient, "ore" + oreName)) continue;
                    this.arecipes.add(new CachedHammerCrushingRecipe("ore", oreName));
                }
            }
        }
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
    }

    public class CachedHammerCrushingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack[] inputs;
        PositionedStack output;

        public CachedHammerCrushingRecipe(String inputType, String oreName) {
            super((TemplateRecipeHandler)NEIHammerCrushingHandler.this);
            this.inputs = new PositionedStack[2];
            for (int j = 0; j < this.inputs.length; ++j) {
                this.inputs[j] = new PositionedStack(j == 0 ? new ItemStack((Item)IEContent.itemTool) : OreDictionary.getOres((String)(inputType + oreName)), 25 + j % 3 * 18, 6 + j / 3 * 18, j != 0);
            }
            ItemStack dust = Utils.copyStackWithAmount(IEApi.getPreferredOreStack("dust" + oreName), 1);
            this.output = new PositionedStack((Object)dust, 119, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(NEIHammerCrushingHandler.this.cycleticks / 20, Arrays.asList(this.inputs));
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

