/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.nei;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public class NEIShaderBagHandler
extends TemplateRecipeHandler {
    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(84, 23, 24, 18), "ieShaderBag", new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId == this.getOverlayIdentifier()) {
            for (int i = 1; i < ShaderRegistry.sortedRarityMap.size(); ++i) {
                this.arecipes.add(new CachedShaderBagRecipe(ShaderRegistry.sortedRarityMap.get(i), true));
                this.arecipes.add(new CachedShaderBagRecipe(ShaderRegistry.sortedRarityMap.get(i), false));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public String getRecipeName() {
        return StatCollector.translateToLocal((String)"item.ImmersiveEngineering.shaderBag.name");
    }

    public String getGuiTexture() {
        return "textures/gui/container/crafting_table.png";
    }

    public String getOverlayIdentifier() {
        return "ieShaderBag";
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        ArrayList<EnumRarity> list;
        if (result != null && ((Object)((Object)IEContent.itemShaderBag)).equals(result.getItem()) && !(list = ShaderRegistry.getHigherRarities(result.getRarity())).isEmpty()) {
            this.arecipes.add(new CachedShaderBagRecipe(result.getRarity(), true));
            for (EnumRarity r : list) {
                if (!ShaderRegistry.totalWeight.containsKey(r) || ShaderRegistry.totalWeight.get(r) <= 0) continue;
                this.arecipes.add(new CachedShaderBagRecipe(result.getRarity(), false));
            }
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        EnumRarity r;
        if (ingredient != null && (((Object)((Object)IEContent.itemShaderBag)).equals(ingredient.getItem()) || ((Object)((Object)IEContent.itemShader)).equals(ingredient.getItem())) && (r = ShaderRegistry.getLowerRarity(ingredient.getRarity())) != null) {
            this.arecipes.add(new CachedShaderBagRecipe(r, ((Object)((Object)IEContent.itemShaderBag)).equals(ingredient.getItem())));
        }
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
    }

    public class CachedShaderBagRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack input;
        PositionedStack output;

        public CachedShaderBagRecipe(EnumRarity outputRarity, boolean inputBag) {
            super((TemplateRecipeHandler)NEIShaderBagHandler.this);
            ArrayList<EnumRarity> upperRarities = ShaderRegistry.getHigherRarities(outputRarity);
            ArrayList<ItemStack> inputList = new ArrayList<ItemStack>();
            if (inputBag) {
                for (EnumRarity r : upperRarities) {
                    ItemStack bag = new ItemStack((Item)IEContent.itemShaderBag);
                    ItemNBTHelper.setString(bag, "rarity", r.toString());
                    inputList.add(bag);
                }
            } else {
                for (ShaderRegistry.ShaderRegistryEntry entry : ShaderRegistry.shaderRegistry.values()) {
                    if (!upperRarities.contains(entry.getRarity())) continue;
                    ItemStack shader = new ItemStack((Item)IEContent.itemShader);
                    ItemNBTHelper.setString(shader, "shader_name", entry.getName());
                    inputList.add(shader);
                }
            }
            this.input = new PositionedStack(inputList, 25, 6, true);
            ItemStack bag = new ItemStack((Item)IEContent.itemShaderBag, inputBag ? 2 : 1);
            ItemNBTHelper.setString(bag, "rarity", outputRarity.toString());
            this.output = new PositionedStack((Object)bag, 119, 24);
        }

        public List<PositionedStack> getIngredients() {
            this.input.setPermutationToRender(NEIShaderBagHandler.this.cycleticks / 20 % this.input.items.length);
            return Arrays.asList(this.input);
        }

        public PositionedStack getIngredient() {
            return null;
        }

        public PositionedStack getResult() {
            return this.output;
        }
    }
}

