/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockWoodenDecoration;
import blusunrize.immersiveengineering.common.blocks.wooden.TileEntityWallmount;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public class BlockRenderWoodenDecoration
implements ISimpleBlockRenderingHandler {
    public static int renderID = RenderingRegistry.getNextAvailableRenderId();
    private static final TileEntityWallmount wallmount = new TileEntityWallmount();

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        GL11.glPushMatrix();
        try {
            if (metadata == 0) {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
            } else if (metadata == 1) {
                renderer.setRenderBounds(0.0, 0.0, 0.375, 0.25, 1.0, 0.625);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
                renderer.setRenderBounds(0.75, 0.0, 0.375, 1.0, 1.0, 0.625);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
                renderer.setRenderBounds(-0.125, 0.8125, 0.4375, 1.125, 0.9375, 0.5625);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
                renderer.setRenderBounds(-0.125, 0.3125, 0.4375, 1.125, 0.4375, 0.5625);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
            } else if (metadata == 2) {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
            } else if (metadata == 4) {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
            } else if (metadata == 5) {
                renderer.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
                ClientUtils.drawInventoryBlock(block, metadata, renderer);
            } else if (metadata == 6) {
                Tessellator.instance.startDrawingQuads();
                ClientUtils.handleStaticTileRenderer(wallmount);
                Tessellator.instance.draw();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glPopMatrix();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (world.getBlockMetadata(x, y, z) == 1) {
            renderer.setRenderBounds(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
            renderer.renderStandardBlock(block, x, y, z);
            BlockWoodenDecoration wd = (BlockWoodenDecoration)block;
            if (wd.canConnectFenceTo(world, x + 1, y, z)) {
                renderer.setRenderBounds(0.625, 0.375, 0.4375, 1.0, 0.5625, 0.5625);
                renderer.renderStandardBlock(block, x, y, z);
                renderer.setRenderBounds(0.625, 0.75, 0.4375, 1.0, 0.9375, 0.5625);
                renderer.renderStandardBlock(block, x, y, z);
            }
            if (wd.canConnectFenceTo(world, x - 1, y, z)) {
                renderer.setRenderBounds(0.0, 0.375, 0.4375, 0.375, 0.5625, 0.5625);
                renderer.renderStandardBlock(block, x, y, z);
                renderer.setRenderBounds(0.0, 0.75, 0.4375, 0.375, 0.9375, 0.5625);
                renderer.renderStandardBlock(block, x, y, z);
            }
            if (wd.canConnectFenceTo(world, x, y, z + 1)) {
                renderer.setRenderBounds(0.4375, 0.375, 0.625, 0.5625, 0.5625, 1.0);
                renderer.renderStandardBlock(block, x, y, z);
                renderer.setRenderBounds(0.4375, 0.75, 0.625, 0.5625, 0.9375, 1.0);
                renderer.renderStandardBlock(block, x, y, z);
            }
            if (wd.canConnectFenceTo(world, x, y, z - 1)) {
                renderer.setRenderBounds(0.4375, 0.375, 0.0, 0.5625, 0.5625, 0.375);
                renderer.renderStandardBlock(block, x, y, z);
                renderer.setRenderBounds(0.4375, 0.75, 0.0, 0.5625, 0.9375, 0.375);
                renderer.renderStandardBlock(block, x, y, z);
            }
            return true;
        }
        if (world.getBlockMetadata(x, y, z) == 5) {
            renderer.setRenderBoundsFromBlock(block);
            float f = 0.015625f;
            float f1 = 0.0f;
            renderer.renderFromInside = true;
            renderer.renderMinX = renderer.renderMinX + (block.shouldSideBeRendered(world, x - 1, y, z, 4) ? (double)f : (double)f1);
            renderer.renderMinY = renderer.renderMinY + (block.shouldSideBeRendered(world, x, y - 1, z, 0) ? (double)f : (double)f1);
            renderer.renderMinZ = renderer.renderMinZ + (block.shouldSideBeRendered(world, x, y, z - 1, 2) ? (double)f : (double)f1);
            renderer.renderMaxX = renderer.renderMaxX - (block.shouldSideBeRendered(world, x + 1, y, z, 5) ? (double)f : (double)f1);
            renderer.renderMaxY = renderer.renderMaxY - (block.shouldSideBeRendered(world, x, y + 1, z, 1) ? (double)f : (double)f1);
            renderer.renderMaxZ = renderer.renderMaxZ - (block.shouldSideBeRendered(world, x, y, z + 1, 3) ? (double)f : (double)f1);
            renderer.renderStandardBlock(block, x, y, z);
            renderer.renderMinX = renderer.renderMinX - (block.shouldSideBeRendered(world, x - 1, y, z, 4) ? (double)f : (double)f1);
            renderer.renderMinY = renderer.renderMinY - (block.shouldSideBeRendered(world, x, y - 1, z, 0) ? (double)f : (double)f1);
            renderer.renderMinZ = renderer.renderMinZ - (block.shouldSideBeRendered(world, x, y, z - 1, 2) ? (double)f : (double)f1);
            renderer.renderMaxX = renderer.renderMaxX + (block.shouldSideBeRendered(world, x + 1, y, z, 5) ? (double)f : (double)f1);
            renderer.renderMaxY = renderer.renderMaxY + (block.shouldSideBeRendered(world, x, y + 1, z, 1) ? (double)f : (double)f1);
            renderer.renderMaxZ = renderer.renderMaxZ + (block.shouldSideBeRendered(world, x, y, z + 1, 3) ? (double)f : (double)f1);
            renderer.renderFromInside = false;
            return renderer.renderStandardBlock(block, x, y, z);
        }
        if (world.getBlockMetadata(x, y, z) == 6) {
            TileEntityWallmount tile = (TileEntityWallmount)world.getTileEntity(x, y, z);
            ClientUtils.handleStaticTileRenderer(tile);
            return true;
        }
        renderer.setRenderBoundsFromBlock(block);
        return renderer.renderStandardBlock(block, x, y, z);
    }

    public boolean shouldRender3DInInventory(int modelID) {
        return true;
    }

    public int getRenderId() {
        return renderID;
    }
}

